/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.AuthCredentials;
import com.google.cloud.BaseSerializationTest;
import com.google.cloud.Restorable;
import com.google.cloud.datastore.Blob;
import com.google.cloud.datastore.BlobValue;
import com.google.cloud.datastore.BooleanValue;
import com.google.cloud.datastore.Cursor;
import com.google.cloud.datastore.DatastoreException;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.datastore.DateTime;
import com.google.cloud.datastore.DateTimeValue;
import com.google.cloud.datastore.DoubleValue;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.EntityQuery;
import com.google.cloud.datastore.EntityValue;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.IncompleteKey;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyQuery;
import com.google.cloud.datastore.KeyValue;
import com.google.cloud.datastore.LatLng;
import com.google.cloud.datastore.LatLngValue;
import com.google.cloud.datastore.ListValue;
import com.google.cloud.datastore.LongValue;
import com.google.cloud.datastore.NullValue;
import com.google.cloud.datastore.PathElement;
import com.google.cloud.datastore.ProjectionEntity;
import com.google.cloud.datastore.ProjectionEntityQuery;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.RawValue;
import com.google.cloud.datastore.StringValue;
import com.google.cloud.datastore.StructuredQuery;
import com.google.cloud.datastore.Value;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class SerializationTest
extends BaseSerializationTest {
    private static final IncompleteKey INCOMPLETE_KEY1 = ((IncompleteKey.Builder)IncompleteKey.builder((String)"ds", (String)"k").ancestors(PathElement.of((String)"p", (long)1L))).build();
    private static final Key KEY1 = Key.builder((String)"ds", (String)"k", (String)"n").build();
    private static final IncompleteKey INCOMPLETE_KEY2 = ((IncompleteKey.Builder)IncompleteKey.builder((Key)KEY1, (String)"v").ancestors(PathElement.of((String)"p", (long)1L))).build();
    private static final Key KEY2 = Key.builder((Key)KEY1, (String)"v", (long)2L).build();
    private static final DateTime DATE_TIME1 = DateTime.now();
    private static final LatLng LAT_LNG = new LatLng(37.422035, -122.084124);
    private static final Blob BLOB1 = Blob.copyFrom((ByteBuffer)StandardCharsets.UTF_8.encode("hello world"));
    private static final Cursor CURSOR1 = Cursor.copyFrom((byte[])new byte[]{1, 2});
    private static final Cursor CURSOR2 = Cursor.copyFrom((byte[])new byte[]{10});
    private static final Query<?> GQL1 = Query.gqlQueryBuilder((String)"select * from kind1 where name = @name and age > @1").setBinding("name", new String[]{"name1"}).addBinding(new long[]{20L}).namespace("ns1").build();
    private static final Query<Entity> GQL2 = Query.gqlQueryBuilder((Query.ResultType)Query.ResultType.ENTITY, (String)"select * from kind1 where name = @name and age > @1").setBinding("name", new String[]{"name1"}).addBinding(new long[]{20L}).namespace("ns1").build();
    private static final Query<Entity> QUERY1 = ((EntityQuery.Builder)Query.entityQueryBuilder().kind("kind1")).build();
    private static final Query<Key> QUERY2 = ((KeyQuery.Builder)((KeyQuery.Builder)Query.keyQueryBuilder().kind("k")).filter((StructuredQuery.Filter)StructuredQuery.PropertyFilter.eq((String)"p1", (String)"hello"))).build();
    private static final Query<ProjectionEntity> QUERY3 = ((ProjectionEntityQuery.Builder)((ProjectionEntityQuery.Builder)((ProjectionEntityQuery.Builder)((ProjectionEntityQuery.Builder)((ProjectionEntityQuery.Builder)((ProjectionEntityQuery.Builder)((ProjectionEntityQuery.Builder)((ProjectionEntityQuery.Builder)Query.projectionEntityQueryBuilder().kind("k")).namespace("ns1")).projection("p", new String[0]).limit(Integer.valueOf(100))).offset(5)).startCursor(CURSOR1)).endCursor(CURSOR2)).filter((StructuredQuery.Filter)StructuredQuery.CompositeFilter.and((StructuredQuery.Filter)StructuredQuery.PropertyFilter.gt((String)"p1", (long)10L), (StructuredQuery.Filter[])new StructuredQuery.Filter[]{StructuredQuery.PropertyFilter.eq((String)"a", (String)"v")}))).addDistinctOn("p", new String[0]).addOrderBy(StructuredQuery.OrderBy.asc((String)"p"), new StructuredQuery.OrderBy[0])).build();
    private static final KeyValue KEY_VALUE = KeyValue.of((Key)KEY1);
    private static final NullValue NULL_VALUE = ((NullValue.Builder)NullValue.builder().excludeFromIndexes(true)).build();
    private static final StringValue STRING_VALUE = StringValue.of((String)"hello");
    private static final LongValue LONG_VALUE = LongValue.of((long)123L);
    private static final DoubleValue DOUBLE_VALUE = DoubleValue.of((double)12.34);
    private static final BooleanValue BOOLEAN_VALUE = BooleanValue.of((boolean)true);
    private static final DateTimeValue DATE_AND_TIME_VALUE = DateTimeValue.of((DateTime)DateTime.now());
    private static final BlobValue BLOB_VALUE = BlobValue.of((Blob)BLOB1);
    private static final RawValue RAW_VALUE = RawValue.of((com.google.datastore.v1beta3.Value)com.google.datastore.v1beta3.Value.newBuilder().setMeaning(18).build());
    private static final LatLngValue LAT_LNG_VALUE = LatLngValue.of((LatLng)LAT_LNG);
    private static final Entity ENTITY1 = Entity.builder((Key)KEY1).build();
    private static final Entity ENTITY2 = ((Entity.Builder)Entity.builder((Key)KEY2).set("null", (Value)NullValue.of())).build();
    private static final Entity ENTITY3 = ((Entity.Builder)((Entity.Builder)((Entity.Builder)((Entity.Builder)Entity.builder((Key)KEY2).set("p1", (Value)((StringValue.Builder)StringValue.builder((String)"hi1").meaning(10)).build())).set("p2", (Value)((StringValue.Builder)((StringValue.Builder)StringValue.builder((String)"hi2").meaning(11)).excludeFromIndexes(true)).build())).set("p3", (Value)((LongValue.Builder)((LongValue.Builder)LongValue.builder((long)100L).excludeFromIndexes(true)).meaning(100)).build())).set("blob", BLOB1)).build();
    private static final FullEntity<IncompleteKey> EMBEDDED_ENTITY = ((FullEntity.Builder)((FullEntity.Builder)Entity.builder((IncompleteKey)INCOMPLETE_KEY1).set("p1", (Value)STRING_VALUE)).set("p2", (Value)((LongValue.Builder)((LongValue.Builder)LongValue.builder((long)100L).excludeFromIndexes(true)).meaning(100)).build())).build();
    private static final EntityValue EMBEDDED_ENTITY_VALUE1 = EntityValue.of((FullEntity)ENTITY1);
    private static final EntityValue EMBEDDED_ENTITY_VALUE2 = EntityValue.of((FullEntity)ENTITY2);
    private static final EntityValue EMBEDDED_ENTITY_VALUE3 = EntityValue.of(EMBEDDED_ENTITY);
    private static final ListValue LIST_VALUE = ListValue.builder().addValue((Value)NULL_VALUE, new Value[0]).addValue((Value)STRING_VALUE, new Value[0]).addValue((Value)new NullValue(), new Value[0]).build();
    private static final ProjectionEntity PROJECTION_ENTITY = ProjectionEntity.fromPb((com.google.datastore.v1beta3.Entity)ENTITY1.toPb());
    private static final DatastoreException DATASTORE_EXCEPTION = new DatastoreException(42, "message", "reason");

    protected Serializable[] serializableObjects() {
        DatastoreOptions options = ((DatastoreOptions.Builder)((DatastoreOptions.Builder)DatastoreOptions.builder().authCredentials(AuthCredentials.createForAppEngine())).projectId("ds1")).build();
        DatastoreOptions otherOptions = ((DatastoreOptions.Builder)options.toBuilder().namespace("ns1").authCredentials(null)).build();
        return new Serializable[]{KEY1, KEY2, INCOMPLETE_KEY1, INCOMPLETE_KEY2, ENTITY1, ENTITY2, ENTITY3, EMBEDDED_ENTITY, PROJECTION_ENTITY, DATE_TIME1, BLOB1, CURSOR1, GQL1, GQL2, QUERY1, QUERY2, QUERY3, NULL_VALUE, KEY_VALUE, STRING_VALUE, EMBEDDED_ENTITY_VALUE1, EMBEDDED_ENTITY_VALUE2, EMBEDDED_ENTITY_VALUE3, LIST_VALUE, LONG_VALUE, DOUBLE_VALUE, BOOLEAN_VALUE, DATE_AND_TIME_VALUE, BLOB_VALUE, RAW_VALUE, LAT_LNG_VALUE, DATASTORE_EXCEPTION, options, otherOptions};
    }

    protected Restorable<?>[] restorableObjects() {
        return null;
    }
}

