/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.Cursor;
import com.google.cloud.datastore.EntityQuery;
import com.google.cloud.datastore.KeyQuery;
import com.google.cloud.datastore.ProjectionEntityQuery;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.StructuredQuery;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class StructuredQueryTest {
    private static final String NAMESPACE = "ns";
    private static final String KIND = "k";
    private static final Cursor START_CURSOR = Cursor.copyFrom((byte[])new byte[]{1, 2});
    private static final Cursor END_CURSOR = Cursor.copyFrom((byte[])new byte[]{10});
    private static final int OFFSET = 42;
    private static final Integer LIMIT = 43;
    private static final StructuredQuery.Filter FILTER = StructuredQuery.CompositeFilter.and((StructuredQuery.Filter)StructuredQuery.PropertyFilter.gt((String)"p1", (long)10L), (StructuredQuery.Filter[])new StructuredQuery.Filter[]{StructuredQuery.PropertyFilter.eq((String)"a", (String)"v")});
    private static final StructuredQuery.OrderBy ORDER_BY_1 = StructuredQuery.OrderBy.asc((String)"p2");
    private static final StructuredQuery.OrderBy ORDER_BY_2 = StructuredQuery.OrderBy.desc((String)"p3");
    private static final List<StructuredQuery.OrderBy> ORDER_BY = ImmutableList.of((Object)ORDER_BY_1, (Object)ORDER_BY_2);
    private static final String PROJECTION1 = "p4";
    private static final String PROJECTION2 = "p5";
    private static final List<String> PROJECTION = ImmutableList.of((Object)"p4", (Object)"p5");
    private static final String DISTINCT_ON1 = "p6";
    private static final String DISTINCT_ON2 = "p7";
    private static final List<String> DISTINCT_ON = ImmutableList.of((Object)"p6", (Object)"p7");
    private static final EntityQuery ENTITY_QUERY = ((EntityQuery.Builder)((EntityQuery.Builder)((EntityQuery.Builder)((EntityQuery.Builder)((EntityQuery.Builder)((EntityQuery.Builder)((EntityQuery.Builder)((EntityQuery.Builder)Query.entityQueryBuilder().namespace("ns")).kind("k")).startCursor(START_CURSOR)).endCursor(END_CURSOR)).offset(42)).limit(LIMIT)).filter(FILTER)).orderBy(ORDER_BY_1, new StructuredQuery.OrderBy[]{ORDER_BY_2})).build();
    private static final KeyQuery KEY_QUERY = ((KeyQuery.Builder)((KeyQuery.Builder)((KeyQuery.Builder)((KeyQuery.Builder)((KeyQuery.Builder)((KeyQuery.Builder)((KeyQuery.Builder)((KeyQuery.Builder)Query.keyQueryBuilder().namespace("ns")).kind("k")).startCursor(START_CURSOR)).endCursor(END_CURSOR)).offset(42)).limit(LIMIT)).filter(FILTER)).orderBy(ORDER_BY_1, new StructuredQuery.OrderBy[]{ORDER_BY_2})).build();
    private static final ProjectionEntityQuery PROJECTION_QUERY = ((ProjectionEntityQuery.Builder)((ProjectionEntityQuery.Builder)((ProjectionEntityQuery.Builder)((ProjectionEntityQuery.Builder)((ProjectionEntityQuery.Builder)((ProjectionEntityQuery.Builder)((ProjectionEntityQuery.Builder)((ProjectionEntityQuery.Builder)Query.projectionEntityQueryBuilder().namespace("ns")).kind("k")).startCursor(START_CURSOR)).endCursor(END_CURSOR)).offset(42)).limit(LIMIT)).filter(FILTER)).orderBy(ORDER_BY_1, new StructuredQuery.OrderBy[]{ORDER_BY_2})).projection("p4", new String[]{"p5"}).distinctOn("p6", new String[]{"p7"}).build();

    @Test
    public void testEntityQueryBuilder() {
        this.compareBaseBuilderFields((StructuredQuery<?>)ENTITY_QUERY);
        Assert.assertTrue((boolean)ENTITY_QUERY.projection().isEmpty());
        Assert.assertTrue((boolean)ENTITY_QUERY.distinctOn().isEmpty());
    }

    @Test
    public void testKeyQueryBuilder() {
        this.compareBaseBuilderFields((StructuredQuery<?>)KEY_QUERY);
        Assert.assertEquals((Object)ImmutableList.of((Object)"__key__"), (Object)KEY_QUERY.projection());
        Assert.assertTrue((boolean)KEY_QUERY.distinctOn().isEmpty());
    }

    @Test
    public void testProjectionEntityQueryBuilder() {
        this.compareBaseBuilderFields((StructuredQuery<?>)PROJECTION_QUERY);
        Assert.assertEquals(PROJECTION, (Object)PROJECTION_QUERY.projection());
        Assert.assertEquals(DISTINCT_ON, (Object)PROJECTION_QUERY.distinctOn());
    }

    private void compareBaseBuilderFields(StructuredQuery<?> query) {
        Assert.assertEquals((Object)NAMESPACE, (Object)query.namespace());
        Assert.assertEquals((Object)KIND, (Object)query.kind());
        Assert.assertEquals((Object)START_CURSOR, (Object)query.startCursor());
        Assert.assertEquals((Object)END_CURSOR, (Object)query.endCursor());
        Assert.assertEquals((long)42L, (long)query.offset());
        Assert.assertEquals((Object)LIMIT, (Object)query.limit());
        Assert.assertEquals((Object)FILTER, (Object)query.filter());
        Assert.assertEquals(ORDER_BY, (Object)query.orderBy());
    }

    @Test
    public void mergeFrom() {
        this.compareMergedQuery((StructuredQuery<?>)ENTITY_QUERY, (StructuredQuery<?>)new EntityQuery.Builder().mergeFrom(ENTITY_QUERY.toPb()).build());
        this.compareMergedQuery((StructuredQuery<?>)KEY_QUERY, (StructuredQuery<?>)new KeyQuery.Builder().mergeFrom(KEY_QUERY.toPb()).build());
        this.compareMergedQuery((StructuredQuery<?>)PROJECTION_QUERY, (StructuredQuery<?>)((ProjectionEntityQuery.Builder)new ProjectionEntityQuery.Builder().mergeFrom(PROJECTION_QUERY.toPb())).build());
    }

    private void compareMergedQuery(StructuredQuery<?> expected, StructuredQuery<?> actual) {
        Assert.assertEquals((Object)expected.kind(), (Object)actual.kind());
        Assert.assertEquals((Object)expected.startCursor(), (Object)actual.startCursor());
        Assert.assertEquals((Object)expected.endCursor(), (Object)actual.endCursor());
        Assert.assertEquals((long)expected.offset(), (long)actual.offset());
        Assert.assertEquals((Object)expected.limit(), (Object)actual.limit());
        Assert.assertEquals((Object)expected.filter(), (Object)actual.filter());
        Assert.assertEquals((Object)expected.orderBy(), (Object)actual.orderBy());
        Assert.assertEquals((Object)expected.projection(), (Object)actual.projection());
        Assert.assertEquals((Object)expected.distinctOn(), (Object)actual.distinctOn());
    }

    @Test
    public void testToAndFromPb() {
        Assert.assertEquals((Object)ENTITY_QUERY, (Object)StructuredQuery.fromPb((Query.ResultType)Query.ResultType.ENTITY, (String)ENTITY_QUERY.namespace(), (com.google.datastore.v1beta3.Query)ENTITY_QUERY.toPb()));
        Assert.assertEquals((Object)KEY_QUERY, (Object)StructuredQuery.fromPb((Query.ResultType)Query.ResultType.KEY, (String)KEY_QUERY.namespace(), (com.google.datastore.v1beta3.Query)KEY_QUERY.toPb()));
        Assert.assertEquals((Object)PROJECTION_QUERY, (Object)StructuredQuery.fromPb((Query.ResultType)Query.ResultType.PROJECTION_ENTITY, (String)PROJECTION_QUERY.namespace(), (com.google.datastore.v1beta3.Query)PROJECTION_QUERY.toPb()));
    }

    @Test
    public void testToBuilder() {
        ImmutableList queries = ImmutableList.of((Object)ENTITY_QUERY, (Object)KEY_QUERY, (Object)PROJECTION_QUERY);
        for (StructuredQuery query : queries) {
            Assert.assertEquals((Object)query, (Object)query.toBuilder().build());
        }
    }

    @Test
    public void testKeyOnly() {
        Assert.assertTrue((boolean)KEY_QUERY.keyOnly());
        Assert.assertFalse((boolean)ENTITY_QUERY.keyOnly());
        Assert.assertFalse((boolean)PROJECTION_QUERY.keyOnly());
    }
}

