/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.BaseKey;
import com.google.cloud.datastore.IncompleteKey;
import com.google.cloud.datastore.PathElement;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.datastore.v1beta3.Key;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public final class Key
extends IncompleteKey {
    private static final long serialVersionUID = 3160994559785491356L;

    Key(String projectId, String namespace, ImmutableList<PathElement> path) {
        super(projectId, namespace, path);
        Preconditions.checkArgument((this.nameOrId() != null ? 1 : 0) != 0);
    }

    public boolean hasId() {
        return this.leaf().hasId();
    }

    public Long id() {
        return this.leaf().id();
    }

    public boolean hasName() {
        return this.leaf().hasName();
    }

    public String name() {
        return this.leaf().name();
    }

    public Object nameOrId() {
        return this.leaf().nameOrId();
    }

    public String toUrlSafe() {
        try {
            return URLEncoder.encode(TextFormat.printToString((MessageOrBuilder)this.toPb()), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unexpected encoding exception", e);
        }
    }

    public static Key fromUrlSafe(String urlSafe) {
        try {
            String utf8Str = URLDecoder.decode(urlSafe, StandardCharsets.UTF_8.name());
            Key.Builder builder = com.google.datastore.v1beta3.Key.newBuilder();
            TextFormat.merge((CharSequence)utf8Str, (Message.Builder)builder);
            return Key.fromPb(builder.build());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unexpected decoding exception", e);
        }
        catch (TextFormat.ParseException e) {
            throw new IllegalArgumentException("Could not parse key", e);
        }
    }

    @Override
    Object fromPb(byte[] bytesPb) throws InvalidProtocolBufferException {
        return Key.fromPb(com.google.datastore.v1beta3.Key.parseFrom((byte[])bytesPb));
    }

    static Key fromPb(com.google.datastore.v1beta3.Key keyPb) {
        IncompleteKey key = IncompleteKey.fromPb(keyPb);
        Preconditions.checkState((boolean)(key instanceof Key), (Object)"Key is not complete");
        return (Key)key;
    }

    public static Builder builder(String projectId, String kind, String name) {
        return new Builder(projectId, kind, name);
    }

    public static Builder builder(String projectId, String kind, long id) {
        return new Builder(projectId, kind, id);
    }

    public static Builder builder(Key copyFrom) {
        return new Builder(copyFrom);
    }

    public static Builder builder(IncompleteKey copyFrom, String name) {
        return new Builder(copyFrom, name);
    }

    public static Builder builder(IncompleteKey copyFrom, long id) {
        return new Builder(copyFrom, id);
    }

    public static Builder builder(Key parent, String kind, String name) {
        Builder builder = Key.builder(parent.projectId(), kind, name);
        Key.addParentToBuilder(parent, builder);
        return builder;
    }

    public static Builder builder(Key parent, String kind, long id) {
        Builder builder = Key.builder(parent.projectId(), kind, id);
        Key.addParentToBuilder(parent, builder);
        return builder;
    }

    private static void addParentToBuilder(Key parent, Builder builder) {
        builder.namespace(parent.namespace());
        builder.ancestors(parent.ancestors());
        if (parent.hasId()) {
            builder.ancestors(PathElement.of(parent.kind(), parent.id()));
        } else {
            builder.ancestors(PathElement.of(parent.kind(), parent.name()));
        }
    }

    public static final class Builder
    extends BaseKey.Builder<Builder> {
        private String name;
        private Long id;

        private Builder(String projectId, String kind, String name) {
            super(projectId, kind);
            this.name = name;
        }

        private Builder(String projectId, String kind, long id) {
            super(projectId, kind);
            this.id = id;
        }

        private Builder(IncompleteKey copyFrom, String name) {
            super(copyFrom);
            this.name = name;
        }

        private Builder(IncompleteKey copyFrom, long id) {
            super(copyFrom);
            this.id = id;
        }

        private Builder(Key copyFrom) {
            super(copyFrom);
            if (copyFrom.hasId()) {
                this.id = copyFrom.id();
            } else {
                this.name = copyFrom.name();
            }
        }

        public Builder name(String name) {
            this.name = name;
            this.id = null;
            return this;
        }

        public Builder id(long id) {
            this.id = id;
            this.name = null;
            return this;
        }

        @Override
        public Key build() {
            ImmutableList.Builder pathBuilder = ImmutableList.builder().addAll((Iterable)this.ancestors);
            if (this.id == null) {
                pathBuilder.add((Object)PathElement.of(this.kind, this.name));
            } else {
                pathBuilder.add((Object)PathElement.of(this.kind, this.id));
            }
            return new Key(this.projectId, this.namespace, (ImmutableList<PathElement>)pathBuilder.build());
        }
    }
}

