/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.BaseEntity;
import com.google.cloud.datastore.Blob;
import com.google.cloud.datastore.BlobValue;
import com.google.cloud.datastore.BooleanValue;
import com.google.cloud.datastore.DatastoreException;
import com.google.cloud.datastore.DateTime;
import com.google.cloud.datastore.DateTimeValue;
import com.google.cloud.datastore.DoubleValue;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.EntityValue;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.IncompleteKey;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.LatLng;
import com.google.cloud.datastore.LatLngValue;
import com.google.cloud.datastore.ListValue;
import com.google.cloud.datastore.LongValue;
import com.google.cloud.datastore.NullValue;
import com.google.cloud.datastore.StringValue;
import com.google.cloud.datastore.Value;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BaseEntityTest {
    private static final Blob BLOB = Blob.copyFrom((byte[])new byte[]{1, 2});
    private static final DateTime DATE_TIME = DateTime.now();
    private static final LatLng LAT_LNG = new LatLng(37.422035, -122.084124);
    private static final Key KEY = Key.builder((String)"ds1", (String)"k1", (String)"n1").build();
    private static final Entity ENTITY = ((Entity.Builder)Entity.builder((Key)KEY).set("name", "foo")).build();
    private static final IncompleteKey INCOMPLETE_KEY = IncompleteKey.builder((String)"ds1", (String)"k1").build();
    private static final FullEntity<IncompleteKey> PARTIAL_ENTITY = Entity.builder((IncompleteKey)INCOMPLETE_KEY).build();
    private Builder builder;

    @Before
    public void setUp() {
        this.builder = new Builder();
        ((Builder)((Builder)this.builder.set("blob", BLOB)).set("boolean", true)).set("dateTime", DATE_TIME);
        ((Builder)((Builder)this.builder.set("double", 1.25)).set("key", KEY)).set("string", "hello world");
        ((Builder)((Builder)((Builder)this.builder.set("long", 125L)).setNull("null")).set("entity", (FullEntity)ENTITY)).set("latLng", LAT_LNG);
        ((Builder)this.builder.set("partialEntity", PARTIAL_ENTITY)).set("stringValue", (Value)StringValue.of((String)"bla"));
        this.builder.set("list1", (Value)NullValue.of(), (Value)StringValue.of((String)"foo"), new Value[]{LatLngValue.of((LatLng)LAT_LNG)});
        this.builder.set("list2", (List)ImmutableList.of((Object)LongValue.of((long)10L), (Object)DoubleValue.of((double)2.0)));
        this.builder.set("list3", Collections.singletonList(BooleanValue.of((boolean)true)));
        this.builder.set("blobList", BLOB, Blob.copyFrom((byte[])new byte[]{3, 4}), new Blob[]{Blob.copyFrom((byte[])new byte[]{5, 6})});
        this.builder.set("booleanList", true, false, new boolean[]{true});
        this.builder.set("dateTimeList", DateTime.now(), DateTime.now(), new DateTime[]{DateTime.now()});
        this.builder.set("doubleList", 12.3, 4.56, new double[]{0.789});
        this.builder.set("keyList", KEY, Key.builder((String)"ds2", (String)"k2", (String)"n2").build(), new Key[]{Key.builder((String)"ds3", (String)"k3", (String)"n3").build()});
        this.builder.set("entityList", (FullEntity)ENTITY, PARTIAL_ENTITY, new FullEntity[0]);
        this.builder.set("stringList", "s1", "s2", new String[]{"s3"});
        this.builder.set("longList", 1L, 23L, new long[]{456L});
        this.builder.set("latLngList", LAT_LNG, LAT_LNG, new LatLng[0]);
    }

    @Test
    public void testContains() throws Exception {
        BaseEntity<Key> entity = this.builder.build();
        Assert.assertTrue((boolean)entity.contains("list1"));
        Assert.assertFalse((boolean)entity.contains("bla"));
        entity = ((Builder)this.builder.clear()).build();
        Assert.assertFalse((boolean)entity.contains("list1"));
    }

    @Test
    public void testGetValue() throws Exception {
        BaseEntity<Key> entity = this.builder.build();
        Assert.assertEquals((Object)BlobValue.of((Blob)BLOB), (Object)entity.getValue("blob"));
    }

    @Test(expected=DatastoreException.class)
    public void testGetValueNotFound() throws Exception {
        BaseEntity<Key> entity = ((Builder)this.builder.clear()).build();
        entity.getValue("blob");
    }

    @Test
    public void testIsNull() throws Exception {
        BaseEntity<Key> entity = this.builder.build();
        Assert.assertTrue((boolean)entity.isNull("null"));
        Assert.assertFalse((boolean)entity.isNull("blob"));
        entity = ((Builder)this.builder.setNull("blob")).build();
        Assert.assertTrue((boolean)entity.isNull("blob"));
    }

    @Test(expected=DatastoreException.class)
    public void testIsNullNotFound() throws Exception {
        BaseEntity<Key> entity = ((Builder)this.builder.clear()).build();
        entity.isNull("null");
    }

    @Test
    public void testGetString() throws Exception {
        BaseEntity<Key> entity = this.builder.build();
        Assert.assertEquals((Object)"hello world", (Object)entity.getString("string"));
        Assert.assertEquals((Object)"bla", (Object)entity.getString("stringValue"));
        entity = ((Builder)this.builder.set("string", "foo")).build();
        Assert.assertEquals((Object)"foo", (Object)entity.getString("string"));
    }

    @Test
    public void testGetLong() throws Exception {
        BaseEntity<Key> entity = this.builder.build();
        Assert.assertEquals((long)125L, (long)entity.getLong("long"));
        entity = ((Builder)this.builder.set("long", (Value)LongValue.of((long)10L))).build();
        Assert.assertEquals((long)10L, (long)entity.getLong("long"));
    }

    @Test
    public void testGetDouble() throws Exception {
        BaseEntity<Key> entity = this.builder.build();
        Assert.assertEquals((double)1.25, (double)entity.getDouble("double"), (double)0.0);
        entity = ((Builder)this.builder.set("double", (Value)DoubleValue.of((double)10.0))).build();
        Assert.assertEquals((double)10.0, (double)entity.getDouble("double"), (double)0.0);
    }

    @Test
    public void testGetBoolean() throws Exception {
        BaseEntity<Key> entity = this.builder.build();
        Assert.assertTrue((boolean)entity.getBoolean("boolean"));
        entity = ((Builder)this.builder.set("boolean", (Value)BooleanValue.of((boolean)false))).build();
        Assert.assertFalse((boolean)entity.getBoolean("boolean"));
    }

    @Test
    public void testGetDateTime() throws Exception {
        BaseEntity<Key> entity = this.builder.build();
        Assert.assertEquals((Object)DATE_TIME, (Object)entity.getDateTime("dateTime"));
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        DateTime dateTime = DateTime.copyFrom((Calendar)cal);
        entity = ((Builder)this.builder.set("dateTime", (Value)DateTimeValue.of((DateTime)dateTime))).build();
        Assert.assertEquals((Object)dateTime, (Object)entity.getDateTime("dateTime"));
    }

    @Test
    public void testGetLatLng() throws Exception {
        BaseEntity<Key> entity = this.builder.build();
        Assert.assertEquals((Object)LAT_LNG, (Object)entity.getLatLng("latLng"));
    }

    @Test
    public void testGetKey() throws Exception {
        BaseEntity<Key> entity = this.builder.build();
        Assert.assertEquals((Object)KEY, (Object)entity.getKey("key"));
        Key key = Key.builder((Key)KEY).name("BLA").build();
        entity = ((Builder)this.builder.set("key", key)).build();
        Assert.assertEquals((Object)key, (Object)entity.getKey("key"));
    }

    @Test
    public void testGetEntity() throws Exception {
        BaseEntity<Key> entity = this.builder.build();
        Assert.assertEquals((Object)ENTITY, (Object)entity.getEntity("entity"));
        Assert.assertEquals(PARTIAL_ENTITY, (Object)entity.getEntity("partialEntity"));
        entity = ((Builder)this.builder.set("entity", (Value)EntityValue.of(PARTIAL_ENTITY))).build();
        Assert.assertEquals(PARTIAL_ENTITY, (Object)entity.getEntity("entity"));
    }

    @Test
    public void testGetList() throws Exception {
        BaseEntity<Key> entity = this.builder.build();
        List list = entity.getList("list1");
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)NullValue.of(), list.get(0));
        Assert.assertEquals((Object)"foo", (Object)((Value)list.get(1)).get());
        Assert.assertEquals((Object)LAT_LNG, (Object)((Value)list.get(2)).get());
        list = entity.getList("list2");
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)10L, (Object)((Value)list.get(0)).get());
        Assert.assertEquals((Object)2.0, (Object)((Value)list.get(1)).get());
        list = entity.getList("list3");
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)((Value)list.get(0)).get());
        entity = ((Builder)this.builder.set("list1", (Value)ListValue.of((List)list))).build();
        Assert.assertEquals((Object)list, (Object)entity.getList("list1"));
        List stringList = entity.getList("stringList");
        Assert.assertEquals((Object)ImmutableList.of((Object)StringValue.of((String)"s1"), (Object)StringValue.of((String)"s2"), (Object)StringValue.of((String)"s3")), (Object)stringList);
        List doubleList = entity.getList("doubleList");
        Assert.assertEquals((Object)ImmutableList.of((Object)DoubleValue.of((double)12.3), (Object)DoubleValue.of((double)4.56), (Object)DoubleValue.of((double)0.789)), (Object)doubleList);
        List entityList = entity.getList("entityList");
        Assert.assertEquals((Object)ImmutableList.of((Object)EntityValue.of((FullEntity)ENTITY), (Object)EntityValue.of(PARTIAL_ENTITY)), (Object)entityList);
    }

    @Test
    public void testGetBlob() throws Exception {
        BaseEntity<Key> entity = this.builder.build();
        Assert.assertEquals((Object)BLOB, (Object)entity.getBlob("blob"));
        Blob blob = Blob.copyFrom((byte[])new byte[0]);
        entity = ((Builder)this.builder.set("blob", (Value)BlobValue.of((Blob)blob))).build();
        Assert.assertEquals((Object)blob, (Object)entity.getBlob("blob"));
    }

    @Test
    public void testNames() throws Exception {
        ImmutableSet names = ImmutableSet.builder().add((Object[])new String[]{"string", "stringValue", "boolean", "double", "long", "list1", "list2", "list3"}).add((Object[])new String[]{"entity", "partialEntity", "null", "dateTime", "blob", "key", "blobList"}).add((Object[])new String[]{"booleanList", "dateTimeList", "doubleList", "keyList", "entityList", "stringList"}).add((Object[])new String[]{"longList", "latLng", "latLngList"}).build();
        BaseEntity<Key> entity = this.builder.build();
        Assert.assertEquals((Object)names, (Object)entity.names());
    }

    private class Builder
    extends BaseEntity.Builder<Key, Builder> {
        private Builder() {
        }

        public BaseEntity<Key> build() {
            return new BaseEntity<Key>((BaseEntity.Builder)this){

                protected Builder emptyBuilder() {
                    return new Builder();
                }
            };
        }
    }
}

