/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.IncompleteKey;
import com.google.cloud.datastore.Key;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IncompleteKeyTest {
    private static IncompleteKey pk1;
    private static IncompleteKey pk2;
    private static Key parent1;

    @Before
    public void setUp() {
        pk1 = IncompleteKey.builder((String)"ds", (String)"kind1").build();
        parent1 = ((Key.Builder)Key.builder((String)"ds", (String)"kind2", (long)10L).namespace("ns")).build();
        pk2 = IncompleteKey.builder((Key)parent1, (String)"kind3").build();
    }

    @Test
    public void testBuilders() throws Exception {
        Assert.assertEquals((Object)"ds", (Object)pk1.projectId());
        Assert.assertEquals((Object)"kind1", (Object)pk1.kind());
        Assert.assertTrue((boolean)pk1.ancestors().isEmpty());
        Assert.assertEquals((Object)"ds", (Object)pk2.projectId());
        Assert.assertEquals((Object)"kind3", (Object)pk2.kind());
        Assert.assertEquals((Object)parent1.path(), (Object)pk2.ancestors());
        Assert.assertEquals((Object)pk2, (Object)IncompleteKey.builder((IncompleteKey)pk2).build());
        IncompleteKey pk3 = ((IncompleteKey.Builder)IncompleteKey.builder((IncompleteKey)pk2).kind("kind4")).build();
        Assert.assertEquals((Object)"ds", (Object)pk3.projectId());
        Assert.assertEquals((Object)"kind4", (Object)pk3.kind());
        Assert.assertEquals((Object)parent1.path(), (Object)pk3.ancestors());
    }

    @Test
    public void testParent() {
        Assert.assertNull((Object)pk1.parent());
        Assert.assertEquals((Object)parent1, (Object)pk2.parent());
        Key parent2 = ((Key.Builder)Key.builder((String)"ds", (String)"kind3", (String)"name").namespace("ns")).build();
        IncompleteKey pk3 = IncompleteKey.builder((Key)parent2, (String)"kind3").build();
        Assert.assertEquals((Object)parent2, (Object)pk3.parent());
    }
}

