/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.LatLng;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class LatLngTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private static LatLng gp1 = new LatLng(37.422035, -122.084124);
    private static LatLng gp2 = new LatLng(0.0, 0.0);
    private static final String INVALID_LAT_MESSAGE = "latitude must be in the range [-90, 90] degrees";
    private static final String INVALID_LNG_MESSAGE = "latitude must be in the range [-180, 180] degrees";

    @Test
    public void testEquals() {
        Assert.assertEquals((Object)gp1, (Object)gp1);
        Assert.assertNotEquals((Object)gp1, (Object)gp2);
    }

    @Test
    public void testUpperLatRange() {
        new LatLng(90.0, 0.0);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(INVALID_LAT_MESSAGE);
        new LatLng(91.0, 0.0);
    }

    @Test
    public void testLowerLatRange() {
        new LatLng(-90.0, 0.0);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(INVALID_LAT_MESSAGE);
        new LatLng(-91.0, 0.0);
    }

    @Test
    public void testUpperLngRange() {
        new LatLng(0.0, 180.0);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(INVALID_LNG_MESSAGE);
        new LatLng(0.0, 181.0);
    }

    @Test
    public void testLowerLngRange() {
        new LatLng(0.0, 180.0);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(INVALID_LNG_MESSAGE);
        new LatLng(0.0, -181.0);
    }
}

