/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.Blob;
import com.google.cloud.datastore.BlobValue;
import com.google.cloud.datastore.BooleanValue;
import com.google.cloud.datastore.DateTime;
import com.google.cloud.datastore.DateTimeValue;
import com.google.cloud.datastore.DoubleValue;
import com.google.cloud.datastore.EntityValue;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.IncompleteKey;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyValue;
import com.google.cloud.datastore.LatLng;
import com.google.cloud.datastore.LatLngValue;
import com.google.cloud.datastore.ListValue;
import com.google.cloud.datastore.LongValue;
import com.google.cloud.datastore.NullValue;
import com.google.cloud.datastore.StringValue;
import com.google.cloud.datastore.Value;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class ListValueTest {
    private static final List<Value<?>> CONTENT = ImmutableList.of((Object)NullValue.of(), (Object)StringValue.of((String)"foo"));
    private static final String STRING1 = "string1";
    private static final String STRING2 = "string2";
    private static final long LONG1 = 1L;
    private static final long LONG2 = 2L;
    private static final double DOUBLE1 = 1.0;
    private static final double DOUBLE2 = 2.0;
    private static final boolean BOOLEAN1 = true;
    private static final boolean BOOLEAN2 = false;
    private static final DateTime DATETIME1 = new DateTime(1L);
    private static final DateTime DATETIME2 = new DateTime(2L);
    private static final LatLng LATLNG1 = LatLng.of((double)1.0, (double)2.0);
    private static final LatLng LATLNG2 = LatLng.of((double)2.0, (double)1.0);
    private static final Key KEY1 = Key.builder((String)"project", (String)"kind", (String)"name1").build();
    private static final Key KEY2 = Key.builder((String)"project", (String)"kind", (String)"name2").build();
    private static final FullEntity<Key> ENTITY1 = FullEntity.builder((IncompleteKey)KEY1).build();
    private static final FullEntity<Key> ENTITY2 = FullEntity.builder((IncompleteKey)KEY2).build();
    private static final Blob BLOB1 = Blob.copyFrom((byte[])new byte[]{13, 14, 10, 13});
    private static final Blob BLOB2 = Blob.copyFrom((byte[])new byte[]{11, 0, 0, 0});

    @Test
    public void testToBuilder() throws Exception {
        ListValue value = ListValue.of(CONTENT);
        Assert.assertEquals((Object)value, (Object)value.toBuilder().build());
    }

    @Test
    public void testOf() throws Exception {
        ListValue value = ListValue.of(CONTENT);
        Assert.assertEquals(CONTENT, (Object)value.get());
        Assert.assertFalse((boolean)value.excludeFromIndexes());
        value = ListValue.of(Collections.emptyList());
        Assert.assertEquals(Collections.emptyList(), (Object)value.get());
        Assert.assertFalse((boolean)value.excludeFromIndexes());
        value = ListValue.of((String)STRING1, (String[])new String[0]);
        Assert.assertEquals((Object)ImmutableList.of((Object)StringValue.of((String)STRING1)), (Object)value.get());
        value = ListValue.of((String)STRING1, (String[])new String[]{STRING2});
        Assert.assertEquals((Object)ImmutableList.of((Object)StringValue.of((String)STRING1), (Object)StringValue.of((String)STRING2)), (Object)value.get());
        value = ListValue.of((long)1L, (long[])new long[0]);
        Assert.assertEquals((Object)ImmutableList.of((Object)LongValue.of((long)1L)), (Object)value.get());
        value = ListValue.of((long)1L, (long[])new long[]{2L});
        Assert.assertEquals((Object)ImmutableList.of((Object)LongValue.of((long)1L), (Object)LongValue.of((long)2L)), (Object)value.get());
        value = ListValue.of((double)1.0, (double[])new double[0]);
        Assert.assertEquals((Object)ImmutableList.of((Object)DoubleValue.of((double)1.0)), (Object)value.get());
        value = ListValue.of((double)1.0, (double[])new double[]{2.0});
        Assert.assertEquals((Object)ImmutableList.of((Object)DoubleValue.of((double)1.0), (Object)DoubleValue.of((double)2.0)), (Object)value.get());
        value = ListValue.of((boolean)true, (boolean[])new boolean[0]);
        Assert.assertEquals((Object)ImmutableList.of((Object)BooleanValue.of((boolean)true)), (Object)value.get());
        value = ListValue.of((boolean)true, (boolean[])new boolean[]{false});
        Assert.assertEquals((Object)ImmutableList.of((Object)BooleanValue.of((boolean)true), (Object)BooleanValue.of((boolean)false)), (Object)value.get());
        value = ListValue.of((DateTime)DATETIME1, (DateTime[])new DateTime[0]);
        Assert.assertEquals((Object)ImmutableList.of((Object)DateTimeValue.of((DateTime)DATETIME1)), (Object)value.get());
        value = ListValue.of((DateTime)DATETIME1, (DateTime[])new DateTime[]{DATETIME2});
        Assert.assertEquals((Object)ImmutableList.of((Object)DateTimeValue.of((DateTime)DATETIME1), (Object)DateTimeValue.of((DateTime)DATETIME2)), (Object)value.get());
        value = ListValue.of((LatLng)LATLNG1, (LatLng[])new LatLng[0]);
        Assert.assertEquals((Object)ImmutableList.of((Object)LatLngValue.of((LatLng)LATLNG1)), (Object)value.get());
        value = ListValue.of((LatLng)LATLNG1, (LatLng[])new LatLng[]{LATLNG2});
        Assert.assertEquals((Object)ImmutableList.of((Object)LatLngValue.of((LatLng)LATLNG1), (Object)LatLngValue.of((LatLng)LATLNG2)), (Object)value.get());
        value = ListValue.of((Key)KEY1, (Key[])new Key[0]);
        Assert.assertEquals((Object)ImmutableList.of((Object)KeyValue.of((Key)KEY1)), (Object)value.get());
        value = ListValue.of((Key)KEY1, (Key[])new Key[]{KEY2});
        Assert.assertEquals((Object)ImmutableList.of((Object)KeyValue.of((Key)KEY1), (Object)KeyValue.of((Key)KEY2)), (Object)value.get());
        value = ListValue.of(ENTITY1, (FullEntity[])new FullEntity[0]);
        Assert.assertEquals((Object)ImmutableList.of((Object)EntityValue.of(ENTITY1)), (Object)value.get());
        value = ListValue.of(ENTITY1, (FullEntity[])new FullEntity[]{ENTITY2});
        Assert.assertEquals((Object)ImmutableList.of((Object)EntityValue.of(ENTITY1), (Object)EntityValue.of(ENTITY2)), (Object)value.get());
        value = ListValue.of((Blob)BLOB1, (Blob[])new Blob[0]);
        Assert.assertEquals((Object)ImmutableList.of((Object)BlobValue.of((Blob)BLOB1)), (Object)value.get());
        value = ListValue.of((Blob)BLOB1, (Blob[])new Blob[]{BLOB2});
        Assert.assertEquals((Object)ImmutableList.of((Object)BlobValue.of((Blob)BLOB1), (Object)BlobValue.of((Blob)BLOB2)), (Object)value.get());
    }

    @Test
    public void testBuilder() throws Exception {
        ListValue.Builder builder = ListValue.builder().set(CONTENT);
        ListValue value = ((ListValue.Builder)((ListValue.Builder)builder.meaning(1)).excludeFromIndexes(true)).build();
        Assert.assertEquals(CONTENT, (Object)value.get());
        Assert.assertEquals((long)1L, (long)value.meaning());
        Assert.assertTrue((boolean)value.excludeFromIndexes());
        builder = ListValue.builder();
        for (Value<?> v : CONTENT) {
            builder.addValue(v, new Value[0]);
        }
        Assert.assertEquals(CONTENT, (Object)builder.build().get());
        builder = builder.set(Collections.emptyList());
        Assert.assertEquals(Collections.emptyList(), (Object)builder.build().get());
        builder = builder.addValue(STRING1, new String[0]);
        Assert.assertEquals((Object)ImmutableList.of((Object)StringValue.of((String)STRING1)), (Object)builder.build().get());
        builder = builder.set(Collections.emptyList());
        builder = builder.addValue(STRING1, new String[]{STRING2});
        Assert.assertEquals((Object)ImmutableList.of((Object)StringValue.of((String)STRING1), (Object)StringValue.of((String)STRING2)), (Object)builder.build().get());
        builder = builder.set(Collections.emptyList());
        builder = builder.addValue(1L, new long[0]);
        Assert.assertEquals((Object)ImmutableList.of((Object)LongValue.of((long)1L)), (Object)builder.build().get());
        builder = builder.set(Collections.emptyList());
        builder = builder.addValue(1L, new long[]{2L});
        Assert.assertEquals((Object)ImmutableList.of((Object)LongValue.of((long)1L), (Object)LongValue.of((long)2L)), (Object)builder.build().get());
        builder = builder.set(Collections.emptyList());
        builder = builder.addValue(1.0, new double[0]);
        Assert.assertEquals((Object)ImmutableList.of((Object)DoubleValue.of((double)1.0)), (Object)builder.build().get());
        builder = builder.set(Collections.emptyList());
        builder = builder.addValue(1.0, new double[]{2.0});
        Assert.assertEquals((Object)ImmutableList.of((Object)DoubleValue.of((double)1.0), (Object)DoubleValue.of((double)2.0)), (Object)builder.build().get());
        builder = builder.set(Collections.emptyList());
        builder = builder.addValue(true, new boolean[0]);
        Assert.assertEquals((Object)ImmutableList.of((Object)BooleanValue.of((boolean)true)), (Object)builder.build().get());
        builder = builder.set(Collections.emptyList());
        builder = builder.addValue(true, new boolean[]{false});
        Assert.assertEquals((Object)ImmutableList.of((Object)BooleanValue.of((boolean)true), (Object)BooleanValue.of((boolean)false)), (Object)builder.build().get());
        builder = builder.set(Collections.emptyList());
        builder = builder.addValue(DATETIME1, new DateTime[0]);
        Assert.assertEquals((Object)ImmutableList.of((Object)DateTimeValue.of((DateTime)DATETIME1)), (Object)builder.build().get());
        builder = builder.set(Collections.emptyList());
        builder = builder.addValue(DATETIME1, new DateTime[]{DATETIME2});
        Assert.assertEquals((Object)ImmutableList.of((Object)DateTimeValue.of((DateTime)DATETIME1), (Object)DateTimeValue.of((DateTime)DATETIME2)), (Object)builder.build().get());
        builder = builder.set(Collections.emptyList());
        builder = builder.addValue(LATLNG1, new LatLng[0]);
        Assert.assertEquals((Object)ImmutableList.of((Object)LatLngValue.of((LatLng)LATLNG1)), (Object)builder.build().get());
        builder = builder.set(Collections.emptyList());
        builder = builder.addValue(LATLNG1, new LatLng[]{LATLNG2});
        Assert.assertEquals((Object)ImmutableList.of((Object)LatLngValue.of((LatLng)LATLNG1), (Object)LatLngValue.of((LatLng)LATLNG2)), (Object)builder.build().get());
        builder = builder.set(Collections.emptyList());
        builder = builder.addValue(KEY1, new Key[0]);
        Assert.assertEquals((Object)ImmutableList.of((Object)KeyValue.of((Key)KEY1)), (Object)builder.build().get());
        builder = builder.set(Collections.emptyList());
        builder = builder.addValue(KEY1, new Key[]{KEY2});
        Assert.assertEquals((Object)ImmutableList.of((Object)KeyValue.of((Key)KEY1), (Object)KeyValue.of((Key)KEY2)), (Object)builder.build().get());
        builder = builder.set(Collections.emptyList());
        builder = builder.addValue(ENTITY1, new FullEntity[0]);
        Assert.assertEquals((Object)ImmutableList.of((Object)EntityValue.of(ENTITY1)), (Object)builder.build().get());
        builder = builder.set(Collections.emptyList());
        builder = builder.addValue(ENTITY1, new FullEntity[]{ENTITY2});
        Assert.assertEquals((Object)ImmutableList.of((Object)EntityValue.of(ENTITY1), (Object)EntityValue.of(ENTITY2)), (Object)builder.build().get());
        builder = builder.set(Collections.emptyList());
        builder = builder.addValue(BLOB1, new Blob[0]);
        Assert.assertEquals((Object)ImmutableList.of((Object)BlobValue.of((Blob)BLOB1)), (Object)builder.build().get());
        builder = builder.set(Collections.emptyList());
        builder = builder.addValue(BLOB1, new Blob[]{BLOB2});
        Assert.assertEquals((Object)ImmutableList.of((Object)BlobValue.of((Blob)BLOB1), (Object)BlobValue.of((Blob)BLOB2)), (Object)builder.build().get());
    }
}

