/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.Blob;
import com.google.cloud.datastore.BlobValue;
import com.google.cloud.datastore.BooleanValue;
import com.google.cloud.datastore.DateTime;
import com.google.cloud.datastore.DateTimeValue;
import com.google.cloud.datastore.DoubleValue;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.EntityValue;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyValue;
import com.google.cloud.datastore.LatLng;
import com.google.cloud.datastore.LatLngValue;
import com.google.cloud.datastore.ListValue;
import com.google.cloud.datastore.LongValue;
import com.google.cloud.datastore.NullValue;
import com.google.cloud.datastore.RawValue;
import com.google.cloud.datastore.StringValue;
import com.google.cloud.datastore.Value;
import com.google.cloud.datastore.ValueBuilder;
import com.google.cloud.datastore.ValueType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Primitives;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ValueTest {
    private static final Key KEY = Key.builder((String)"ds", (String)"kind", (long)1L).build();
    private static final Blob BLOB = Blob.copyFrom((byte[])new byte[0]);
    private static final DateTime DATE_TIME = DateTime.now();
    private static final Entity ENTITY = ((Entity.Builder)Entity.builder((Key)KEY).set("FOO", "BAR")).build();
    private static final NullValue NULL_VALUE = NullValue.of();
    private static final StringValue STRING_VALUE = StringValue.of((String)"hello");
    private static final RawValue RAW_VALUE = RawValue.of((com.google.datastore.v1.Value)STRING_VALUE.toPb());
    private static final LatLngValue LAT_LNG_VALUE = LatLngValue.of((LatLng)new LatLng(37.422035, -122.084124));
    private static final ImmutableMap<ValueType, Object[]> TYPES = ImmutableMap.builder().put((Object)ValueType.NULL, (Object)new Object[]{NullValue.class, NULL_VALUE.get()}).put((Object)ValueType.KEY, (Object)new Object[]{KeyValue.class, KEY}).put((Object)ValueType.BLOB, (Object)new Object[]{BlobValue.class, BLOB}).put((Object)ValueType.BOOLEAN, (Object)new Object[]{BooleanValue.class, Boolean.TRUE}).put((Object)ValueType.DATE_TIME, (Object)new Object[]{DateTimeValue.class, DATE_TIME}).put((Object)ValueType.DOUBLE, (Object)new Object[]{DoubleValue.class, 1.25}).put((Object)ValueType.ENTITY, (Object)new Object[]{EntityValue.class, ENTITY}).put((Object)ValueType.LIST, (Object)new Object[]{ListValue.class, ImmutableList.of((Object)NULL_VALUE, (Object)STRING_VALUE, (Object)RAW_VALUE)}).put((Object)ValueType.LONG, (Object)new Object[]{LongValue.class, 123L}).put((Object)ValueType.RAW_VALUE, (Object)new Object[]{RawValue.class, RAW_VALUE.get()}).put((Object)ValueType.LAT_LNG, (Object)new Object[]{LatLngValue.class, LAT_LNG_VALUE.get()}).put((Object)ValueType.STRING, (Object)new Object[]{StringValue.class, STRING_VALUE.get()}).build();
    private ImmutableMap<ValueType, Value<?>> typeToValue;

    @Before
    public void setUp() throws Exception {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ValueType valueType : ValueType.values()) {
            Object[] values = (Object[])TYPES.get((Object)valueType);
            Class valueClass = (Class)values[0];
            Object value = values[1];
            if (value == null) {
                Method method = valueClass.getMethod("of", new Class[0]);
                builder.put((Object)valueType, (Object)((Value)method.invoke(null, new Object[0])));
                continue;
            }
            boolean found = false;
            for (Method method : valueClass.getDeclaredMethods()) {
                if (!method.getName().equals("of")) continue;
                Class paramType = method.getParameterTypes()[0];
                if (paramType.isPrimitive()) {
                    paramType = Primitives.wrap(paramType);
                }
                if (!paramType.isAssignableFrom(value.getClass())) continue;
                builder.put((Object)valueType, (Object)((Value)method.invoke(null, value)));
                found = true;
                break;
            }
            Assert.assertTrue((String)("Could not find an of method for " + valueClass), (boolean)found);
        }
        this.typeToValue = builder.build();
    }

    @Test
    public void testType() throws Exception {
        for (Map.Entry entry : this.typeToValue.entrySet()) {
            Assert.assertEquals(entry.getKey(), (Object)((Value)entry.getValue()).type());
        }
    }

    @Test
    public void testExcludeFromIndexes() throws Exception {
        for (Map.Entry entry : this.typeToValue.entrySet()) {
            Assert.assertFalse((boolean)((Value)entry.getValue()).excludeFromIndexes());
        }
        TestBuilder builder = new TestBuilder();
        Assert.assertFalse((boolean)builder.build().excludeFromIndexes());
        Assert.assertTrue((boolean)((TestBuilder)builder.excludeFromIndexes(true)).build().excludeFromIndexes());
        Assert.assertFalse((boolean)((TestBuilder)builder.excludeFromIndexes(false)).build().excludeFromIndexes());
    }

    @Test
    public void testMeaning() throws Exception {
        TestBuilder builder = new TestBuilder();
        Assert.assertEquals((long)10L, (long)((TestBuilder)builder.meaning(10)).build().meaning());
    }

    @Test
    public void testGet() throws Exception {
        for (Map.Entry entry : this.typeToValue.entrySet()) {
            ValueType valueType = (ValueType)entry.getKey();
            Value value = (Value)entry.getValue();
            Assert.assertEquals((Object)((Object[])TYPES.get((Object)valueType))[1], (Object)value.get());
        }
        TestBuilder builder = new TestBuilder();
        Set<String> value = Collections.singleton("bla");
        Assert.assertEquals(value, (Object)((TestBuilder)builder.set(value)).build().get());
    }

    @Test
    public void testToBuilder() throws Exception {
        Set<String> content = Collections.singleton("bla");
        TestBuilder builder = new TestBuilder();
        builder.meaning(1).set(content).excludeFromIndexes(true);
        Value value = builder.build();
        builder = value.toBuilder();
        Assert.assertEquals((long)1L, (long)value.meaning());
        Assert.assertTrue((boolean)value.excludeFromIndexes());
        Assert.assertEquals((Object)ValueType.LIST, (Object)value.type());
        Assert.assertEquals(content, (Object)value.get());
        Assert.assertEquals((Object)value, (Object)builder.build());
    }

    private class TestBuilder
    extends Value.BaseBuilder<Set, Value<Set>, TestBuilder> {
        TestBuilder() {
            super(ValueType.LIST);
        }

        public Value<Set> build() {
            return new Value((ValueBuilder)this){

                public TestBuilder toBuilder() {
                    return (TestBuilder)new TestBuilder().mergeFrom(this);
                }
            };
        }
    }
}

