/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.testing;

import com.google.cloud.AuthCredentials;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.datastore.testing.LocalDatastoreHelper;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class LocalDatastoreHelperTest {
    private static final double TOLERANCE = 1.0E-5;
    private static final String PROJECT_ID_PREFIX = "test-project-";
    private static final String NAMESPACE = "namespace";

    @Test
    public void testCreate() {
        LocalDatastoreHelper helper = LocalDatastoreHelper.create((double)0.75);
        Assert.assertTrue((Math.abs(0.75 - helper.consistency()) < 1.0E-5 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)helper.projectId().startsWith(PROJECT_ID_PREFIX));
        helper = LocalDatastoreHelper.create();
        Assert.assertTrue((Math.abs(0.9 - helper.consistency()) < 1.0E-5 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)helper.projectId().startsWith(PROJECT_ID_PREFIX));
    }

    @Test
    public void testOptions() {
        LocalDatastoreHelper helper = LocalDatastoreHelper.create();
        DatastoreOptions options = helper.options();
        Assert.assertTrue((boolean)options.projectId().startsWith(PROJECT_ID_PREFIX));
        Assert.assertTrue((boolean)options.host().startsWith("localhost:"));
        Assert.assertSame((Object)AuthCredentials.noAuth(), (Object)options.authCredentials());
        options = helper.options(NAMESPACE);
        Assert.assertTrue((boolean)options.projectId().startsWith(PROJECT_ID_PREFIX));
        Assert.assertTrue((boolean)options.host().startsWith("localhost:"));
        Assert.assertSame((Object)AuthCredentials.noAuth(), (Object)options.authCredentials());
        Assert.assertEquals((Object)NAMESPACE, (Object)options.namespace());
    }
}

