/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.examples.bigquery.snippets;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.InsertAllRequest;
import com.google.cloud.bigquery.InsertAllResponse;
import com.google.cloud.bigquery.QueryRequest;
import com.google.cloud.bigquery.QueryResponse;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import java.util.HashMap;
import java.util.Iterator;

public class InsertDataAndQueryTable {
    public static void main(String ... args) throws InterruptedException {
        BigQuery bigquery = (BigQuery)BigQueryOptions.defaultInstance().service();
        String datasetId = "my_dataset_id";
        bigquery.create(DatasetInfo.builder((String)datasetId).build(), new BigQuery.DatasetOption[0]);
        TableId tableId = TableId.of((String)datasetId, (String)"my_table_id");
        Field stringField = Field.of((String)"StringField", (Field.Type)Field.Type.string());
        Schema schema = Schema.of((Field[])new Field[]{stringField});
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)schema);
        bigquery.create(TableInfo.of((TableId)tableId, (TableDefinition)tableDefinition), new BigQuery.TableOption[0]);
        HashMap<String, String> firstRow = new HashMap<String, String>();
        HashMap<String, String> secondRow = new HashMap<String, String>();
        firstRow.put("StringField", "value1");
        secondRow.put("StringField", "value2");
        InsertAllRequest insertRequest = InsertAllRequest.builder((TableId)tableId).addRow(firstRow).addRow(secondRow).build();
        InsertAllResponse insertResponse = bigquery.insertAll(insertRequest);
        if (insertResponse.hasErrors()) {
            System.out.println("Errors occurred while inserting rows");
        }
        QueryRequest queryRequest = QueryRequest.builder((String)"SELECT * FROM my_dataset_id.my_table_id").maxWaitTime(Long.valueOf(60000L)).pageSize(Long.valueOf(1000L)).build();
        QueryResponse queryResponse = bigquery.query(queryRequest);
        while (!queryResponse.jobCompleted()) {
            Thread.sleep(1000L);
            queryResponse = bigquery.getQueryResults(queryResponse.jobId(), new BigQuery.QueryResultsOption[0]);
        }
        Iterator rowIterator = queryResponse.result().iterateAll();
        System.out.println("Table rows:");
        while (rowIterator.hasNext()) {
            System.out.println(rowIterator.next());
        }
    }
}

