/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.examples.storage.snippets;

import com.google.cloud.storage.Blob;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;

public class CreateAndListBucketsAndBlobs {
    public static void main(String ... args) {
        Storage storage = (Storage)StorageOptions.defaultInstance().service();
        String bucketName = "my_unique_bucket";
        Bucket bucket = storage.create(BucketInfo.of((String)bucketName), new Storage.BucketTargetOption[0]);
        Blob blob = bucket.create("my_blob_name", "a simple blob".getBytes(StandardCharsets.UTF_8), "text/plain", new Bucket.BlobTargetOption[0]);
        String blobContent = new String(blob.content(new Storage.BlobSourceOption[0]), StandardCharsets.UTF_8);
        Iterator bucketIterator = storage.list(new Storage.BucketListOption[0]).iterateAll();
        System.out.println("My buckets:");
        while (bucketIterator.hasNext()) {
            System.out.println(bucketIterator.next());
        }
        Iterator blobIterator = bucket.list(new Storage.BlobListOption[0]).iterateAll();
        System.out.println("My blobs:");
        while (blobIterator.hasNext()) {
            System.out.println(blobIterator.next());
        }
    }
}

