/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.examples.bigquery.snippets;

import com.google.cloud.WaitForOption;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import java.util.concurrent.TimeoutException;

public class CreateTableAndLoadData {
    public static void main(String ... args) throws InterruptedException, TimeoutException {
        TableId tableId;
        BigQuery bigquery = (BigQuery)BigQueryOptions.defaultInstance().service();
        Table table = bigquery.getTable(tableId = TableId.of((String)"dataset", (String)"table"), new BigQuery.TableOption[0]);
        if (table == null) {
            System.out.println("Creating table " + tableId);
            Field integerField = Field.of((String)"fieldName", (Field.Type)Field.Type.integer());
            Schema schema = Schema.of((Field[])new Field[]{integerField});
            table = bigquery.create(TableInfo.of((TableId)tableId, (TableDefinition)StandardTableDefinition.of((Schema)schema)), new BigQuery.TableOption[0]);
        }
        System.out.println("Loading data into table " + tableId);
        Job loadJob = table.load((FormatOptions)FormatOptions.csv(), "gs://bucket/path", new BigQuery.JobOption[0]);
        loadJob = loadJob.waitFor(new WaitForOption[0]);
        if (loadJob.status().error() != null) {
            System.out.println("Job completed with errors");
        } else {
            System.out.println("Job succeeded");
        }
    }
}

