/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.example.storage.snippets;

import com.google.cloud.examples.storage.snippets.BlobSnippets;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.testing.RemoteStorageHelper;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ITBlobSnippets {
    private static final Logger log = Logger.getLogger(ITBlobSnippets.class.getName());
    private static final String BUCKET = RemoteStorageHelper.generateBucketName();
    private static final String BLOB = "blob";
    private static final byte[] EMPTY_CONTENT = new byte[0];
    private static final byte[] CONTENT = "Hello, World!".getBytes(StandardCharsets.UTF_8);
    private static Storage storage;
    private static Blob blob;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @BeforeClass
    public static void beforeClass() {
        RemoteStorageHelper helper = RemoteStorageHelper.create();
        storage = (Storage)helper.options().service();
        storage.create(BucketInfo.of((String)BUCKET), new Storage.BucketTargetOption[0]);
        blob = storage.create(BlobInfo.builder((String)BUCKET, (String)BLOB).build(), new Storage.BlobTargetOption[0]);
    }

    @AfterClass
    public static void afterClass() throws ExecutionException, InterruptedException {
        boolean wasDeleted;
        if (storage != null && !(wasDeleted = RemoteStorageHelper.forceDelete((Storage)storage, (String)BUCKET, (long)5L, (TimeUnit)TimeUnit.SECONDS).booleanValue()) && log.isLoggable(Level.WARNING)) {
            log.log(Level.WARNING, "Deletion of bucket {0} timed out, bucket is not empty", BUCKET);
        }
    }

    @Test
    public void testBlob() throws IOException {
        BlobSnippets blobSnippets = new BlobSnippets(blob);
        Assert.assertTrue((boolean)blobSnippets.exists());
        Assert.assertArrayEquals((byte[])EMPTY_CONTENT, (byte[])blobSnippets.content());
        try {
            Assert.assertNotNull((Object)blobSnippets.reload());
            Assert.fail((String)"Expected StorageException to be thrown");
        }
        catch (StorageException ex) {
            // empty catch block
        }
        Blob updatedBlob = blobSnippets.update();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"key", (Object)"value"), (Object)updatedBlob.metadata());
        Blob copiedBlob = blobSnippets.copyToStrings(BUCKET, "copyBlob");
        Assert.assertNotNull((Object)copiedBlob);
        copiedBlob.delete(new Blob.BlobSourceOption[0]);
        copiedBlob = blobSnippets.copyToId(BUCKET, "copyBlob");
        Assert.assertNotNull((Object)copiedBlob);
        copiedBlob.delete(new Blob.BlobSourceOption[0]);
        copiedBlob = blobSnippets.copyToBucket(BUCKET);
        Assert.assertNotNull((Object)copiedBlob);
        blobSnippets.reload();
        blobSnippets.writer();
        URL signedUrl = blobSnippets.signUrl();
        URLConnection connection = signedUrl.openConnection();
        byte[] readBytes = new byte[CONTENT.length];
        try (InputStream responseStream = connection.getInputStream();){
            Assert.assertEquals((long)CONTENT.length, (long)responseStream.read(readBytes));
            Assert.assertArrayEquals((byte[])CONTENT, (byte[])readBytes);
        }
        signedUrl = blobSnippets.signUrlWithSigner(System.getenv("GOOGLE_APPLICATION_CREDENTIALS"));
        connection = signedUrl.openConnection();
        responseStream = connection.getInputStream();
        var8_9 = null;
        try {
            Assert.assertEquals((long)CONTENT.length, (long)responseStream.read(readBytes));
            Assert.assertArrayEquals((byte[])CONTENT, (byte[])readBytes);
        }
        catch (Throwable throwable) {
            var8_9 = throwable;
            throw throwable;
        }
        finally {
            if (responseStream != null) {
                if (var8_9 != null) {
                    try {
                        responseStream.close();
                    }
                    catch (Throwable x2) {
                        var8_9.addSuppressed(x2);
                    }
                } else {
                    responseStream.close();
                }
            }
        }
        Assert.assertFalse((boolean)blobSnippets.delete());
        storage.delete(BlobId.of((String)BUCKET, (String)BLOB));
    }
}

