/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.examples.translate.snippets;

import com.google.cloud.examples.translate.snippets.TranslateSnippets;
import com.google.cloud.translate.Detection;
import com.google.cloud.translate.Language;
import com.google.cloud.translate.Translate;
import com.google.cloud.translate.Translation;
import com.google.cloud.translate.testing.RemoteTranslateHelper;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ITTranslateSnippets {
    private static TranslateSnippets translateSnippets;
    private static final String[] LANGUAGES;

    @BeforeClass
    public static void beforeClass() {
        RemoteTranslateHelper helper = RemoteTranslateHelper.create();
        translateSnippets = new TranslateSnippets((Translate)helper.options().service());
    }

    @Test
    public void testListSupportedLanguages() {
        HashSet<String> supportedLanguages = new HashSet<String>();
        List languages = translateSnippets.listSupportedLanguages();
        for (Language language : languages) {
            supportedLanguages.add(language.code());
            Assert.assertNotNull((Object)language.name());
        }
        for (String code : LANGUAGES) {
            Assert.assertTrue((boolean)supportedLanguages.contains(code));
        }
    }

    @Test
    public void testListSupportedLanguagesWithTarget() {
        HashSet<String> supportedLanguages = new HashSet<String>();
        List languages = translateSnippets.listSupportedLanguagesWithTarget();
        for (Language language : languages) {
            supportedLanguages.add(language.code());
            Assert.assertNotNull((Object)language.name());
        }
        for (String code : LANGUAGES) {
            Assert.assertTrue((boolean)supportedLanguages.contains(code));
        }
    }

    @Test
    public void testDetectLanguageOfTexts() {
        List detections = translateSnippets.detectLanguageOfTexts();
        Detection detection = (Detection)detections.get(0);
        Assert.assertEquals((Object)"en", (Object)detection.language());
        detection = (Detection)detections.get(1);
        Assert.assertEquals((Object)"es", (Object)detection.language());
    }

    @Test
    public void testDetectLanguageOfTextList() {
        List detections = translateSnippets.detectLanguageOfTextList();
        Detection detection = (Detection)detections.get(0);
        Assert.assertEquals((Object)"en", (Object)detection.language());
        detection = (Detection)detections.get(1);
        Assert.assertEquals((Object)"es", (Object)detection.language());
    }

    @Test
    public void testDetectLanguageOfText() {
        Detection detection = translateSnippets.detectLanguageOfText();
        Assert.assertEquals((Object)"en", (Object)detection.language());
    }

    @Test
    public void testTranslateTextList() {
        List translations = translateSnippets.translateTexts();
        Translation translation = (Translation)translations.get(0);
        Assert.assertEquals((Object)"Hello, World!", (Object)translation.translatedText());
        Assert.assertEquals((Object)"en", (Object)translation.sourceLanguage());
        translation = (Translation)translations.get(1);
        Assert.assertEquals((Object)"Hello World!", (Object)translation.translatedText());
        Assert.assertEquals((Object)"es", (Object)translation.sourceLanguage());
    }

    @Test
    public void testTranslateText() {
        Translation translation = translateSnippets.translateText();
        Assert.assertEquals((Object)"Hello World!", (Object)translation.translatedText());
        Assert.assertEquals((Object)"es", (Object)translation.sourceLanguage());
    }

    @Test
    public void testTranslateTextWithOptions() {
        Translation translation = translateSnippets.translateTextWithOptions();
        Assert.assertEquals((Object)"Hallo Welt!", (Object)translation.translatedText());
        Assert.assertEquals((Object)"es", (Object)translation.sourceLanguage());
    }

    static {
        LANGUAGES = new String[]{"af", "sq", "ar", "hy", "az", "eu", "be", "bn", "bs", "bg", "ca", "ceb", "ny", "zh-TW", "hr", "cs", "da", "nl", "en", "eo", "et", "tl", "fi", "fr", "gl", "ka", "de", "el", "gu", "ht", "ha", "iw", "hi", "hmn", "hu", "is", "ig", "id", "ga", "it", "ja", "jw", "kn", "kk", "km", "ko", "lo", "la", "lv", "lt", "mk", "mg", "ms", "ml", "mt", "mi", "mr", "mn", "my", "ne", "no", "fa", "pl", "pt", "ro", "ru", "sr", "st", "si", "sk", "sl", "so", "es", "su", "sw", "sv", "tg", "ta", "te", "th", "tr", "uk", "ur", "uz", "vi", "cy", "yi", "yo", "zu"};
    }
}

