/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.common.base.MoreObjects;
import com.google.logging.type.HttpRequest;
import java.io.Serializable;
import java.util.Objects;

public final class HttpRequest
implements Serializable {
    private static final long serialVersionUID = -274998005454709817L;
    private final RequestMethod requestMethod;
    private final String requestUrl;
    private final Long requestSize;
    private final Integer status;
    private final Long responseSize;
    private final String userAgent;
    private final String remoteIp;
    private final String referer;
    private final boolean cacheHit;
    private final boolean cacheValidatedWithOriginServer;

    HttpRequest(Builder builder) {
        this.requestMethod = builder.requestMethod;
        this.requestUrl = builder.requestUrl;
        this.requestSize = builder.requestSize;
        this.status = builder.status;
        this.responseSize = builder.responseSize;
        this.userAgent = builder.userAgent;
        this.remoteIp = builder.remoteIp;
        this.referer = builder.referer;
        this.cacheHit = builder.cacheHit;
        this.cacheValidatedWithOriginServer = builder.cacheValidatedWithOriginServer;
    }

    public RequestMethod requestMethod() {
        return this.requestMethod;
    }

    public String requestUrl() {
        return this.requestUrl;
    }

    public Long requestSize() {
        return this.requestSize;
    }

    public Integer status() {
        return this.status;
    }

    public Long responseSize() {
        return this.responseSize;
    }

    public String userAgent() {
        return this.userAgent;
    }

    public String remoteIp() {
        return this.remoteIp;
    }

    public String referer() {
        return this.referer;
    }

    public boolean cacheHit() {
        return this.cacheHit;
    }

    public boolean cacheValidatedWithOriginServer() {
        return this.cacheValidatedWithOriginServer;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.requestMethod, this.requestUrl, this.requestSize, this.status, this.responseSize, this.userAgent, this.remoteIp, this.referer, this.cacheHit, this.cacheValidatedWithOriginServer});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("requestMethod", (Object)this.requestMethod).add("requestUrl", (Object)this.requestUrl).add("requestSize", (Object)this.requestSize).add("status", (Object)this.status).add("responseSize", (Object)this.responseSize).add("userAgent", (Object)this.userAgent).add("remoteIp", (Object)this.remoteIp).add("referer", (Object)this.referer).add("cacheHit", this.cacheHit).add("cacheValidatedWithOriginServer", this.cacheValidatedWithOriginServer).toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HttpRequest)) {
            return false;
        }
        HttpRequest other = (HttpRequest)obj;
        return Objects.equals((Object)this.requestMethod, (Object)other.requestMethod) && Objects.equals(this.requestUrl, other.requestUrl) && Objects.equals(this.requestSize, other.requestSize) && Objects.equals(this.status, other.status) && Objects.equals(this.responseSize, other.responseSize) && Objects.equals(this.userAgent, other.userAgent) && Objects.equals(this.remoteIp, other.remoteIp) && Objects.equals(this.referer, other.referer) && this.cacheHit == other.cacheHit && this.cacheValidatedWithOriginServer == other.cacheValidatedWithOriginServer;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    com.google.logging.type.HttpRequest toPb() {
        HttpRequest.Builder builder = com.google.logging.type.HttpRequest.newBuilder();
        if (this.requestMethod != null) {
            builder.setRequestMethod(this.requestMethod.name());
        }
        if (this.requestUrl != null) {
            builder.setRequestUrl(this.requestUrl);
        }
        if (this.requestSize != null) {
            builder.setRequestSize(this.requestSize.longValue());
        }
        if (this.status != null) {
            builder.setStatus(this.status.intValue());
        }
        if (this.responseSize != null) {
            builder.setResponseSize(this.responseSize.longValue());
        }
        if (this.userAgent != null) {
            builder.setUserAgent(this.userAgent);
        }
        if (this.remoteIp != null) {
            builder.setRemoteIp(this.remoteIp);
        }
        if (this.referer != null) {
            builder.setReferer(this.referer);
        }
        builder.setCacheHit(this.cacheHit);
        builder.setValidatedWithOriginServer(this.cacheValidatedWithOriginServer);
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static HttpRequest fromPb(com.google.logging.type.HttpRequest requestPb) {
        Builder builder = HttpRequest.builder();
        if (requestPb.getRequestMethod() != null && !requestPb.getRequestMethod().equals("")) {
            builder.requestMethod(RequestMethod.valueOf(requestPb.getRequestMethod()));
        }
        if (requestPb.getRequestUrl() != null && !requestPb.getRequestUrl().equals("")) {
            builder.requestUrl(requestPb.getRequestUrl());
        }
        if (requestPb.getRequestSize() != 0L) {
            builder.requestSize(requestPb.getRequestSize());
        }
        if ((long)requestPb.getStatus() != 0L) {
            builder.status(requestPb.getStatus());
        }
        if (requestPb.getResponseSize() != 0L) {
            builder.responseSize(requestPb.getResponseSize());
        }
        if (requestPb.getUserAgent() != null && !requestPb.getRequestUrl().equals("")) {
            builder.userAgent(requestPb.getUserAgent());
        }
        if (requestPb.getRemoteIp() != null && !requestPb.getRemoteIp().equals("")) {
            builder.remoteIp(requestPb.getRemoteIp());
        }
        if (requestPb.getReferer() != null && !requestPb.getReferer().equals("")) {
            builder.referer(requestPb.getReferer());
        }
        builder.cacheHit(requestPb.getCacheHit());
        builder.cacheValidatedWithOriginServer(requestPb.getValidatedWithOriginServer());
        return builder.build();
    }

    public static final class Builder {
        private RequestMethod requestMethod;
        private String requestUrl;
        private Long requestSize;
        private Integer status;
        private Long responseSize;
        private String userAgent;
        private String remoteIp;
        private String referer;
        private boolean cacheHit;
        private boolean cacheValidatedWithOriginServer;

        Builder() {
        }

        Builder(HttpRequest request) {
            this.requestMethod = request.requestMethod;
            this.requestUrl = request.requestUrl;
            this.requestSize = request.requestSize;
            this.status = request.status;
            this.responseSize = request.responseSize;
            this.userAgent = request.userAgent;
            this.remoteIp = request.remoteIp;
            this.referer = request.referer;
            this.cacheHit = request.cacheHit;
            this.cacheValidatedWithOriginServer = request.cacheValidatedWithOriginServer;
        }

        public Builder requestMethod(RequestMethod requestMethod) {
            this.requestMethod = requestMethod;
            return this;
        }

        public Builder requestUrl(String requestUrl) {
            this.requestUrl = requestUrl;
            return this;
        }

        public Builder requestSize(long requestSize) {
            this.requestSize = requestSize;
            return this;
        }

        public Builder status(int status) {
            this.status = status;
            return this;
        }

        public Builder responseSize(long responseSize) {
            this.responseSize = responseSize;
            return this;
        }

        public Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder remoteIp(String remoteIp) {
            this.remoteIp = remoteIp;
            return this;
        }

        public Builder referer(String referer) {
            this.referer = referer;
            return this;
        }

        public Builder cacheHit(boolean cacheHit) {
            this.cacheHit = cacheHit;
            return this;
        }

        public Builder cacheValidatedWithOriginServer(boolean cacheValidatedWithOriginServer) {
            this.cacheValidatedWithOriginServer = cacheValidatedWithOriginServer;
            return this;
        }

        public HttpRequest build() {
            return new HttpRequest(this);
        }
    }

    public static enum RequestMethod {
        GET,
        HEAD,
        PUT,
        POST;

    }
}

