/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.spi.v2;

import com.google.api.gax.core.PageAccessor;
import com.google.api.gax.grpc.ApiCallable;
import com.google.api.gax.protobuf.PathTemplate;
import com.google.cloud.logging.spi.v2.MetricsServiceV2Settings;
import com.google.logging.v2.CreateLogMetricRequest;
import com.google.logging.v2.DeleteLogMetricRequest;
import com.google.logging.v2.GetLogMetricRequest;
import com.google.logging.v2.ListLogMetricsRequest;
import com.google.logging.v2.ListLogMetricsResponse;
import com.google.logging.v2.LogMetric;
import com.google.logging.v2.UpdateLogMetricRequest;
import com.google.protobuf.Empty;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

public class MetricsServiceV2Api
implements AutoCloseable {
    private final MetricsServiceV2Settings settings;
    private final ManagedChannel channel;
    private final ScheduledExecutorService executor;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final ApiCallable<ListLogMetricsRequest, ListLogMetricsResponse> listLogMetricsCallable;
    private final ApiCallable<ListLogMetricsRequest, PageAccessor<LogMetric>> listLogMetricsPagedCallable;
    private final ApiCallable<GetLogMetricRequest, LogMetric> getLogMetricCallable;
    private final ApiCallable<CreateLogMetricRequest, LogMetric> createLogMetricCallable;
    private final ApiCallable<UpdateLogMetricRequest, LogMetric> updateLogMetricCallable;
    private final ApiCallable<DeleteLogMetricRequest, Empty> deleteLogMetricCallable;
    private static final PathTemplate PROJECT_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}");
    private static final PathTemplate METRIC_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/metrics/{metric}");

    public final MetricsServiceV2Settings getSettings() {
        return this.settings;
    }

    public static final String formatProjectName(String project) {
        return PROJECT_PATH_TEMPLATE.instantiate(new String[]{"project", project});
    }

    public static final String formatMetricName(String project, String metric) {
        return METRIC_PATH_TEMPLATE.instantiate(new String[]{"project", project, "metric", metric});
    }

    public static final String parseProjectFromProjectName(String projectName) {
        return PROJECT_PATH_TEMPLATE.parse(projectName).get((Object)"project");
    }

    public static final String parseProjectFromMetricName(String metricName) {
        return METRIC_PATH_TEMPLATE.parse(metricName).get((Object)"project");
    }

    public static final String parseMetricFromMetricName(String metricName) {
        return METRIC_PATH_TEMPLATE.parse(metricName).get((Object)"metric");
    }

    public static final MetricsServiceV2Api createWithDefaults() throws IOException {
        return MetricsServiceV2Api.create(MetricsServiceV2Settings.defaultBuilder().build());
    }

    public static final MetricsServiceV2Api create(MetricsServiceV2Settings settings) throws IOException {
        return new MetricsServiceV2Api(settings);
    }

    protected MetricsServiceV2Api(MetricsServiceV2Settings settings) throws IOException {
        this.settings = settings;
        this.executor = settings.getExecutorProvider().getOrBuildExecutor();
        this.channel = settings.getChannelProvider().getOrBuildChannel((Executor)this.executor);
        this.listLogMetricsCallable = ApiCallable.create(settings.listLogMetricsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listLogMetricsPagedCallable = ApiCallable.createPagedVariant(settings.listLogMetricsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.getLogMetricCallable = ApiCallable.create(settings.getLogMetricSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.createLogMetricCallable = ApiCallable.create(settings.createLogMetricSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.updateLogMetricCallable = ApiCallable.create(settings.updateLogMetricSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.deleteLogMetricCallable = ApiCallable.create(settings.deleteLogMetricSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    MetricsServiceV2Api.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    MetricsServiceV2Api.this.executor.shutdown();
                }
            });
        }
    }

    public final PageAccessor<LogMetric> listLogMetrics(String projectName) {
        PROJECT_PATH_TEMPLATE.validate(projectName);
        ListLogMetricsRequest request = ListLogMetricsRequest.newBuilder().setProjectName(projectName).build();
        return this.listLogMetrics(request);
    }

    public final PageAccessor<LogMetric> listLogMetrics(ListLogMetricsRequest request) {
        return (PageAccessor)this.listLogMetricsPagedCallable().call((Object)request);
    }

    public final ApiCallable<ListLogMetricsRequest, PageAccessor<LogMetric>> listLogMetricsPagedCallable() {
        return this.listLogMetricsPagedCallable;
    }

    public final ApiCallable<ListLogMetricsRequest, ListLogMetricsResponse> listLogMetricsCallable() {
        return this.listLogMetricsCallable;
    }

    public final LogMetric getLogMetric(String metricName) {
        METRIC_PATH_TEMPLATE.validate(metricName);
        GetLogMetricRequest request = GetLogMetricRequest.newBuilder().setMetricName(metricName).build();
        return this.getLogMetric(request);
    }

    private LogMetric getLogMetric(GetLogMetricRequest request) {
        return (LogMetric)this.getLogMetricCallable().call((Object)request);
    }

    public final ApiCallable<GetLogMetricRequest, LogMetric> getLogMetricCallable() {
        return this.getLogMetricCallable;
    }

    public final LogMetric createLogMetric(String projectName, LogMetric metric) {
        PROJECT_PATH_TEMPLATE.validate(projectName);
        CreateLogMetricRequest request = CreateLogMetricRequest.newBuilder().setProjectName(projectName).setMetric(metric).build();
        return this.createLogMetric(request);
    }

    public LogMetric createLogMetric(CreateLogMetricRequest request) {
        return (LogMetric)this.createLogMetricCallable().call((Object)request);
    }

    public final ApiCallable<CreateLogMetricRequest, LogMetric> createLogMetricCallable() {
        return this.createLogMetricCallable;
    }

    public final LogMetric updateLogMetric(String metricName, LogMetric metric) {
        METRIC_PATH_TEMPLATE.validate(metricName);
        UpdateLogMetricRequest request = UpdateLogMetricRequest.newBuilder().setMetricName(metricName).setMetric(metric).build();
        return this.updateLogMetric(request);
    }

    public LogMetric updateLogMetric(UpdateLogMetricRequest request) {
        return (LogMetric)this.updateLogMetricCallable().call((Object)request);
    }

    public final ApiCallable<UpdateLogMetricRequest, LogMetric> updateLogMetricCallable() {
        return this.updateLogMetricCallable;
    }

    public final void deleteLogMetric(String metricName) {
        METRIC_PATH_TEMPLATE.validate(metricName);
        DeleteLogMetricRequest request = DeleteLogMetricRequest.newBuilder().setMetricName(metricName).build();
        this.deleteLogMetric(request);
    }

    private void deleteLogMetric(DeleteLogMetricRequest request) {
        this.deleteLogMetricCallable().call((Object)request);
    }

    public final ApiCallable<DeleteLogMetricRequest, Empty> deleteLogMetricCallable() {
        return this.deleteLogMetricCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

