/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.spi.v2;

import com.google.api.gax.core.ConnectionSettings;
import com.google.api.gax.core.RetrySettings;
import com.google.api.gax.grpc.ApiCallSettings;
import com.google.api.gax.grpc.PageStreamingCallSettings;
import com.google.api.gax.grpc.PageStreamingDescriptor;
import com.google.api.gax.grpc.ServiceApiSettings;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.auth.Credentials;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.logging.v2.CreateLogMetricRequest;
import com.google.logging.v2.DeleteLogMetricRequest;
import com.google.logging.v2.GetLogMetricRequest;
import com.google.logging.v2.ListLogMetricsRequest;
import com.google.logging.v2.ListLogMetricsResponse;
import com.google.logging.v2.LogMetric;
import com.google.logging.v2.MetricsServiceV2Grpc;
import com.google.logging.v2.UpdateLogMetricRequest;
import com.google.protobuf.Empty;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.joda.time.Duration;

public class MetricsServiceV2Settings
extends ServiceApiSettings {
    public static final String DEFAULT_SERVICE_ADDRESS = "logging.googleapis.com";
    public static final int DEFAULT_SERVICE_PORT = 443;
    public static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/logging.write").add((Object)"https://www.googleapis.com/auth/logging.admin").add((Object)"https://www.googleapis.com/auth/logging.read").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    public static final ConnectionSettings DEFAULT_CONNECTION_SETTINGS = ConnectionSettings.newBuilder().setServiceAddress("logging.googleapis.com").setPort(443).provideCredentialsWith(DEFAULT_SERVICE_SCOPES).build();
    private final PageStreamingCallSettings<ListLogMetricsRequest, ListLogMetricsResponse, LogMetric> listLogMetricsSettings;
    private final SimpleCallSettings<GetLogMetricRequest, LogMetric> getLogMetricSettings;
    private final SimpleCallSettings<CreateLogMetricRequest, LogMetric> createLogMetricSettings;
    private final SimpleCallSettings<UpdateLogMetricRequest, LogMetric> updateLogMetricSettings;
    private final SimpleCallSettings<DeleteLogMetricRequest, Empty> deleteLogMetricSettings;
    private static PageStreamingDescriptor<ListLogMetricsRequest, ListLogMetricsResponse, LogMetric> LIST_LOG_METRICS_PAGE_STR_DESC = new PageStreamingDescriptor<ListLogMetricsRequest, ListLogMetricsResponse, LogMetric>(){

        public Object emptyToken() {
            return "";
        }

        public ListLogMetricsRequest injectToken(ListLogMetricsRequest payload, Object token) {
            return ListLogMetricsRequest.newBuilder((ListLogMetricsRequest)payload).setPageToken((String)token).build();
        }

        public Object extractNextToken(ListLogMetricsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<LogMetric> extractResources(ListLogMetricsResponse payload) {
            return payload.getMetricsList();
        }
    };

    public PageStreamingCallSettings<ListLogMetricsRequest, ListLogMetricsResponse, LogMetric> listLogMetricsSettings() {
        return this.listLogMetricsSettings;
    }

    public SimpleCallSettings<GetLogMetricRequest, LogMetric> getLogMetricSettings() {
        return this.getLogMetricSettings;
    }

    public SimpleCallSettings<CreateLogMetricRequest, LogMetric> createLogMetricSettings() {
        return this.createLogMetricSettings;
    }

    public SimpleCallSettings<UpdateLogMetricRequest, LogMetric> updateLogMetricSettings() {
        return this.updateLogMetricSettings;
    }

    public SimpleCallSettings<DeleteLogMetricRequest, Empty> deleteLogMetricSettings() {
        return this.deleteLogMetricSettings;
    }

    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private MetricsServiceV2Settings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getChannelProvider(), settingsBuilder.getExecutorProvider(), settingsBuilder.getGeneratorName(), settingsBuilder.getGeneratorVersion(), settingsBuilder.getClientLibName(), settingsBuilder.getClientLibVersion());
        this.listLogMetricsSettings = settingsBuilder.listLogMetricsSettings().build();
        this.getLogMetricSettings = settingsBuilder.getLogMetricSettings().build();
        this.createLogMetricSettings = settingsBuilder.createLogMetricSettings().build();
        this.updateLogMetricSettings = settingsBuilder.updateLogMetricSettings().build();
        this.deleteLogMetricSettings = settingsBuilder.deleteLogMetricSettings().build();
    }

    public static class Builder
    extends ServiceApiSettings.Builder {
        private final ImmutableList<ApiCallSettings.Builder> methodSettingsBuilders;
        private PageStreamingCallSettings.Builder<ListLogMetricsRequest, ListLogMetricsResponse, LogMetric> listLogMetricsSettings;
        private SimpleCallSettings.Builder<GetLogMetricRequest, LogMetric> getLogMetricSettings;
        private SimpleCallSettings.Builder<CreateLogMetricRequest, LogMetric> createLogMetricSettings;
        private SimpleCallSettings.Builder<UpdateLogMetricRequest, LogMetric> updateLogMetricSettings;
        private SimpleCallSettings.Builder<DeleteLogMetricRequest, Empty> deleteLogMetricSettings;
        private static final ImmutableMap<String, ImmutableSet<Status.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings.Builder> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            super(DEFAULT_CONNECTION_SETTINGS);
            this.listLogMetricsSettings = PageStreamingCallSettings.newBuilder((MethodDescriptor)MetricsServiceV2Grpc.METHOD_LIST_LOG_METRICS, (PageStreamingDescriptor)LIST_LOG_METRICS_PAGE_STR_DESC);
            this.getLogMetricSettings = SimpleCallSettings.newBuilder((MethodDescriptor)MetricsServiceV2Grpc.METHOD_GET_LOG_METRIC);
            this.createLogMetricSettings = SimpleCallSettings.newBuilder((MethodDescriptor)MetricsServiceV2Grpc.METHOD_CREATE_LOG_METRIC);
            this.updateLogMetricSettings = SimpleCallSettings.newBuilder((MethodDescriptor)MetricsServiceV2Grpc.METHOD_UPDATE_LOG_METRIC);
            this.deleteLogMetricSettings = SimpleCallSettings.newBuilder((MethodDescriptor)MetricsServiceV2Grpc.METHOD_DELETE_LOG_METRIC);
            this.methodSettingsBuilders = ImmutableList.of(this.listLogMetricsSettings, this.getLogMetricSettings, this.createLogMetricSettings, this.updateLogMetricSettings, this.deleteLogMetricSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder();
            builder.listLogMetricsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getLogMetricSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createLogMetricSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateLogMetricSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteLogMetricSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(MetricsServiceV2Settings settings) {
            super((ServiceApiSettings)settings);
            this.listLogMetricsSettings = settings.listLogMetricsSettings.toBuilder();
            this.getLogMetricSettings = settings.getLogMetricSettings.toBuilder();
            this.createLogMetricSettings = settings.createLogMetricSettings.toBuilder();
            this.updateLogMetricSettings = settings.updateLogMetricSettings.toBuilder();
            this.deleteLogMetricSettings = settings.deleteLogMetricSettings.toBuilder();
            this.methodSettingsBuilders = ImmutableList.of(this.listLogMetricsSettings, this.getLogMetricSettings, this.createLogMetricSettings, this.updateLogMetricSettings, this.deleteLogMetricSettings);
        }

        protected ConnectionSettings getDefaultConnectionSettings() {
            return DEFAULT_CONNECTION_SETTINGS;
        }

        public Builder provideExecutorWith(ScheduledExecutorService executor, boolean shouldAutoClose) {
            super.provideExecutorWith(executor, shouldAutoClose);
            return this;
        }

        public Builder provideChannelWith(ManagedChannel channel, boolean shouldAutoClose) {
            super.provideChannelWith(channel, shouldAutoClose);
            return this;
        }

        public Builder provideChannelWith(ConnectionSettings settings) {
            super.provideChannelWith(settings);
            return this;
        }

        public Builder provideChannelWith(Credentials credentials) {
            super.provideChannelWith(credentials);
            return this;
        }

        public Builder provideChannelWith(List<String> scopes) {
            super.provideChannelWith(scopes);
            return this;
        }

        public Builder setGeneratorHeader(String name, String version) {
            super.setGeneratorHeader(name, version);
            return this;
        }

        public Builder setClientLibHeader(String name, String version) {
            super.setClientLibHeader(name, version);
            return this;
        }

        public Builder applyToAllApiMethods(ApiCallSettings.Builder apiCallSettings) throws Exception {
            super.applyToAllApiMethods(this.methodSettingsBuilders, apiCallSettings);
            return this;
        }

        public PageStreamingCallSettings.Builder<ListLogMetricsRequest, ListLogMetricsResponse, LogMetric> listLogMetricsSettings() {
            return this.listLogMetricsSettings;
        }

        public SimpleCallSettings.Builder<GetLogMetricRequest, LogMetric> getLogMetricSettings() {
            return this.getLogMetricSettings;
        }

        public SimpleCallSettings.Builder<CreateLogMetricRequest, LogMetric> createLogMetricSettings() {
            return this.createLogMetricSettings;
        }

        public SimpleCallSettings.Builder<UpdateLogMetricRequest, LogMetric> updateLogMetricSettings() {
            return this.updateLogMetricSettings;
        }

        public SimpleCallSettings.Builder<DeleteLogMetricRequest, Empty> deleteLogMetricSettings() {
            return this.deleteLogMetricSettings;
        }

        public MetricsServiceV2Settings build() throws IOException {
            return new MetricsServiceV2Settings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings.Builder settingsBuilder = null;
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.millis((long)100L)).setRetryDelayMultiplier(1.2).setMaxRetryDelay(Duration.millis((long)1000L)).setInitialRpcTimeout(Duration.millis((long)2000L)).setRpcTimeoutMultiplier(1.5).setMaxRpcTimeout(Duration.millis((long)30000L)).setTotalTimeout(Duration.millis((long)45000L));
            definitions.put((Object)"default", (Object)settingsBuilder);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

