/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.testing;

import com.google.cloud.AuthCredentials;
import com.google.cloud.RetryParams;
import com.google.cloud.logging.LoggingOptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteLoggingHelper {
    private static final Logger log = Logger.getLogger(RemoteLoggingHelper.class.getName());
    private final LoggingOptions options;

    private RemoteLoggingHelper(LoggingOptions options) {
        this.options = options;
    }

    public LoggingOptions options() {
        return this.options;
    }

    public static RemoteLoggingHelper create(String projectId, InputStream keyStream) throws LoggingHelperException {
        try {
            LoggingOptions storageOptions = ((LoggingOptions.Builder)((LoggingOptions.Builder)((LoggingOptions.Builder)((LoggingOptions.Builder)((LoggingOptions.Builder)((LoggingOptions.Builder)LoggingOptions.builder().authCredentials((AuthCredentials)AuthCredentials.createForJson((InputStream)keyStream))).projectId(projectId)).retryParams(RemoteLoggingHelper.retryParams())).initialTimeout(60000)).maxTimeout(120000)).timeoutMultiplier(1.5)).build();
            return new RemoteLoggingHelper(storageOptions);
        }
        catch (IOException ex) {
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, ex.getMessage());
            }
            throw LoggingHelperException.translate(ex);
        }
    }

    public static RemoteLoggingHelper create() throws LoggingHelperException {
        LoggingOptions loggingOptions = ((LoggingOptions.Builder)((LoggingOptions.Builder)((LoggingOptions.Builder)((LoggingOptions.Builder)LoggingOptions.builder().retryParams(RemoteLoggingHelper.retryParams())).initialTimeout(60000)).maxTimeout(240000)).timeoutMultiplier(1.5)).build();
        return new RemoteLoggingHelper(loggingOptions);
    }

    public static String formatForTest(String name) {
        return name + "-" + UUID.randomUUID().toString();
    }

    private static RetryParams retryParams() {
        return RetryParams.builder().maxRetryDelayMillis(30000L).totalRetryPeriodMillis(120000L).initialRetryDelayMillis(250L).build();
    }

    public static class LoggingHelperException
    extends RuntimeException {
        private static final long serialVersionUID = 2617749404172557196L;

        public LoggingHelperException(String message, Throwable cause) {
            super(message, cause);
        }

        public static LoggingHelperException translate(Exception ex) {
            return new LoggingHelperException(ex.getMessage(), ex);
        }
    }
}

