/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.cloud.ByteArray;
import com.google.cloud.pubsub.Message;
import com.google.common.collect.ImmutableMap;
import com.google.pubsub.v1.PubsubMessage;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class MessageTest {
    private static final String MESSAGE_ID = "messageId";
    private static final String PAYLOAD_STRING = "payload";
    private static final ByteArray PAYLOAD = ByteArray.copyFrom((byte[])"payload".getBytes(StandardCharsets.UTF_8));
    private static final Map<String, String> ATTRIBUTES = ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2");
    private static final Long PUBLISH_TIME = 42L;
    private static final Message MESSAGE_STRING = Message.builder((String)"payload").id("messageId").attributes(ATTRIBUTES).publishTime(PUBLISH_TIME.longValue()).build();
    private static final Message MESSAGE = Message.builder((ByteArray)PAYLOAD).id("messageId").attributes(ATTRIBUTES).publishTime(PUBLISH_TIME.longValue()).build();

    @Test
    public void testToBuilder() {
        this.compareMessage(MESSAGE, MESSAGE.toBuilder().build());
        Message message = MESSAGE.toBuilder().payload("newPayload").clearAttributes().addAttribute("key1", "value1").build();
        Assert.assertEquals((Object)"newPayload", (Object)message.payloadAsString());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"key1", (Object)"value1"), (Object)message.attributes());
        message = message.toBuilder().payload(PAYLOAD_STRING).removeAttribute("key1").attributes(ATTRIBUTES).build();
        this.compareMessage(MESSAGE, message);
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)MESSAGE_ID, (Object)MESSAGE.id());
        Assert.assertEquals((Object)PAYLOAD, (Object)MESSAGE.payload());
        Assert.assertEquals((Object)PAYLOAD_STRING, (Object)MESSAGE.payloadAsString());
        Assert.assertEquals(ATTRIBUTES, (Object)MESSAGE.attributes());
        Assert.assertEquals((Object)PUBLISH_TIME, (Object)MESSAGE.publishTime());
        Assert.assertEquals((Object)MESSAGE_ID, (Object)MESSAGE_STRING.id());
        Assert.assertEquals((Object)PAYLOAD, (Object)MESSAGE_STRING.payload());
        Assert.assertEquals((Object)PAYLOAD_STRING, (Object)MESSAGE_STRING.payloadAsString());
        Assert.assertEquals(ATTRIBUTES, (Object)MESSAGE_STRING.attributes());
        Assert.assertEquals((Object)PUBLISH_TIME, (Object)MESSAGE_STRING.publishTime());
        this.compareMessage(MESSAGE, MESSAGE_STRING);
        Message message = Message.builder((ByteArray)PAYLOAD).id(MESSAGE_ID).attributes(ATTRIBUTES).clearAttributes().addAttribute("key1", "value1").addAttribute("key2", "value2").publishTime(PUBLISH_TIME.longValue()).build();
        Assert.assertEquals((Object)MESSAGE_ID, (Object)message.id());
        Assert.assertEquals((Object)PAYLOAD, (Object)message.payload());
        Assert.assertEquals((Object)PAYLOAD_STRING, (Object)message.payloadAsString());
        Assert.assertEquals(ATTRIBUTES, (Object)message.attributes());
        Assert.assertEquals((Object)PUBLISH_TIME, (Object)message.publishTime());
        this.compareMessage(MESSAGE, message);
    }

    @Test
    public void testOf() {
        Message message1 = Message.of((String)PAYLOAD_STRING);
        Assert.assertNull((Object)message1.id());
        Assert.assertEquals((Object)PAYLOAD, (Object)message1.payload());
        Assert.assertEquals((Object)PAYLOAD_STRING, (Object)message1.payloadAsString());
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)message1.attributes());
        Assert.assertNull((Object)message1.publishTime());
        Message message2 = Message.of((ByteArray)PAYLOAD);
        Assert.assertNull((Object)message2.id());
        Assert.assertEquals((Object)PAYLOAD, (Object)message2.payload());
        Assert.assertEquals((Object)PAYLOAD_STRING, (Object)message2.payloadAsString());
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)message2.attributes());
        Assert.assertNull((Object)message2.publishTime());
        this.compareMessage(message1, message2);
    }

    @Test
    public void testToAndFromPb() {
        this.compareMessage(MESSAGE, Message.fromPb((PubsubMessage)MESSAGE.toPb()));
        this.compareMessage(MESSAGE_STRING, Message.fromPb((PubsubMessage)MESSAGE_STRING.toPb()));
    }

    @Test
    public void testToAndFromPbIncomplete() {
        Message message = Message.of((String)PAYLOAD_STRING);
        this.compareMessage(message, Message.fromPb((PubsubMessage)message.toPb()));
        message = Message.of((ByteArray)PAYLOAD);
        this.compareMessage(message, Message.fromPb((PubsubMessage)message.toPb()));
    }

    private void compareMessage(Message expected, Message value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.id(), (Object)value.id());
        Assert.assertEquals((Object)expected.payload(), (Object)value.payload());
        Assert.assertEquals((Object)expected.payloadAsString(), (Object)value.payloadAsString());
        Assert.assertEquals((Object)expected.attributes(), (Object)value.attributes());
        Assert.assertEquals((Object)expected.publishTime(), (Object)value.publishTime());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

