/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.cloud.AsyncPage;
import com.google.cloud.GrpcServiceOptions;
import com.google.cloud.Page;
import com.google.cloud.RetryParams;
import com.google.cloud.pubsub.AckDeadlineRenewer;
import com.google.cloud.pubsub.Message;
import com.google.cloud.pubsub.MessageConsumerImplTest;
import com.google.cloud.pubsub.PubSub;
import com.google.cloud.pubsub.PubSubException;
import com.google.cloud.pubsub.PubSubImpl;
import com.google.cloud.pubsub.PubSubOptions;
import com.google.cloud.pubsub.PushConfig;
import com.google.cloud.pubsub.ReceivedMessage;
import com.google.cloud.pubsub.Subscription;
import com.google.cloud.pubsub.SubscriptionId;
import com.google.cloud.pubsub.SubscriptionInfo;
import com.google.cloud.pubsub.Topic;
import com.google.cloud.pubsub.TopicId;
import com.google.cloud.pubsub.TopicInfo;
import com.google.cloud.pubsub.spi.PubSubRpc;
import com.google.cloud.pubsub.spi.PubSubRpcFactory;
import com.google.cloud.pubsub.spi.v1.SubscriberApi;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.Empty;
import com.google.pubsub.v1.AcknowledgeRequest;
import com.google.pubsub.v1.DeleteSubscriptionRequest;
import com.google.pubsub.v1.DeleteTopicRequest;
import com.google.pubsub.v1.GetSubscriptionRequest;
import com.google.pubsub.v1.GetTopicRequest;
import com.google.pubsub.v1.ListSubscriptionsRequest;
import com.google.pubsub.v1.ListSubscriptionsResponse;
import com.google.pubsub.v1.ListTopicSubscriptionsRequest;
import com.google.pubsub.v1.ListTopicSubscriptionsResponse;
import com.google.pubsub.v1.ListTopicsRequest;
import com.google.pubsub.v1.ListTopicsResponse;
import com.google.pubsub.v1.ModifyAckDeadlineRequest;
import com.google.pubsub.v1.ModifyPushConfigRequest;
import com.google.pubsub.v1.PublishRequest;
import com.google.pubsub.v1.PublishResponse;
import com.google.pubsub.v1.PullRequest;
import com.google.pubsub.v1.PullResponse;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class PubSubImplTest {
    private static final String PROJECT = "project";
    private static final String PROJECT_PB = "projects/project";
    private static final String TOPIC = "topic";
    private static final String TOPIC_NAME_PB = "projects/project/topics/topic";
    private static final TopicInfo TOPIC_INFO = TopicInfo.of((String)"topic");
    private static final Function<TopicInfo, com.google.pubsub.v1.Topic> TOPIC_TO_PB_FUNCTION = new Function<TopicInfo, com.google.pubsub.v1.Topic>(){

        public com.google.pubsub.v1.Topic apply(TopicInfo topicInfo) {
            return topicInfo.toPb(PubSubImplTest.PROJECT);
        }
    };
    private static final Message MESSAGE = Message.of((String)"payload");
    private static final String SUBSCRIPTION = "subscription";
    private static final String SUBSCRIPTION_NAME_PB = "projects/project/subscriptions/subscription";
    private static final PushConfig PUSH_CONFIG = PushConfig.of((String)"endpoint");
    private static final SubscriptionInfo SUBSCRIPTION_INFO = SubscriptionInfo.builder((String)"topic", (String)"subscription").ackDeadLineSeconds(42).pushConfig(PUSH_CONFIG).build();
    private static final SubscriptionInfo COMPLETE_SUBSCRIPTION_INFO = SubscriptionInfo.builder((TopicId)TopicId.of((String)"project", (String)"topic"), (String)"subscription").ackDeadLineSeconds(42).pushConfig(PUSH_CONFIG).build();
    private static final Message MESSAGE1 = Message.of((String)"payload1");
    private static final com.google.pubsub.v1.ReceivedMessage MESSAGE_PB1 = com.google.pubsub.v1.ReceivedMessage.newBuilder().setMessage(MESSAGE1.toPb()).setAckId("ackId1").build();
    private static final Message MESSAGE2 = Message.of((String)"payload2");
    private static final com.google.pubsub.v1.ReceivedMessage MESSAGE_PB2 = com.google.pubsub.v1.ReceivedMessage.newBuilder().setMessage(MESSAGE2.toPb()).setAckId("ackId2").build();
    private static final Function<SubscriptionInfo, com.google.pubsub.v1.Subscription> SUBSCRIPTION_TO_PB_FUNCTION = new Function<SubscriptionInfo, com.google.pubsub.v1.Subscription>(){

        public com.google.pubsub.v1.Subscription apply(SubscriptionInfo subscriptionInfo) {
            return subscriptionInfo.toPb(PubSubImplTest.PROJECT);
        }
    };
    private static final Function<SubscriptionId, String> SUBSCRIPTION_ID_TO_PB_FUNCTION = new Function<SubscriptionId, String>(){

        public String apply(SubscriptionId subscriptionId) {
            return SubscriberApi.formatSubscriptionName((String)subscriptionId.project(), (String)subscriptionId.subscription());
        }
    };
    private static final PubSub.MessageProcessor DO_NOTHING = new PubSub.MessageProcessor(){

        public void process(Message message) throws Exception {
        }
    };
    private PubSubOptions options;
    private PubSubRpcFactory rpcFactoryMock;
    private PubSubRpc pubsubRpcMock;
    private AckDeadlineRenewer renewerMock;
    private PubSub pubsub;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() {
        this.rpcFactoryMock = (PubSubRpcFactory)EasyMock.createStrictMock(PubSubRpcFactory.class);
        this.pubsubRpcMock = (PubSubRpc)EasyMock.createStrictMock(PubSubRpc.class);
        this.renewerMock = (AckDeadlineRenewer)EasyMock.createStrictMock(AckDeadlineRenewer.class);
        this.options = (PubSubOptions)EasyMock.createMock(PubSubOptions.class);
        EasyMock.expect((Object)this.options.projectId()).andReturn((Object)PROJECT).anyTimes();
        EasyMock.expect((Object)this.options.rpc()).andReturn((Object)this.pubsubRpcMock).anyTimes();
        EasyMock.expect((Object)this.options.retryParams()).andReturn((Object)RetryParams.noRetries()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.rpcFactoryMock, this.pubsubRpcMock, this.renewerMock, this.options});
        EasyMock.reset((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
    }

    @After
    public void tearDown() {
        EasyMock.verify((Object[])new Object[]{this.rpcFactoryMock, this.pubsubRpcMock, this.renewerMock, this.options});
    }

    private void resetOptionsForList(int pageCount) {
        EasyMock.reset((Object[])new Object[]{this.options});
        EasyMock.expect((Object)this.options.projectId()).andReturn((Object)PROJECT).times(pageCount);
        EasyMock.expect((Object)this.options.rpc()).andReturn((Object)this.pubsubRpcMock).times(pageCount);
        EasyMock.expect((Object)this.options.service()).andReturn((Object)this.pubsub).times(pageCount);
        EasyMock.replay((Object[])new Object[]{this.options});
    }

    @Test
    public void testGetOptions() {
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        Assert.assertSame((Object)this.options, (Object)this.pubsub.options());
    }

    @Test
    public void testCreateTopic() {
        com.google.pubsub.v1.Topic topicPb = TOPIC_INFO.toPb(PROJECT);
        ListenableFuture response = Futures.immediateFuture((Object)topicPb);
        EasyMock.expect((Object)this.pubsubRpcMock.create(topicPb)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        Topic topic = this.pubsub.create(TOPIC_INFO);
        Assert.assertEquals((Object)new Topic(this.pubsub, new TopicInfo.BuilderImpl(TOPIC_INFO)), (Object)topic);
    }

    @Test
    public void testCreateTopicAsync() throws ExecutionException, InterruptedException {
        com.google.pubsub.v1.Topic topicPb = TOPIC_INFO.toPb(PROJECT);
        ListenableFuture response = Futures.immediateFuture((Object)topicPb);
        EasyMock.expect((Object)this.pubsubRpcMock.create(topicPb)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        Topic topic = (Topic)this.pubsub.createAsync(TOPIC_INFO).get();
        Assert.assertEquals((Object)new Topic(this.pubsub, new TopicInfo.BuilderImpl(TOPIC_INFO)), (Object)topic);
    }

    @Test
    public void testGetTopic() {
        GetTopicRequest request = GetTopicRequest.newBuilder().setTopic(TOPIC_NAME_PB).build();
        ListenableFuture response = Futures.immediateFuture((Object)TOPIC_INFO.toPb(PROJECT));
        EasyMock.expect((Object)this.pubsubRpcMock.get(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        Topic topic = this.pubsub.getTopic(TOPIC);
        Assert.assertEquals((Object)new Topic(this.pubsub, new TopicInfo.BuilderImpl(TOPIC_INFO)), (Object)topic);
    }

    @Test
    public void testGetTopic_Null() {
        GetTopicRequest request = GetTopicRequest.newBuilder().setTopic(TOPIC_NAME_PB).build();
        ListenableFuture responseFuture = Futures.immediateFuture(null);
        EasyMock.expect((Object)this.pubsubRpcMock.get(request)).andReturn((Object)responseFuture);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        Assert.assertNull((Object)this.pubsub.getTopic(TOPIC));
    }

    @Test
    public void testGetTopicAsync() throws ExecutionException, InterruptedException {
        GetTopicRequest request = GetTopicRequest.newBuilder().setTopic(TOPIC_NAME_PB).build();
        ListenableFuture response = Futures.immediateFuture((Object)TOPIC_INFO.toPb(PROJECT));
        EasyMock.expect((Object)this.pubsubRpcMock.get(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        Future topicFuture = this.pubsub.getTopicAsync(TOPIC);
        Assert.assertEquals((Object)new Topic(this.pubsub, new TopicInfo.BuilderImpl(TOPIC_INFO)), topicFuture.get());
    }

    @Test
    public void testGetTopicAsync_Null() throws ExecutionException, InterruptedException {
        GetTopicRequest request = GetTopicRequest.newBuilder().setTopic(TOPIC_NAME_PB).build();
        ListenableFuture responseFuture = Futures.immediateFuture(null);
        EasyMock.expect((Object)this.pubsubRpcMock.get(request)).andReturn((Object)responseFuture);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        Assert.assertNull(this.pubsub.getTopicAsync(TOPIC).get());
    }

    @Test
    public void testDeleteTopic() {
        DeleteTopicRequest request = DeleteTopicRequest.newBuilder().setTopic(TOPIC_NAME_PB).build();
        ListenableFuture response = Futures.immediateFuture((Object)Empty.getDefaultInstance());
        EasyMock.expect((Object)this.pubsubRpcMock.delete(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        Assert.assertTrue((boolean)this.pubsub.deleteTopic(TOPIC));
    }

    @Test
    public void testDeleteTopic_Null() {
        DeleteTopicRequest request = DeleteTopicRequest.newBuilder().setTopic(TOPIC_NAME_PB).build();
        ListenableFuture response = Futures.immediateFuture(null);
        EasyMock.expect((Object)this.pubsubRpcMock.delete(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        Assert.assertFalse((boolean)this.pubsub.deleteTopic(TOPIC));
    }

    @Test
    public void testDeleteTopicAsync() throws ExecutionException, InterruptedException {
        DeleteTopicRequest request = DeleteTopicRequest.newBuilder().setTopic(TOPIC_NAME_PB).build();
        ListenableFuture response = Futures.immediateFuture((Object)Empty.getDefaultInstance());
        EasyMock.expect((Object)this.pubsubRpcMock.delete(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        Assert.assertTrue((boolean)((Boolean)this.pubsub.deleteTopicAsync(TOPIC).get()));
    }

    @Test
    public void testDeleteTopicAsync_Null() throws ExecutionException, InterruptedException {
        DeleteTopicRequest request = DeleteTopicRequest.newBuilder().setTopic(TOPIC_NAME_PB).build();
        ListenableFuture response = Futures.immediateFuture(null);
        EasyMock.expect((Object)this.pubsubRpcMock.delete(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        Assert.assertFalse((boolean)((Boolean)this.pubsub.deleteTopicAsync(TOPIC).get()));
    }

    @Test
    public void testListTopics() {
        String cursor = "cursor";
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        this.resetOptionsForList(1);
        ListTopicsRequest request = ListTopicsRequest.newBuilder().setProject(PROJECT_PB).build();
        ImmutableList topicList = ImmutableList.of((Object)new Topic(this.pubsub, new TopicInfo.BuilderImpl(TOPIC_INFO)), (Object)new Topic(this.pubsub, new TopicInfo.BuilderImpl(TOPIC_INFO)));
        ListTopicsResponse response = ListTopicsResponse.newBuilder().setNextPageToken("cursor").addAllTopics((Iterable)Lists.transform((List)topicList, TOPIC_TO_PB_FUNCTION)).build();
        ListenableFuture futureResponse = Futures.immediateFuture((Object)response);
        EasyMock.expect((Object)this.pubsubRpcMock.list(request)).andReturn((Object)futureResponse);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        Page page = this.pubsub.listTopics(new PubSub.ListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])topicList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Topic.class));
    }

    @Test
    public void testListTopicsNextPage() {
        String cursor1 = "cursor";
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        this.resetOptionsForList(2);
        ListTopicsRequest request1 = ListTopicsRequest.newBuilder().setProject(PROJECT_PB).build();
        ListTopicsRequest request2 = ListTopicsRequest.newBuilder().setProject(PROJECT_PB).setPageToken(cursor1).build();
        ImmutableList topicList1 = ImmutableList.of((Object)new Topic(this.pubsub, new TopicInfo.BuilderImpl(TOPIC_INFO)), (Object)new Topic(this.pubsub, new TopicInfo.BuilderImpl(TOPIC_INFO)));
        ImmutableList topicList2 = ImmutableList.of((Object)new Topic(this.pubsub, new TopicInfo.BuilderImpl(TOPIC_INFO)));
        ListTopicsResponse response1 = ListTopicsResponse.newBuilder().setNextPageToken(cursor1).addAllTopics((Iterable)Lists.transform((List)topicList1, TOPIC_TO_PB_FUNCTION)).build();
        String cursor2 = "nextCursor";
        ListTopicsResponse response2 = ListTopicsResponse.newBuilder().setNextPageToken(cursor2).addAllTopics((Iterable)Lists.transform((List)topicList2, TOPIC_TO_PB_FUNCTION)).build();
        ListenableFuture futureResponse1 = Futures.immediateFuture((Object)response1);
        ListenableFuture futureResponse2 = Futures.immediateFuture((Object)response2);
        EasyMock.expect((Object)this.pubsubRpcMock.list(request1)).andReturn((Object)futureResponse1);
        EasyMock.expect((Object)this.pubsubRpcMock.list(request2)).andReturn((Object)futureResponse2);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        Page page = this.pubsub.listTopics(new PubSub.ListOption[0]);
        Assert.assertEquals((Object)cursor1, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])topicList1.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Topic.class));
        page = page.nextPage();
        Assert.assertEquals((Object)cursor2, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])topicList2.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Topic.class));
    }

    @Test
    public void testListTopicsEmpty() {
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        this.resetOptionsForList(1);
        ListTopicsRequest request = ListTopicsRequest.newBuilder().setProject(PROJECT_PB).build();
        ImmutableList topicList = ImmutableList.of();
        ListTopicsResponse response = ListTopicsResponse.newBuilder().setNextPageToken("").addAllTopics((Iterable)Lists.transform((List)topicList, TOPIC_TO_PB_FUNCTION)).build();
        ListenableFuture futureResponse = Futures.immediateFuture((Object)response);
        EasyMock.expect((Object)this.pubsubRpcMock.list(request)).andReturn((Object)futureResponse);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        Page page = this.pubsub.listTopics(new PubSub.ListOption[0]);
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertNull((Object)page.nextPage());
        Assert.assertArrayEquals((Object[])topicList.toArray(), (Object[])Iterators.toArray((Iterator)page.iterateAll(), Topic.class));
    }

    @Test
    public void testListTopicsWithOptions() {
        String cursor = "cursor";
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        this.resetOptionsForList(1);
        ListTopicsRequest request = ListTopicsRequest.newBuilder().setProject(PROJECT_PB).setPageSize(42).setPageToken(cursor).build();
        ImmutableList topicList = ImmutableList.of((Object)new Topic(this.pubsub, new TopicInfo.BuilderImpl(TOPIC_INFO)), (Object)new Topic(this.pubsub, new TopicInfo.BuilderImpl(TOPIC_INFO)));
        ListTopicsResponse response = ListTopicsResponse.newBuilder().setNextPageToken("").addAllTopics((Iterable)Lists.transform((List)topicList, TOPIC_TO_PB_FUNCTION)).build();
        ListenableFuture futureResponse = Futures.immediateFuture((Object)response);
        EasyMock.expect((Object)this.pubsubRpcMock.list(request)).andReturn((Object)futureResponse);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        Page page = this.pubsub.listTopics(new PubSub.ListOption[]{PubSub.ListOption.pageSize((int)42), PubSub.ListOption.pageToken((String)cursor)});
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertNull((Object)page.nextPage());
        Assert.assertArrayEquals((Object[])topicList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Topic.class));
    }

    @Test
    public void testListTopicsAsync() throws ExecutionException, InterruptedException {
        String cursor = "cursor";
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        this.resetOptionsForList(1);
        ListTopicsRequest request = ListTopicsRequest.newBuilder().setProject(PROJECT_PB).build();
        ImmutableList topicList = ImmutableList.of((Object)new Topic(this.pubsub, new TopicInfo.BuilderImpl(TOPIC_INFO)), (Object)new Topic(this.pubsub, new TopicInfo.BuilderImpl(TOPIC_INFO)));
        ListTopicsResponse response = ListTopicsResponse.newBuilder().setNextPageToken("cursor").addAllTopics((Iterable)Lists.transform((List)topicList, TOPIC_TO_PB_FUNCTION)).build();
        ListenableFuture futureResponse = Futures.immediateFuture((Object)response);
        EasyMock.expect((Object)this.pubsubRpcMock.list(request)).andReturn((Object)futureResponse);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        AsyncPage page = (AsyncPage)this.pubsub.listTopicsAsync(new PubSub.ListOption[0]).get();
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])topicList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Topic.class));
    }

    @Test
    public void testListTopicsAsyncNextPage() throws ExecutionException, InterruptedException {
        String cursor1 = "cursor";
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        this.resetOptionsForList(2);
        ListTopicsRequest request1 = ListTopicsRequest.newBuilder().setProject(PROJECT_PB).build();
        ListTopicsRequest request2 = ListTopicsRequest.newBuilder().setProject(PROJECT_PB).setPageToken(cursor1).build();
        ImmutableList topicList1 = ImmutableList.of((Object)new Topic(this.pubsub, new TopicInfo.BuilderImpl(TOPIC_INFO)), (Object)new Topic(this.pubsub, new TopicInfo.BuilderImpl(TOPIC_INFO)));
        ImmutableList topicList2 = ImmutableList.of((Object)new Topic(this.pubsub, new TopicInfo.BuilderImpl(TOPIC_INFO)));
        ListTopicsResponse response1 = ListTopicsResponse.newBuilder().setNextPageToken(cursor1).addAllTopics((Iterable)Lists.transform((List)topicList1, TOPIC_TO_PB_FUNCTION)).build();
        String cursor2 = "nextCursor";
        ListTopicsResponse response2 = ListTopicsResponse.newBuilder().setNextPageToken(cursor2).addAllTopics((Iterable)Lists.transform((List)topicList2, TOPIC_TO_PB_FUNCTION)).build();
        ListenableFuture futureResponse1 = Futures.immediateFuture((Object)response1);
        ListenableFuture futureResponse2 = Futures.immediateFuture((Object)response2);
        EasyMock.expect((Object)this.pubsubRpcMock.list(request1)).andReturn((Object)futureResponse1);
        EasyMock.expect((Object)this.pubsubRpcMock.list(request2)).andReturn((Object)futureResponse2);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        AsyncPage page = (AsyncPage)this.pubsub.listTopicsAsync(new PubSub.ListOption[0]).get();
        Assert.assertEquals((Object)cursor1, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])topicList1.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Topic.class));
        page = (AsyncPage)page.nextPageAsync().get();
        Assert.assertEquals((Object)cursor2, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])topicList2.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Topic.class));
    }

    @Test
    public void testListTopicsAsyncEmpty() throws ExecutionException, InterruptedException {
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        this.resetOptionsForList(1);
        ListTopicsRequest request = ListTopicsRequest.newBuilder().setProject(PROJECT_PB).build();
        ImmutableList topicList = ImmutableList.of();
        ListTopicsResponse response = ListTopicsResponse.newBuilder().setNextPageToken("").addAllTopics((Iterable)Lists.transform((List)topicList, TOPIC_TO_PB_FUNCTION)).build();
        ListenableFuture futureResponse = Futures.immediateFuture((Object)response);
        EasyMock.expect((Object)this.pubsubRpcMock.list(request)).andReturn((Object)futureResponse);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        AsyncPage page = (AsyncPage)this.pubsub.listTopicsAsync(new PubSub.ListOption[0]).get();
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertNull(page.nextPageAsync().get());
        Assert.assertNull((Object)page.nextPage());
        Assert.assertArrayEquals((Object[])topicList.toArray(), (Object[])Iterators.toArray((Iterator)page.iterateAll(), Topic.class));
    }

    @Test
    public void testListTopicsAsyncWithOptions() throws ExecutionException, InterruptedException {
        String cursor = "cursor";
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        this.resetOptionsForList(1);
        ListTopicsRequest request = ListTopicsRequest.newBuilder().setProject(PROJECT_PB).setPageSize(42).setPageToken(cursor).build();
        ImmutableList topicList = ImmutableList.of((Object)new Topic(this.pubsub, new TopicInfo.BuilderImpl(TOPIC_INFO)), (Object)new Topic(this.pubsub, new TopicInfo.BuilderImpl(TOPIC_INFO)));
        ListTopicsResponse response = ListTopicsResponse.newBuilder().setNextPageToken("").addAllTopics((Iterable)Lists.transform((List)topicList, TOPIC_TO_PB_FUNCTION)).build();
        ListenableFuture futureResponse = Futures.immediateFuture((Object)response);
        EasyMock.expect((Object)this.pubsubRpcMock.list(request)).andReturn((Object)futureResponse);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        AsyncPage page = (AsyncPage)this.pubsub.listTopicsAsync(new PubSub.ListOption[]{PubSub.ListOption.pageSize((int)42), PubSub.ListOption.pageToken((String)cursor)}).get();
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertNull(page.nextPageAsync().get());
        Assert.assertArrayEquals((Object[])topicList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Topic.class));
    }

    @Test
    public void testPublishOneMessage() {
        PublishRequest request = PublishRequest.newBuilder().setTopic(TOPIC_NAME_PB).addAllMessages((Iterable)ImmutableList.of((Object)MESSAGE.toPb())).build();
        String messageId = "messageId";
        PublishResponse response = PublishResponse.newBuilder().addMessageIds(messageId).build();
        ListenableFuture responseFuture = Futures.immediateFuture((Object)response);
        EasyMock.expect((Object)this.pubsubRpcMock.publish(request)).andReturn((Object)responseFuture);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        Assert.assertEquals((Object)messageId, (Object)this.pubsub.publish(TOPIC, MESSAGE));
    }

    @Test
    public void testPublishOneMessageAsync() throws ExecutionException, InterruptedException {
        PublishRequest request = PublishRequest.newBuilder().setTopic(TOPIC_NAME_PB).addMessages(MESSAGE.toPb()).build();
        String messageId = "messageId";
        PublishResponse response = PublishResponse.newBuilder().addMessageIds(messageId).build();
        ListenableFuture responseFuture = Futures.immediateFuture((Object)response);
        EasyMock.expect((Object)this.pubsubRpcMock.publish(request)).andReturn((Object)responseFuture);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        Assert.assertEquals((Object)messageId, this.pubsub.publishAsync(TOPIC, MESSAGE).get());
    }

    @Test
    public void testPublishMoreMessages() {
        PublishRequest request = PublishRequest.newBuilder().setTopic(TOPIC_NAME_PB).addAllMessages((Iterable)ImmutableList.of((Object)MESSAGE.toPb(), (Object)MESSAGE.toPb())).build();
        ImmutableList messageIds = ImmutableList.of((Object)"messageId1", (Object)"messageId2");
        PublishResponse response = PublishResponse.newBuilder().addAllMessageIds((Iterable)messageIds).build();
        ListenableFuture responseFuture = Futures.immediateFuture((Object)response);
        EasyMock.expect((Object)this.pubsubRpcMock.publish(request)).andReturn((Object)responseFuture);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        Assert.assertEquals((Object)messageIds, (Object)this.pubsub.publish(TOPIC, MESSAGE, new Message[]{MESSAGE}));
    }

    @Test
    public void testPublishMoreMessagesAsync() throws ExecutionException, InterruptedException {
        PublishRequest request = PublishRequest.newBuilder().setTopic(TOPIC_NAME_PB).addAllMessages((Iterable)ImmutableList.of((Object)MESSAGE.toPb(), (Object)MESSAGE.toPb())).build();
        ImmutableList messageIds = ImmutableList.of((Object)"messageId1", (Object)"messageId2");
        PublishResponse response = PublishResponse.newBuilder().addAllMessageIds((Iterable)messageIds).build();
        ListenableFuture responseFuture = Futures.immediateFuture((Object)response);
        EasyMock.expect((Object)this.pubsubRpcMock.publish(request)).andReturn((Object)responseFuture);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        Assert.assertEquals((Object)messageIds, this.pubsub.publishAsync(TOPIC, MESSAGE, new Message[]{MESSAGE}).get());
    }

    @Test
    public void testPublishMessageList() {
        PublishRequest request = PublishRequest.newBuilder().setTopic(TOPIC_NAME_PB).addAllMessages((Iterable)ImmutableList.of((Object)MESSAGE.toPb(), (Object)MESSAGE.toPb())).build();
        ImmutableList messageIds = ImmutableList.of((Object)"messageId1", (Object)"messageId2");
        PublishResponse response = PublishResponse.newBuilder().addAllMessageIds((Iterable)messageIds).build();
        ListenableFuture responseFuture = Futures.immediateFuture((Object)response);
        EasyMock.expect((Object)this.pubsubRpcMock.publish(request)).andReturn((Object)responseFuture);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        Assert.assertEquals((Object)messageIds, (Object)this.pubsub.publish(TOPIC, (Iterable)ImmutableList.of((Object)MESSAGE, (Object)MESSAGE)));
    }

    @Test
    public void testPublishMessageListAsync() throws ExecutionException, InterruptedException {
        PublishRequest request = PublishRequest.newBuilder().setTopic(TOPIC_NAME_PB).addAllMessages((Iterable)ImmutableList.of((Object)MESSAGE.toPb(), (Object)MESSAGE.toPb())).build();
        ImmutableList messageIds = ImmutableList.of((Object)"messageId1", (Object)"messageId2");
        PublishResponse response = PublishResponse.newBuilder().addAllMessageIds((Iterable)messageIds).build();
        ListenableFuture responseFuture = Futures.immediateFuture((Object)response);
        EasyMock.expect((Object)this.pubsubRpcMock.publish(request)).andReturn((Object)responseFuture);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        Assert.assertEquals((Object)messageIds, this.pubsub.publishAsync(TOPIC, (Iterable)ImmutableList.of((Object)MESSAGE, (Object)MESSAGE)).get());
    }

    @Test
    public void testCreateSubscription() {
        com.google.pubsub.v1.Subscription subscriptionPb = SUBSCRIPTION_INFO.toPb(PROJECT);
        ListenableFuture response = Futures.immediateFuture((Object)subscriptionPb);
        EasyMock.expect((Object)this.pubsubRpcMock.create(subscriptionPb)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        Subscription subscription = this.pubsub.create(SUBSCRIPTION_INFO);
        Assert.assertEquals((Object)new Subscription(this.pubsub, new SubscriptionInfo.BuilderImpl(COMPLETE_SUBSCRIPTION_INFO)), (Object)subscription);
    }

    @Test
    public void testCreateSubscriptionAsync() throws ExecutionException, InterruptedException {
        com.google.pubsub.v1.Subscription subscriptionPb = SUBSCRIPTION_INFO.toPb(PROJECT);
        ListenableFuture response = Futures.immediateFuture((Object)subscriptionPb);
        EasyMock.expect((Object)this.pubsubRpcMock.create(subscriptionPb)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        Subscription subscription = (Subscription)this.pubsub.createAsync(SUBSCRIPTION_INFO).get();
        Assert.assertEquals((Object)new Subscription(this.pubsub, new SubscriptionInfo.BuilderImpl(COMPLETE_SUBSCRIPTION_INFO)), (Object)subscription);
    }

    @Test
    public void testGetSubscription() {
        GetSubscriptionRequest request = GetSubscriptionRequest.newBuilder().setSubscription(SUBSCRIPTION_NAME_PB).build();
        ListenableFuture response = Futures.immediateFuture((Object)SUBSCRIPTION_INFO.toPb(PROJECT));
        EasyMock.expect((Object)this.pubsubRpcMock.get(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        Subscription subscription = this.pubsub.getSubscription(SUBSCRIPTION);
        Assert.assertEquals((Object)new Subscription(this.pubsub, new SubscriptionInfo.BuilderImpl(COMPLETE_SUBSCRIPTION_INFO)), (Object)subscription);
    }

    @Test
    public void testGetSubscription_Null() {
        GetSubscriptionRequest request = GetSubscriptionRequest.newBuilder().setSubscription(SUBSCRIPTION_NAME_PB).build();
        ListenableFuture response = Futures.immediateFuture(null);
        EasyMock.expect((Object)this.pubsubRpcMock.get(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        Assert.assertNull((Object)this.pubsub.getSubscription(SUBSCRIPTION));
    }

    @Test
    public void testGetSubscriptionAsync() throws ExecutionException, InterruptedException {
        GetSubscriptionRequest request = GetSubscriptionRequest.newBuilder().setSubscription(SUBSCRIPTION_NAME_PB).build();
        ListenableFuture response = Futures.immediateFuture((Object)SUBSCRIPTION_INFO.toPb(PROJECT));
        EasyMock.expect((Object)this.pubsubRpcMock.get(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        Subscription subscription = (Subscription)this.pubsub.getSubscriptionAsync(SUBSCRIPTION).get();
        Assert.assertEquals((Object)new Subscription(this.pubsub, new SubscriptionInfo.BuilderImpl(COMPLETE_SUBSCRIPTION_INFO)), (Object)subscription);
    }

    @Test
    public void testGetSubscriptionAsync_Null() throws ExecutionException, InterruptedException {
        GetSubscriptionRequest request = GetSubscriptionRequest.newBuilder().setSubscription(SUBSCRIPTION_NAME_PB).build();
        ListenableFuture response = Futures.immediateFuture(null);
        EasyMock.expect((Object)this.pubsubRpcMock.get(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        Assert.assertNull(this.pubsub.getSubscriptionAsync(SUBSCRIPTION).get());
    }

    @Test
    public void testDeleteSubscription() {
        DeleteSubscriptionRequest request = DeleteSubscriptionRequest.newBuilder().setSubscription(SUBSCRIPTION_NAME_PB).build();
        ListenableFuture response = Futures.immediateFuture((Object)Empty.getDefaultInstance());
        EasyMock.expect((Object)this.pubsubRpcMock.delete(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        Assert.assertTrue((boolean)this.pubsub.deleteSubscription(SUBSCRIPTION));
    }

    @Test
    public void testDeleteSubscription_Null() {
        DeleteSubscriptionRequest request = DeleteSubscriptionRequest.newBuilder().setSubscription(SUBSCRIPTION_NAME_PB).build();
        ListenableFuture response = Futures.immediateFuture(null);
        EasyMock.expect((Object)this.pubsubRpcMock.delete(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        Assert.assertFalse((boolean)this.pubsub.deleteSubscription(SUBSCRIPTION));
    }

    @Test
    public void testDeleteSubscriptionAsync() throws ExecutionException, InterruptedException {
        DeleteSubscriptionRequest request = DeleteSubscriptionRequest.newBuilder().setSubscription(SUBSCRIPTION_NAME_PB).build();
        ListenableFuture response = Futures.immediateFuture((Object)Empty.getDefaultInstance());
        EasyMock.expect((Object)this.pubsubRpcMock.delete(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        Assert.assertTrue((boolean)((Boolean)this.pubsub.deleteSubscriptionAsync(SUBSCRIPTION).get()));
    }

    @Test
    public void testDeleteSubscriptionAsync_Null() throws ExecutionException, InterruptedException {
        DeleteSubscriptionRequest request = DeleteSubscriptionRequest.newBuilder().setSubscription(SUBSCRIPTION_NAME_PB).build();
        ListenableFuture response = Futures.immediateFuture(null);
        EasyMock.expect((Object)this.pubsubRpcMock.delete(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        Assert.assertFalse((boolean)((Boolean)this.pubsub.deleteSubscriptionAsync(SUBSCRIPTION).get()));
    }

    @Test
    public void testReplacePushConfig() {
        ModifyPushConfigRequest request = ModifyPushConfigRequest.newBuilder().setSubscription(SUBSCRIPTION_NAME_PB).setPushConfig(PUSH_CONFIG.toPb()).build();
        ListenableFuture response = Futures.immediateFuture((Object)Empty.getDefaultInstance());
        EasyMock.expect((Object)this.pubsubRpcMock.modify(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        this.pubsub.replacePushConfig(SUBSCRIPTION, PUSH_CONFIG);
    }

    @Test
    public void testReplacePushConfig_Null() {
        ModifyPushConfigRequest request = ModifyPushConfigRequest.newBuilder().setSubscription(SUBSCRIPTION_NAME_PB).setPushConfig(com.google.pubsub.v1.PushConfig.getDefaultInstance()).build();
        ListenableFuture response = Futures.immediateFuture((Object)Empty.getDefaultInstance());
        EasyMock.expect((Object)this.pubsubRpcMock.modify(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        this.pubsub.replacePushConfig(SUBSCRIPTION, null);
    }

    @Test
    public void testReplacePushConfigAsync() throws ExecutionException, InterruptedException {
        ModifyPushConfigRequest request = ModifyPushConfigRequest.newBuilder().setSubscription(SUBSCRIPTION_NAME_PB).setPushConfig(PUSH_CONFIG.toPb()).build();
        ListenableFuture response = Futures.immediateFuture((Object)Empty.getDefaultInstance());
        EasyMock.expect((Object)this.pubsubRpcMock.modify(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        this.pubsub.replacePushConfigAsync(SUBSCRIPTION, PUSH_CONFIG).get();
    }

    @Test
    public void testReplacePushConfigAsync_Null() throws ExecutionException, InterruptedException {
        ModifyPushConfigRequest request = ModifyPushConfigRequest.newBuilder().setSubscription(SUBSCRIPTION_NAME_PB).setPushConfig(com.google.pubsub.v1.PushConfig.getDefaultInstance()).build();
        ListenableFuture response = Futures.immediateFuture((Object)Empty.getDefaultInstance());
        EasyMock.expect((Object)this.pubsubRpcMock.modify(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        this.pubsub.replacePushConfigAsync(SUBSCRIPTION, null).get();
    }

    @Test
    public void testListSubscriptions() {
        String cursor = "cursor";
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        this.resetOptionsForList(1);
        ListSubscriptionsRequest request = ListSubscriptionsRequest.newBuilder().setProject(PROJECT_PB).build();
        ImmutableList subscriptionList = ImmutableList.of((Object)new Subscription(this.pubsub, new SubscriptionInfo.BuilderImpl(COMPLETE_SUBSCRIPTION_INFO)), (Object)new Subscription(this.pubsub, new SubscriptionInfo.BuilderImpl(COMPLETE_SUBSCRIPTION_INFO)));
        ListSubscriptionsResponse response = ListSubscriptionsResponse.newBuilder().setNextPageToken("cursor").addAllSubscriptions((Iterable)Lists.transform((List)subscriptionList, SUBSCRIPTION_TO_PB_FUNCTION)).build();
        ListenableFuture futureResponse = Futures.immediateFuture((Object)response);
        EasyMock.expect((Object)this.pubsubRpcMock.list(request)).andReturn((Object)futureResponse);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        Page page = this.pubsub.listSubscriptions(new PubSub.ListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])subscriptionList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Subscription.class));
    }

    @Test
    public void testListSubscriptionsNextPage() {
        String cursor1 = "cursor";
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        this.resetOptionsForList(2);
        ListSubscriptionsRequest request1 = ListSubscriptionsRequest.newBuilder().setProject(PROJECT_PB).build();
        ListSubscriptionsRequest request2 = ListSubscriptionsRequest.newBuilder().setProject(PROJECT_PB).setPageToken(cursor1).build();
        ImmutableList subscriptionList1 = ImmutableList.of((Object)new Subscription(this.pubsub, new SubscriptionInfo.BuilderImpl(COMPLETE_SUBSCRIPTION_INFO)), (Object)new Subscription(this.pubsub, new SubscriptionInfo.BuilderImpl(COMPLETE_SUBSCRIPTION_INFO)));
        ImmutableList subscriptionList2 = ImmutableList.of((Object)new Subscription(this.pubsub, new SubscriptionInfo.BuilderImpl(COMPLETE_SUBSCRIPTION_INFO)));
        ListSubscriptionsResponse response1 = ListSubscriptionsResponse.newBuilder().setNextPageToken(cursor1).addAllSubscriptions((Iterable)Lists.transform((List)subscriptionList1, SUBSCRIPTION_TO_PB_FUNCTION)).build();
        String cursor2 = "nextCursor";
        ListSubscriptionsResponse response2 = ListSubscriptionsResponse.newBuilder().setNextPageToken(cursor2).addAllSubscriptions((Iterable)Lists.transform((List)subscriptionList2, SUBSCRIPTION_TO_PB_FUNCTION)).build();
        ListenableFuture futureResponse1 = Futures.immediateFuture((Object)response1);
        ListenableFuture futureResponse2 = Futures.immediateFuture((Object)response2);
        EasyMock.expect((Object)this.pubsubRpcMock.list(request1)).andReturn((Object)futureResponse1);
        EasyMock.expect((Object)this.pubsubRpcMock.list(request2)).andReturn((Object)futureResponse2);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        Page page = this.pubsub.listSubscriptions(new PubSub.ListOption[0]);
        Assert.assertEquals((Object)cursor1, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])subscriptionList1.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Subscription.class));
        page = page.nextPage();
        Assert.assertEquals((Object)cursor2, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])subscriptionList2.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Subscription.class));
    }

    @Test
    public void testListSubscriptionsEmpty() {
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        this.resetOptionsForList(1);
        ListSubscriptionsRequest request = ListSubscriptionsRequest.newBuilder().setProject(PROJECT_PB).build();
        ImmutableList subscriptionList = ImmutableList.of();
        ListSubscriptionsResponse response = ListSubscriptionsResponse.newBuilder().setNextPageToken("").addAllSubscriptions((Iterable)Lists.transform((List)subscriptionList, SUBSCRIPTION_TO_PB_FUNCTION)).build();
        ListenableFuture futureResponse = Futures.immediateFuture((Object)response);
        EasyMock.expect((Object)this.pubsubRpcMock.list(request)).andReturn((Object)futureResponse);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        Page page = this.pubsub.listSubscriptions(new PubSub.ListOption[0]);
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertNull((Object)page.nextPage());
        Assert.assertArrayEquals((Object[])subscriptionList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Subscription.class));
    }

    @Test
    public void testListSubscriptionsWithOptions() {
        String cursor = "cursor";
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        this.resetOptionsForList(1);
        ListSubscriptionsRequest request = ListSubscriptionsRequest.newBuilder().setProject(PROJECT_PB).setPageSize(42).setPageToken(cursor).build();
        ImmutableList subscriptionList = ImmutableList.of((Object)new Subscription(this.pubsub, new SubscriptionInfo.BuilderImpl(COMPLETE_SUBSCRIPTION_INFO)), (Object)new Subscription(this.pubsub, new SubscriptionInfo.BuilderImpl(COMPLETE_SUBSCRIPTION_INFO)));
        ListSubscriptionsResponse response = ListSubscriptionsResponse.newBuilder().setNextPageToken("").addAllSubscriptions((Iterable)Lists.transform((List)subscriptionList, SUBSCRIPTION_TO_PB_FUNCTION)).build();
        ListenableFuture futureResponse = Futures.immediateFuture((Object)response);
        EasyMock.expect((Object)this.pubsubRpcMock.list(request)).andReturn((Object)futureResponse);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        Page page = this.pubsub.listSubscriptions(new PubSub.ListOption[]{PubSub.ListOption.pageSize((int)42), PubSub.ListOption.pageToken((String)cursor)});
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertNull((Object)page.nextPage());
        Assert.assertArrayEquals((Object[])subscriptionList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Subscription.class));
    }

    @Test
    public void testListSubscriptionsAsync() throws ExecutionException, InterruptedException {
        String cursor = "cursor";
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        this.resetOptionsForList(1);
        ListSubscriptionsRequest request = ListSubscriptionsRequest.newBuilder().setProject(PROJECT_PB).build();
        ImmutableList subscriptionList = ImmutableList.of((Object)new Subscription(this.pubsub, new SubscriptionInfo.BuilderImpl(COMPLETE_SUBSCRIPTION_INFO)), (Object)new Subscription(this.pubsub, new SubscriptionInfo.BuilderImpl(COMPLETE_SUBSCRIPTION_INFO)));
        ListSubscriptionsResponse response = ListSubscriptionsResponse.newBuilder().setNextPageToken("cursor").addAllSubscriptions((Iterable)Lists.transform((List)subscriptionList, SUBSCRIPTION_TO_PB_FUNCTION)).build();
        ListenableFuture futureResponse = Futures.immediateFuture((Object)response);
        EasyMock.expect((Object)this.pubsubRpcMock.list(request)).andReturn((Object)futureResponse);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        AsyncPage page = (AsyncPage)this.pubsub.listSubscriptionsAsync(new PubSub.ListOption[0]).get();
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])subscriptionList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Subscription.class));
    }

    @Test
    public void testListSubscriptionsAsyncNextPage() throws ExecutionException, InterruptedException {
        String cursor1 = "cursor";
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        this.resetOptionsForList(2);
        ListSubscriptionsRequest request1 = ListSubscriptionsRequest.newBuilder().setProject(PROJECT_PB).build();
        ListSubscriptionsRequest request2 = ListSubscriptionsRequest.newBuilder().setProject(PROJECT_PB).setPageToken(cursor1).build();
        ImmutableList subscriptionList1 = ImmutableList.of((Object)new Subscription(this.pubsub, new SubscriptionInfo.BuilderImpl(COMPLETE_SUBSCRIPTION_INFO)), (Object)new Subscription(this.pubsub, new SubscriptionInfo.BuilderImpl(COMPLETE_SUBSCRIPTION_INFO)));
        ImmutableList subscriptionList2 = ImmutableList.of((Object)new Subscription(this.pubsub, new SubscriptionInfo.BuilderImpl(COMPLETE_SUBSCRIPTION_INFO)));
        ListSubscriptionsResponse response1 = ListSubscriptionsResponse.newBuilder().setNextPageToken(cursor1).addAllSubscriptions((Iterable)Lists.transform((List)subscriptionList1, SUBSCRIPTION_TO_PB_FUNCTION)).build();
        String cursor2 = "nextCursor";
        ListSubscriptionsResponse response2 = ListSubscriptionsResponse.newBuilder().setNextPageToken(cursor2).addAllSubscriptions((Iterable)Lists.transform((List)subscriptionList2, SUBSCRIPTION_TO_PB_FUNCTION)).build();
        ListenableFuture futureResponse1 = Futures.immediateFuture((Object)response1);
        ListenableFuture futureResponse2 = Futures.immediateFuture((Object)response2);
        EasyMock.expect((Object)this.pubsubRpcMock.list(request1)).andReturn((Object)futureResponse1);
        EasyMock.expect((Object)this.pubsubRpcMock.list(request2)).andReturn((Object)futureResponse2);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        AsyncPage page = (AsyncPage)this.pubsub.listSubscriptionsAsync(new PubSub.ListOption[0]).get();
        Assert.assertEquals((Object)cursor1, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])subscriptionList1.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Subscription.class));
        page = (AsyncPage)page.nextPageAsync().get();
        Assert.assertEquals((Object)cursor2, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])subscriptionList2.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Subscription.class));
    }

    @Test
    public void testListSubscriptionsAsyncEmpty() throws ExecutionException, InterruptedException {
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        this.resetOptionsForList(1);
        ListSubscriptionsRequest request = ListSubscriptionsRequest.newBuilder().setProject(PROJECT_PB).build();
        ImmutableList subscriptionList = ImmutableList.of();
        ListSubscriptionsResponse response = ListSubscriptionsResponse.newBuilder().setNextPageToken("").addAllSubscriptions((Iterable)Lists.transform((List)subscriptionList, SUBSCRIPTION_TO_PB_FUNCTION)).build();
        ListenableFuture futureResponse = Futures.immediateFuture((Object)response);
        EasyMock.expect((Object)this.pubsubRpcMock.list(request)).andReturn((Object)futureResponse);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        AsyncPage page = (AsyncPage)this.pubsub.listSubscriptionsAsync(new PubSub.ListOption[0]).get();
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertNull(page.nextPageAsync().get());
        Assert.assertNull((Object)page.nextPage());
        Assert.assertArrayEquals((Object[])subscriptionList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Subscription.class));
    }

    @Test
    public void testListSubscriptionsAsyncWithOptions() throws ExecutionException, InterruptedException {
        String cursor = "cursor";
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        this.resetOptionsForList(1);
        ListSubscriptionsRequest request = ListSubscriptionsRequest.newBuilder().setProject(PROJECT_PB).setPageSize(42).setPageToken(cursor).build();
        ImmutableList subscriptionList = ImmutableList.of((Object)new Subscription(this.pubsub, new SubscriptionInfo.BuilderImpl(COMPLETE_SUBSCRIPTION_INFO)), (Object)new Subscription(this.pubsub, new SubscriptionInfo.BuilderImpl(COMPLETE_SUBSCRIPTION_INFO)));
        ListSubscriptionsResponse response = ListSubscriptionsResponse.newBuilder().setNextPageToken("").addAllSubscriptions((Iterable)Lists.transform((List)subscriptionList, SUBSCRIPTION_TO_PB_FUNCTION)).build();
        ListenableFuture futureResponse = Futures.immediateFuture((Object)response);
        EasyMock.expect((Object)this.pubsubRpcMock.list(request)).andReturn((Object)futureResponse);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        AsyncPage page = (AsyncPage)this.pubsub.listSubscriptionsAsync(new PubSub.ListOption[]{PubSub.ListOption.pageSize((int)42), PubSub.ListOption.pageToken((String)cursor)}).get();
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertNull((Object)page.nextPage());
        Assert.assertNull(page.nextPageAsync().get());
        Assert.assertArrayEquals((Object[])subscriptionList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Subscription.class));
    }

    @Test
    public void testListTopicSubscriptions() {
        String cursor = "cursor";
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        ListTopicSubscriptionsRequest request = ListTopicSubscriptionsRequest.newBuilder().setTopic(TOPIC_NAME_PB).build();
        ImmutableList subscriptionList = ImmutableList.of((Object)new SubscriptionId(PROJECT, "subscription1"), (Object)new SubscriptionId(PROJECT, "subscription2"));
        ListTopicSubscriptionsResponse response = ListTopicSubscriptionsResponse.newBuilder().setNextPageToken("cursor").addAllSubscriptions((Iterable)Lists.transform((List)subscriptionList, SUBSCRIPTION_ID_TO_PB_FUNCTION)).build();
        ListenableFuture futureResponse = Futures.immediateFuture((Object)response);
        EasyMock.expect((Object)this.pubsubRpcMock.list(request)).andReturn((Object)futureResponse);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        Page page = this.pubsub.listSubscriptions(TOPIC, new PubSub.ListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])subscriptionList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), SubscriptionId.class));
    }

    @Test
    public void testListTopicSubscriptionsNextPage() {
        String cursor1 = "cursor";
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        ListTopicSubscriptionsRequest request1 = ListTopicSubscriptionsRequest.newBuilder().setTopic(TOPIC_NAME_PB).build();
        ListTopicSubscriptionsRequest request2 = ListTopicSubscriptionsRequest.newBuilder().setTopic(TOPIC_NAME_PB).setPageToken(cursor1).build();
        ImmutableList subscriptionList1 = ImmutableList.of((Object)new SubscriptionId(PROJECT, "subscription1"), (Object)new SubscriptionId(PROJECT, "subscription2"));
        ImmutableList subscriptionList2 = ImmutableList.of((Object)new SubscriptionId(PROJECT, "subscription3"));
        ListTopicSubscriptionsResponse response1 = ListTopicSubscriptionsResponse.newBuilder().setNextPageToken(cursor1).addAllSubscriptions((Iterable)Lists.transform((List)subscriptionList1, SUBSCRIPTION_ID_TO_PB_FUNCTION)).build();
        String cursor2 = "nextCursor";
        ListTopicSubscriptionsResponse response2 = ListTopicSubscriptionsResponse.newBuilder().setNextPageToken(cursor2).addAllSubscriptions((Iterable)Lists.transform((List)subscriptionList2, SUBSCRIPTION_ID_TO_PB_FUNCTION)).build();
        ListenableFuture futureResponse1 = Futures.immediateFuture((Object)response1);
        ListenableFuture futureResponse2 = Futures.immediateFuture((Object)response2);
        EasyMock.expect((Object)this.pubsubRpcMock.list(request1)).andReturn((Object)futureResponse1);
        EasyMock.expect((Object)this.pubsubRpcMock.list(request2)).andReturn((Object)futureResponse2);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        Page page = this.pubsub.listSubscriptions(TOPIC, new PubSub.ListOption[0]);
        Assert.assertEquals((Object)cursor1, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])subscriptionList1.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), SubscriptionId.class));
        page = page.nextPage();
        Assert.assertEquals((Object)cursor2, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])subscriptionList2.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), SubscriptionId.class));
    }

    @Test
    public void testListTopicSubscriptionsEmpty() {
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        ListTopicSubscriptionsRequest request = ListTopicSubscriptionsRequest.newBuilder().setTopic(TOPIC_NAME_PB).build();
        ImmutableList subscriptionList = ImmutableList.of();
        ListTopicSubscriptionsResponse response = ListTopicSubscriptionsResponse.newBuilder().setNextPageToken("").addAllSubscriptions((Iterable)Lists.transform((List)subscriptionList, SUBSCRIPTION_ID_TO_PB_FUNCTION)).build();
        ListenableFuture futureResponse = Futures.immediateFuture((Object)response);
        EasyMock.expect((Object)this.pubsubRpcMock.list(request)).andReturn((Object)futureResponse);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        Page page = this.pubsub.listSubscriptions(TOPIC, new PubSub.ListOption[0]);
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertNull((Object)page.nextPage());
        Assert.assertArrayEquals((Object[])subscriptionList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), SubscriptionId.class));
    }

    @Test
    public void testListTopicSubscriptionsWithOptions() {
        String cursor = "cursor";
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        ListTopicSubscriptionsRequest request = ListTopicSubscriptionsRequest.newBuilder().setTopic(TOPIC_NAME_PB).setPageSize(42).setPageToken(cursor).build();
        ImmutableList subscriptionList = ImmutableList.of((Object)new SubscriptionId(PROJECT, "subscription1"), (Object)new SubscriptionId(PROJECT, "subscription2"));
        ListTopicSubscriptionsResponse response = ListTopicSubscriptionsResponse.newBuilder().setNextPageToken("").addAllSubscriptions((Iterable)Lists.transform((List)subscriptionList, SUBSCRIPTION_ID_TO_PB_FUNCTION)).build();
        ListenableFuture futureResponse = Futures.immediateFuture((Object)response);
        EasyMock.expect((Object)this.pubsubRpcMock.list(request)).andReturn((Object)futureResponse);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        Page page = this.pubsub.listSubscriptions(TOPIC, new PubSub.ListOption[]{PubSub.ListOption.pageSize((int)42), PubSub.ListOption.pageToken((String)cursor)});
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertNull((Object)page.nextPage());
        Assert.assertArrayEquals((Object[])subscriptionList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), SubscriptionId.class));
    }

    @Test
    public void testListTopicSubscriptionsAsync() throws ExecutionException, InterruptedException {
        String cursor = "cursor";
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        ListTopicSubscriptionsRequest request = ListTopicSubscriptionsRequest.newBuilder().setTopic(TOPIC_NAME_PB).build();
        ImmutableList subscriptionList = ImmutableList.of((Object)new SubscriptionId(PROJECT, "subscription1"), (Object)new SubscriptionId(PROJECT, "subscription2"));
        ListTopicSubscriptionsResponse response = ListTopicSubscriptionsResponse.newBuilder().setNextPageToken("cursor").addAllSubscriptions((Iterable)Lists.transform((List)subscriptionList, SUBSCRIPTION_ID_TO_PB_FUNCTION)).build();
        ListenableFuture futureResponse = Futures.immediateFuture((Object)response);
        EasyMock.expect((Object)this.pubsubRpcMock.list(request)).andReturn((Object)futureResponse);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        AsyncPage page = (AsyncPage)this.pubsub.listSubscriptionsAsync(TOPIC, new PubSub.ListOption[0]).get();
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])subscriptionList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), SubscriptionId.class));
    }

    @Test
    public void testListTopicSubscriptionsAsyncNextPage() throws ExecutionException, InterruptedException {
        String cursor1 = "cursor";
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        ListTopicSubscriptionsRequest request1 = ListTopicSubscriptionsRequest.newBuilder().setTopic(TOPIC_NAME_PB).build();
        ListTopicSubscriptionsRequest request2 = ListTopicSubscriptionsRequest.newBuilder().setTopic(TOPIC_NAME_PB).setPageToken(cursor1).build();
        ImmutableList subscriptionList1 = ImmutableList.of((Object)new SubscriptionId(PROJECT, "subscription1"), (Object)new SubscriptionId(PROJECT, "subscription2"));
        ImmutableList subscriptionList2 = ImmutableList.of((Object)new SubscriptionId(PROJECT, "subscription3"));
        ListTopicSubscriptionsResponse response1 = ListTopicSubscriptionsResponse.newBuilder().setNextPageToken(cursor1).addAllSubscriptions((Iterable)Lists.transform((List)subscriptionList1, SUBSCRIPTION_ID_TO_PB_FUNCTION)).build();
        String cursor2 = "nextCursor";
        ListTopicSubscriptionsResponse response2 = ListTopicSubscriptionsResponse.newBuilder().setNextPageToken(cursor2).addAllSubscriptions((Iterable)Lists.transform((List)subscriptionList2, SUBSCRIPTION_ID_TO_PB_FUNCTION)).build();
        ListenableFuture futureResponse1 = Futures.immediateFuture((Object)response1);
        ListenableFuture futureResponse2 = Futures.immediateFuture((Object)response2);
        EasyMock.expect((Object)this.pubsubRpcMock.list(request1)).andReturn((Object)futureResponse1);
        EasyMock.expect((Object)this.pubsubRpcMock.list(request2)).andReturn((Object)futureResponse2);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        AsyncPage page = (AsyncPage)this.pubsub.listSubscriptionsAsync(TOPIC, new PubSub.ListOption[0]).get();
        Assert.assertEquals((Object)cursor1, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])subscriptionList1.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), SubscriptionId.class));
        page = (AsyncPage)page.nextPageAsync().get();
        Assert.assertEquals((Object)cursor2, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])subscriptionList2.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), SubscriptionId.class));
    }

    @Test
    public void testListTopicSubscriptionsAsyncEmpty() throws ExecutionException, InterruptedException {
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        ListTopicSubscriptionsRequest request = ListTopicSubscriptionsRequest.newBuilder().setTopic(TOPIC_NAME_PB).build();
        ImmutableList subscriptionList = ImmutableList.of();
        ListTopicSubscriptionsResponse response = ListTopicSubscriptionsResponse.newBuilder().setNextPageToken("").addAllSubscriptions((Iterable)Lists.transform((List)subscriptionList, SUBSCRIPTION_ID_TO_PB_FUNCTION)).build();
        ListenableFuture futureResponse = Futures.immediateFuture((Object)response);
        EasyMock.expect((Object)this.pubsubRpcMock.list(request)).andReturn((Object)futureResponse);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        AsyncPage page = (AsyncPage)this.pubsub.listSubscriptionsAsync(TOPIC, new PubSub.ListOption[0]).get();
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertNull((Object)page.nextPage());
        Assert.assertNull(page.nextPageAsync().get());
        Assert.assertArrayEquals((Object[])subscriptionList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), SubscriptionId.class));
    }

    @Test
    public void testListTopicSubscriptionsAsyncWithOptions() throws ExecutionException, InterruptedException {
        String cursor = "cursor";
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        ListTopicSubscriptionsRequest request = ListTopicSubscriptionsRequest.newBuilder().setTopic(TOPIC_NAME_PB).setPageSize(42).setPageToken(cursor).build();
        ImmutableList subscriptionList = ImmutableList.of((Object)new SubscriptionId(PROJECT, "subscription1"), (Object)new SubscriptionId(PROJECT, "subscription2"));
        ListTopicSubscriptionsResponse response = ListTopicSubscriptionsResponse.newBuilder().setNextPageToken("").addAllSubscriptions((Iterable)Lists.transform((List)subscriptionList, SUBSCRIPTION_ID_TO_PB_FUNCTION)).build();
        ListenableFuture futureResponse = Futures.immediateFuture((Object)response);
        EasyMock.expect((Object)this.pubsubRpcMock.list(request)).andReturn((Object)futureResponse);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        AsyncPage page = (AsyncPage)this.pubsub.listSubscriptionsAsync(TOPIC, new PubSub.ListOption[]{PubSub.ListOption.pageSize((int)42), PubSub.ListOption.pageToken((String)cursor)}).get();
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertNull((Object)page.nextPage());
        Assert.assertNull(page.nextPageAsync().get());
        Assert.assertArrayEquals((Object[])subscriptionList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), SubscriptionId.class));
    }

    @Test
    public void testPullMessages() throws ExecutionException, InterruptedException {
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        PullRequest request = PullRequest.newBuilder().setSubscription(SUBSCRIPTION_NAME_PB).setMaxMessages(42).setReturnImmediately(true).build();
        ImmutableList messageList = ImmutableList.of((Object)ReceivedMessage.fromPb((PubSub)this.pubsub, (String)SUBSCRIPTION, (com.google.pubsub.v1.ReceivedMessage)MESSAGE_PB1), (Object)ReceivedMessage.fromPb((PubSub)this.pubsub, (String)SUBSCRIPTION, (com.google.pubsub.v1.ReceivedMessage)MESSAGE_PB2));
        PullResponse response = PullResponse.newBuilder().addReceivedMessages(MESSAGE_PB1).addReceivedMessages(MESSAGE_PB2).build();
        Capture callback = Capture.newInstance();
        PubSubRpc.PullFuture futureMock = (PubSubRpc.PullFuture)EasyMock.createStrictMock(PubSubRpc.PullFuture.class);
        futureMock.addCallback((PubSubRpc.PullCallback)EasyMock.capture((Capture)callback));
        EasyMock.expectLastCall();
        EasyMock.expect((Object)futureMock.get()).andReturn((Object)response);
        EasyMock.expect((Object)this.pubsubRpcMock.pull(request)).andReturn((Object)futureMock);
        this.renewerMock.add(SUBSCRIPTION, (Iterable)ImmutableList.of((Object)"ackId1", (Object)"ackId2"));
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock, futureMock});
        Iterator messageIterator = this.pubsub.pull(SUBSCRIPTION, 42);
        ((PubSubRpc.PullCallback)callback.getValue()).success(response);
        EasyMock.reset((Object[])new Object[]{this.renewerMock});
        for (ReceivedMessage message : messageList) {
            this.renewerMock.remove(SUBSCRIPTION, message.ackId());
            EasyMock.expectLastCall();
        }
        EasyMock.replay((Object[])new Object[]{this.renewerMock});
        while (messageIterator.hasNext()) {
            messageIterator.next();
        }
        EasyMock.verify((Object[])new Object[]{futureMock});
    }

    @Test
    public void testPullMessagesAsync() throws ExecutionException, InterruptedException {
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        PullRequest request = PullRequest.newBuilder().setSubscription(SUBSCRIPTION_NAME_PB).setMaxMessages(42).setReturnImmediately(true).build();
        ImmutableList messageList = ImmutableList.of((Object)ReceivedMessage.fromPb((PubSub)this.pubsub, (String)SUBSCRIPTION, (com.google.pubsub.v1.ReceivedMessage)MESSAGE_PB1), (Object)ReceivedMessage.fromPb((PubSub)this.pubsub, (String)SUBSCRIPTION, (com.google.pubsub.v1.ReceivedMessage)MESSAGE_PB2));
        PullResponse response = PullResponse.newBuilder().addReceivedMessages(MESSAGE_PB1).addReceivedMessages(MESSAGE_PB2).build();
        Capture callback = Capture.newInstance();
        PubSubRpc.PullFuture futureMock = (PubSubRpc.PullFuture)EasyMock.createStrictMock(PubSubRpc.PullFuture.class);
        futureMock.addCallback((PubSubRpc.PullCallback)EasyMock.capture((Capture)callback));
        EasyMock.expectLastCall();
        EasyMock.expect((Object)futureMock.get()).andReturn((Object)response);
        EasyMock.expect((Object)this.pubsubRpcMock.pull(request)).andReturn((Object)futureMock);
        this.renewerMock.add(SUBSCRIPTION, (Iterable)ImmutableList.of((Object)"ackId1", (Object)"ackId2"));
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock, futureMock});
        Iterator messageIterator = (Iterator)this.pubsub.pullAsync(SUBSCRIPTION, 42).get();
        ((PubSubRpc.PullCallback)callback.getValue()).success(response);
        EasyMock.reset((Object[])new Object[]{this.renewerMock});
        for (ReceivedMessage message : messageList) {
            this.renewerMock.remove(SUBSCRIPTION, message.ackId());
            EasyMock.expectLastCall();
        }
        EasyMock.replay((Object[])new Object[]{this.renewerMock});
        while (messageIterator.hasNext()) {
            messageIterator.next();
        }
        EasyMock.verify((Object[])new Object[]{futureMock});
    }

    @Test
    public void testPullMessagesError() throws ExecutionException, InterruptedException {
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        PullRequest request = PullRequest.newBuilder().setSubscription(SUBSCRIPTION_NAME_PB).setMaxMessages(42).setReturnImmediately(true).build();
        PubSubException exception = new PubSubException(new IOException(), false);
        PubSubRpc.PullFuture futureMock = (PubSubRpc.PullFuture)EasyMock.createStrictMock(PubSubRpc.PullFuture.class);
        futureMock.addCallback((PubSubRpc.PullCallback)EasyMock.anyObject(PubSubRpc.PullCallback.class));
        EasyMock.expectLastCall();
        EasyMock.expect((Object)futureMock.get()).andThrow((Throwable)new ExecutionException(exception));
        EasyMock.expect((Object)this.pubsubRpcMock.pull(request)).andReturn((Object)futureMock);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock, futureMock});
        try {
            this.pubsub.pull(SUBSCRIPTION, 42);
            Assert.fail((String)"Expected PubSubException");
        }
        catch (PubSubException ex) {
            Assert.assertSame((Object)((Object)exception), (Object)((Object)ex));
        }
        EasyMock.verify((Object[])new Object[]{futureMock});
    }

    @Test
    public void testPullMessagesAsyncError() throws ExecutionException, InterruptedException {
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        PullRequest request = PullRequest.newBuilder().setSubscription(SUBSCRIPTION_NAME_PB).setMaxMessages(42).setReturnImmediately(true).build();
        PubSubException exception = new PubSubException(new IOException(), false);
        PubSubRpc.PullFuture futureMock = (PubSubRpc.PullFuture)EasyMock.createStrictMock(PubSubRpc.PullFuture.class);
        futureMock.addCallback((PubSubRpc.PullCallback)EasyMock.anyObject(PubSubRpc.PullCallback.class));
        EasyMock.expectLastCall();
        EasyMock.expect((Object)futureMock.get()).andThrow((Throwable)new ExecutionException(exception));
        EasyMock.expect((Object)this.pubsubRpcMock.pull(request)).andReturn((Object)futureMock);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock, futureMock});
        try {
            this.pubsub.pullAsync(SUBSCRIPTION, 42).get();
            Assert.fail((String)"Expected ExecutionException");
        }
        catch (ExecutionException ex) {
            Assert.assertSame((Object)((Object)exception), (Object)ex.getCause());
        }
        EasyMock.verify((Object[])new Object[]{futureMock});
    }

    @Test
    public void testMessageConsumer() throws Exception {
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        EasyMock.reset((Object[])new Object[]{this.options});
        EasyMock.expect((Object)this.options.service()).andReturn((Object)this.pubsub);
        EasyMock.expect((Object)this.options.rpc()).andReturn((Object)this.pubsubRpcMock);
        EasyMock.expect((Object)this.options.projectId()).andReturn((Object)PROJECT);
        EasyMock.replay((Object[])new Object[]{this.options});
        PullRequest request = PullRequest.newBuilder().setSubscription(SUBSCRIPTION_NAME_PB).setMaxMessages(100).setReturnImmediately(false).build();
        final PullResponse response = PullResponse.getDefaultInstance();
        final CountDownLatch latch = new CountDownLatch(1);
        EasyMock.expect((Object)this.pubsubRpcMock.pull(request)).andAnswer((IAnswer)new IAnswer<PubSubRpc.PullFuture>(){

            public PubSubRpc.PullFuture answer() throws Throwable {
                latch.countDown();
                return new MessageConsumerImplTest.TestPullFuture(response);
            }
        });
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        try (PubSub.MessageConsumer consumer = this.pubsub.pullAsync(SUBSCRIPTION, DO_NOTHING, new PubSub.PullOption[0]);){
            latch.await();
        }
    }

    @Test
    public void testMessageConsumerWithOptions() throws Exception {
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        EasyMock.reset((Object[])new Object[]{this.options});
        EasyMock.expect((Object)this.options.service()).andReturn((Object)this.pubsub);
        EasyMock.expect((Object)this.options.rpc()).andReturn((Object)this.pubsubRpcMock);
        EasyMock.expect((Object)this.options.projectId()).andReturn((Object)PROJECT);
        EasyMock.replay((Object[])new Object[]{this.options});
        GrpcServiceOptions.ExecutorFactory executorFactoryMock = (GrpcServiceOptions.ExecutorFactory)EasyMock.createStrictMock(GrpcServiceOptions.ExecutorFactory.class);
        ExecutorService executorServiceMock = (ExecutorService)EasyMock.createStrictMock(ExecutorService.class);
        EasyMock.expect((Object)executorFactoryMock.get()).andReturn((Object)executorServiceMock);
        executorFactoryMock.release(executorServiceMock);
        PullRequest request = PullRequest.newBuilder().setSubscription(SUBSCRIPTION_NAME_PB).setMaxMessages(42).setReturnImmediately(false).build();
        final PullResponse response = PullResponse.getDefaultInstance();
        final CountDownLatch latch = new CountDownLatch(1);
        EasyMock.expect((Object)this.pubsubRpcMock.pull(request)).andAnswer((IAnswer)new IAnswer<PubSubRpc.PullFuture>(){

            public PubSubRpc.PullFuture answer() throws Throwable {
                latch.countDown();
                return new MessageConsumerImplTest.TestPullFuture(response);
            }
        });
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock, executorFactoryMock, executorServiceMock});
        PubSub.PullOption[] options = new PubSub.PullOption[]{PubSub.PullOption.maxQueuedCallbacks((int)42), PubSub.PullOption.executorFactory((GrpcServiceOptions.ExecutorFactory)executorFactoryMock)};
        try (PubSub.MessageConsumer consumer = this.pubsub.pullAsync(SUBSCRIPTION, DO_NOTHING, options);){
            latch.await();
        }
    }

    @Test
    public void testAckOneMessage() {
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        AcknowledgeRequest request = AcknowledgeRequest.newBuilder().setSubscription(SUBSCRIPTION_NAME_PB).addAckIds("ackId").build();
        ListenableFuture response = Futures.immediateFuture((Object)Empty.getDefaultInstance());
        EasyMock.expect((Object)this.pubsubRpcMock.acknowledge(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub.ack(SUBSCRIPTION, "ackId", new String[0]);
    }

    @Test
    public void testAckOneMessageAsync() throws ExecutionException, InterruptedException {
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        AcknowledgeRequest request = AcknowledgeRequest.newBuilder().setSubscription(SUBSCRIPTION_NAME_PB).addAckIds("ackId").build();
        ListenableFuture response = Futures.immediateFuture((Object)Empty.getDefaultInstance());
        EasyMock.expect((Object)this.pubsubRpcMock.acknowledge(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        Future future = this.pubsub.ackAsync(SUBSCRIPTION, "ackId", new String[0]);
        Assert.assertNull(future.get());
    }

    @Test
    public void testAckMoreMessages() {
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        AcknowledgeRequest request = AcknowledgeRequest.newBuilder().setSubscription(SUBSCRIPTION_NAME_PB).addAllAckIds((Iterable)ImmutableList.of((Object)"ackId1", (Object)"ackId2")).build();
        ListenableFuture response = Futures.immediateFuture((Object)Empty.getDefaultInstance());
        EasyMock.expect((Object)this.pubsubRpcMock.acknowledge(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub.ack(SUBSCRIPTION, "ackId1", new String[]{"ackId2"});
    }

    @Test
    public void testAckMoreMessagesAsync() throws ExecutionException, InterruptedException {
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        AcknowledgeRequest request = AcknowledgeRequest.newBuilder().setSubscription(SUBSCRIPTION_NAME_PB).addAllAckIds((Iterable)ImmutableList.of((Object)"ackId1", (Object)"ackId2")).build();
        ListenableFuture response = Futures.immediateFuture((Object)Empty.getDefaultInstance());
        EasyMock.expect((Object)this.pubsubRpcMock.acknowledge(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        Future future = this.pubsub.ackAsync(SUBSCRIPTION, "ackId1", new String[]{"ackId2"});
        Assert.assertNull(future.get());
    }

    @Test
    public void testAckMessageList() {
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        ImmutableList ackIds = ImmutableList.of((Object)"ackId1", (Object)"ackId2");
        AcknowledgeRequest request = AcknowledgeRequest.newBuilder().setSubscription(SUBSCRIPTION_NAME_PB).addAllAckIds((Iterable)ackIds).build();
        ListenableFuture response = Futures.immediateFuture((Object)Empty.getDefaultInstance());
        EasyMock.expect((Object)this.pubsubRpcMock.acknowledge(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub.ack(SUBSCRIPTION, (Iterable)ackIds);
    }

    @Test
    public void testAckMessageListAsync() throws ExecutionException, InterruptedException {
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        ImmutableList ackIds = ImmutableList.of((Object)"ackId1", (Object)"ackId2");
        AcknowledgeRequest request = AcknowledgeRequest.newBuilder().setSubscription(SUBSCRIPTION_NAME_PB).addAllAckIds((Iterable)ackIds).build();
        ListenableFuture response = Futures.immediateFuture((Object)Empty.getDefaultInstance());
        EasyMock.expect((Object)this.pubsubRpcMock.acknowledge(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        Future future = this.pubsub.ackAsync(SUBSCRIPTION, (Iterable)ackIds);
        Assert.assertNull(future.get());
    }

    @Test
    public void testNackOneMessage() {
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        ModifyAckDeadlineRequest request = ModifyAckDeadlineRequest.newBuilder().setAckDeadlineSeconds(0).setSubscription(SUBSCRIPTION_NAME_PB).addAckIds("ackId").build();
        ListenableFuture response = Futures.immediateFuture((Object)Empty.getDefaultInstance());
        EasyMock.expect((Object)this.pubsubRpcMock.modify(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub.nack(SUBSCRIPTION, "ackId", new String[0]);
    }

    @Test
    public void testNackOneMessageAsync() throws ExecutionException, InterruptedException {
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        ModifyAckDeadlineRequest request = ModifyAckDeadlineRequest.newBuilder().setAckDeadlineSeconds(0).setSubscription(SUBSCRIPTION_NAME_PB).addAckIds("ackId").build();
        ListenableFuture response = Futures.immediateFuture((Object)Empty.getDefaultInstance());
        EasyMock.expect((Object)this.pubsubRpcMock.modify(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        Future future = this.pubsub.nackAsync(SUBSCRIPTION, "ackId", new String[0]);
        Assert.assertNull(future.get());
    }

    @Test
    public void testNackMoreMessages() {
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        ModifyAckDeadlineRequest request = ModifyAckDeadlineRequest.newBuilder().setAckDeadlineSeconds(0).setSubscription(SUBSCRIPTION_NAME_PB).addAllAckIds((Iterable)ImmutableList.of((Object)"ackId1", (Object)"ackId2")).build();
        ListenableFuture response = Futures.immediateFuture((Object)Empty.getDefaultInstance());
        EasyMock.expect((Object)this.pubsubRpcMock.modify(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub.nack(SUBSCRIPTION, "ackId1", new String[]{"ackId2"});
    }

    @Test
    public void testNackMoreMessagesAsync() throws ExecutionException, InterruptedException {
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        ModifyAckDeadlineRequest request = ModifyAckDeadlineRequest.newBuilder().setAckDeadlineSeconds(0).setSubscription(SUBSCRIPTION_NAME_PB).addAllAckIds((Iterable)ImmutableList.of((Object)"ackId1", (Object)"ackId2")).build();
        ListenableFuture response = Futures.immediateFuture((Object)Empty.getDefaultInstance());
        EasyMock.expect((Object)this.pubsubRpcMock.modify(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        Future future = this.pubsub.nackAsync(SUBSCRIPTION, "ackId1", new String[]{"ackId2"});
        Assert.assertNull(future.get());
    }

    @Test
    public void testNackMessageList() {
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        ImmutableList ackIds = ImmutableList.of((Object)"ackId1", (Object)"ackId2");
        ModifyAckDeadlineRequest request = ModifyAckDeadlineRequest.newBuilder().setAckDeadlineSeconds(0).setSubscription(SUBSCRIPTION_NAME_PB).addAllAckIds((Iterable)ackIds).build();
        ListenableFuture response = Futures.immediateFuture((Object)Empty.getDefaultInstance());
        EasyMock.expect((Object)this.pubsubRpcMock.modify(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub.nack(SUBSCRIPTION, (Iterable)ackIds);
    }

    @Test
    public void testNackMessageListAsync() throws ExecutionException, InterruptedException {
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        ImmutableList ackIds = ImmutableList.of((Object)"ackId1", (Object)"ackId2");
        ModifyAckDeadlineRequest request = ModifyAckDeadlineRequest.newBuilder().setAckDeadlineSeconds(0).setSubscription(SUBSCRIPTION_NAME_PB).addAllAckIds((Iterable)ackIds).build();
        ListenableFuture response = Futures.immediateFuture((Object)Empty.getDefaultInstance());
        EasyMock.expect((Object)this.pubsubRpcMock.modify(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        Future future = this.pubsub.nackAsync(SUBSCRIPTION, (Iterable)ackIds);
        Assert.assertNull(future.get());
    }

    @Test
    public void testModifyAckDeadlineOneMessage() {
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        ModifyAckDeadlineRequest request = ModifyAckDeadlineRequest.newBuilder().setAckDeadlineSeconds(10).setSubscription(SUBSCRIPTION_NAME_PB).addAckIds("ackId").build();
        ListenableFuture response = Futures.immediateFuture((Object)Empty.getDefaultInstance());
        EasyMock.expect((Object)this.pubsubRpcMock.modify(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub.modifyAckDeadline(SUBSCRIPTION, 10, TimeUnit.SECONDS, "ackId", new String[0]);
    }

    @Test
    public void testModifyAckDeadlineOneMessageAsync() throws ExecutionException, InterruptedException {
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        ModifyAckDeadlineRequest request = ModifyAckDeadlineRequest.newBuilder().setAckDeadlineSeconds(10).setSubscription(SUBSCRIPTION_NAME_PB).addAckIds("ackId").build();
        ListenableFuture response = Futures.immediateFuture((Object)Empty.getDefaultInstance());
        EasyMock.expect((Object)this.pubsubRpcMock.modify(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        Future future = this.pubsub.modifyAckDeadlineAsync(SUBSCRIPTION, 10, TimeUnit.SECONDS, "ackId", new String[0]);
        Assert.assertNull(future.get());
    }

    @Test
    public void testModifyAckDeadlineMoreMessages() {
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        ModifyAckDeadlineRequest request = ModifyAckDeadlineRequest.newBuilder().setAckDeadlineSeconds(10).setSubscription(SUBSCRIPTION_NAME_PB).addAllAckIds((Iterable)ImmutableList.of((Object)"ackId1", (Object)"ackId2")).build();
        ListenableFuture response = Futures.immediateFuture((Object)Empty.getDefaultInstance());
        EasyMock.expect((Object)this.pubsubRpcMock.modify(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub.modifyAckDeadline(SUBSCRIPTION, 10, TimeUnit.SECONDS, "ackId1", new String[]{"ackId2"});
    }

    @Test
    public void testModifyAckDeadlineMoreMessagesAsync() throws ExecutionException, InterruptedException {
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        ModifyAckDeadlineRequest request = ModifyAckDeadlineRequest.newBuilder().setAckDeadlineSeconds(10).setSubscription(SUBSCRIPTION_NAME_PB).addAllAckIds((Iterable)ImmutableList.of((Object)"ackId1", (Object)"ackId2")).build();
        ListenableFuture response = Futures.immediateFuture((Object)Empty.getDefaultInstance());
        EasyMock.expect((Object)this.pubsubRpcMock.modify(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        Future future = this.pubsub.modifyAckDeadlineAsync(SUBSCRIPTION, 10, TimeUnit.SECONDS, "ackId1", new String[]{"ackId2"});
        Assert.assertNull(future.get());
    }

    @Test
    public void testModifyAckDeadlineMessageList() {
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        ImmutableList ackIds = ImmutableList.of((Object)"ackId1", (Object)"ackId2");
        ModifyAckDeadlineRequest request = ModifyAckDeadlineRequest.newBuilder().setAckDeadlineSeconds(10).setSubscription(SUBSCRIPTION_NAME_PB).addAllAckIds((Iterable)ackIds).build();
        ListenableFuture response = Futures.immediateFuture((Object)Empty.getDefaultInstance());
        EasyMock.expect((Object)this.pubsubRpcMock.modify(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub.modifyAckDeadline(SUBSCRIPTION, 10, TimeUnit.SECONDS, (Iterable)ackIds);
    }

    @Test
    public void testModifyAckDeadlineMessageListAsync() throws ExecutionException, InterruptedException {
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        ImmutableList ackIds = ImmutableList.of((Object)"ackId1", (Object)"ackId2");
        ModifyAckDeadlineRequest request = ModifyAckDeadlineRequest.newBuilder().setAckDeadlineSeconds(10).setSubscription(SUBSCRIPTION_NAME_PB).addAllAckIds((Iterable)ackIds).build();
        ListenableFuture response = Futures.immediateFuture((Object)Empty.getDefaultInstance());
        EasyMock.expect((Object)this.pubsubRpcMock.modify(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        Future future = this.pubsub.modifyAckDeadlineAsync(SUBSCRIPTION, 10, TimeUnit.SECONDS, (Iterable)ackIds);
        Assert.assertNull(future.get());
    }

    @Test
    public void testClose() throws Exception {
        this.pubsub = new PubSubImpl(this.options, this.renewerMock);
        this.pubsubRpcMock.close();
        EasyMock.expectLastCall();
        EasyMock.expectLastCall();
        this.renewerMock.close();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.pubsubRpcMock, this.renewerMock});
        this.pubsub.close();
        this.pubsub.close();
    }
}

