/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.cloud.AuthCredentials;
import com.google.cloud.BaseSerializationTest;
import com.google.cloud.GrpcServiceOptions;
import com.google.cloud.Restorable;
import com.google.cloud.pubsub.Message;
import com.google.cloud.pubsub.PubSub;
import com.google.cloud.pubsub.PubSubOptions;
import com.google.cloud.pubsub.ReceivedMessage;
import com.google.cloud.pubsub.Subscription;
import com.google.cloud.pubsub.SubscriptionId;
import com.google.cloud.pubsub.SubscriptionInfo;
import com.google.cloud.pubsub.Topic;
import com.google.cloud.pubsub.TopicInfo;
import java.io.Serializable;
import java.util.concurrent.ScheduledExecutorService;

public class SerializationTest
extends BaseSerializationTest {
    private static final PubSub PUB_SUB = (PubSub)((PubSubOptions.Builder)((PubSubOptions.Builder)((PubSubOptions.Builder)PubSubOptions.builder().projectId("p")).authCredentials(AuthCredentials.noAuth())).host("localhost")).build().service();
    private static final Message MESSAGE = Message.of((String)"payload");
    private static final com.google.pubsub.v1.ReceivedMessage RECEIVED_MESSAGE_PB = com.google.pubsub.v1.ReceivedMessage.newBuilder().setMessage(MESSAGE.toPb()).setAckId("ackId").build();
    private static final ReceivedMessage RECEIVED_MESSAGE = ReceivedMessage.fromPb((PubSub)PUB_SUB, (String)"subscription", (com.google.pubsub.v1.ReceivedMessage)RECEIVED_MESSAGE_PB);
    private static final SubscriptionInfo SUBSCRIPTION_INFO = SubscriptionInfo.of((String)"topic", (String)"sub");
    private static final Subscription SUBSCRIPTION = new Subscription(PUB_SUB, new SubscriptionInfo.BuilderImpl(SUBSCRIPTION_INFO));
    private static final SubscriptionId SUBSCRIPTION_ID = new SubscriptionId("project", "sub");
    private static final TopicInfo TOPIC_INFO = TopicInfo.of((String)"topic");
    private static final Topic TOPIC = new Topic(PUB_SUB, new TopicInfo.BuilderImpl(TOPIC_INFO));
    private static final PubSub.ListOption PAGE_TOKEN_OPTION = PubSub.ListOption.pageToken((String)"cursor");
    private static final PubSub.ListOption PAGE_SIZE_OPTION = PubSub.ListOption.pageSize((int)42);
    private static final PubSub.PullOption MAX_QUEUED_CALLBACKS_OPTION = PubSub.PullOption.maxQueuedCallbacks((int)42);
    private static final PubSub.PullOption EXECUTOR_FACTORY_OPTION = PubSub.PullOption.executorFactory((GrpcServiceOptions.ExecutorFactory)new TestExecutorFactory());

    protected Serializable[] serializableObjects() {
        PubSubOptions options = ((PubSubOptions.Builder)((PubSubOptions.Builder)PubSubOptions.builder().projectId("p1")).initialTimeout(1234)).build();
        PubSubOptions otherOptions = ((PubSubOptions.Builder)((PubSubOptions.Builder)options.toBuilder().projectId("p2")).executorFactory((GrpcServiceOptions.ExecutorFactory)new TestExecutorFactory())).build();
        return new Serializable[]{options, otherOptions, MESSAGE, RECEIVED_MESSAGE, SUBSCRIPTION_INFO, SUBSCRIPTION, SUBSCRIPTION_ID, TOPIC_INFO, TOPIC, PAGE_TOKEN_OPTION, PAGE_SIZE_OPTION, MAX_QUEUED_CALLBACKS_OPTION, EXECUTOR_FACTORY_OPTION};
    }

    protected Restorable<?>[] restorableObjects() {
        return null;
    }

    public static class TestExecutorFactory
    implements GrpcServiceOptions.ExecutorFactory<ScheduledExecutorService>,
    Serializable {
        private static final long serialVersionUID = -2154875338174302704L;

        public ScheduledExecutorService get() {
            return null;
        }

        public void release(ScheduledExecutorService executor) {
        }

        public boolean equals(Object obj) {
            return obj instanceof TestExecutorFactory;
        }

        public int hashCode() {
            return 1;
        }
    }
}

