/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.cloud.pubsub.PushConfig;
import com.google.cloud.pubsub.SubscriptionInfo;
import com.google.cloud.pubsub.TopicId;
import com.google.pubsub.v1.Subscription;
import org.junit.Assert;
import org.junit.Test;

public class SubscriptionInfoTest {
    private static final TopicId TOPIC = TopicId.of((String)"project", (String)"topic");
    private static final String NAME = "subscription";
    private static final String ENDPOINT = "https://example.com/push";
    private static final PushConfig PUSH_CONFIG = PushConfig.of((String)"https://example.com/push");
    private static final int ACK_DEADLINE = 42;
    private static final SubscriptionInfo SUBSCRIPTION_INFO = SubscriptionInfo.builder((TopicId)TOPIC, (String)"subscription").pushConfig(PUSH_CONFIG).ackDeadLineSeconds(42).build();

    @Test
    public void testToBuilder() {
        this.compareSubscriptionInfo(SUBSCRIPTION_INFO, SUBSCRIPTION_INFO.toBuilder().build());
        SubscriptionInfo subscriptionInfo = SUBSCRIPTION_INFO.toBuilder().topic("newTopic").name("newSubscription").build();
        Assert.assertEquals((Object)TopicId.of((String)"newTopic"), (Object)subscriptionInfo.topic());
        Assert.assertEquals((Object)"newSubscription", (Object)subscriptionInfo.name());
        subscriptionInfo = subscriptionInfo.toBuilder().name(NAME).topic(TOPIC).build();
        this.compareSubscriptionInfo(SUBSCRIPTION_INFO, subscriptionInfo);
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)TOPIC, (Object)SUBSCRIPTION_INFO.topic());
        Assert.assertEquals((Object)NAME, (Object)SUBSCRIPTION_INFO.name());
        Assert.assertEquals((Object)PUSH_CONFIG, (Object)SUBSCRIPTION_INFO.pushConfig());
        Assert.assertEquals((long)42L, (long)SUBSCRIPTION_INFO.ackDeadlineSeconds());
        SubscriptionInfo subscriptionInfo = SubscriptionInfo.builder((String)"topic", (String)NAME).build();
        Assert.assertEquals((Object)TopicId.of((String)"topic"), (Object)subscriptionInfo.topic());
        Assert.assertEquals((Object)NAME, (Object)subscriptionInfo.name());
        Assert.assertNull((Object)subscriptionInfo.pushConfig());
        Assert.assertEquals((long)0L, (long)subscriptionInfo.ackDeadlineSeconds());
        subscriptionInfo = SubscriptionInfo.builder((String)"topic", (String)NAME).topic("project", "topic").build();
        Assert.assertEquals((Object)TOPIC, (Object)subscriptionInfo.topic());
        Assert.assertEquals((Object)NAME, (Object)subscriptionInfo.name());
        Assert.assertNull((Object)subscriptionInfo.pushConfig());
        Assert.assertEquals((long)0L, (long)subscriptionInfo.ackDeadlineSeconds());
        subscriptionInfo = SubscriptionInfo.builder((String)"topic", (String)NAME).topic(TOPIC).build();
        Assert.assertEquals((Object)TOPIC, (Object)subscriptionInfo.topic());
        Assert.assertEquals((Object)NAME, (Object)subscriptionInfo.name());
        Assert.assertNull((Object)subscriptionInfo.pushConfig());
        Assert.assertEquals((long)0L, (long)subscriptionInfo.ackDeadlineSeconds());
    }

    @Test
    public void testOf() {
        SubscriptionInfo subscriptionInfo = SubscriptionInfo.of((TopicId)TOPIC, (String)NAME);
        Assert.assertEquals((Object)TOPIC, (Object)subscriptionInfo.topic());
        Assert.assertEquals((Object)NAME, (Object)subscriptionInfo.name());
        Assert.assertNull((Object)subscriptionInfo.pushConfig());
        Assert.assertEquals((long)0L, (long)subscriptionInfo.ackDeadlineSeconds());
        subscriptionInfo = SubscriptionInfo.of((String)"topic", (String)NAME);
        Assert.assertEquals((Object)TopicId.of((String)"topic"), (Object)subscriptionInfo.topic());
        Assert.assertEquals((Object)NAME, (Object)subscriptionInfo.name());
        Assert.assertNull((Object)subscriptionInfo.pushConfig());
        Assert.assertEquals((long)0L, (long)subscriptionInfo.ackDeadlineSeconds());
        subscriptionInfo = SubscriptionInfo.of((TopicId)TOPIC, (String)NAME, (String)ENDPOINT);
        Assert.assertEquals((Object)TOPIC, (Object)subscriptionInfo.topic());
        Assert.assertEquals((Object)NAME, (Object)subscriptionInfo.name());
        Assert.assertEquals((Object)PushConfig.of((String)ENDPOINT), (Object)subscriptionInfo.pushConfig());
        Assert.assertEquals((long)0L, (long)subscriptionInfo.ackDeadlineSeconds());
        subscriptionInfo = SubscriptionInfo.of((String)"topic", (String)NAME, (String)ENDPOINT);
        Assert.assertEquals((Object)TopicId.of((String)"topic"), (Object)subscriptionInfo.topic());
        Assert.assertEquals((Object)NAME, (Object)subscriptionInfo.name());
        Assert.assertEquals((Object)PushConfig.of((String)ENDPOINT), (Object)subscriptionInfo.pushConfig());
        Assert.assertEquals((long)0L, (long)subscriptionInfo.ackDeadlineSeconds());
    }

    @Test
    public void testToAndFromPb() {
        this.compareSubscriptionInfo(SUBSCRIPTION_INFO, SubscriptionInfo.fromPb((Subscription)SUBSCRIPTION_INFO.toPb("project")));
        SubscriptionInfo subscriptionInfo = SubscriptionInfo.of((TopicId)TOPIC, (String)NAME);
        this.compareSubscriptionInfo(subscriptionInfo, SubscriptionInfo.fromPb((Subscription)subscriptionInfo.toPb("project")));
        subscriptionInfo = SubscriptionInfo.of((String)"topic", (String)NAME);
        this.compareSubscriptionInfo(SubscriptionInfo.of((TopicId)TOPIC, (String)NAME), SubscriptionInfo.fromPb((Subscription)subscriptionInfo.toPb("project")));
        subscriptionInfo = SubscriptionInfo.of((TopicId)TOPIC, (String)NAME, (String)ENDPOINT);
        this.compareSubscriptionInfo(subscriptionInfo, SubscriptionInfo.fromPb((Subscription)subscriptionInfo.toPb("project")));
        subscriptionInfo = SubscriptionInfo.of((String)"topic", (String)NAME, (String)ENDPOINT);
        this.compareSubscriptionInfo(SubscriptionInfo.of((TopicId)TOPIC, (String)NAME, (String)ENDPOINT), SubscriptionInfo.fromPb((Subscription)subscriptionInfo.toPb("project")));
        Subscription subscription = SUBSCRIPTION_INFO.toPb("project");
        subscriptionInfo = SubscriptionInfo.fromPb((Subscription)subscription.toBuilder().setTopic("_deleted-topic_").build());
        Assert.assertEquals((Object)TopicId.deletedTopic(), (Object)subscriptionInfo.topic());
        Assert.assertEquals((Object)NAME, (Object)subscriptionInfo.name());
        Assert.assertEquals((Object)PUSH_CONFIG, (Object)subscriptionInfo.pushConfig());
        Assert.assertEquals((long)42L, (long)subscriptionInfo.ackDeadlineSeconds());
    }

    private void compareSubscriptionInfo(SubscriptionInfo expected, SubscriptionInfo value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.topic(), (Object)value.topic());
        Assert.assertEquals((Object)expected.name(), (Object)value.name());
        Assert.assertEquals((Object)expected.pushConfig(), (Object)value.pushConfig());
        Assert.assertEquals((long)expected.ackDeadlineSeconds(), (long)value.ackDeadlineSeconds());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

