/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.cloud.AsyncPage;
import com.google.cloud.GrpcServiceOptions;
import com.google.cloud.Page;
import com.google.cloud.Service;
import com.google.cloud.pubsub.Message;
import com.google.cloud.pubsub.Option;
import com.google.cloud.pubsub.PubSubOptions;
import com.google.cloud.pubsub.PushConfig;
import com.google.cloud.pubsub.ReceivedMessage;
import com.google.cloud.pubsub.Subscription;
import com.google.cloud.pubsub.SubscriptionId;
import com.google.cloud.pubsub.SubscriptionInfo;
import com.google.cloud.pubsub.Topic;
import com.google.cloud.pubsub.TopicInfo;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public interface PubSub
extends AutoCloseable,
Service<PubSubOptions> {
    public Topic create(TopicInfo var1);

    public Future<Topic> createAsync(TopicInfo var1);

    public Topic getTopic(String var1);

    public Future<Topic> getTopicAsync(String var1);

    public boolean deleteTopic(String var1);

    public Future<Boolean> deleteTopicAsync(String var1);

    public Page<Topic> listTopics(ListOption ... var1);

    public Future<AsyncPage<Topic>> listTopicsAsync(ListOption ... var1);

    public String publish(String var1, Message var2);

    public Future<String> publishAsync(String var1, Message var2);

    public List<String> publish(String var1, Message var2, Message ... var3);

    public Future<List<String>> publishAsync(String var1, Message var2, Message ... var3);

    public List<String> publish(String var1, Iterable<Message> var2);

    public Future<List<String>> publishAsync(String var1, Iterable<Message> var2);

    public Subscription create(SubscriptionInfo var1);

    public Future<Subscription> createAsync(SubscriptionInfo var1);

    public Subscription getSubscription(String var1);

    public Future<Subscription> getSubscriptionAsync(String var1);

    public void replacePushConfig(String var1, PushConfig var2);

    public Future<Void> replacePushConfigAsync(String var1, PushConfig var2);

    public boolean deleteSubscription(String var1);

    public Future<Boolean> deleteSubscriptionAsync(String var1);

    public Page<Subscription> listSubscriptions(ListOption ... var1);

    public Future<AsyncPage<Subscription>> listSubscriptionsAsync(ListOption ... var1);

    public Page<SubscriptionId> listSubscriptions(String var1, ListOption ... var2);

    public Future<AsyncPage<SubscriptionId>> listSubscriptionsAsync(String var1, ListOption ... var2);

    public Iterator<ReceivedMessage> pull(String var1, int var2);

    public Future<Iterator<ReceivedMessage>> pullAsync(String var1, int var2);

    public MessageConsumer pullAsync(String var1, MessageProcessor var2, PullOption ... var3);

    public void ack(String var1, String var2, String ... var3);

    public Future<Void> ackAsync(String var1, String var2, String ... var3);

    public void ack(String var1, Iterable<String> var2);

    public Future<Void> ackAsync(String var1, Iterable<String> var2);

    public void nack(String var1, String var2, String ... var3);

    public Future<Void> nackAsync(String var1, String var2, String ... var3);

    public void nack(String var1, Iterable<String> var2);

    public Future<Void> nackAsync(String var1, Iterable<String> var2);

    public void modifyAckDeadline(String var1, int var2, TimeUnit var3, String var4, String ... var5);

    public Future<Void> modifyAckDeadlineAsync(String var1, int var2, TimeUnit var3, String var4, String ... var5);

    public void modifyAckDeadline(String var1, int var2, TimeUnit var3, Iterable<String> var4);

    public Future<Void> modifyAckDeadlineAsync(String var1, int var2, TimeUnit var3, Iterable<String> var4);

    public static interface MessageConsumer
    extends AutoCloseable {
        @Override
        public void close() throws Exception;
    }

    public static interface MessageProcessor {
        public void process(Message var1) throws Exception;
    }

    public static final class PullOption
    extends Option {
        private static final long serialVersionUID = 4792164134340316582L;

        private PullOption(Option.OptionType option, Object value) {
            super(option, value);
        }

        public static PullOption maxQueuedCallbacks(int maxQueuedCallbacks) {
            return new PullOption(OptionType.MAX_QUEUED_CALLBACKS, maxQueuedCallbacks);
        }

        public static PullOption executorFactory(GrpcServiceOptions.ExecutorFactory executorFactory) {
            return new PullOption(OptionType.EXECUTOR_FACTORY, executorFactory);
        }

        static enum OptionType implements Option.OptionType
        {
            EXECUTOR_FACTORY,
            MAX_QUEUED_CALLBACKS;


            <T> T get(Map<Option.OptionType, ?> options) {
                return (T)options.get(this);
            }

            Integer getInteger(Map<Option.OptionType, ?> options) {
                return (Integer)this.get(options);
            }

            GrpcServiceOptions.ExecutorFactory<ExecutorService> getExecutorFactory(Map<Option.OptionType, ?> options) {
                return (GrpcServiceOptions.ExecutorFactory)this.get(options);
            }
        }
    }

    public static final class ListOption
    extends Option {
        private static final long serialVersionUID = 6517442127283383124L;

        private ListOption(OptionType option, Object value) {
            super(option, value);
        }

        public static ListOption pageSize(int pageSize) {
            return new ListOption(OptionType.PAGE_SIZE, (Object)pageSize);
        }

        public static ListOption pageToken(String pageToken) {
            return new ListOption(OptionType.PAGE_TOKEN, (Object)pageToken);
        }

        static enum OptionType implements Option.OptionType
        {
            PAGE_SIZE,
            PAGE_TOKEN;


            <T> T get(Map<Option.OptionType, ?> options) {
                return (T)options.get(this);
            }

            String getString(Map<Option.OptionType, ?> options) {
                return (String)this.get(options);
            }

            Integer getInteger(Map<Option.OptionType, ?> options) {
                return (Integer)this.get(options);
            }
        }
    }
}

