/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.cloud.GrpcServiceOptions;
import com.google.cloud.pubsub.PubSub;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class PubSubTest {
    private static final int PAGE_SIZE = 42;
    private static final String PAGE_TOKEN = "page token";
    private static final int MAX_QUEUED_CALLBACKS = 42;

    @Test
    public void testListOption() {
        PubSub.ListOption listOption = PubSub.ListOption.pageToken((String)PAGE_TOKEN);
        Assert.assertEquals((Object)PAGE_TOKEN, (Object)listOption.value());
        Assert.assertEquals((Object)PubSub.ListOption.OptionType.PAGE_TOKEN, (Object)listOption.optionType());
        listOption = PubSub.ListOption.pageSize((int)42);
        Assert.assertEquals((Object)42, (Object)listOption.value());
        Assert.assertEquals((Object)PubSub.ListOption.OptionType.PAGE_SIZE, (Object)listOption.optionType());
    }

    @Test
    public void testPullOptions() {
        PubSub.PullOption pullOption = PubSub.PullOption.maxQueuedCallbacks((int)42);
        Assert.assertEquals((Object)42, (Object)pullOption.value());
        Assert.assertEquals((Object)PubSub.PullOption.OptionType.MAX_QUEUED_CALLBACKS, (Object)pullOption.optionType());
        GrpcServiceOptions.ExecutorFactory executorFactory = (GrpcServiceOptions.ExecutorFactory)EasyMock.createStrictMock(GrpcServiceOptions.ExecutorFactory.class);
        pullOption = PubSub.PullOption.executorFactory((GrpcServiceOptions.ExecutorFactory)executorFactory);
        Assert.assertSame((Object)executorFactory, (Object)pullOption.value());
        Assert.assertEquals((Object)PubSub.PullOption.OptionType.EXECUTOR_FACTORY, (Object)pullOption.optionType());
    }
}

