/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.api.client.util.Charsets;
import com.google.cloud.ByteArray;
import com.google.cloud.pubsub.Message;
import com.google.cloud.pubsub.PubSub;
import com.google.cloud.pubsub.PubSubOptions;
import com.google.cloud.pubsub.ReceivedMessage;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ReceivedMessageTest {
    private static final String SUBSCRIPTION = "subscription";
    private static final String ACK_ID = "ackId";
    private static final String MESSAGE_ID = "messageId";
    private static final String PAYLOAD_STRING = "payload";
    private static final ByteArray PAYLOAD = ByteArray.copyFrom((byte[])"payload".getBytes(StandardCharsets.UTF_8));
    private static final Map<String, String> ATTRIBUTES = ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2");
    private static final Long PUBLISH_TIME = 42L;
    private static final Message MESSAGE = Message.builder((ByteArray)PAYLOAD).id("messageId").attributes(ATTRIBUTES).publishTime(PUBLISH_TIME.longValue()).build();
    private static final com.google.pubsub.v1.ReceivedMessage RECEIVED_MESSAGE_PB = com.google.pubsub.v1.ReceivedMessage.newBuilder().setMessage(MESSAGE.toPb()).setAckId("ackId").build();
    private final PubSub serviceMockReturnsOptions = (PubSub)EasyMock.createStrictMock(PubSub.class);
    private final PubSubOptions mockOptions = (PubSubOptions)EasyMock.createMock(PubSubOptions.class);
    private PubSub pubsub;
    private ReceivedMessage expectedMessage;
    private ReceivedMessage message;

    private void initializeExpectedMessage(int optionsCalls) {
        EasyMock.expect((Object)this.serviceMockReturnsOptions.options()).andReturn((Object)this.mockOptions).times(optionsCalls);
        EasyMock.replay((Object[])new Object[]{this.serviceMockReturnsOptions});
        this.pubsub = (PubSub)EasyMock.createStrictMock(PubSub.class);
        this.expectedMessage = ReceivedMessage.fromPb((PubSub)this.serviceMockReturnsOptions, (String)SUBSCRIPTION, (com.google.pubsub.v1.ReceivedMessage)RECEIVED_MESSAGE_PB);
    }

    private void initializeMessage() {
        this.message = ReceivedMessage.fromPb((PubSub)this.pubsub, (String)SUBSCRIPTION, (com.google.pubsub.v1.ReceivedMessage)RECEIVED_MESSAGE_PB);
    }

    @After
    public void tearDown() throws Exception {
        EasyMock.verify((Object[])new Object[]{this.pubsub, this.serviceMockReturnsOptions});
    }

    @Test
    public void testBuilder() {
        this.initializeExpectedMessage(3);
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        ImmutableMap attributes = ImmutableMap.of((Object)"newKey1", (Object)"newVal1");
        ReceivedMessage builtMessage = this.expectedMessage.toBuilder().payload("newPayload").id("newMessageId").attributes((Map)attributes).publishTime(PUBLISH_TIME + 1L).build();
        Assert.assertSame((Object)this.serviceMockReturnsOptions, (Object)builtMessage.pubsub());
        Assert.assertEquals((Object)SUBSCRIPTION, (Object)builtMessage.subscription());
        Assert.assertEquals((Object)ACK_ID, (Object)builtMessage.ackId());
        Assert.assertEquals((Object)"newMessageId", (Object)builtMessage.id());
        Assert.assertArrayEquals((byte[])"newPayload".getBytes(Charsets.UTF_8), (byte[])builtMessage.payload().toByteArray());
        Assert.assertEquals((Object)"newPayload", (Object)builtMessage.payloadAsString());
        Assert.assertEquals((Object)attributes, (Object)builtMessage.attributes());
        Assert.assertEquals((long)(PUBLISH_TIME + 1L), (long)builtMessage.publishTime());
        builtMessage = builtMessage.toBuilder().payload(PAYLOAD).id(MESSAGE_ID).clearAttributes().addAttribute("key1", "value1").addAttribute("key2", "value2").publishTime(PUBLISH_TIME.longValue()).build();
        Assert.assertSame((Object)this.serviceMockReturnsOptions, (Object)builtMessage.pubsub());
        Assert.assertEquals((Object)MESSAGE_ID, (Object)builtMessage.id());
        Assert.assertEquals((Object)PAYLOAD, (Object)builtMessage.payload());
        Assert.assertEquals((Object)PAYLOAD_STRING, (Object)builtMessage.payloadAsString());
        Assert.assertEquals(ATTRIBUTES, (Object)builtMessage.attributes());
        Assert.assertEquals((Object)PUBLISH_TIME, (Object)builtMessage.publishTime());
        this.compareReceivedMessage(this.expectedMessage, builtMessage);
    }

    @Test
    public void testToBuilder() {
        this.initializeExpectedMessage(2);
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.compareReceivedMessage(this.expectedMessage, this.expectedMessage.toBuilder().build());
    }

    @Test
    public void testAck() {
        this.initializeExpectedMessage(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        this.pubsub.ack(SUBSCRIPTION, ACK_ID, new String[0]);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeMessage();
        this.message.ack();
    }

    @Test
    public void testAckAsync() throws ExecutionException, InterruptedException {
        this.initializeExpectedMessage(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.pubsub.ackAsync(SUBSCRIPTION, ACK_ID, new String[0])).andReturn((Object)Futures.immediateFuture(null));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeMessage();
        Assert.assertNull(this.message.ackAsync().get());
    }

    @Test
    public void testModifyAckDeadline() {
        this.initializeExpectedMessage(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        this.pubsub.modifyAckDeadline(SUBSCRIPTION, 10, TimeUnit.SECONDS, ACK_ID, new String[0]);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeMessage();
        this.message.modifyAckDeadline(10, TimeUnit.SECONDS);
    }

    @Test
    public void testModifyAckDeadlineAsync() throws ExecutionException, InterruptedException {
        this.initializeExpectedMessage(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.pubsub.modifyAckDeadlineAsync(SUBSCRIPTION, 10, TimeUnit.SECONDS, ACK_ID, new String[0])).andReturn((Object)Futures.immediateFuture(null));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeMessage();
        Assert.assertNull(this.message.modifyAckDeadlineAsync(10, TimeUnit.SECONDS).get());
    }

    private void compareReceivedMessage(ReceivedMessage expected, ReceivedMessage value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.id(), (Object)value.id());
        Assert.assertEquals((Object)expected.payload(), (Object)value.payload());
        Assert.assertEquals((Object)expected.payloadAsString(), (Object)value.payloadAsString());
        Assert.assertEquals((Object)expected.attributes(), (Object)value.attributes());
        Assert.assertEquals((Object)expected.publishTime(), (Object)value.publishTime());
        Assert.assertEquals((Object)expected.ackId(), (Object)value.ackId());
        Assert.assertEquals((Object)expected.subscription(), (Object)value.subscription());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

