/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.cloud.pubsub.SubscriptionId;
import org.junit.Assert;
import org.junit.Test;

public class SubscriptionIdTest {
    private static final String PROJECT = "project";
    private static final String NAME = "subscription";
    private static final String TOPIC_PB = "projects/project/subscriptions/subscription";
    private static final SubscriptionId SUBSCRIPTION_ID = new SubscriptionId("project", "subscription");

    @Test
    public void testConstructor() {
        Assert.assertEquals((Object)PROJECT, (Object)SUBSCRIPTION_ID.project());
        Assert.assertEquals((Object)NAME, (Object)SUBSCRIPTION_ID.subscription());
    }

    @Test
    public void testToAndFromPb() {
        SubscriptionId subscriptionId = SubscriptionId.fromPb((String)TOPIC_PB);
        this.compareSubscriptionId(SUBSCRIPTION_ID, subscriptionId);
        Assert.assertEquals((Object)PROJECT, (Object)subscriptionId.project());
        Assert.assertEquals((Object)NAME, (Object)subscriptionId.subscription());
    }

    private void compareSubscriptionId(SubscriptionId expected, SubscriptionId value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.project(), (Object)value.project());
        Assert.assertEquals((Object)expected.subscription(), (Object)value.subscription());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

