/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.cloud.pubsub.Message;
import com.google.cloud.pubsub.PubSub;
import com.google.cloud.pubsub.PubSubOptions;
import com.google.cloud.pubsub.PushConfig;
import com.google.cloud.pubsub.ReceivedMessage;
import com.google.cloud.pubsub.Subscription;
import com.google.cloud.pubsub.SubscriptionInfo;
import com.google.cloud.pubsub.TopicId;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class SubscriptionTest {
    private static final TopicId TOPIC_ID = TopicId.of((String)"project", (String)"topic");
    private static final String NAME = "subscription";
    private static final String ENDPOINT = "https://example.com/push";
    private static final PushConfig PUSH_CONFIG = PushConfig.of((String)"https://example.com/push");
    private static final int ACK_DEADLINE = 42;
    private static final SubscriptionInfo SUBSCRIPTION_INFO = SubscriptionInfo.builder((TopicId)TOPIC_ID, (String)"subscription").pushConfig(PUSH_CONFIG).ackDeadLineSeconds(42).build();
    private static final Message MESSAGE1 = Message.of((String)"payload1");
    private static final com.google.pubsub.v1.ReceivedMessage MESSAGE_PB1 = com.google.pubsub.v1.ReceivedMessage.newBuilder().setMessage(MESSAGE1.toPb()).setAckId("ackId1").build();
    private static final Message MESSAGE2 = Message.of((String)"payload2");
    private static final com.google.pubsub.v1.ReceivedMessage MESSAGE_PB2 = com.google.pubsub.v1.ReceivedMessage.newBuilder().setMessage(MESSAGE2.toPb()).setAckId("ackId2").build();
    private final PubSub serviceMockReturnsOptions = (PubSub)EasyMock.createStrictMock(PubSub.class);
    private final PubSubOptions mockOptions = (PubSubOptions)EasyMock.createStrictMock(PubSubOptions.class);
    private PubSub pubsub;
    private Subscription expectedSubscription;
    private Subscription subscription;

    private void initializeExpectedSubscription(int optionsCalls) {
        EasyMock.expect((Object)this.serviceMockReturnsOptions.options()).andReturn((Object)this.mockOptions).times(optionsCalls);
        EasyMock.replay((Object[])new Object[]{this.serviceMockReturnsOptions});
        this.pubsub = (PubSub)EasyMock.createStrictMock(PubSub.class);
        this.expectedSubscription = new Subscription(this.serviceMockReturnsOptions, new SubscriptionInfo.BuilderImpl(SUBSCRIPTION_INFO));
    }

    private void initializeSubscription() {
        this.subscription = new Subscription(this.pubsub, new SubscriptionInfo.BuilderImpl(SUBSCRIPTION_INFO));
    }

    @After
    public void tearDown() throws Exception {
        EasyMock.verify((Object[])new Object[]{this.pubsub, this.serviceMockReturnsOptions});
    }

    @Test
    public void testBuilder() {
        this.initializeExpectedSubscription(2);
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        Assert.assertEquals((Object)TOPIC_ID, (Object)this.expectedSubscription.topic());
        Assert.assertEquals((Object)NAME, (Object)this.expectedSubscription.name());
        Assert.assertEquals((Object)PUSH_CONFIG, (Object)this.expectedSubscription.pushConfig());
        Assert.assertEquals((long)42L, (long)this.expectedSubscription.ackDeadlineSeconds());
        Subscription builtSubscription = this.expectedSubscription.toBuilder().name("newSubscription").topic("newProject", "newTopic").pushConfig(null).ackDeadLineSeconds(10).build();
        Assert.assertEquals((Object)TopicId.of((String)"newProject", (String)"newTopic"), (Object)builtSubscription.topic());
        Assert.assertEquals((Object)"newSubscription", (Object)builtSubscription.name());
        Assert.assertEquals(null, (Object)builtSubscription.pushConfig());
        Assert.assertEquals((long)10L, (long)builtSubscription.ackDeadlineSeconds());
    }

    @Test
    public void testToBuilder() {
        this.initializeExpectedSubscription(2);
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.compareSubscription(this.expectedSubscription, this.expectedSubscription.toBuilder().build());
    }

    @Test
    public void testReload() {
        this.initializeExpectedSubscription(2);
        SubscriptionInfo updatedInfo = SUBSCRIPTION_INFO.toBuilder().name("newSubscription").build();
        Subscription expectedSubscription = new Subscription(this.serviceMockReturnsOptions, new SubscriptionInfo.BuilderImpl(updatedInfo));
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.pubsub.getSubscription(NAME)).andReturn((Object)expectedSubscription);
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeSubscription();
        Subscription updatedSubscription = this.subscription.reload();
        this.compareSubscription(expectedSubscription, updatedSubscription);
    }

    @Test
    public void testReloadNull() {
        this.initializeExpectedSubscription(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.pubsub.getSubscription(NAME)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeSubscription();
        Assert.assertNull((Object)this.subscription.reload());
    }

    @Test
    public void testReloadAsync() throws ExecutionException, InterruptedException {
        this.initializeExpectedSubscription(2);
        SubscriptionInfo updatedInfo = SUBSCRIPTION_INFO.toBuilder().name("newSubscription").build();
        Subscription expectedSubscription = new Subscription(this.serviceMockReturnsOptions, new SubscriptionInfo.BuilderImpl(updatedInfo));
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.pubsub.getSubscriptionAsync(NAME)).andReturn((Object)Futures.immediateFuture((Object)expectedSubscription));
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeSubscription();
        Subscription updatedSubscription = (Subscription)this.subscription.reloadAsync().get();
        this.compareSubscription(expectedSubscription, updatedSubscription);
    }

    @Test
    public void testReloadAsyncNull() throws ExecutionException, InterruptedException {
        this.initializeExpectedSubscription(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.pubsub.getSubscriptionAsync(NAME)).andReturn((Object)Futures.immediateFuture(null));
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeSubscription();
        Assert.assertNull(this.subscription.reloadAsync().get());
    }

    @Test
    public void testDeleteTrue() {
        this.initializeExpectedSubscription(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.pubsub.deleteSubscription(NAME)).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeSubscription();
        Assert.assertTrue((boolean)this.subscription.delete());
    }

    @Test
    public void testDeleteFalse() {
        this.initializeExpectedSubscription(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.pubsub.deleteSubscription(NAME)).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeSubscription();
        Assert.assertFalse((boolean)this.subscription.delete());
    }

    @Test
    public void testDeleteAsyncTrue() throws ExecutionException, InterruptedException {
        this.initializeExpectedSubscription(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.pubsub.deleteSubscriptionAsync(NAME)).andReturn((Object)Futures.immediateFuture((Object)true));
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeSubscription();
        Assert.assertTrue((boolean)((Boolean)this.subscription.deleteAsync().get()));
    }

    @Test
    public void testDeleteAsyncFalse() throws ExecutionException, InterruptedException {
        this.initializeExpectedSubscription(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.pubsub.deleteSubscriptionAsync(NAME)).andReturn((Object)Futures.immediateFuture((Object)false));
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeSubscription();
        Assert.assertFalse((boolean)((Boolean)this.subscription.deleteAsync().get()));
    }

    @Test
    public void testReplacePushConfig() {
        this.initializeExpectedSubscription(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        PushConfig pushConfig = PushConfig.of((String)"https://example.com/newPush");
        this.pubsub.replacePushConfig(NAME, pushConfig);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeSubscription();
        this.subscription.replacePushConfig(pushConfig);
    }

    @Test
    public void testReplacePushConfig_Null() {
        this.initializeExpectedSubscription(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        this.pubsub.replacePushConfig(NAME, null);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeSubscription();
        this.subscription.replacePushConfig(null);
    }

    @Test
    public void testReplacePushConfig_Async() throws ExecutionException, InterruptedException {
        this.initializeExpectedSubscription(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        PushConfig pushConfig = PushConfig.of((String)"https://example.com/newPush");
        EasyMock.expect((Object)this.pubsub.replacePushConfigAsync(NAME, pushConfig)).andReturn((Object)Futures.immediateFuture(null));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeSubscription();
        Assert.assertNull(this.subscription.replacePushConfigAsync(pushConfig).get());
    }

    @Test
    public void testReplacePushConfigAsync_Null() throws ExecutionException, InterruptedException {
        this.initializeExpectedSubscription(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.pubsub.replacePushConfigAsync(NAME, null)).andReturn((Object)Futures.immediateFuture(null));
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeSubscription();
        Assert.assertNull(this.subscription.replacePushConfigAsync(null).get());
    }

    @Test
    public void testPull() {
        this.initializeExpectedSubscription(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions).times(2);
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        ReceivedMessage message1 = ReceivedMessage.fromPb((PubSub)this.pubsub, (String)NAME, (com.google.pubsub.v1.ReceivedMessage)MESSAGE_PB1);
        ReceivedMessage message2 = ReceivedMessage.fromPb((PubSub)this.pubsub, (String)NAME, (com.google.pubsub.v1.ReceivedMessage)MESSAGE_PB2);
        EasyMock.reset((Object[])new Object[]{this.pubsub});
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        ImmutableList messages = ImmutableList.of((Object)message1, (Object)message2);
        EasyMock.expect((Object)this.pubsub.pull(NAME, 42)).andReturn(messages.iterator());
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeSubscription();
        Assert.assertEquals((Object)messages, (Object)Lists.newArrayList((Iterator)this.subscription.pull(42)));
    }

    @Test
    public void testPullAsync() throws ExecutionException, InterruptedException {
        this.initializeExpectedSubscription(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions).times(2);
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        ReceivedMessage message1 = ReceivedMessage.fromPb((PubSub)this.pubsub, (String)NAME, (com.google.pubsub.v1.ReceivedMessage)MESSAGE_PB1);
        ReceivedMessage message2 = ReceivedMessage.fromPb((PubSub)this.pubsub, (String)NAME, (com.google.pubsub.v1.ReceivedMessage)MESSAGE_PB2);
        EasyMock.reset((Object[])new Object[]{this.pubsub});
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        ImmutableList messages = ImmutableList.of((Object)message1, (Object)message2);
        EasyMock.expect((Object)this.pubsub.pullAsync(NAME, 42)).andReturn((Object)Futures.immediateFuture(messages.iterator()));
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeSubscription();
        Assert.assertEquals((Object)messages, (Object)Lists.newArrayList((Iterator)((Iterator)this.subscription.pullAsync(42).get())));
    }

    @Test
    public void testMessageConsumer() throws ExecutionException, InterruptedException {
        this.initializeExpectedSubscription(1);
        PubSub.MessageConsumer messageConsumer = (PubSub.MessageConsumer)EasyMock.createStrictMock(PubSub.MessageConsumer.class);
        PubSub.MessageProcessor messageProcessor = (PubSub.MessageProcessor)EasyMock.createStrictMock(PubSub.MessageProcessor.class);
        EasyMock.replay((Object[])new Object[]{messageConsumer, messageProcessor});
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.pubsub.pullAsync(NAME, messageProcessor, new PubSub.PullOption[0])).andReturn((Object)messageConsumer);
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeSubscription();
        Assert.assertSame((Object)messageConsumer, (Object)this.subscription.pullAsync(messageProcessor, new PubSub.PullOption[0]));
        EasyMock.verify((Object[])new Object[]{messageConsumer, messageProcessor});
    }

    @Test
    public void testMessageConsumerWithOptions() throws ExecutionException, InterruptedException {
        this.initializeExpectedSubscription(1);
        PubSub.MessageConsumer messageConsumer = (PubSub.MessageConsumer)EasyMock.createStrictMock(PubSub.MessageConsumer.class);
        PubSub.MessageProcessor messageProcessor = (PubSub.MessageProcessor)EasyMock.createStrictMock(PubSub.MessageProcessor.class);
        EasyMock.replay((Object[])new Object[]{messageConsumer, messageProcessor});
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.pubsub.pullAsync(NAME, messageProcessor, new PubSub.PullOption[]{PubSub.PullOption.maxQueuedCallbacks((int)2)})).andReturn((Object)messageConsumer);
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeSubscription();
        Assert.assertSame((Object)messageConsumer, (Object)this.subscription.pullAsync(messageProcessor, new PubSub.PullOption[]{PubSub.PullOption.maxQueuedCallbacks((int)2)}));
        EasyMock.verify((Object[])new Object[]{messageConsumer, messageProcessor});
    }

    private void compareSubscription(Subscription expected, Subscription value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.topic(), (Object)value.topic());
        Assert.assertEquals((Object)expected.name(), (Object)value.name());
        Assert.assertEquals((Object)expected.pushConfig(), (Object)value.pushConfig());
        Assert.assertEquals((long)expected.ackDeadlineSeconds(), (long)value.ackDeadlineSeconds());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

