/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.cloud.ByteArray;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import com.google.pubsub.v1.PubsubMessage;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Message
implements Serializable {
    static final Function<Message, PubsubMessage> TO_PB_FUNCTION = new Function<Message, PubsubMessage>(){

        public PubsubMessage apply(Message message) {
            return message.toPb();
        }
    };
    private static final long serialVersionUID = -1436515787233340634L;
    private static final long NANOS_PER_MILLISECOND = 1000000L;
    private static final long MILLIS_PER_SECOND = 1000L;
    private final String id;
    private final InternalByteArray payload;
    private final ImmutableMap<String, String> attributes;
    private final Long publishTime;

    Message(BuilderImpl builder) {
        this.id = builder.id;
        this.payload = new InternalByteArray((ByteArray)Preconditions.checkNotNull((Object)builder.payload));
        this.attributes = ImmutableMap.copyOf((Map)builder.attributes);
        this.publishTime = builder.publishTime;
    }

    public Long publishTime() {
        return this.publishTime;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public String id() {
        return this.id;
    }

    public String payloadAsString() {
        return this.payload.toStringUtf8();
    }

    public ByteArray payload() {
        return this.payload;
    }

    final boolean baseEquals(Message message) {
        return Objects.equals(this.id, message.id) && Objects.equals((Object)this.payload, (Object)message.payload) && Objects.equals(this.attributes, message.attributes) && Objects.equals(this.publishTime, message.publishTime);
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(Message.class) && this.baseEquals((Message)obj);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.payload, this.attributes, this.publishTime});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("payload", (Object)this.payload).add("attributes", this.attributes).add("publishTime", (Object)this.publishTime).toString();
    }

    PubsubMessage toPb() {
        PubsubMessage.Builder builder = PubsubMessage.newBuilder();
        if (this.id != null) {
            builder.setMessageId(this.id);
        }
        builder.setData(this.payload.byteString());
        builder.putAllAttributes(this.attributes);
        Timestamp.Builder tsBuilder = Timestamp.newBuilder();
        if (this.publishTime != null) {
            tsBuilder.setSeconds(this.publishTime / 1000L);
            tsBuilder.setNanos((int)(this.publishTime % 1000L * 1000000L));
        }
        builder.setPublishTime(tsBuilder);
        return builder.build();
    }

    static Message fromPb(PubsubMessage messagePb) {
        Timestamp ts;
        Long millis;
        Builder builder = Message.builder(new InternalByteArray(messagePb.getData()));
        if (messagePb.hasPublishTime() && (millis = Long.valueOf((ts = messagePb.getPublishTime()).getSeconds() * 1000L + (long)ts.getNanos() / 1000000L)) != 0L) {
            builder.publishTime(millis);
        }
        if (!Objects.equals(messagePb.getMessageId(), "")) {
            builder.id(messagePb.getMessageId());
        }
        for (Map.Entry entry : messagePb.getAttributes().entrySet()) {
            builder.addAttribute((String)entry.getKey(), (String)entry.getValue());
        }
        return builder.build();
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Message of(String payload) {
        return Message.builder(payload).build();
    }

    public static Message of(ByteArray payload) {
        return Message.builder(payload).build();
    }

    public static Builder builder(String payload) {
        return new BuilderImpl().payload(payload);
    }

    public static Builder builder(ByteArray payload) {
        return new BuilderImpl().payload(payload);
    }

    static final class BuilderImpl
    extends Builder {
        private String id;
        private ByteArray payload;
        private Map<String, String> attributes = new HashMap<String, String>();
        private Long publishTime;

        private BuilderImpl() {
        }

        BuilderImpl(Message message) {
            this.id = message.id;
            this.payload = message.payload;
            this.attributes = new HashMap<String, String>((Map<String, String>)message.attributes);
            this.publishTime = message.publishTime;
        }

        @Override
        BuilderImpl id(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id);
            return this;
        }

        @Override
        public Builder payload(String payload) {
            return this.payload(ByteArray.copyFrom((String)payload));
        }

        @Override
        public Builder payload(ByteArray payload) {
            this.payload = payload;
            return this;
        }

        @Override
        public Builder addAttribute(String name, String value) {
            this.attributes.put(name, value);
            return this;
        }

        @Override
        public Builder attributes(Map<String, String> attributes) {
            this.attributes = new HashMap<String, String>(attributes);
            return this;
        }

        @Override
        public Builder removeAttribute(String name) {
            this.attributes.remove(name);
            return this;
        }

        @Override
        public Builder clearAttributes() {
            this.attributes.clear();
            return this;
        }

        @Override
        Builder publishTime(long publishTime) {
            this.publishTime = publishTime;
            return this;
        }

        @Override
        public Message build() {
            return new Message(this);
        }
    }

    public static abstract class Builder {
        abstract Builder id(String var1);

        public abstract Builder payload(String var1);

        public abstract Builder payload(ByteArray var1);

        public abstract Builder attributes(Map<String, String> var1);

        public abstract Builder addAttribute(String var1, String var2);

        public abstract Builder removeAttribute(String var1);

        public abstract Builder clearAttributes();

        abstract Builder publishTime(long var1);

        public abstract Message build();
    }

    private static final class InternalByteArray
    extends ByteArray {
        private static final long serialVersionUID = -3330181485911805428L;

        InternalByteArray(ByteString byteString) {
            super(byteString);
        }

        InternalByteArray(ByteArray byteArray) {
            super(byteArray);
        }

        protected ByteString byteString() {
            return super.byteString();
        }
    }
}

