/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.cloud.GrpcServiceOptions;
import com.google.cloud.pubsub.AckDeadlineRenewer;
import com.google.cloud.pubsub.PubSub;
import com.google.cloud.pubsub.PubSubOptions;
import com.google.common.collect.ImmutableList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class AckDeadlineRenewerTest {
    private static final int MIN_DEADLINE_MILLIS = 10000;
    private static final String SUBSCRIPTION1 = "subscription1";
    private static final String SUBSCRIPTION2 = "subscription2";
    private static final String ACK_ID1 = "ack-id1";
    private static final String ACK_ID2 = "ack-id2";
    private static final String ACK_ID3 = "ack-id3";
    private PubSub pubsub;
    private AckDeadlineRenewer ackDeadlineRenewer;
    @Rule
    public Timeout globalTimeout = Timeout.seconds((long)60L);

    @Before
    public void setUp() {
        this.pubsub = (PubSub)EasyMock.createStrictMock(PubSub.class);
        PubSubOptions options = ((PubSubOptions.Builder)PubSubOptions.builder().projectId("projectId")).build();
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)options);
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.ackDeadlineRenewer = new AckDeadlineRenewer(this.pubsub);
    }

    @After
    public void tearDown() throws Exception {
        EasyMock.verify((Object[])new Object[]{this.pubsub});
        this.ackDeadlineRenewer.close();
    }

    private static IAnswer<Future<Void>> createAnswer(final CountDownLatch latch, final AtomicLong renewal) {
        return new IAnswer<Future<Void>>(){

            public Future<Void> answer() throws Throwable {
                latch.countDown();
                renewal.set(System.currentTimeMillis());
                return null;
            }
        };
    }

    @Test
    public void testAddOneMessage() throws InterruptedException {
        EasyMock.reset((Object[])new Object[]{this.pubsub});
        CountDownLatch firstLatch = new CountDownLatch(1);
        CountDownLatch secondLatch = new CountDownLatch(1);
        AtomicLong firstRenewal = new AtomicLong();
        AtomicLong secondRenewal = new AtomicLong();
        EasyMock.expect((Object)this.pubsub.modifyAckDeadlineAsync(SUBSCRIPTION1, 10000, TimeUnit.MILLISECONDS, (Iterable)ImmutableList.of((Object)ACK_ID1))).andAnswer(AckDeadlineRenewerTest.createAnswer(firstLatch, firstRenewal));
        EasyMock.expect((Object)this.pubsub.modifyAckDeadlineAsync(SUBSCRIPTION1, 10000, TimeUnit.MILLISECONDS, (Iterable)ImmutableList.of((Object)ACK_ID1))).andAnswer(AckDeadlineRenewerTest.createAnswer(secondLatch, secondRenewal));
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        long addTime = System.currentTimeMillis();
        this.ackDeadlineRenewer.add(SUBSCRIPTION1, ACK_ID1);
        firstLatch.await();
        Assert.assertTrue((firstRenewal.get() < addTime + 10000L ? 1 : 0) != 0);
        secondLatch.await();
        Assert.assertTrue((secondRenewal.get() < firstRenewal.get() + 10000L ? 1 : 0) != 0);
    }

    @Test
    public void testAddMessages() throws InterruptedException {
        EasyMock.reset((Object[])new Object[]{this.pubsub});
        CountDownLatch firstLatch = new CountDownLatch(2);
        CountDownLatch secondLatch = new CountDownLatch(2);
        AtomicLong firstRenewalSub1 = new AtomicLong();
        AtomicLong firstRenewalSub2 = new AtomicLong();
        AtomicLong secondRenewalSub1 = new AtomicLong();
        AtomicLong secondRenewalSub2 = new AtomicLong();
        EasyMock.expect((Object)this.pubsub.modifyAckDeadlineAsync(SUBSCRIPTION1, 10000, TimeUnit.MILLISECONDS, (Iterable)ImmutableList.of((Object)ACK_ID1, (Object)ACK_ID2))).andAnswer(AckDeadlineRenewerTest.createAnswer(firstLatch, firstRenewalSub1));
        EasyMock.expect((Object)this.pubsub.modifyAckDeadlineAsync(SUBSCRIPTION2, 10000, TimeUnit.MILLISECONDS, (Iterable)ImmutableList.of((Object)ACK_ID1))).andAnswer(AckDeadlineRenewerTest.createAnswer(firstLatch, firstRenewalSub2));
        EasyMock.expect((Object)this.pubsub.modifyAckDeadlineAsync(SUBSCRIPTION1, 10000, TimeUnit.MILLISECONDS, (Iterable)ImmutableList.of((Object)ACK_ID1, (Object)ACK_ID2))).andAnswer(AckDeadlineRenewerTest.createAnswer(secondLatch, secondRenewalSub1));
        EasyMock.expect((Object)this.pubsub.modifyAckDeadlineAsync(SUBSCRIPTION2, 10000, TimeUnit.MILLISECONDS, (Iterable)ImmutableList.of((Object)ACK_ID1, (Object)ACK_ID3))).andAnswer(AckDeadlineRenewerTest.createAnswer(secondLatch, secondRenewalSub2));
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        long addTime1 = System.currentTimeMillis();
        this.ackDeadlineRenewer.add(SUBSCRIPTION1, (Iterable)ImmutableList.of((Object)ACK_ID1, (Object)ACK_ID2));
        this.ackDeadlineRenewer.add(SUBSCRIPTION2, ACK_ID1);
        firstLatch.await();
        Assert.assertTrue((firstRenewalSub1.get() < addTime1 + 10000L ? 1 : 0) != 0);
        Assert.assertTrue((firstRenewalSub2.get() < addTime1 + 10000L ? 1 : 0) != 0);
        this.ackDeadlineRenewer.add(SUBSCRIPTION2, ACK_ID3);
        secondLatch.await();
        Assert.assertTrue((secondRenewalSub1.get() < firstRenewalSub1.get() + 10000L ? 1 : 0) != 0);
        Assert.assertTrue((secondRenewalSub2.get() < firstRenewalSub2.get() + 10000L ? 1 : 0) != 0);
    }

    @Test
    public void testAddExistingMessage() throws InterruptedException {
        EasyMock.reset((Object[])new Object[]{this.pubsub});
        CountDownLatch firstLatch = new CountDownLatch(2);
        CountDownLatch secondLatch = new CountDownLatch(2);
        AtomicLong firstRenewalSub1 = new AtomicLong();
        AtomicLong firstRenewalSub2 = new AtomicLong();
        AtomicLong secondRenewalSub1 = new AtomicLong();
        AtomicLong secondRenewalSub2 = new AtomicLong();
        EasyMock.expect((Object)this.pubsub.modifyAckDeadlineAsync(SUBSCRIPTION1, 10000, TimeUnit.MILLISECONDS, (Iterable)ImmutableList.of((Object)ACK_ID1, (Object)ACK_ID2))).andAnswer(AckDeadlineRenewerTest.createAnswer(firstLatch, firstRenewalSub1));
        EasyMock.expect((Object)this.pubsub.modifyAckDeadlineAsync(SUBSCRIPTION2, 10000, TimeUnit.MILLISECONDS, (Iterable)ImmutableList.of((Object)ACK_ID1))).andAnswer(AckDeadlineRenewerTest.createAnswer(firstLatch, firstRenewalSub2));
        EasyMock.expect((Object)this.pubsub.modifyAckDeadlineAsync(SUBSCRIPTION1, 10000, TimeUnit.MILLISECONDS, (Iterable)ImmutableList.of((Object)ACK_ID1, (Object)ACK_ID2))).andAnswer(AckDeadlineRenewerTest.createAnswer(secondLatch, secondRenewalSub1));
        EasyMock.expect((Object)this.pubsub.modifyAckDeadlineAsync(SUBSCRIPTION2, 10000, TimeUnit.MILLISECONDS, (Iterable)ImmutableList.of((Object)ACK_ID1))).andAnswer(AckDeadlineRenewerTest.createAnswer(secondLatch, secondRenewalSub2));
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        long addTime1 = System.currentTimeMillis();
        this.ackDeadlineRenewer.add(SUBSCRIPTION1, (Iterable)ImmutableList.of((Object)ACK_ID1, (Object)ACK_ID2));
        this.ackDeadlineRenewer.add(SUBSCRIPTION2, ACK_ID1);
        firstLatch.await();
        Assert.assertTrue((firstRenewalSub1.get() < addTime1 + 10000L ? 1 : 0) != 0);
        Assert.assertTrue((firstRenewalSub2.get() < addTime1 + 10000L ? 1 : 0) != 0);
        this.ackDeadlineRenewer.add(SUBSCRIPTION2, ACK_ID1);
        secondLatch.await();
        Assert.assertTrue((secondRenewalSub1.get() < firstRenewalSub1.get() + 10000L ? 1 : 0) != 0);
        Assert.assertTrue((secondRenewalSub2.get() < firstRenewalSub2.get() + 10000L ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveNonExistingMessage() throws InterruptedException {
        EasyMock.reset((Object[])new Object[]{this.pubsub});
        CountDownLatch firstLatch = new CountDownLatch(2);
        CountDownLatch secondLatch = new CountDownLatch(2);
        AtomicLong firstRenewalSub1 = new AtomicLong();
        AtomicLong firstRenewalSub2 = new AtomicLong();
        AtomicLong secondRenewalSub1 = new AtomicLong();
        AtomicLong secondRenewalSub2 = new AtomicLong();
        EasyMock.expect((Object)this.pubsub.modifyAckDeadlineAsync(SUBSCRIPTION1, 10000, TimeUnit.MILLISECONDS, (Iterable)ImmutableList.of((Object)ACK_ID1, (Object)ACK_ID2))).andAnswer(AckDeadlineRenewerTest.createAnswer(firstLatch, firstRenewalSub1));
        EasyMock.expect((Object)this.pubsub.modifyAckDeadlineAsync(SUBSCRIPTION2, 10000, TimeUnit.MILLISECONDS, (Iterable)ImmutableList.of((Object)ACK_ID1))).andAnswer(AckDeadlineRenewerTest.createAnswer(firstLatch, firstRenewalSub2));
        EasyMock.expect((Object)this.pubsub.modifyAckDeadlineAsync(SUBSCRIPTION1, 10000, TimeUnit.MILLISECONDS, (Iterable)ImmutableList.of((Object)ACK_ID1, (Object)ACK_ID2))).andAnswer(AckDeadlineRenewerTest.createAnswer(secondLatch, secondRenewalSub1));
        EasyMock.expect((Object)this.pubsub.modifyAckDeadlineAsync(SUBSCRIPTION2, 10000, TimeUnit.MILLISECONDS, (Iterable)ImmutableList.of((Object)ACK_ID1))).andAnswer(AckDeadlineRenewerTest.createAnswer(secondLatch, secondRenewalSub2));
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        long addTime1 = System.currentTimeMillis();
        this.ackDeadlineRenewer.add(SUBSCRIPTION1, (Iterable)ImmutableList.of((Object)ACK_ID1, (Object)ACK_ID2));
        this.ackDeadlineRenewer.add(SUBSCRIPTION2, ACK_ID1);
        firstLatch.await();
        Assert.assertTrue((firstRenewalSub1.get() < addTime1 + 10000L ? 1 : 0) != 0);
        Assert.assertTrue((firstRenewalSub2.get() < addTime1 + 10000L ? 1 : 0) != 0);
        this.ackDeadlineRenewer.remove(SUBSCRIPTION1, ACK_ID3);
        secondLatch.await();
        Assert.assertTrue((secondRenewalSub1.get() < firstRenewalSub1.get() + 10000L ? 1 : 0) != 0);
        Assert.assertTrue((secondRenewalSub2.get() < firstRenewalSub2.get() + 10000L ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveMessage() throws InterruptedException {
        EasyMock.reset((Object[])new Object[]{this.pubsub});
        CountDownLatch firstLatch = new CountDownLatch(2);
        CountDownLatch secondLatch = new CountDownLatch(2);
        AtomicLong firstRenewalSub1 = new AtomicLong();
        AtomicLong firstRenewalSub2 = new AtomicLong();
        AtomicLong secondRenewalSub1 = new AtomicLong();
        AtomicLong secondRenewalSub2 = new AtomicLong();
        EasyMock.expect((Object)this.pubsub.modifyAckDeadlineAsync(SUBSCRIPTION1, 10000, TimeUnit.MILLISECONDS, (Iterable)ImmutableList.of((Object)ACK_ID1, (Object)ACK_ID2))).andAnswer(AckDeadlineRenewerTest.createAnswer(firstLatch, firstRenewalSub1));
        EasyMock.expect((Object)this.pubsub.modifyAckDeadlineAsync(SUBSCRIPTION2, 10000, TimeUnit.MILLISECONDS, (Iterable)ImmutableList.of((Object)ACK_ID1))).andAnswer(AckDeadlineRenewerTest.createAnswer(firstLatch, firstRenewalSub2));
        EasyMock.expect((Object)this.pubsub.modifyAckDeadlineAsync(SUBSCRIPTION1, 10000, TimeUnit.MILLISECONDS, (Iterable)ImmutableList.of((Object)ACK_ID1))).andAnswer(AckDeadlineRenewerTest.createAnswer(secondLatch, secondRenewalSub1));
        EasyMock.expect((Object)this.pubsub.modifyAckDeadlineAsync(SUBSCRIPTION2, 10000, TimeUnit.MILLISECONDS, (Iterable)ImmutableList.of((Object)ACK_ID1))).andAnswer(AckDeadlineRenewerTest.createAnswer(secondLatch, secondRenewalSub2));
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        long addTime1 = System.currentTimeMillis();
        this.ackDeadlineRenewer.add(SUBSCRIPTION1, (Iterable)ImmutableList.of((Object)ACK_ID1, (Object)ACK_ID2));
        this.ackDeadlineRenewer.add(SUBSCRIPTION2, ACK_ID1);
        firstLatch.await();
        Assert.assertTrue((firstRenewalSub1.get() < addTime1 + 10000L ? 1 : 0) != 0);
        Assert.assertTrue((firstRenewalSub2.get() < addTime1 + 10000L ? 1 : 0) != 0);
        this.ackDeadlineRenewer.remove(SUBSCRIPTION1, ACK_ID2);
        secondLatch.await();
        Assert.assertTrue((secondRenewalSub1.get() < firstRenewalSub1.get() + 10000L ? 1 : 0) != 0);
        Assert.assertTrue((secondRenewalSub2.get() < firstRenewalSub2.get() + 10000L ? 1 : 0) != 0);
    }

    @Test
    public void testClose() throws Exception {
        PubSub pubsub = (PubSub)EasyMock.createStrictMock(PubSub.class);
        ScheduledExecutorService executor = (ScheduledExecutorService)EasyMock.createStrictMock(ScheduledExecutorService.class);
        GrpcServiceOptions.ExecutorFactory executorFactory = (GrpcServiceOptions.ExecutorFactory)EasyMock.createStrictMock(GrpcServiceOptions.ExecutorFactory.class);
        EasyMock.expect((Object)executorFactory.get()).andReturn((Object)executor);
        PubSubOptions options = ((PubSubOptions.Builder)((PubSubOptions.Builder)PubSubOptions.builder().projectId("projectId")).executorFactory(executorFactory)).build();
        EasyMock.expect((Object)pubsub.options()).andReturn((Object)options);
        executorFactory.release((ExecutorService)executor);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{executor, executorFactory, pubsub});
        AckDeadlineRenewer ackDeadlineRenewer = new AckDeadlineRenewer(pubsub);
        ackDeadlineRenewer.close();
        EasyMock.verify((Object[])new Object[]{pubsub, executor, executorFactory});
    }

    @Test
    public void testCloseWithMessage() throws Exception {
        PubSub pubsub = (PubSub)EasyMock.createStrictMock(PubSub.class);
        ScheduledExecutorService executor = (ScheduledExecutorService)EasyMock.createStrictMock(ScheduledExecutorService.class);
        GrpcServiceOptions.ExecutorFactory executorFactory = (GrpcServiceOptions.ExecutorFactory)EasyMock.createStrictMock(GrpcServiceOptions.ExecutorFactory.class);
        EasyMock.expect((Object)executorFactory.get()).andReturn((Object)executor);
        ScheduledFuture future = (ScheduledFuture)EasyMock.createStrictMock(ScheduledFuture.class);
        EasyMock.expect(executor.schedule((Runnable)EasyMock.anyObject(), EasyMock.anyLong(), (TimeUnit)((Object)EasyMock.eq((Object)((Object)TimeUnit.MILLISECONDS))))).andReturn((Object)future);
        PubSubOptions options = ((PubSubOptions.Builder)((PubSubOptions.Builder)PubSubOptions.builder().projectId("projectId")).executorFactory(executorFactory)).build();
        EasyMock.expect((Object)pubsub.options()).andReturn((Object)options);
        EasyMock.expect((Object)future.cancel(true)).andReturn((Object)true);
        executorFactory.release((ExecutorService)executor);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{executor, executorFactory, future, pubsub});
        AckDeadlineRenewer ackDeadlineRenewer = new AckDeadlineRenewer(pubsub);
        ackDeadlineRenewer.add(SUBSCRIPTION1, ACK_ID1);
        ackDeadlineRenewer.close();
        EasyMock.verify((Object[])new Object[]{pubsub, executor, executorFactory, future});
    }
}

