/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.cloud.AsyncPage;
import com.google.cloud.Page;
import com.google.cloud.pubsub.Message;
import com.google.cloud.pubsub.PubSub;
import com.google.cloud.pubsub.PubSubException;
import com.google.cloud.pubsub.PubSubOptions;
import com.google.cloud.pubsub.PushConfig;
import com.google.cloud.pubsub.ReceivedMessage;
import com.google.cloud.pubsub.Subscription;
import com.google.cloud.pubsub.SubscriptionId;
import com.google.cloud.pubsub.SubscriptionInfo;
import com.google.cloud.pubsub.Topic;
import com.google.cloud.pubsub.TopicId;
import com.google.cloud.pubsub.TopicInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public abstract class BaseSystemTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    protected abstract PubSub pubsub();

    protected abstract String formatForTest(String var1);

    @Test
    public void testCreateGetAndDeleteTopic() {
        String name = this.formatForTest("test-create-get-delete-topic");
        Topic topic = this.pubsub().create(TopicInfo.of((String)name));
        Assert.assertEquals((Object)name, (Object)topic.name());
        Topic remoteTopic = this.pubsub().getTopic(name);
        Assert.assertEquals((Object)topic, (Object)remoteTopic);
        Assert.assertTrue((boolean)topic.delete());
    }

    @Test
    public void testGetTopic_NotExist() {
        String name = this.formatForTest("test-get-non-existing-topic");
        Assert.assertNull((Object)this.pubsub().getTopic(name));
    }

    @Test
    public void testDeleteTopic_NotExist() {
        Assert.assertFalse((boolean)this.pubsub().deleteTopic(this.formatForTest("test-delete-non-existing-topic")));
    }

    @Test
    public void testCreateGetAndDeleteTopicAsync() throws ExecutionException, InterruptedException {
        String name = this.formatForTest("test-create-get-delete-async-topic");
        Future topicFuture = this.pubsub().createAsync(TopicInfo.of((String)name));
        Topic createdTopic = (Topic)topicFuture.get();
        Assert.assertEquals((Object)name, (Object)createdTopic.name());
        topicFuture = this.pubsub().getTopicAsync(name);
        Assert.assertEquals((Object)createdTopic, topicFuture.get());
        Assert.assertTrue((boolean)((Boolean)createdTopic.deleteAsync().get()));
    }

    @Test
    public void testListTopics() {
        Topic topic1 = this.pubsub().create(TopicInfo.of((String)this.formatForTest("test-list-topic1")));
        Topic topic2 = this.pubsub().create(TopicInfo.of((String)this.formatForTest("test-list-topic2")));
        Topic topic3 = this.pubsub().create(TopicInfo.of((String)this.formatForTest("test-list-topic3")));
        HashSet topicNames = Sets.newHashSet();
        Page topics = this.pubsub().listTopics(new PubSub.ListOption[]{PubSub.ListOption.pageSize((int)1)});
        Iterator iterator = topics.iterateAll();
        while (iterator.hasNext()) {
            topicNames.add(((Topic)iterator.next()).name());
        }
        Assert.assertTrue((boolean)topicNames.contains(topic1.name()));
        Assert.assertTrue((boolean)topicNames.contains(topic2.name()));
        Assert.assertTrue((boolean)topicNames.contains(topic3.name()));
        Assert.assertTrue((boolean)topic1.delete());
        Assert.assertTrue((boolean)topic2.delete());
        Assert.assertTrue((boolean)topic3.delete());
    }

    @Test
    public void testListTopicsAsync() throws ExecutionException, InterruptedException {
        Topic topic1 = this.pubsub().create(TopicInfo.of((String)this.formatForTest("test-list-async-topic1")));
        Topic topic2 = this.pubsub().create(TopicInfo.of((String)this.formatForTest("test-list-async-topic2")));
        Topic topic3 = this.pubsub().create(TopicInfo.of((String)this.formatForTest("test-list-async-topic3")));
        HashSet topicNames = Sets.newHashSet();
        Future pageFuture = this.pubsub().listTopicsAsync(new PubSub.ListOption[]{PubSub.ListOption.pageSize((int)1)});
        Iterator iterator = ((AsyncPage)pageFuture.get()).iterateAll();
        while (iterator.hasNext()) {
            topicNames.add(((Topic)iterator.next()).name());
        }
        Assert.assertTrue((boolean)topicNames.contains(topic1.name()));
        Assert.assertTrue((boolean)topicNames.contains(topic2.name()));
        Assert.assertTrue((boolean)topicNames.contains(topic3.name()));
        Assert.assertTrue((boolean)topic1.delete());
        Assert.assertTrue((boolean)topic2.delete());
        Assert.assertTrue((boolean)topic3.delete());
    }

    @Test
    public void testPublishOneMessage() {
        String topic = this.formatForTest("test-publish-one-message-topic");
        this.pubsub().create(TopicInfo.of((String)topic));
        Message message = Message.of((String)"payload");
        Assert.assertNotNull((Object)this.pubsub().publish(topic, message));
        Assert.assertTrue((boolean)this.pubsub().deleteTopic(topic));
    }

    @Test
    public void testPublishNonExistingTopic() {
        String topic = this.formatForTest("test-publish-non-existing-topic");
        Message message = Message.of((String)"payload");
        this.thrown.expect(PubSubException.class);
        this.pubsub().publish(topic, message);
    }

    @Test
    public void testPublishOneMessageAsync() throws ExecutionException, InterruptedException {
        String topic = this.formatForTest("test-publish-one-message-async-topic");
        this.pubsub().create(TopicInfo.of((String)topic));
        Message message = Message.of((String)"payload");
        Future publishFuture = this.pubsub().publishAsync(topic, message);
        Assert.assertNotNull(publishFuture.get());
        Assert.assertTrue((boolean)this.pubsub().deleteTopic(topic));
    }

    @Test
    public void testPublishMoreMessages() {
        String topic = this.formatForTest("test-publish-more-messages-topic");
        this.pubsub().create(TopicInfo.of((String)topic));
        Message message1 = Message.of((String)"payload1");
        Message message2 = Message.of((String)"payload2");
        List messageIds = this.pubsub().publish(topic, message1, new Message[]{message2});
        Assert.assertEquals((long)2L, (long)messageIds.size());
        Assert.assertTrue((boolean)this.pubsub().deleteTopic(topic));
    }

    @Test
    public void testPublishMoreMessagesAsync() throws ExecutionException, InterruptedException {
        String topic = this.formatForTest("test-publish-more-messages-topic-async-topic");
        this.pubsub().create(TopicInfo.of((String)topic));
        Message message1 = Message.of((String)"payload1");
        Message message2 = Message.of((String)"payload2");
        Future publishFuture = this.pubsub().publishAsync(topic, message1, new Message[]{message2});
        Assert.assertEquals((long)2L, (long)((List)publishFuture.get()).size());
        Assert.assertTrue((boolean)this.pubsub().deleteTopic(topic));
    }

    @Test
    public void testPublishMessageList() {
        String topic = this.formatForTest("test-publish-message-list-topic");
        this.pubsub().create(TopicInfo.of((String)topic));
        Message message1 = Message.of((String)"payload1");
        Message message2 = Message.of((String)"payload2");
        List messageIds = this.pubsub().publish(topic, (Iterable)ImmutableList.of((Object)message1, (Object)message2));
        Assert.assertEquals((long)2L, (long)messageIds.size());
        Assert.assertTrue((boolean)this.pubsub().deleteTopic(topic));
    }

    @Test
    public void testPublishMessagesListAsync() throws ExecutionException, InterruptedException {
        String topic = this.formatForTest("test-publish-message-list-async-topic");
        this.pubsub().create(TopicInfo.of((String)topic));
        Message message1 = Message.of((String)"payload1");
        Message message2 = Message.of((String)"payload2");
        Future publishFuture = this.pubsub().publishAsync(topic, (Iterable)ImmutableList.of((Object)message1, (Object)message2));
        Assert.assertEquals((long)2L, (long)((List)publishFuture.get()).size());
        Assert.assertTrue((boolean)this.pubsub().deleteTopic(topic));
    }

    @Test
    public void testCreateGetAndDeleteSubscription() {
        String topic = this.formatForTest("test-create-get-delete-subscription-topic");
        this.pubsub().create(TopicInfo.of((String)topic));
        String name = this.formatForTest("test-create-get-delete-subscription");
        Subscription subscription = this.pubsub().create(SubscriptionInfo.of((String)topic, (String)name));
        Assert.assertEquals((Object)TopicId.of((String)((PubSubOptions)this.pubsub().options()).projectId(), (String)topic), (Object)subscription.topic());
        Assert.assertEquals((Object)name, (Object)subscription.name());
        Assert.assertNull((Object)subscription.pushConfig());
        Subscription remoteSubscription = this.pubsub().getSubscription(name);
        Assert.assertEquals((Object)subscription, (Object)remoteSubscription);
        Assert.assertTrue((boolean)subscription.delete());
        Assert.assertTrue((boolean)this.pubsub().deleteTopic(topic));
    }

    @Test
    public void testGetSubscription_NotExist() {
        Assert.assertNull((Object)this.pubsub().getSubscription(this.formatForTest("test-get-non-existing-subscription")));
    }

    @Test
    public void testDeleteSubscription_NotExist() {
        Assert.assertFalse((boolean)this.pubsub().deleteSubscription(this.formatForTest("test-delete-non-existing-subscription")));
    }

    @Test
    public void testCreateGetAndDeleteSubscriptionAsync() throws ExecutionException, InterruptedException {
        String topic = this.formatForTest("test-create-get-delete-async-subscription-topic");
        this.pubsub().create(TopicInfo.of((String)topic));
        String name = this.formatForTest("test-create-get-delete-async-subscription");
        String endpoint = "https://" + ((PubSubOptions)this.pubsub().options()).projectId() + ".appspot.com/push";
        PushConfig pushConfig = PushConfig.of((String)endpoint);
        Future subscriptionFuture = this.pubsub().createAsync(SubscriptionInfo.builder((String)topic, (String)name).pushConfig(pushConfig).build());
        Subscription subscription = (Subscription)subscriptionFuture.get();
        Assert.assertEquals((Object)TopicId.of((String)((PubSubOptions)this.pubsub().options()).projectId(), (String)topic), (Object)subscription.topic());
        Assert.assertEquals((Object)name, (Object)subscription.name());
        Assert.assertEquals((Object)pushConfig, (Object)subscription.pushConfig());
        subscriptionFuture = this.pubsub().getSubscriptionAsync(name);
        Subscription remoteSubscription = (Subscription)subscriptionFuture.get();
        Assert.assertEquals((Object)subscription, (Object)remoteSubscription);
        Assert.assertTrue((boolean)((Boolean)subscription.deleteAsync().get()));
        Assert.assertTrue((boolean)this.pubsub().deleteTopic(topic));
    }

    @Test
    @Ignore(value="Emulator incosistency; see issue ##988")
    public void testGetSubscriptionDeletedTopic() {
        String topic = this.formatForTest("test-get-deleted-topic-subscription-topic");
        this.pubsub().create(TopicInfo.of((String)topic));
        String name = this.formatForTest("test-get-deleted-topic-subscription");
        Subscription subscription = this.pubsub().create(SubscriptionInfo.of((String)topic, (String)name));
        Assert.assertEquals((Object)TopicId.of((String)((PubSubOptions)this.pubsub().options()).projectId(), (String)topic), (Object)subscription.topic());
        Assert.assertEquals((Object)name, (Object)subscription.name());
        Assert.assertNull((Object)subscription.pushConfig());
        Assert.assertTrue((boolean)this.pubsub().deleteTopic(topic));
        Assert.assertNull((Object)this.pubsub().getTopic(topic));
        Subscription remoteSubscription = this.pubsub().getSubscription(name);
        Assert.assertEquals((Object)TopicId.of((String)"_deleted-topic_"), (Object)remoteSubscription.topic());
        Assert.assertEquals((Object)name, (Object)remoteSubscription.name());
        Assert.assertNull((Object)remoteSubscription.pushConfig());
        Assert.assertTrue((boolean)subscription.delete());
    }

    @Test
    public void testReplaceSubscriptionPushConfig() {
        String topic = this.formatForTest("test-replace-push-config-topic");
        this.pubsub().create(TopicInfo.of((String)topic));
        String name = this.formatForTest("test-replace-push-config-subscription");
        String endpoint = "https://" + ((PubSubOptions)this.pubsub().options()).projectId() + ".appspot.com/push";
        PushConfig pushConfig = PushConfig.of((String)endpoint);
        Subscription subscription = this.pubsub().create(SubscriptionInfo.builder((String)topic, (String)name).pushConfig(pushConfig).build());
        Assert.assertEquals((Object)TopicId.of((String)((PubSubOptions)this.pubsub().options()).projectId(), (String)topic), (Object)subscription.topic());
        Assert.assertEquals((Object)name, (Object)subscription.name());
        Assert.assertEquals((Object)pushConfig, (Object)subscription.pushConfig());
        this.pubsub().replacePushConfig(name, null);
        Subscription remoteSubscription = this.pubsub().getSubscription(name);
        Assert.assertEquals((Object)TopicId.of((String)((PubSubOptions)this.pubsub().options()).projectId(), (String)topic), (Object)remoteSubscription.topic());
        Assert.assertEquals((Object)name, (Object)remoteSubscription.name());
        Assert.assertNull((Object)remoteSubscription.pushConfig());
        Assert.assertTrue((boolean)subscription.delete());
        Assert.assertTrue((boolean)this.pubsub().deleteTopic(topic));
    }

    @Test
    public void testReplaceNonExistingSubscriptionPushConfig() {
        String name = this.formatForTest("test-replace-push-config-non-existing-subscription");
        this.thrown.expect(PubSubException.class);
        this.pubsub().replacePushConfig(name, null);
    }

    @Test
    public void testReplaceSubscriptionPushConfigAsync() throws ExecutionException, InterruptedException {
        String topic = this.formatForTest("test-replace-push-config-async-topic");
        this.pubsub().create(TopicInfo.of((String)topic));
        String name = this.formatForTest("test-replace-push-config-async-subscription");
        Future subscriptionFuture = this.pubsub().createAsync(SubscriptionInfo.of((String)topic, (String)name));
        Subscription subscription = (Subscription)subscriptionFuture.get();
        Assert.assertEquals((Object)TopicId.of((String)((PubSubOptions)this.pubsub().options()).projectId(), (String)topic), (Object)subscription.topic());
        Assert.assertEquals((Object)name, (Object)subscription.name());
        Assert.assertNull((Object)subscription.pushConfig());
        String endpoint = "https://" + ((PubSubOptions)this.pubsub().options()).projectId() + ".appspot.com/push";
        PushConfig pushConfig = PushConfig.of((String)endpoint);
        this.pubsub().replacePushConfigAsync(name, pushConfig).get();
        Subscription remoteSubscription = (Subscription)this.pubsub().getSubscriptionAsync(name).get();
        Assert.assertEquals((Object)TopicId.of((String)((PubSubOptions)this.pubsub().options()).projectId(), (String)topic), (Object)remoteSubscription.topic());
        Assert.assertEquals((Object)name, (Object)remoteSubscription.name());
        Assert.assertEquals((Object)pushConfig, (Object)remoteSubscription.pushConfig());
        Assert.assertTrue((boolean)((Boolean)subscription.deleteAsync().get()));
        Assert.assertTrue((boolean)this.pubsub().deleteTopic(topic));
    }

    @Test
    public void testListSubscriptions() {
        String topicName1 = this.formatForTest("test-list-subscriptions-topic1");
        String topicName2 = this.formatForTest("test-list-subscriptions-topic2");
        Topic topic1 = this.pubsub().create(TopicInfo.of((String)topicName1));
        Topic topic2 = this.pubsub().create(TopicInfo.of((String)topicName2));
        String subscriptionName1 = this.formatForTest("test-list-subscriptions-subscription1");
        String subscriptionName2 = this.formatForTest("test-list-subscriptions-subscription2");
        String subscriptionName3 = this.formatForTest("test-list-subscriptions-subscription3");
        Subscription subscription1 = this.pubsub().create(SubscriptionInfo.of((String)topicName1, (String)subscriptionName1));
        Subscription subscription2 = this.pubsub().create(SubscriptionInfo.of((String)topicName1, (String)subscriptionName2));
        Subscription subscription3 = this.pubsub().create(SubscriptionInfo.of((String)topicName2, (String)subscriptionName3));
        HashSet subscriptionNames = Sets.newHashSet();
        Page subscriptions = this.pubsub().listSubscriptions(new PubSub.ListOption[]{PubSub.ListOption.pageSize((int)1)});
        Iterator iterator = subscriptions.iterateAll();
        while (iterator.hasNext()) {
            String name = ((Subscription)iterator.next()).name();
            subscriptionNames.add(name);
        }
        Assert.assertTrue((boolean)subscriptionNames.contains(subscriptionName1));
        Assert.assertTrue((boolean)subscriptionNames.contains(subscriptionName2));
        Assert.assertTrue((boolean)subscriptionNames.contains(subscriptionName3));
        HashSet topicSubscriptionNames = Sets.newHashSet();
        Page topic1Subscriptions = topic1.listSubscriptions(new PubSub.ListOption[]{PubSub.ListOption.pageSize((int)1)});
        Iterator firstStringPageIterator = topic1Subscriptions.values().iterator();
        topicSubscriptionNames.add(((SubscriptionId)firstStringPageIterator.next()).subscription());
        Assert.assertFalse((boolean)firstStringPageIterator.hasNext());
        Iterator topicSubscriptionsIterator = topic1Subscriptions.nextPage().iterateAll();
        while (topicSubscriptionsIterator.hasNext()) {
            topicSubscriptionNames.add(((SubscriptionId)topicSubscriptionsIterator.next()).subscription());
        }
        Assert.assertEquals((long)2L, (long)topicSubscriptionNames.size());
        Assert.assertTrue((boolean)topicSubscriptionNames.contains(subscriptionName1));
        Assert.assertTrue((boolean)topicSubscriptionNames.contains(subscriptionName2));
        Assert.assertTrue((boolean)topic1.delete());
        Assert.assertTrue((boolean)topic2.delete());
        Assert.assertTrue((boolean)subscription1.delete());
        Assert.assertTrue((boolean)subscription2.delete());
        Assert.assertTrue((boolean)subscription3.delete());
    }

    @Test
    public void testListSubscriptionsAsync() throws ExecutionException, InterruptedException {
        String topicName1 = this.formatForTest("test-list-subscriptions-async-topic1");
        String topicName2 = this.formatForTest("test-list-subscriptions-async-topic2");
        Topic topic1 = this.pubsub().create(TopicInfo.of((String)topicName1));
        Topic topic2 = this.pubsub().create(TopicInfo.of((String)topicName2));
        String subscriptionName1 = this.formatForTest("test-list-subscriptions-async-subscription1");
        String subscriptionName2 = this.formatForTest("test-list-subscriptions-async-subscription2");
        String subscriptionName3 = this.formatForTest("test-list-subscriptions-async-subscription3");
        Subscription subscription1 = this.pubsub().create(SubscriptionInfo.of((String)topicName1, (String)subscriptionName1));
        Subscription subscription2 = this.pubsub().create(SubscriptionInfo.of((String)topicName1, (String)subscriptionName2));
        Subscription subscription3 = this.pubsub().create(SubscriptionInfo.of((String)topicName2, (String)subscriptionName3));
        HashSet subscriptionNames = Sets.newHashSet();
        Future pageFuture = this.pubsub().listSubscriptionsAsync(new PubSub.ListOption[]{PubSub.ListOption.pageSize((int)1)});
        Iterator iterator = ((AsyncPage)pageFuture.get()).iterateAll();
        while (iterator.hasNext()) {
            subscriptionNames.add(((Subscription)iterator.next()).name());
        }
        Assert.assertTrue((boolean)subscriptionNames.contains(subscriptionName1));
        Assert.assertTrue((boolean)subscriptionNames.contains(subscriptionName2));
        Assert.assertTrue((boolean)subscriptionNames.contains(subscriptionName3));
        HashSet topicSubscriptionNames = Sets.newHashSet();
        AsyncPage topic1Subscriptions = (AsyncPage)topic1.listSubscriptionsAsync(new PubSub.ListOption[]{PubSub.ListOption.pageSize((int)1)}).get();
        Iterator firstStringPageIterator = topic1Subscriptions.values().iterator();
        topicSubscriptionNames.add(((SubscriptionId)firstStringPageIterator.next()).subscription());
        Assert.assertFalse((boolean)firstStringPageIterator.hasNext());
        Iterator topicSubscriptionsIterator = ((AsyncPage)topic1Subscriptions.nextPageAsync().get()).iterateAll();
        while (topicSubscriptionsIterator.hasNext()) {
            topicSubscriptionNames.add(((SubscriptionId)topicSubscriptionsIterator.next()).subscription());
        }
        Assert.assertEquals((long)2L, (long)topicSubscriptionNames.size());
        Assert.assertTrue((boolean)topicSubscriptionNames.contains(subscriptionName1));
        Assert.assertTrue((boolean)topicSubscriptionNames.contains(subscriptionName2));
        Assert.assertTrue((boolean)topic1.delete());
        Assert.assertTrue((boolean)topic2.delete());
        Assert.assertTrue((boolean)subscription1.delete());
        Assert.assertTrue((boolean)subscription2.delete());
        Assert.assertTrue((boolean)subscription3.delete());
    }

    @Test
    public void testPullMessages() {
        String topic = this.formatForTest("test-pull-messages-topic");
        this.pubsub().create(TopicInfo.of((String)topic));
        String subscription = this.formatForTest("test-pull-messages-subscription");
        this.pubsub().create(SubscriptionInfo.of((String)topic, (String)subscription));
        Message message1 = Message.of((String)"payload1");
        Message message2 = Message.of((String)"payload2");
        List messageIds = this.pubsub().publish(topic, (Iterable)ImmutableList.of((Object)message1, (Object)message2));
        Assert.assertEquals((long)2L, (long)messageIds.size());
        Iterator iterator = this.pubsub().pull(subscription, 2);
        Assert.assertEquals((Object)message1.payloadAsString(), (Object)((ReceivedMessage)iterator.next()).payloadAsString());
        Assert.assertEquals((Object)message2.payloadAsString(), (Object)((ReceivedMessage)iterator.next()).payloadAsString());
        Assert.assertTrue((boolean)this.pubsub().deleteSubscription(subscription));
        Assert.assertTrue((boolean)this.pubsub().deleteTopic(topic));
    }

    @Test
    public void testPullMessagesAndAutoRenewDeadline() throws InterruptedException {
        String topic = this.formatForTest("test-pull-messages-and-renew-deadline-topic");
        this.pubsub().create(TopicInfo.of((String)topic));
        String subscription = this.formatForTest("test-pull-messages-and-renew-deadline-subscription");
        this.pubsub().create(SubscriptionInfo.builder((String)topic, (String)subscription).ackDeadLineSeconds(10).build());
        Message message1 = Message.of((String)"payload1");
        Message message2 = Message.of((String)"payload2");
        this.pubsub().publish(topic, message1);
        this.pubsub().publish(topic, message2);
        Iterator iterator = this.pubsub().pull(subscription, 2);
        ReceivedMessage consumedMessage = (ReceivedMessage)iterator.next();
        Thread.sleep(15000L);
        Iterator nextIterator = this.pubsub().pull(subscription, 2);
        Assert.assertTrue((boolean)nextIterator.hasNext());
        ReceivedMessage message = (ReceivedMessage)nextIterator.next();
        Assert.assertEquals((Object)consumedMessage.payloadAsString(), (Object)message.payloadAsString());
        Assert.assertFalse((boolean)nextIterator.hasNext());
        consumedMessage.ack();
        ((ReceivedMessage)iterator.next()).ack();
        nextIterator = this.pubsub().pull(subscription, 2);
        Assert.assertFalse((boolean)nextIterator.hasNext());
        Assert.assertTrue((boolean)this.pubsub().deleteSubscription(subscription));
        Assert.assertTrue((boolean)this.pubsub().deleteTopic(topic));
    }

    @Test
    public void testPullMessagesAndModifyAckDeadline() throws InterruptedException {
        String topic = this.formatForTest("test-pull-messages-and-modify-deadline-topic");
        this.pubsub().create(TopicInfo.of((String)topic));
        String subscription = this.formatForTest("test-pull-messages-and-modify-deadline-subscription");
        this.pubsub().create(SubscriptionInfo.builder((String)topic, (String)subscription).ackDeadLineSeconds(10).build());
        Message message1 = Message.of((String)"payload1");
        Message message2 = Message.of((String)"payload2");
        this.pubsub().publish(topic, message1);
        this.pubsub().publish(topic, message2);
        ArrayList receivedMessages = Lists.newArrayList((Iterator)this.pubsub().pull(subscription, 2));
        ((ReceivedMessage)receivedMessages.get(0)).modifyAckDeadline(60, TimeUnit.SECONDS);
        Thread.sleep(15000L);
        Iterator nextIterator = this.pubsub().pull(subscription, 2);
        Assert.assertTrue((boolean)nextIterator.hasNext());
        ReceivedMessage message = (ReceivedMessage)nextIterator.next();
        Assert.assertEquals((Object)((ReceivedMessage)receivedMessages.get(1)).payloadAsString(), (Object)message.payloadAsString());
        Assert.assertFalse((boolean)nextIterator.hasNext());
        Assert.assertTrue((boolean)this.pubsub().deleteSubscription(subscription));
        Assert.assertTrue((boolean)this.pubsub().deleteTopic(topic));
    }

    @Test
    public void testPullNonExistingSubscription() {
        this.thrown.expect(PubSubException.class);
        this.pubsub().pull(this.formatForTest("non-existing-subscription"), 2);
    }

    @Test
    public void testPullMessagesAsync() throws ExecutionException, InterruptedException {
        String topic = this.formatForTest("test-pull-messages-async-topic");
        this.pubsub().create(TopicInfo.of((String)topic));
        String subscription = this.formatForTest("test-pull-messages-async-subscription");
        this.pubsub().create(SubscriptionInfo.of((String)topic, (String)subscription));
        Message message1 = Message.of((String)"payload1");
        Message message2 = Message.of((String)"payload2");
        List messageIds = this.pubsub().publish(topic, (Iterable)ImmutableList.of((Object)message1, (Object)message2));
        Assert.assertEquals((long)2L, (long)messageIds.size());
        Iterator iterator = (Iterator)this.pubsub().pullAsync(subscription, 2).get();
        Assert.assertEquals((Object)message1.payloadAsString(), (Object)((ReceivedMessage)iterator.next()).payloadAsString());
        Assert.assertEquals((Object)message2.payloadAsString(), (Object)((ReceivedMessage)iterator.next()).payloadAsString());
        Assert.assertTrue((boolean)this.pubsub().deleteSubscription(subscription));
        Assert.assertTrue((boolean)this.pubsub().deleteTopic(topic));
    }

    @Test
    public void testPullAsyncNonExistingSubscription() throws ExecutionException, InterruptedException {
        this.thrown.expect(ExecutionException.class);
        this.pubsub().pullAsync(this.formatForTest("non-existing-subscription"), 2).get();
    }

    @Test
    public void testMessageConsumer() throws Exception {
        String topic = this.formatForTest("test-message-consumer-topic");
        this.pubsub().create(TopicInfo.of((String)topic));
        String subscription = this.formatForTest("test-message-consumer-subscription");
        this.pubsub().create(SubscriptionInfo.of((String)topic, (String)subscription));
        Message message1 = Message.of((String)"payload1");
        Message message2 = Message.of((String)"payload2");
        HashSet payloads = Sets.newHashSet((Object[])new String[]{"payload1", "payload2"});
        List messageIds = this.pubsub().publish(topic, (Iterable)ImmutableList.of((Object)message1, (Object)message2));
        Assert.assertEquals((long)2L, (long)messageIds.size());
        final List<Message> receivedMessages = Collections.synchronizedList(new ArrayList());
        final CountDownLatch countDownLatch = new CountDownLatch(2);
        PubSub.MessageProcessor processor = new PubSub.MessageProcessor(){

            public void process(Message message) throws Exception {
                receivedMessages.add(message);
                countDownLatch.countDown();
            }
        };
        try (PubSub.MessageConsumer consumer = this.pubsub().pullAsync(subscription, processor, new PubSub.PullOption[0]);){
            countDownLatch.await();
        }
        for (Message message : receivedMessages) {
            payloads.contains(message.payloadAsString());
        }
        Iterator messages = this.pubsub().pull(subscription, 2);
        Assert.assertFalse((boolean)messages.hasNext());
        Assert.assertTrue((boolean)this.pubsub().deleteSubscription(subscription));
        Assert.assertTrue((boolean)this.pubsub().deleteTopic(topic));
    }

    @Test
    public void testMessageConsumerNack() throws Exception {
        String topic = this.formatForTest("test-message-consumer-nack-topic");
        this.pubsub().create(TopicInfo.of((String)topic));
        String subscription = this.formatForTest("test-message-consumer-nack-subscription");
        this.pubsub().create(SubscriptionInfo.of((String)topic, (String)subscription));
        Message message1 = Message.of((String)"payload1");
        Message message2 = Message.of((String)"payload2");
        HashSet payloads = Sets.newHashSet((Object[])new String[]{"payload1", "payload2"});
        List messageIds = this.pubsub().publish(topic, (Iterable)ImmutableList.of((Object)message1, (Object)message2));
        Assert.assertEquals((long)2L, (long)messageIds.size());
        final List<Message> receivedMessages = Collections.synchronizedList(new ArrayList());
        final CountDownLatch countDownLatch = new CountDownLatch(2);
        PubSub.MessageProcessor processor = new PubSub.MessageProcessor(){

            public void process(Message message) throws Exception {
                receivedMessages.add(message);
                countDownLatch.countDown();
                throw new RuntimeException("Force nack");
            }
        };
        try (PubSub.MessageConsumer consumer = this.pubsub().pullAsync(subscription, processor, new PubSub.PullOption[0]);){
            countDownLatch.await();
        }
        for (Message message : receivedMessages) {
            payloads.contains(message.payloadAsString());
        }
        Thread.sleep(5000L);
        Iterator messages = this.pubsub().pull(subscription, 2);
        while (messages.hasNext()) {
            payloads.contains(((ReceivedMessage)messages.next()).payloadAsString());
        }
        Assert.assertTrue((boolean)this.pubsub().deleteSubscription(subscription));
        Assert.assertTrue((boolean)this.pubsub().deleteTopic(topic));
    }

    @Test
    public void testMessageConsumerWithMoreMessages() throws Exception {
        String topic = this.formatForTest("test-message-consumer-more-messages-topic");
        this.pubsub().create(TopicInfo.of((String)topic));
        String subscription = this.formatForTest("test-message-consumer-more-messages-subscriptions");
        this.pubsub().create(SubscriptionInfo.of((String)topic, (String)subscription));
        int totalMessages = 200;
        HashSet payloads = Sets.newHashSetWithExpectedSize((int)totalMessages);
        ArrayList messagesToSend = Lists.newArrayListWithCapacity((int)totalMessages);
        for (int i = 0; i < totalMessages; ++i) {
            String payload = "payload" + i;
            messagesToSend.add(Message.of((String)payload));
            payloads.add(payload);
        }
        List messageIds = this.pubsub().publish(topic, (Iterable)messagesToSend);
        Assert.assertEquals((long)totalMessages, (long)messageIds.size());
        final List receivedMessages = Collections.synchronizedList(new ArrayList());
        final CountDownLatch countDownLatch = new CountDownLatch(totalMessages);
        PubSub.MessageProcessor processor = new PubSub.MessageProcessor(){

            public void process(Message message) throws Exception {
                receivedMessages.add(message);
                countDownLatch.countDown();
            }
        };
        try (PubSub.MessageConsumer consumer = this.pubsub().pullAsync(subscription, processor, new PubSub.PullOption[0]);){
            countDownLatch.await();
        }
        Iterator messages = this.pubsub().pull(subscription, totalMessages);
        Assert.assertFalse((boolean)messages.hasNext());
        Assert.assertTrue((boolean)this.pubsub().deleteSubscription(subscription));
        Assert.assertTrue((boolean)this.pubsub().deleteTopic(topic));
    }

    @Test
    public void testMessageConsumerAndAutoRenewDeadline() throws Exception {
        String topic = this.formatForTest("test-message-consumer-and-renew-deadline-topic");
        this.pubsub().create(TopicInfo.of((String)topic));
        final String subscription = this.formatForTest("test-message-consumer-and-renew-deadline-subscription");
        this.pubsub().create(SubscriptionInfo.builder((String)topic, (String)subscription).ackDeadLineSeconds(10).build());
        Message message1 = Message.of((String)"payload1");
        Message message2 = Message.of((String)"payload2");
        HashSet payloads = Sets.newHashSet((Object[])new String[]{"payload1", "payload2"});
        List messageIds = this.pubsub().publish(topic, (Iterable)ImmutableList.of((Object)message1, (Object)message2));
        Assert.assertEquals((long)2L, (long)messageIds.size());
        final List<Message> receivedMessages = Collections.synchronizedList(new ArrayList());
        final CountDownLatch countDownLatch = new CountDownLatch(2);
        PubSub.MessageProcessor processor = new PubSub.MessageProcessor(){

            public void process(Message message) throws Exception {
                receivedMessages.add(message);
                Thread.sleep(15000L);
                Iterator messages = BaseSystemTest.this.pubsub().pull(subscription, 2);
                Assert.assertFalse((boolean)messages.hasNext());
                countDownLatch.countDown();
            }
        };
        try (PubSub.MessageConsumer consumer = this.pubsub().pullAsync(subscription, processor, new PubSub.PullOption[0]);){
            countDownLatch.await();
        }
        for (Message message : receivedMessages) {
            payloads.contains(message.payloadAsString());
        }
        Iterator messages = this.pubsub().pull(subscription, 2);
        Assert.assertFalse((boolean)messages.hasNext());
        Assert.assertTrue((boolean)this.pubsub().deleteSubscription(subscription));
        Assert.assertTrue((boolean)this.pubsub().deleteTopic(topic));
    }

    @Test
    public void testAckAndNackOneMessage() {
        String topic = this.formatForTest("test-ack-one-message-topic");
        this.pubsub().create(TopicInfo.of((String)topic));
        String subscription = this.formatForTest("test-ack-one-message-subscription");
        this.pubsub().create(SubscriptionInfo.of((String)topic, (String)subscription));
        Message message = Message.of((String)"payload");
        Assert.assertNotNull((Object)this.pubsub().publish(topic, message));
        Iterator receivedMessages = this.pubsub().pull(subscription, 1);
        ((ReceivedMessage)receivedMessages.next()).nack();
        receivedMessages = this.pubsub().pull(subscription, 1);
        ((ReceivedMessage)receivedMessages.next()).ack();
        Assert.assertFalse((boolean)this.pubsub().pull(subscription, 1).hasNext());
        Assert.assertTrue((boolean)this.pubsub().deleteSubscription(subscription));
        Assert.assertTrue((boolean)this.pubsub().deleteTopic(topic));
    }

    @Test
    public void testAckAndNackOneMessageAsync() throws ExecutionException, InterruptedException {
        String topic = this.formatForTest("test-ack-one-message-async-topic");
        this.pubsub().create(TopicInfo.of((String)topic));
        String subscription = this.formatForTest("test-ack-one-message-async-subscription");
        this.pubsub().create(SubscriptionInfo.of((String)topic, (String)subscription));
        Message message = Message.of((String)"payload");
        Assert.assertNotNull((Object)this.pubsub().publish(topic, message));
        Iterator receivedMessages = this.pubsub().pull(subscription, 1);
        ((ReceivedMessage)receivedMessages.next()).nackAsync().get();
        receivedMessages = this.pubsub().pull(subscription, 1);
        ((ReceivedMessage)receivedMessages.next()).ackAsync().get();
        Assert.assertFalse((boolean)this.pubsub().pull(subscription, 1).hasNext());
        Assert.assertTrue((boolean)this.pubsub().deleteSubscription(subscription));
        Assert.assertTrue((boolean)this.pubsub().deleteTopic(topic));
    }

    @Test
    public void testAckAndNackMoreMessages() throws ExecutionException, InterruptedException {
        String topic = this.formatForTest("test-ack-more-messages-topic");
        this.pubsub().create(TopicInfo.of((String)topic));
        String subscription = this.formatForTest("test-ack-more-messages-subscription");
        this.pubsub().create(SubscriptionInfo.of((String)topic, (String)subscription));
        Message message1 = Message.of((String)"payload1");
        Message message2 = Message.of((String)"payload2");
        Assert.assertNotNull((Object)this.pubsub().publish(topic, message1, new Message[]{message2}));
        Iterator receivedMessages = this.pubsub().pull(subscription, 2);
        this.pubsub().nack(subscription, ((ReceivedMessage)receivedMessages.next()).ackId(), new String[]{((ReceivedMessage)receivedMessages.next()).ackId()});
        receivedMessages = this.pubsub().pull(subscription, 2);
        this.pubsub().ack(subscription, ((ReceivedMessage)receivedMessages.next()).ackId(), new String[]{((ReceivedMessage)receivedMessages.next()).ackId()});
        Assert.assertFalse((boolean)this.pubsub().pull(subscription, 2).hasNext());
        Assert.assertTrue((boolean)this.pubsub().deleteSubscription(subscription));
        Assert.assertTrue((boolean)this.pubsub().deleteTopic(topic));
    }

    @Test
    public void testAckAndNackMoreMessagesAsync() throws ExecutionException, InterruptedException {
        String topic = this.formatForTest("test-ack-more-messages-async-topic");
        this.pubsub().create(TopicInfo.of((String)topic));
        String subscription = this.formatForTest("test-ack-more-messages-async-subscription");
        this.pubsub().create(SubscriptionInfo.of((String)topic, (String)subscription));
        Message message1 = Message.of((String)"payload1");
        Message message2 = Message.of((String)"payload2");
        Assert.assertNotNull((Object)this.pubsub().publish(topic, message1, new Message[]{message2}));
        Iterator receivedMessages = this.pubsub().pull(subscription, 2);
        this.pubsub().nackAsync(subscription, ((ReceivedMessage)receivedMessages.next()).ackId(), new String[]{((ReceivedMessage)receivedMessages.next()).ackId()}).get();
        receivedMessages = this.pubsub().pull(subscription, 2);
        this.pubsub().ackAsync(subscription, ((ReceivedMessage)receivedMessages.next()).ackId(), new String[]{((ReceivedMessage)receivedMessages.next()).ackId()}).get();
        Assert.assertFalse((boolean)this.pubsub().pull(subscription, 2).hasNext());
        Assert.assertTrue((boolean)this.pubsub().deleteSubscription(subscription));
        Assert.assertTrue((boolean)this.pubsub().deleteTopic(topic));
    }

    @Test
    public void testAckAndNackMessageList() throws ExecutionException, InterruptedException {
        String topic = this.formatForTest("test-ack-message-list-topic");
        this.pubsub().create(TopicInfo.of((String)topic));
        String subscription = this.formatForTest("test-ack-message-list-subscription");
        this.pubsub().create(SubscriptionInfo.of((String)topic, (String)subscription));
        Message message1 = Message.of((String)"payload1");
        Message message2 = Message.of((String)"payload2");
        Assert.assertNotNull((Object)this.pubsub().publish(topic, (Iterable)ImmutableList.of((Object)message1, (Object)message2)));
        Iterator receivedMessages = this.pubsub().pull(subscription, 2);
        this.pubsub().nack(subscription, (Iterable)ImmutableList.of((Object)((ReceivedMessage)receivedMessages.next()).ackId(), (Object)((ReceivedMessage)receivedMessages.next()).ackId()));
        receivedMessages = this.pubsub().pull(subscription, 2);
        this.pubsub().ack(subscription, (Iterable)ImmutableList.of((Object)((ReceivedMessage)receivedMessages.next()).ackId(), (Object)((ReceivedMessage)receivedMessages.next()).ackId()));
        Assert.assertFalse((boolean)this.pubsub().pull(subscription, 2).hasNext());
        Assert.assertTrue((boolean)this.pubsub().deleteSubscription(subscription));
        Assert.assertTrue((boolean)this.pubsub().deleteTopic(topic));
    }

    @Test
    public void testAckAndNackMessageListAsync() throws ExecutionException, InterruptedException {
        String topic = this.formatForTest("test-ack-message-list-async-topic");
        this.pubsub().create(TopicInfo.of((String)topic));
        String subscription = this.formatForTest("test-ack-message-list-async-subscription");
        this.pubsub().create(SubscriptionInfo.of((String)topic, (String)subscription));
        Message message1 = Message.of((String)"payload1");
        Message message2 = Message.of((String)"payload2");
        Assert.assertNotNull((Object)this.pubsub().publish(topic, (Iterable)ImmutableList.of((Object)message1, (Object)message2)));
        Iterator receivedMessages = this.pubsub().pull(subscription, 2);
        this.pubsub().nackAsync(subscription, (Iterable)ImmutableList.of((Object)((ReceivedMessage)receivedMessages.next()).ackId(), (Object)((ReceivedMessage)receivedMessages.next()).ackId())).get();
        receivedMessages = this.pubsub().pull(subscription, 2);
        this.pubsub().ackAsync(subscription, (Iterable)ImmutableList.of((Object)((ReceivedMessage)receivedMessages.next()).ackId(), (Object)((ReceivedMessage)receivedMessages.next()).ackId())).get();
        Assert.assertFalse((boolean)this.pubsub().pull(subscription, 2).hasNext());
        Assert.assertTrue((boolean)this.pubsub().deleteSubscription(subscription));
        Assert.assertTrue((boolean)this.pubsub().deleteTopic(topic));
    }
}

