/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.cloud.pubsub.Option;
import com.google.cloud.pubsub.PubSub;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class OptionTest {
    private static final Option.OptionType OPTION_TYPE = PubSub.ListOption.OptionType.PAGE_SIZE;
    private static final Option.OptionType ANOTHER_OPTION_TYPE = PubSub.ListOption.OptionType.PAGE_TOKEN;
    private static final String VALUE = "some value";
    private static final String OTHER_VALUE = "another value";
    private static final Option OPTION = new Option(OPTION_TYPE, "some value"){};
    private static final Option OPTION_EQUALS = new Option(OPTION_TYPE, "some value"){};
    private static final Option OPTION_NOT_EQUALS1 = new Option(ANOTHER_OPTION_TYPE, "another value"){};
    private static final Option OPTION_NOT_EQUALS2 = new Option(ANOTHER_OPTION_TYPE, "some value"){};
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testEquals() {
        Assert.assertEquals((Object)OPTION, (Object)OPTION_EQUALS);
        Assert.assertNotEquals((Object)OPTION, (Object)OPTION_NOT_EQUALS1);
        Assert.assertNotEquals((Object)OPTION, (Object)OPTION_NOT_EQUALS2);
    }

    @Test
    public void testHashCode() {
        Assert.assertEquals((long)OPTION.hashCode(), (long)OPTION_EQUALS.hashCode());
    }

    @Test
    public void testConstructor() {
        Assert.assertEquals((Object)OPTION_TYPE, (Object)OPTION.optionType());
        Assert.assertEquals((Object)VALUE, (Object)OPTION.value());
        Option option = new Option(OPTION_TYPE, null){};
        Assert.assertEquals((Object)OPTION_TYPE, (Object)option.optionType());
        Assert.assertNull((Object)option.value());
        this.thrown.expect(NullPointerException.class);
        new Option(null, VALUE){};
    }
}

