/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.cloud.pubsub.PushConfig;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class PushConfigTest {
    private static final String ENDPOINT = "https://example.com/push";
    private static final Map<String, String> ATTRIBUTES = ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2");
    private static final PushConfig PUSH_CONFIG = PushConfig.builder((String)"https://example.com/push", ATTRIBUTES).build();

    @Test
    public void testToBuilder() {
        this.comparePushConfig(PUSH_CONFIG, PUSH_CONFIG.toBuilder().build());
        PushConfig pushConfig = PUSH_CONFIG.toBuilder().endpoint("https://example2.com/push").clearAttributes().addAttribute("key1", "value1").build();
        Assert.assertEquals((Object)"https://example2.com/push", (Object)pushConfig.endpoint());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"key1", (Object)"value1"), (Object)pushConfig.attributes());
        pushConfig = pushConfig.toBuilder().endpoint(ENDPOINT).removeAttribute("key1").attributes(ATTRIBUTES).build();
        this.comparePushConfig(PUSH_CONFIG, pushConfig);
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)ENDPOINT, (Object)PUSH_CONFIG.endpoint());
        Assert.assertEquals(ATTRIBUTES, (Object)PUSH_CONFIG.attributes());
        PushConfig pushConfig = PushConfig.builder((String)"https://example2.com/push").endpoint(ENDPOINT).attributes(ATTRIBUTES).clearAttributes().addAttribute("key1", "value1").addAttribute("key2", "value2").build();
        Assert.assertEquals((Object)ENDPOINT, (Object)pushConfig.endpoint());
        Assert.assertEquals(ATTRIBUTES, (Object)pushConfig.attributes());
        this.comparePushConfig(PUSH_CONFIG, pushConfig);
    }

    @Test
    public void testOf() {
        PushConfig pushConfig = PushConfig.of((String)ENDPOINT);
        Assert.assertEquals((Object)ENDPOINT, (Object)pushConfig.endpoint());
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)pushConfig.attributes());
        pushConfig = PushConfig.of((String)ENDPOINT, ATTRIBUTES);
        Assert.assertEquals((Object)ENDPOINT, (Object)pushConfig.endpoint());
        Assert.assertEquals(ATTRIBUTES, (Object)pushConfig.attributes());
        this.comparePushConfig(PUSH_CONFIG, pushConfig);
    }

    @Test
    public void testToAndFromPb() {
        this.comparePushConfig(PUSH_CONFIG, PushConfig.fromPb((com.google.pubsub.v1.PushConfig)PUSH_CONFIG.toPb()));
    }

    @Test
    public void testToAndFromPbIncomplete() {
        PushConfig pushConfig = PushConfig.of((String)ENDPOINT);
        this.comparePushConfig(pushConfig, PushConfig.fromPb((com.google.pubsub.v1.PushConfig)pushConfig.toPb()));
    }

    private void comparePushConfig(PushConfig expected, PushConfig value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.endpoint(), (Object)value.endpoint());
        Assert.assertEquals((Object)expected.attributes(), (Object)value.attributes());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

