/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.cloud.pubsub.TopicId;
import org.junit.Assert;
import org.junit.Test;

public class TopicIdTest {
    private static final String PROJECT = "project";
    private static final String NAME = "topic";
    private static final String TOPIC_PB = "projects/project/topics/topic";
    private static final String DELETED_TOPIC_NAME = "_deleted-topic_";

    @Test
    public void testOf() {
        TopicId topicId = TopicId.of((String)PROJECT, (String)NAME);
        Assert.assertEquals((Object)PROJECT, (Object)topicId.project());
        Assert.assertEquals((Object)NAME, (Object)topicId.topic());
        topicId = TopicId.of((String)NAME);
        Assert.assertNull((Object)topicId.project());
        Assert.assertEquals((Object)NAME, (Object)topicId.topic());
        Assert.assertFalse((boolean)topicId.isDeleted());
    }

    @Test
    public void testDeletedTopic() {
        TopicId deletedTopic = TopicId.deletedTopic();
        Assert.assertNull((Object)deletedTopic.project());
        Assert.assertEquals((Object)DELETED_TOPIC_NAME, (Object)deletedTopic.topic());
        Assert.assertTrue((boolean)deletedTopic.isDeleted());
        Assert.assertSame((Object)deletedTopic, (Object)TopicId.deletedTopic());
    }

    @Test
    public void testToAndFromPb() {
        TopicId topicId = TopicId.of((String)PROJECT, (String)NAME);
        String topicPb = topicId.toPb("otherProject");
        Assert.assertEquals((Object)TOPIC_PB, (Object)topicPb);
        this.compareTopicId(topicId, TopicId.fromPb((String)topicPb));
        topicId = TopicId.of((String)NAME);
        topicPb = topicId.toPb("otherProject");
        Assert.assertEquals((Object)"projects/otherProject/topics/topic", (Object)topicPb);
        this.compareTopicId(TopicId.of((String)"otherProject", (String)NAME), TopicId.fromPb((String)topicPb));
        Assert.assertSame((Object)TopicId.deletedTopic(), (Object)TopicId.fromPb((String)DELETED_TOPIC_NAME));
    }

    private void compareTopicId(TopicId expected, TopicId value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.project(), (Object)value.project());
        Assert.assertEquals((Object)expected.topic(), (Object)value.topic());
        Assert.assertEquals((Object)expected.isDeleted(), (Object)value.isDeleted());
        Assert.assertEquals((Object)expected.toPb(PROJECT), (Object)value.toPb(PROJECT));
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

