/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.cloud.pubsub.TopicInfo;
import com.google.pubsub.v1.Topic;
import org.junit.Assert;
import org.junit.Test;

public class TopicInfoTest {
    private static final String NAME = "topic";
    private static final TopicInfo TOPIC_INFO = TopicInfo.builder((String)"topic").build();

    @Test
    public void testToBuilder() {
        this.compareTopicInfo(TOPIC_INFO, TOPIC_INFO.toBuilder().build());
        TopicInfo topicInfo = TOPIC_INFO.toBuilder().name("newTopic").build();
        Assert.assertEquals((Object)"newTopic", (Object)topicInfo.name());
        topicInfo = topicInfo.toBuilder().name(NAME).build();
        this.compareTopicInfo(TOPIC_INFO, topicInfo);
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)NAME, (Object)TOPIC_INFO.name());
        TopicInfo topicInfo = TopicInfo.builder((String)"wrongName").name(NAME).build();
        this.compareTopicInfo(TOPIC_INFO, topicInfo);
    }

    @Test
    public void testOf() {
        this.compareTopicInfo(TOPIC_INFO, TopicInfo.of((String)NAME));
    }

    @Test
    public void testToAndFromPb() {
        this.compareTopicInfo(TOPIC_INFO, TopicInfo.fromPb((Topic)TOPIC_INFO.toPb("project")));
        Assert.assertEquals((Object)"projects/project/topics/topic", (Object)TOPIC_INFO.toPb("project").getName());
    }

    private void compareTopicInfo(TopicInfo expected, TopicInfo value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.name(), (Object)value.name());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

