/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.cloud.AsyncPage;
import com.google.cloud.AsyncPageImpl;
import com.google.cloud.PageImpl;
import com.google.cloud.pubsub.Message;
import com.google.cloud.pubsub.PubSub;
import com.google.cloud.pubsub.PubSubOptions;
import com.google.cloud.pubsub.SubscriptionId;
import com.google.cloud.pubsub.Topic;
import com.google.cloud.pubsub.TopicInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import java.util.concurrent.ExecutionException;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TopicTest {
    private static final String NAME = "topic";
    private static final TopicInfo TOPIC_INFO = TopicInfo.of((String)"topic");
    private final PubSub serviceMockReturnsOptions = (PubSub)EasyMock.createStrictMock(PubSub.class);
    private final PubSubOptions mockOptions = (PubSubOptions)EasyMock.createMock(PubSubOptions.class);
    private PubSub pubsub;
    private Topic expectedTopic;
    private Topic topic;

    private void initializeExpectedTopic(int optionsCalls) {
        EasyMock.expect((Object)this.serviceMockReturnsOptions.options()).andReturn((Object)this.mockOptions).times(optionsCalls);
        EasyMock.replay((Object[])new Object[]{this.serviceMockReturnsOptions});
        this.pubsub = (PubSub)EasyMock.createStrictMock(PubSub.class);
        this.expectedTopic = new Topic(this.serviceMockReturnsOptions, new TopicInfo.BuilderImpl(TOPIC_INFO));
    }

    private void initializeTopic() {
        this.topic = new Topic(this.pubsub, new TopicInfo.BuilderImpl(TOPIC_INFO));
    }

    @After
    public void tearDown() throws Exception {
        EasyMock.verify((Object[])new Object[]{this.pubsub, this.serviceMockReturnsOptions});
    }

    @Test
    public void testBuilder() {
        this.initializeExpectedTopic(2);
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        Topic builtTopic = this.expectedTopic.toBuilder().name("newTopic").build();
        Assert.assertEquals((Object)"newTopic", (Object)builtTopic.name());
    }

    @Test
    public void testToBuilder() {
        this.initializeExpectedTopic(2);
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.compareTopic(this.expectedTopic, this.expectedTopic.toBuilder().build());
    }

    @Test
    public void testReload() {
        this.initializeExpectedTopic(2);
        TopicInfo updatedInfo = TOPIC_INFO.toBuilder().name("newTopic").build();
        Topic expectedTopic = new Topic(this.serviceMockReturnsOptions, new TopicInfo.BuilderImpl(updatedInfo));
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.pubsub.getTopic(NAME)).andReturn((Object)expectedTopic);
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeTopic();
        Topic updatedTopic = this.topic.reload();
        this.compareTopic(expectedTopic, updatedTopic);
    }

    @Test
    public void testReloadNull() {
        this.initializeExpectedTopic(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.pubsub.getTopic(NAME)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeTopic();
        Assert.assertNull((Object)this.topic.reload());
    }

    @Test
    public void testReloadAsync() throws ExecutionException, InterruptedException {
        this.initializeExpectedTopic(2);
        TopicInfo updatedInfo = TOPIC_INFO.toBuilder().name("newTopic").build();
        Topic expectedTopic = new Topic(this.serviceMockReturnsOptions, new TopicInfo.BuilderImpl(updatedInfo));
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.pubsub.getTopicAsync(NAME)).andReturn((Object)Futures.immediateFuture((Object)expectedTopic));
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeTopic();
        Topic updatedTopic = (Topic)this.topic.reloadAsync().get();
        this.compareTopic(expectedTopic, updatedTopic);
    }

    @Test
    public void testReloadAsyncNull() throws ExecutionException, InterruptedException {
        this.initializeExpectedTopic(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.pubsub.getTopicAsync(NAME)).andReturn((Object)Futures.immediateFuture(null));
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeTopic();
        Assert.assertNull(this.topic.reloadAsync().get());
    }

    @Test
    public void testDeleteTrue() {
        this.initializeExpectedTopic(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.pubsub.deleteTopic(NAME)).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeTopic();
        Assert.assertTrue((boolean)this.topic.delete());
    }

    @Test
    public void testDeleteFalse() {
        this.initializeExpectedTopic(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.pubsub.deleteTopic(NAME)).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeTopic();
        Assert.assertFalse((boolean)this.topic.delete());
    }

    @Test
    public void testDeleteAsyncTrue() throws ExecutionException, InterruptedException {
        this.initializeExpectedTopic(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.pubsub.deleteTopicAsync(NAME)).andReturn((Object)Futures.immediateFuture((Object)true));
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeTopic();
        Assert.assertTrue((boolean)((Boolean)this.topic.deleteAsync().get()));
    }

    @Test
    public void testDeleteAsyncFalse() throws ExecutionException, InterruptedException {
        this.initializeExpectedTopic(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.pubsub.deleteTopicAsync(NAME)).andReturn((Object)Futures.immediateFuture((Object)false));
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeTopic();
        Assert.assertFalse((boolean)((Boolean)this.topic.deleteAsync().get()));
    }

    @Test
    public void testPublishOneMessage() {
        this.initializeExpectedTopic(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        Message message = Message.of((String)"payload1");
        String messageId = "messageId";
        EasyMock.expect((Object)this.pubsub.publish(NAME, message)).andReturn((Object)messageId);
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeTopic();
        Assert.assertEquals((Object)messageId, (Object)this.topic.publish(message));
    }

    @Test
    public void testPublishOneMessageAsync() throws ExecutionException, InterruptedException {
        this.initializeExpectedTopic(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        Message message = Message.of((String)"payload1");
        String messageId = "messageId";
        EasyMock.expect((Object)this.pubsub.publishAsync(NAME, message)).andReturn((Object)Futures.immediateFuture((Object)messageId));
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeTopic();
        Assert.assertEquals((Object)messageId, this.topic.publishAsync(message).get());
    }

    @Test
    public void testPublishMoreMessages() {
        this.initializeExpectedTopic(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        Message message1 = Message.of((String)"payload1");
        Message message2 = Message.of((String)"payload2");
        ImmutableList messageIds = ImmutableList.of((Object)"messageId1", (Object)"messageId2");
        EasyMock.expect((Object)this.pubsub.publish(NAME, message1, new Message[]{message2})).andReturn((Object)messageIds);
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeTopic();
        Assert.assertEquals((Object)messageIds, (Object)this.topic.publish(message1, new Message[]{message2}));
    }

    @Test
    public void testPublishMoreMessagesAsync() throws ExecutionException, InterruptedException {
        this.initializeExpectedTopic(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        Message message1 = Message.of((String)"payload1");
        Message message2 = Message.of((String)"payload2");
        ImmutableList messageIds = ImmutableList.of((Object)"messageId1", (Object)"messageId2");
        EasyMock.expect((Object)this.pubsub.publishAsync(NAME, message1, new Message[]{message2})).andReturn((Object)Futures.immediateFuture((Object)messageIds));
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeTopic();
        Assert.assertEquals((Object)messageIds, this.topic.publishAsync(message1, new Message[]{message2}).get());
    }

    @Test
    public void testPublishMessageList() {
        this.initializeExpectedTopic(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        Message message1 = Message.of((String)"payload1");
        Message message2 = Message.of((String)"payload2");
        ImmutableList messages = ImmutableList.of((Object)message1, (Object)message2);
        ImmutableList messageIds = ImmutableList.of((Object)"messageId1", (Object)"messageId2");
        EasyMock.expect((Object)this.pubsub.publish(NAME, (Iterable)messages)).andReturn((Object)messageIds);
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeTopic();
        Assert.assertEquals((Object)messageIds, (Object)this.topic.publish((Iterable)messages));
    }

    @Test
    public void testPublishMessageListAsync() throws ExecutionException, InterruptedException {
        this.initializeExpectedTopic(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        Message message1 = Message.of((String)"payload1");
        Message message2 = Message.of((String)"payload2");
        ImmutableList messages = ImmutableList.of((Object)message1, (Object)message2);
        ImmutableList messageIds = ImmutableList.of((Object)"messageId1", (Object)"messageId2");
        EasyMock.expect((Object)this.pubsub.publishAsync(NAME, (Iterable)messages)).andReturn((Object)Futures.immediateFuture((Object)messageIds));
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeTopic();
        Assert.assertEquals((Object)messageIds, this.topic.publishAsync((Iterable)messages).get());
    }

    @Test
    public void testListSubscriptions() {
        this.initializeExpectedTopic(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        ImmutableList subscriptions = ImmutableList.of((Object)new SubscriptionId("project", "subscription1"), (Object)new SubscriptionId("project", "subscription2"));
        PageImpl result = new PageImpl(null, null, (Iterable)subscriptions);
        EasyMock.expect((Object)this.pubsub.listSubscriptions(NAME, new PubSub.ListOption[0])).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeTopic();
        Assert.assertEquals((Object)subscriptions, (Object)this.topic.listSubscriptions(new PubSub.ListOption[0]).values());
    }

    @Test
    public void testListSubscriptionsWithOptions() {
        this.initializeExpectedTopic(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        ImmutableList subscriptions = ImmutableList.of((Object)new SubscriptionId("project", "subscription1"), (Object)new SubscriptionId("project", "subscription2"));
        PageImpl result = new PageImpl(null, null, (Iterable)subscriptions);
        EasyMock.expect((Object)this.pubsub.listSubscriptions(NAME, new PubSub.ListOption[]{PubSub.ListOption.pageSize((int)42)})).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeTopic();
        Assert.assertEquals((Object)subscriptions, (Object)this.topic.listSubscriptions(new PubSub.ListOption[]{PubSub.ListOption.pageSize((int)42)}).values());
    }

    @Test
    public void testListSubscriptionsAsync() throws ExecutionException, InterruptedException {
        this.initializeExpectedTopic(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        ImmutableList subscriptions = ImmutableList.of((Object)new SubscriptionId("project", "subscription1"), (Object)new SubscriptionId("project", "subscription2"));
        AsyncPageImpl result = new AsyncPageImpl(null, null, (Iterable)subscriptions);
        EasyMock.expect((Object)this.pubsub.listSubscriptionsAsync(NAME, new PubSub.ListOption[0])).andReturn((Object)Futures.immediateFuture((Object)result));
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeTopic();
        Assert.assertEquals((Object)subscriptions, (Object)((AsyncPage)this.topic.listSubscriptionsAsync(new PubSub.ListOption[0]).get()).values());
    }

    @Test
    public void testListSubscriptionsAsyncWithOptions() throws ExecutionException, InterruptedException {
        this.initializeExpectedTopic(1);
        EasyMock.expect((Object)this.pubsub.options()).andReturn((Object)this.mockOptions);
        ImmutableList subscriptions = ImmutableList.of((Object)new SubscriptionId("project", "subscription1"), (Object)new SubscriptionId("project", "subscription2"));
        AsyncPageImpl result = new AsyncPageImpl(null, null, (Iterable)subscriptions);
        EasyMock.expect((Object)this.pubsub.listSubscriptionsAsync(NAME, new PubSub.ListOption[]{PubSub.ListOption.pageSize((int)42)})).andReturn((Object)Futures.immediateFuture((Object)result));
        EasyMock.replay((Object[])new Object[]{this.pubsub});
        this.initializeTopic();
        Assert.assertEquals((Object)subscriptions, (Object)((AsyncPage)this.topic.listSubscriptionsAsync(new PubSub.ListOption[]{PubSub.ListOption.pageSize((int)42)}).get()).values());
    }

    private void compareTopic(Topic expected, Topic value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.name(), (Object)value.name());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

