/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.spi.v1;

import com.google.api.gax.grpc.BundlingSettings;
import com.google.cloud.pubsub.spi.v1.PublisherApi;
import com.google.cloud.pubsub.spi.v1.PublisherSettings;
import com.google.cloud.pubsub.spi.v1.SubscriberApi;
import com.google.cloud.pubsub.spi.v1.SubscriberSettings;
import com.google.cloud.pubsub.testing.LocalPubsubHelper;
import com.google.protobuf.ByteString;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.PullResponse;
import com.google.pubsub.v1.PushConfig;
import com.google.pubsub.v1.Topic;
import io.grpc.ManagedChannel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.joda.time.Duration;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class PublisherApiTest {
    private static LocalPubsubHelper pubsubHelper;
    private PublisherApi publisherApi;
    private PublisherApi bundledPublisherApi;
    private SubscriberApi subscriberApi;

    @BeforeClass
    public static void startServer() throws IOException, InterruptedException {
        pubsubHelper = LocalPubsubHelper.create();
        pubsubHelper.start();
    }

    @AfterClass
    public static void stopServer() throws IOException, InterruptedException {
        pubsubHelper.stop();
    }

    @Before
    public void setUp() throws Exception {
        ManagedChannel channel = pubsubHelper.createChannel();
        PublisherSettings publisherSettings = PublisherSettings.defaultBuilder().provideChannelWith(channel, true).build();
        this.publisherApi = PublisherApi.create((PublisherSettings)publisherSettings);
        BundlingSettings.Builder bundlingSettings = BundlingSettings.newBuilder().setElementCountThreshold(Integer.valueOf(10)).setDelayThreshold(Duration.standardSeconds((long)30L));
        PublisherSettings.Builder bundledPublisherSettingsBuilder = PublisherSettings.defaultBuilder();
        bundledPublisherSettingsBuilder.provideChannelWith(channel, true).publishSettings().setBundlingSettingsBuilder(bundlingSettings);
        PublisherSettings bundledPublisherSettings = bundledPublisherSettingsBuilder.build();
        this.bundledPublisherApi = PublisherApi.create((PublisherSettings)bundledPublisherSettings);
        SubscriberSettings subscriberSettings = SubscriberSettings.defaultBuilder().provideChannelWith(channel, true).build();
        this.subscriberApi = SubscriberApi.create((SubscriberSettings)subscriberSettings);
    }

    @After
    public void tearDown() throws Exception {
        if (this.publisherApi != null) {
            this.publisherApi.close();
        }
        if (this.subscriberApi != null) {
            this.subscriberApi.close();
        }
        if (this.bundledPublisherApi != null) {
            this.bundledPublisherApi.close();
        }
        pubsubHelper.reset();
    }

    @Test
    public void testCreateTopic() throws Exception {
        String topicName = PublisherApi.formatTopicName((String)"my-project", (String)"my-topic");
        Topic result = this.publisherApi.createTopic(topicName);
        Assert.assertEquals((Object)topicName, (Object)result.getName());
    }

    @Test
    public void testPublish() throws Exception {
        String topicName = PublisherApi.formatTopicName((String)"my-project", (String)"publish-topic");
        this.publisherApi.createTopic(topicName);
        String subscriberName = SubscriberApi.formatSubscriptionName((String)"my-project", (String)"my-subscribe");
        PushConfig config = PushConfig.getDefaultInstance();
        this.subscriberApi.createSubscription(subscriberName, topicName, config, 5);
        PubsubMessage msg = PubsubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)"pubsub-message")).build();
        this.publisherApi.publish(topicName, Collections.singletonList(msg));
        PullResponse response = this.subscriberApi.pull(subscriberName, true, 100);
        Assert.assertEquals((long)1L, (long)response.getReceivedMessagesCount());
        Assert.assertEquals((Object)"pubsub-message", (Object)response.getReceivedMessages(0).getMessage().getData().toStringUtf8());
    }

    @Test
    public void testBundledPublish() throws Exception {
        String topicName = PublisherApi.formatTopicName((String)"my-project", (String)"publish-topic");
        this.bundledPublisherApi.createTopic(topicName);
        String subscriberName = SubscriberApi.formatSubscriptionName((String)"my-project", (String)"my-subscribe");
        PushConfig config = PushConfig.getDefaultInstance();
        this.subscriberApi.createSubscription(subscriberName, topicName, config, 5);
        PubsubMessage msg = PubsubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)"pubsub-message")).build();
        this.bundledPublisherApi.publish(topicName, Collections.singletonList(msg));
        PullResponse response = this.subscriberApi.pull(subscriberName, true, 100);
        Assert.assertEquals((long)1L, (long)response.getReceivedMessagesCount());
        Assert.assertEquals((Object)"pubsub-message", (Object)response.getReceivedMessages(0).getMessage().getData().toStringUtf8());
    }

    @Test
    public void testGetTopic() throws Exception {
        String topicName = PublisherApi.formatTopicName((String)"my-project", (String)"fun-topic");
        this.publisherApi.createTopic(topicName);
        Topic result = this.publisherApi.getTopic(topicName);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)topicName, (Object)result.getName());
    }

    @Test
    public void testListTopics() throws Exception {
        String project1 = PublisherApi.formatProjectName((String)"project.1");
        String topicName1 = PublisherApi.formatTopicName((String)"project.1", (String)"topic.1");
        String topicName2 = PublisherApi.formatTopicName((String)"project.1", (String)"topic.2");
        String topicName3 = PublisherApi.formatTopicName((String)"project.2", (String)"topic.3");
        this.publisherApi.createTopic(topicName1);
        this.publisherApi.createTopic(topicName2);
        this.publisherApi.createTopic(topicName3);
        ArrayList<Topic> topics = new ArrayList<Topic>();
        for (Topic topic : this.publisherApi.listTopics(project1)) {
            topics.add(topic);
        }
        Assert.assertEquals((long)2L, (long)topics.size());
        Assert.assertEquals((Object)topicName1, (Object)((Topic)topics.get(0)).getName());
        Assert.assertEquals((Object)topicName2, (Object)((Topic)topics.get(1)).getName());
    }

    @Test
    public void testDeleteTopic() throws Exception {
        String project = PublisherApi.formatProjectName((String)"project.1");
        String topicName = PublisherApi.formatTopicName((String)"my-project", (String)"fun-topic");
        this.publisherApi.createTopic(topicName);
        this.publisherApi.deleteTopic(topicName);
        ArrayList<Topic> topics = new ArrayList<Topic>();
        for (Topic topic : this.publisherApi.listTopics(project)) {
            topics.add(topic);
        }
        Assert.assertEquals((long)0L, (long)topics.size());
    }
}

