/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager;

import com.google.cloud.resourcemanager.Option;
import com.google.cloud.resourcemanager.spi.ResourceManagerRpc;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class OptionTest {
    private static final ResourceManagerRpc.Option RPC_OPTION = ResourceManagerRpc.Option.FILTER;
    private static final ResourceManagerRpc.Option ANOTHER_RPC_OPTION = ResourceManagerRpc.Option.FIELDS;
    private static final String VALUE = "some value";
    private static final String OTHER_VALUE = "another value";
    private static final Option OPTION = new Option(RPC_OPTION, "some value"){};
    private static final Option OPTION_EQUALS = new Option(RPC_OPTION, "some value"){};
    private static final Option OPTION_NOT_EQUALS1 = new Option(RPC_OPTION, "another value"){};
    private static final Option OPTION_NOT_EQUALS2 = new Option(ANOTHER_RPC_OPTION, "some value"){};
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testEquals() {
        Assert.assertEquals((Object)OPTION, (Object)OPTION_EQUALS);
        Assert.assertNotEquals((Object)OPTION, (Object)OPTION_NOT_EQUALS1);
        Assert.assertNotEquals((Object)OPTION, (Object)OPTION_NOT_EQUALS2);
    }

    @Test
    public void testHashCode() {
        Assert.assertEquals((long)OPTION.hashCode(), (long)OPTION_EQUALS.hashCode());
    }

    @Test
    public void testConstructor() {
        Assert.assertEquals((Object)RPC_OPTION, (Object)OPTION.rpcOption());
        Assert.assertEquals((Object)VALUE, (Object)OPTION.value());
        Option option = new Option(RPC_OPTION, null){};
        Assert.assertEquals((Object)RPC_OPTION, (Object)option.rpcOption());
        Assert.assertNull((Object)option.value());
        this.thrown.expect(NullPointerException.class);
        new Option(null, VALUE){};
    }
}

