/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager;

import com.google.cloud.Identity;
import com.google.cloud.resourcemanager.Policy;
import org.junit.Assert;
import org.junit.Test;

public class PolicyTest {
    private static final Identity ALL_USERS = Identity.allUsers();
    private static final Identity ALL_AUTH_USERS = Identity.allAuthenticatedUsers();
    private static final Identity USER = Identity.user((String)"abc@gmail.com");
    private static final Identity SERVICE_ACCOUNT = Identity.serviceAccount((String)"service-account@gmail.com");
    private static final Identity GROUP = Identity.group((String)"group@gmail.com");
    private static final Identity DOMAIN = Identity.domain((String)"google.com");
    private static final Policy SIMPLE_POLICY = ((Policy.Builder)((Policy.Builder)((Policy.Builder)((Policy.Builder)Policy.builder().addIdentity((Object)Policy.ProjectRole.OWNER.value(), USER, new Identity[0])).addIdentity((Object)Policy.ProjectRole.VIEWER.value(), ALL_USERS, new Identity[0])).addIdentity((Object)Policy.ProjectRole.EDITOR.value(), ALL_AUTH_USERS, new Identity[]{DOMAIN})).addIdentity((Object)"roles/some-role", SERVICE_ACCOUNT, new Identity[]{GROUP})).build();
    private static final Policy FULL_POLICY = new Policy.Builder(SIMPLE_POLICY.bindings(), "etag", Integer.valueOf(1)).build();

    @Test
    public void testIamPolicyToBuilder() {
        Assert.assertEquals((Object)FULL_POLICY, (Object)FULL_POLICY.toBuilder().build());
        Assert.assertEquals((Object)SIMPLE_POLICY, (Object)SIMPLE_POLICY.toBuilder().build());
    }

    @Test
    public void testPolicyToAndFromPb() {
        Assert.assertEquals((Object)FULL_POLICY, (Object)Policy.fromPb((com.google.api.services.cloudresourcemanager.model.Policy)FULL_POLICY.toPb()));
        Assert.assertEquals((Object)SIMPLE_POLICY, (Object)Policy.fromPb((com.google.api.services.cloudresourcemanager.model.Policy)SIMPLE_POLICY.toPb()));
    }

    @Test
    public void testEquals() {
        Policy copy = ((Policy.Builder)((Policy.Builder)((Policy.Builder)((Policy.Builder)Policy.builder().addIdentity((Object)Policy.ProjectRole.OWNER.value(), USER, new Identity[0])).addIdentity((Object)Policy.ProjectRole.VIEWER.value(), ALL_USERS, new Identity[0])).addIdentity((Object)Policy.ProjectRole.EDITOR.value(), ALL_AUTH_USERS, new Identity[]{DOMAIN})).addIdentity((Object)"roles/some-role", SERVICE_ACCOUNT, new Identity[]{GROUP})).build();
        Assert.assertEquals((Object)SIMPLE_POLICY, (Object)copy);
        Assert.assertNotEquals((Object)SIMPLE_POLICY, (Object)FULL_POLICY);
    }
}

