/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager;

import com.google.api.services.cloudresourcemanager.model.Project;
import com.google.cloud.resourcemanager.ProjectInfo;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class ProjectInfoTest {
    private static final String PROJECT_ID = "project-id";
    private static final String NAME = "myProj";
    private static final Map<String, String> LABELS = ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2");
    private static final Long PROJECT_NUMBER = 123L;
    private static final Long CREATE_TIME_MILLIS = 123456789L;
    private static final ProjectInfo.State STATE = ProjectInfo.State.DELETE_REQUESTED;
    private static final ProjectInfo.ResourceId PARENT = new ProjectInfo.ResourceId("id", "organization");
    private static final ProjectInfo FULL_PROJECT_INFO = ProjectInfo.builder((String)"project-id").name("myProj").labels(LABELS).projectNumber(PROJECT_NUMBER).createTimeMillis(CREATE_TIME_MILLIS).state(STATE).parent(PARENT).build();
    private static final ProjectInfo PARTIAL_PROJECT_INFO = ProjectInfo.builder((String)"project-id").build();
    private static final ProjectInfo UNNAMED_PROJECT_FROM_LIST = PARTIAL_PROJECT_INFO.toBuilder().name("Unnamed").build();

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)PROJECT_ID, (Object)FULL_PROJECT_INFO.projectId());
        Assert.assertEquals((Object)NAME, (Object)FULL_PROJECT_INFO.name());
        Assert.assertEquals(LABELS, (Object)FULL_PROJECT_INFO.labels());
        Assert.assertEquals((Object)PROJECT_NUMBER, (Object)FULL_PROJECT_INFO.projectNumber());
        Assert.assertEquals((Object)CREATE_TIME_MILLIS, (Object)FULL_PROJECT_INFO.createTimeMillis());
        Assert.assertEquals((Object)STATE, (Object)FULL_PROJECT_INFO.state());
        Assert.assertEquals((Object)PROJECT_ID, (Object)PARTIAL_PROJECT_INFO.projectId());
        Assert.assertEquals(null, (Object)PARTIAL_PROJECT_INFO.name());
        Assert.assertTrue((boolean)PARTIAL_PROJECT_INFO.labels().isEmpty());
        Assert.assertEquals(null, (Object)PARTIAL_PROJECT_INFO.projectNumber());
        Assert.assertEquals(null, (Object)PARTIAL_PROJECT_INFO.createTimeMillis());
        Assert.assertEquals(null, (Object)PARTIAL_PROJECT_INFO.state());
    }

    @Test
    public void testToBuilder() {
        this.compareProjects(FULL_PROJECT_INFO, FULL_PROJECT_INFO.toBuilder().build());
        this.compareProjects(PARTIAL_PROJECT_INFO, PARTIAL_PROJECT_INFO.toBuilder().build());
    }

    @Test
    public void testToAndFromPb() {
        Assert.assertTrue((boolean)FULL_PROJECT_INFO.toPb().getCreateTime().endsWith("Z"));
        this.compareProjects(FULL_PROJECT_INFO, ProjectInfo.fromPb((Project)FULL_PROJECT_INFO.toPb()));
        this.compareProjects(PARTIAL_PROJECT_INFO, ProjectInfo.fromPb((Project)PARTIAL_PROJECT_INFO.toPb()));
        this.compareProjects(PARTIAL_PROJECT_INFO, ProjectInfo.fromPb((Project)UNNAMED_PROJECT_FROM_LIST.toPb()));
    }

    @Test
    public void testEquals() {
        this.compareProjects(FULL_PROJECT_INFO, ProjectInfo.builder((String)PROJECT_ID).name(NAME).labels(LABELS).projectNumber(PROJECT_NUMBER).createTimeMillis(CREATE_TIME_MILLIS).state(STATE).parent(PARENT).build());
        this.compareProjects(PARTIAL_PROJECT_INFO, ProjectInfo.builder((String)PROJECT_ID).build());
        Assert.assertNotEquals((Object)FULL_PROJECT_INFO, (Object)PARTIAL_PROJECT_INFO);
    }

    private void compareProjects(ProjectInfo expected, ProjectInfo value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.projectId(), (Object)value.projectId());
        Assert.assertEquals((Object)expected.name(), (Object)value.name());
        Assert.assertEquals((Object)expected.labels(), (Object)value.labels());
        Assert.assertEquals((Object)expected.projectNumber(), (Object)value.projectNumber());
        Assert.assertEquals((Object)expected.createTimeMillis(), (Object)value.createTimeMillis());
        Assert.assertEquals((Object)expected.state(), (Object)value.state());
        Assert.assertEquals((Object)expected.parent(), (Object)value.parent());
    }
}

