/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager;

import com.google.cloud.Identity;
import com.google.cloud.resourcemanager.Policy;
import com.google.cloud.resourcemanager.Project;
import com.google.cloud.resourcemanager.ProjectInfo;
import com.google.cloud.resourcemanager.ResourceManager;
import com.google.cloud.resourcemanager.ResourceManagerOptions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProjectTest {
    private static final String PROJECT_ID = "project-id";
    private static final String NAME = "myProj";
    private static final Map<String, String> LABELS = ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2");
    private static final Long PROJECT_NUMBER = 123L;
    private static final Long CREATE_TIME_MILLIS = 123456789L;
    private static final ProjectInfo.State STATE = ProjectInfo.State.DELETE_REQUESTED;
    private static final ProjectInfo PROJECT_INFO = ProjectInfo.builder((String)"project-id").name("myProj").labels(LABELS).projectNumber(PROJECT_NUMBER).createTimeMillis(CREATE_TIME_MILLIS).state(STATE).build();
    private static final Identity USER = Identity.user((String)"abc@gmail.com");
    private static final Identity SERVICE_ACCOUNT = Identity.serviceAccount((String)"service-account@gmail.com");
    private static final Policy POLICY = ((Policy.Builder)((Policy.Builder)Policy.builder().addIdentity((Object)Policy.ProjectRole.OWNER.value(), USER, new Identity[0])).addIdentity((Object)Policy.ProjectRole.EDITOR.value(), SERVICE_ACCOUNT, new Identity[0])).build();
    private ResourceManager serviceMockReturnsOptions = (ResourceManager)EasyMock.createStrictMock(ResourceManager.class);
    private ResourceManagerOptions mockOptions = (ResourceManagerOptions)EasyMock.createMock(ResourceManagerOptions.class);
    private ResourceManager resourceManager;
    private Project expectedProject;
    private Project project;

    @Before
    public void setUp() {
        this.resourceManager = (ResourceManager)EasyMock.createStrictMock(ResourceManager.class);
    }

    @After
    public void tearDown() throws Exception {
        EasyMock.verify((Object[])new Object[]{this.resourceManager});
    }

    private void initializeExpectedProject(int optionsCalls) {
        EasyMock.expect((Object)this.serviceMockReturnsOptions.options()).andReturn((Object)this.mockOptions).times(optionsCalls);
        EasyMock.replay((Object[])new Object[]{this.serviceMockReturnsOptions});
        this.expectedProject = new Project(this.serviceMockReturnsOptions, new ProjectInfo.BuilderImpl(PROJECT_INFO));
    }

    private void initializeProject() {
        this.project = new Project(this.resourceManager, new ProjectInfo.BuilderImpl(PROJECT_INFO));
    }

    @Test
    public void testToBuilder() {
        this.initializeExpectedProject(4);
        EasyMock.replay((Object[])new Object[]{this.resourceManager});
        this.compareProjects(this.expectedProject, this.expectedProject.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        EasyMock.expect((Object)this.resourceManager.options()).andReturn((Object)this.mockOptions).times(7);
        EasyMock.replay((Object[])new Object[]{this.resourceManager});
        Project.Builder builder = new Project.Builder(new Project(this.resourceManager, new ProjectInfo.BuilderImpl("wrong-id")));
        Project project = builder.projectId(PROJECT_ID).name(NAME).labels(LABELS).projectNumber(PROJECT_NUMBER).createTimeMillis(CREATE_TIME_MILLIS).state(STATE).build();
        Assert.assertEquals((Object)PROJECT_ID, (Object)project.projectId());
        Assert.assertEquals((Object)NAME, (Object)project.name());
        Assert.assertEquals(LABELS, (Object)project.labels());
        Assert.assertEquals((Object)PROJECT_NUMBER, (Object)project.projectNumber());
        Assert.assertEquals((Object)CREATE_TIME_MILLIS, (Object)project.createTimeMillis());
        Assert.assertEquals((Object)STATE, (Object)project.state());
        Assert.assertEquals((Object)this.resourceManager.options(), (Object)project.resourceManager().options());
        Assert.assertNull((Object)project.parent());
        ProjectInfo.ResourceId parent = new ProjectInfo.ResourceId("id", "type");
        project = project.toBuilder().clearLabels().addLabel("k3", "v3").addLabel("k4", "v4").removeLabel("k4").parent(parent).build();
        Assert.assertEquals((Object)PROJECT_ID, (Object)project.projectId());
        Assert.assertEquals((Object)NAME, (Object)project.name());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"k3", (Object)"v3"), (Object)project.labels());
        Assert.assertEquals((Object)PROJECT_NUMBER, (Object)project.projectNumber());
        Assert.assertEquals((Object)CREATE_TIME_MILLIS, (Object)project.createTimeMillis());
        Assert.assertEquals((Object)STATE, (Object)project.state());
        Assert.assertEquals((Object)this.resourceManager.options(), (Object)project.resourceManager().options());
        Assert.assertEquals((Object)parent, (Object)project.parent());
    }

    @Test
    public void testGet() {
        this.initializeExpectedProject(1);
        EasyMock.expect((Object)this.resourceManager.get(PROJECT_INFO.projectId(), new ResourceManager.ProjectGetOption[0])).andReturn((Object)this.expectedProject);
        EasyMock.replay((Object[])new Object[]{this.resourceManager});
        Project loadedProject = this.resourceManager.get(PROJECT_INFO.projectId(), new ResourceManager.ProjectGetOption[0]);
        Assert.assertEquals((Object)this.expectedProject, (Object)loadedProject);
    }

    @Test
    public void testReload() {
        this.initializeExpectedProject(2);
        ProjectInfo newInfo = PROJECT_INFO.toBuilder().addLabel("k3", "v3").build();
        Project expectedProject = new Project(this.serviceMockReturnsOptions, new ProjectInfo.BuilderImpl(newInfo));
        EasyMock.expect((Object)this.resourceManager.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.resourceManager.get(PROJECT_INFO.projectId(), new ResourceManager.ProjectGetOption[0])).andReturn((Object)expectedProject);
        EasyMock.replay((Object[])new Object[]{this.resourceManager});
        this.initializeProject();
        Project newProject = this.project.reload();
        Assert.assertEquals((Object)expectedProject, (Object)newProject);
    }

    @Test
    public void testLoadNull() {
        this.initializeExpectedProject(1);
        EasyMock.expect((Object)this.resourceManager.get(PROJECT_INFO.projectId(), new ResourceManager.ProjectGetOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.resourceManager});
        Assert.assertNull((Object)this.resourceManager.get(PROJECT_INFO.projectId(), new ResourceManager.ProjectGetOption[0]));
    }

    @Test
    public void testReloadNull() {
        this.initializeExpectedProject(1);
        EasyMock.expect((Object)this.resourceManager.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.resourceManager.get(PROJECT_INFO.projectId(), new ResourceManager.ProjectGetOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.resourceManager});
        Project reloadedProject = new Project(this.resourceManager, new ProjectInfo.BuilderImpl(PROJECT_INFO)).reload();
        Assert.assertNull((Object)reloadedProject);
    }

    @Test
    public void testResourceManager() {
        this.initializeExpectedProject(1);
        EasyMock.replay((Object[])new Object[]{this.resourceManager});
        Assert.assertEquals((Object)this.serviceMockReturnsOptions, (Object)this.expectedProject.resourceManager());
    }

    @Test
    public void testDelete() {
        this.initializeExpectedProject(1);
        EasyMock.expect((Object)this.resourceManager.options()).andReturn((Object)this.mockOptions);
        this.resourceManager.delete(PROJECT_INFO.projectId());
        EasyMock.replay((Object[])new Object[]{this.resourceManager});
        this.initializeProject();
        this.project.delete();
    }

    @Test
    public void testUndelete() {
        this.initializeExpectedProject(1);
        EasyMock.expect((Object)this.resourceManager.options()).andReturn((Object)this.mockOptions);
        this.resourceManager.undelete(PROJECT_INFO.projectId());
        EasyMock.replay((Object[])new Object[]{this.resourceManager});
        this.initializeProject();
        this.project.undelete();
    }

    @Test
    public void testReplace() {
        this.initializeExpectedProject(2);
        Project expectedReplacedProject = this.expectedProject.toBuilder().addLabel("k3", "v3").build();
        EasyMock.expect((Object)this.resourceManager.options()).andReturn((Object)this.mockOptions).times(2);
        EasyMock.expect((Object)this.resourceManager.replace((ProjectInfo)EasyMock.anyObject(Project.class))).andReturn((Object)expectedReplacedProject);
        EasyMock.replay((Object[])new Object[]{this.resourceManager});
        this.initializeProject();
        Project newProject = new Project(this.resourceManager, new ProjectInfo.BuilderImpl((ProjectInfo)expectedReplacedProject));
        Project actualReplacedProject = newProject.replace();
        this.compareProjectInfos((ProjectInfo)expectedReplacedProject, (ProjectInfo)actualReplacedProject);
    }

    @Test
    public void testGetPolicy() {
        EasyMock.expect((Object)this.resourceManager.options()).andReturn((Object)this.mockOptions).times(1);
        EasyMock.expect((Object)this.resourceManager.getPolicy(PROJECT_ID)).andReturn((Object)POLICY);
        EasyMock.replay((Object[])new Object[]{this.resourceManager});
        this.initializeProject();
        Assert.assertEquals((Object)POLICY, (Object)this.project.getPolicy());
    }

    @Test
    public void testReplacePolicy() {
        EasyMock.expect((Object)this.resourceManager.options()).andReturn((Object)this.mockOptions).times(1);
        EasyMock.expect((Object)this.resourceManager.replacePolicy(PROJECT_ID, POLICY)).andReturn((Object)POLICY);
        EasyMock.replay((Object[])new Object[]{this.resourceManager});
        this.initializeProject();
        Assert.assertEquals((Object)POLICY, (Object)this.project.replacePolicy(POLICY));
    }

    @Test
    public void testTestPermissions() {
        ImmutableList response = ImmutableList.of((Object)true, (Object)true);
        String getPermission = "resourcemanager.projects.get";
        String deletePermission = "resourcemanager.projects.delete";
        EasyMock.expect((Object)this.resourceManager.options()).andReturn((Object)this.mockOptions).times(1);
        EasyMock.expect((Object)this.resourceManager.testPermissions(PROJECT_ID, (List)ImmutableList.of((Object)getPermission, (Object)deletePermission))).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.resourceManager});
        this.initializeProject();
        Assert.assertEquals((Object)response, (Object)this.project.testPermissions((List)ImmutableList.of((Object)getPermission, (Object)deletePermission)));
    }

    private void compareProjects(Project expected, Project value) {
        Assert.assertEquals((Object)expected, (Object)value);
        this.compareProjectInfos((ProjectInfo)expected, (ProjectInfo)value);
        Assert.assertEquals((Object)expected.resourceManager().options(), (Object)value.resourceManager().options());
    }

    private void compareProjectInfos(ProjectInfo expected, ProjectInfo value) {
        Assert.assertEquals((Object)expected.projectId(), (Object)value.projectId());
        Assert.assertEquals((Object)expected.name(), (Object)value.name());
        Assert.assertEquals((Object)expected.labels(), (Object)value.labels());
        Assert.assertEquals((Object)expected.projectNumber(), (Object)value.projectNumber());
        Assert.assertEquals((Object)expected.createTimeMillis(), (Object)value.createTimeMillis());
        Assert.assertEquals((Object)expected.state(), (Object)value.state());
        Assert.assertEquals((Object)expected.parent(), (Object)value.parent());
    }
}

