/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager;

import com.google.cloud.Identity;
import com.google.cloud.Page;
import com.google.cloud.ServiceOptions;
import com.google.cloud.resourcemanager.Policy;
import com.google.cloud.resourcemanager.Project;
import com.google.cloud.resourcemanager.ProjectInfo;
import com.google.cloud.resourcemanager.ResourceManager;
import com.google.cloud.resourcemanager.ResourceManagerException;
import com.google.cloud.resourcemanager.ResourceManagerOptions;
import com.google.cloud.resourcemanager.spi.ResourceManagerRpc;
import com.google.cloud.resourcemanager.spi.ResourceManagerRpcFactory;
import com.google.cloud.resourcemanager.testing.LocalResourceManagerHelper;
import com.google.cloud.spi.ServiceRpcFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.easymock.EasyMock;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ResourceManagerImplTest {
    private static final LocalResourceManagerHelper RESOURCE_MANAGER_HELPER = LocalResourceManagerHelper.create();
    private static final ResourceManager RESOURCE_MANAGER = (ResourceManager)RESOURCE_MANAGER_HELPER.options().service();
    private static final ResourceManager.ProjectGetOption GET_FIELDS = ResourceManager.ProjectGetOption.fields((ResourceManager.ProjectField[])new ResourceManager.ProjectField[]{ResourceManager.ProjectField.NAME, ResourceManager.ProjectField.CREATE_TIME});
    private static final ResourceManager.ProjectListOption LIST_FIELDS = ResourceManager.ProjectListOption.fields((ResourceManager.ProjectField[])new ResourceManager.ProjectField[]{ResourceManager.ProjectField.NAME, ResourceManager.ProjectField.LABELS});
    private static final ResourceManager.ProjectListOption LIST_FILTER = ResourceManager.ProjectListOption.filter((String)"id:* name:myProject labels.color:blue LABELS.SIZE:*");
    private static final ProjectInfo PARTIAL_PROJECT = ProjectInfo.builder((String)"partial-project").build();
    private static final ProjectInfo.ResourceId PARENT = new ProjectInfo.ResourceId("id", "type");
    private static final ProjectInfo COMPLETE_PROJECT = ProjectInfo.builder((String)"complete-project").name("name").labels((Map)ImmutableMap.of((Object)"k1", (Object)"v1")).parent(PARENT).build();
    private static final Map<ResourceManagerRpc.Option, ?> EMPTY_RPC_OPTIONS = ImmutableMap.of();
    private static final Policy POLICY = ((Policy.Builder)((Policy.Builder)Policy.builder().addIdentity((Object)Policy.ProjectRole.OWNER.value(), Identity.user((String)"me@gmail.com"), new Identity[0])).addIdentity((Object)Policy.ProjectRole.EDITOR.value(), Identity.serviceAccount((String)"serviceaccount@gmail.com"), new Identity[0])).build();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @BeforeClass
    public static void beforeClass() {
        RESOURCE_MANAGER_HELPER.start();
    }

    @Before
    public void setUp() {
        this.clearProjects();
    }

    private void clearProjects() {
        for (Project project : RESOURCE_MANAGER.list(new ResourceManager.ProjectListOption[0]).values()) {
            RESOURCE_MANAGER_HELPER.removeProject(project.projectId());
        }
    }

    @AfterClass
    public static void afterClass() {
        RESOURCE_MANAGER_HELPER.stop();
    }

    private void compareReadWriteFields(ProjectInfo expected, ProjectInfo actual) {
        Assert.assertEquals((Object)expected.projectId(), (Object)actual.projectId());
        Assert.assertEquals((Object)expected.name(), (Object)actual.name());
        Assert.assertEquals((Object)expected.labels(), (Object)actual.labels());
        Assert.assertEquals((Object)expected.parent(), (Object)actual.parent());
    }

    @Test
    public void testCreate() {
        Project returnedProject = RESOURCE_MANAGER.create(PARTIAL_PROJECT);
        this.compareReadWriteFields(PARTIAL_PROJECT, (ProjectInfo)returnedProject);
        Assert.assertEquals((Object)ProjectInfo.State.ACTIVE, (Object)returnedProject.state());
        Assert.assertNull((Object)returnedProject.name());
        Assert.assertNull((Object)returnedProject.parent());
        Assert.assertNotNull((Object)returnedProject.projectNumber());
        Assert.assertNotNull((Object)returnedProject.createTimeMillis());
        Assert.assertSame((Object)RESOURCE_MANAGER, (Object)returnedProject.resourceManager());
        try {
            RESOURCE_MANAGER.create(PARTIAL_PROJECT);
            Assert.fail((String)"Should fail, project already exists.");
        }
        catch (ResourceManagerException e) {
            Assert.assertEquals((long)409L, (long)e.code());
            Assert.assertTrue((e.getMessage().startsWith("A project with the same project ID") && e.getMessage().endsWith("already exists.") ? 1 : 0) != 0);
        }
        returnedProject = RESOURCE_MANAGER.create(COMPLETE_PROJECT);
        this.compareReadWriteFields(COMPLETE_PROJECT, (ProjectInfo)returnedProject);
        Assert.assertEquals((Object)ProjectInfo.State.ACTIVE, (Object)returnedProject.state());
        Assert.assertNotNull((Object)returnedProject.projectNumber());
        Assert.assertNotNull((Object)returnedProject.createTimeMillis());
        Assert.assertSame((Object)RESOURCE_MANAGER, (Object)returnedProject.resourceManager());
    }

    @Test
    public void testDelete() {
        RESOURCE_MANAGER.create(COMPLETE_PROJECT);
        RESOURCE_MANAGER.delete(COMPLETE_PROJECT.projectId());
        Assert.assertEquals((Object)ProjectInfo.State.DELETE_REQUESTED, (Object)RESOURCE_MANAGER.get(COMPLETE_PROJECT.projectId(), new ResourceManager.ProjectGetOption[0]).state());
        try {
            RESOURCE_MANAGER.delete("some-nonexistant-project-id");
            Assert.fail((String)"Should fail because the project doesn't exist.");
        }
        catch (ResourceManagerException e) {
            Assert.assertEquals((long)403L, (long)e.code());
            Assert.assertTrue((boolean)e.getMessage().contains("not found."));
        }
    }

    @Test
    public void testGet() {
        RESOURCE_MANAGER.create(COMPLETE_PROJECT);
        Project returnedProject = RESOURCE_MANAGER.get(COMPLETE_PROJECT.projectId(), new ResourceManager.ProjectGetOption[0]);
        this.compareReadWriteFields(COMPLETE_PROJECT, (ProjectInfo)returnedProject);
        Assert.assertEquals((Object)RESOURCE_MANAGER, (Object)returnedProject.resourceManager());
        RESOURCE_MANAGER_HELPER.removeProject(COMPLETE_PROJECT.projectId());
        Assert.assertNull((Object)RESOURCE_MANAGER.get(COMPLETE_PROJECT.projectId(), new ResourceManager.ProjectGetOption[0]));
    }

    @Test
    public void testGetWithOptions() {
        Project originalProject = RESOURCE_MANAGER.create(COMPLETE_PROJECT);
        Project returnedProject = RESOURCE_MANAGER.get(COMPLETE_PROJECT.projectId(), new ResourceManager.ProjectGetOption[]{GET_FIELDS});
        Assert.assertFalse((boolean)COMPLETE_PROJECT.equals((Object)returnedProject));
        Assert.assertEquals((Object)COMPLETE_PROJECT.projectId(), (Object)returnedProject.projectId());
        Assert.assertEquals((Object)COMPLETE_PROJECT.name(), (Object)returnedProject.name());
        Assert.assertEquals((Object)originalProject.createTimeMillis(), (Object)returnedProject.createTimeMillis());
        Assert.assertNull((Object)returnedProject.parent());
        Assert.assertNull((Object)returnedProject.projectNumber());
        Assert.assertNull((Object)returnedProject.state());
        Assert.assertTrue((boolean)returnedProject.labels().isEmpty());
        Assert.assertEquals((Object)RESOURCE_MANAGER, (Object)originalProject.resourceManager());
        Assert.assertEquals((Object)RESOURCE_MANAGER, (Object)returnedProject.resourceManager());
    }

    @Test
    public void testList() {
        Page projects = RESOURCE_MANAGER.list(new ResourceManager.ProjectListOption[0]);
        Assert.assertFalse((boolean)projects.values().iterator().hasNext());
        RESOURCE_MANAGER.create(PARTIAL_PROJECT);
        RESOURCE_MANAGER.create(COMPLETE_PROJECT);
        for (Project p : RESOURCE_MANAGER.list(new ResourceManager.ProjectListOption[0]).values()) {
            if (p.projectId().equals(PARTIAL_PROJECT.projectId())) {
                this.compareReadWriteFields(PARTIAL_PROJECT, (ProjectInfo)p);
            } else if (p.projectId().equals(COMPLETE_PROJECT.projectId())) {
                this.compareReadWriteFields(COMPLETE_PROJECT, (ProjectInfo)p);
            } else {
                Assert.fail((String)"Some unexpected project returned by list.");
            }
            Assert.assertSame((Object)RESOURCE_MANAGER, (Object)p.resourceManager());
        }
    }

    @Test
    public void testListPaging() {
        RESOURCE_MANAGER.create(PARTIAL_PROJECT);
        RESOURCE_MANAGER.create(COMPLETE_PROJECT);
        Page page = RESOURCE_MANAGER.list(new ResourceManager.ProjectListOption[]{ResourceManager.ProjectListOption.pageSize((int)1)});
        Assert.assertNotNull((Object)page.nextPageCursor());
        Iterator iterator = page.values().iterator();
        this.compareReadWriteFields(COMPLETE_PROJECT, (ProjectInfo)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        page = page.nextPage();
        iterator = page.values().iterator();
        this.compareReadWriteFields(PARTIAL_PROJECT, (ProjectInfo)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertNull((Object)page.nextPageCursor());
    }

    @Test
    public void testListFieldOptions() {
        RESOURCE_MANAGER.create(COMPLETE_PROJECT);
        Page projects = RESOURCE_MANAGER.list(new ResourceManager.ProjectListOption[]{LIST_FIELDS});
        Project returnedProject = (Project)projects.iterateAll().next();
        Assert.assertEquals((Object)COMPLETE_PROJECT.projectId(), (Object)returnedProject.projectId());
        Assert.assertEquals((Object)COMPLETE_PROJECT.name(), (Object)returnedProject.name());
        Assert.assertEquals((Object)COMPLETE_PROJECT.labels(), (Object)returnedProject.labels());
        Assert.assertNull((Object)returnedProject.parent());
        Assert.assertNull((Object)returnedProject.projectNumber());
        Assert.assertNull((Object)returnedProject.state());
        Assert.assertNull((Object)returnedProject.createTimeMillis());
        Assert.assertSame((Object)RESOURCE_MANAGER, (Object)returnedProject.resourceManager());
    }

    @Test
    public void testListPagingWithFieldOptions() {
        RESOURCE_MANAGER.create(PARTIAL_PROJECT);
        RESOURCE_MANAGER.create(COMPLETE_PROJECT);
        Page projects = RESOURCE_MANAGER.list(new ResourceManager.ProjectListOption[]{LIST_FIELDS, ResourceManager.ProjectListOption.pageSize((int)1)});
        Assert.assertNotNull((Object)projects.nextPageCursor());
        Iterator iterator = projects.values().iterator();
        Project returnedProject = (Project)iterator.next();
        Assert.assertEquals((Object)COMPLETE_PROJECT.projectId(), (Object)returnedProject.projectId());
        Assert.assertEquals((Object)COMPLETE_PROJECT.name(), (Object)returnedProject.name());
        Assert.assertEquals((Object)COMPLETE_PROJECT.labels(), (Object)returnedProject.labels());
        Assert.assertNull((Object)returnedProject.parent());
        Assert.assertNull((Object)returnedProject.projectNumber());
        Assert.assertNull((Object)returnedProject.state());
        Assert.assertNull((Object)returnedProject.createTimeMillis());
        Assert.assertSame((Object)RESOURCE_MANAGER, (Object)returnedProject.resourceManager());
        Assert.assertFalse((boolean)iterator.hasNext());
        projects = projects.nextPage();
        iterator = projects.values().iterator();
        returnedProject = (Project)iterator.next();
        Assert.assertEquals((Object)PARTIAL_PROJECT.projectId(), (Object)returnedProject.projectId());
        Assert.assertEquals((Object)PARTIAL_PROJECT.name(), (Object)returnedProject.name());
        Assert.assertEquals((Object)PARTIAL_PROJECT.labels(), (Object)returnedProject.labels());
        Assert.assertNull((Object)returnedProject.parent());
        Assert.assertNull((Object)returnedProject.projectNumber());
        Assert.assertNull((Object)returnedProject.state());
        Assert.assertNull((Object)returnedProject.createTimeMillis());
        Assert.assertSame((Object)RESOURCE_MANAGER, (Object)returnedProject.resourceManager());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertNull((Object)projects.nextPageCursor());
    }

    @Test
    public void testListFilterOptions() {
        ProjectInfo matchingProject = ProjectInfo.builder((String)"matching-project").name("MyProject").labels((Map)ImmutableMap.of((Object)"color", (Object)"blue", (Object)"size", (Object)"big")).build();
        ProjectInfo nonMatchingProject1 = ProjectInfo.builder((String)"non-matching-project1").name("myProject").labels((Map)ImmutableMap.of((Object)"color", (Object)"blue")).build();
        ProjectInfo nonMatchingProject2 = ProjectInfo.builder((String)"non-matching-project2").name("myProj").labels((Map)ImmutableMap.of((Object)"color", (Object)"blue", (Object)"size", (Object)"big")).build();
        ProjectInfo nonMatchingProject3 = ProjectInfo.builder((String)"non-matching-project3").build();
        RESOURCE_MANAGER.create(matchingProject);
        RESOURCE_MANAGER.create(nonMatchingProject1);
        RESOURCE_MANAGER.create(nonMatchingProject2);
        RESOURCE_MANAGER.create(nonMatchingProject3);
        for (Project p : RESOURCE_MANAGER.list(new ResourceManager.ProjectListOption[]{LIST_FILTER}).values()) {
            Assert.assertFalse((boolean)p.equals((Object)nonMatchingProject1));
            Assert.assertFalse((boolean)p.equals((Object)nonMatchingProject2));
            this.compareReadWriteFields(matchingProject, (ProjectInfo)p);
            Assert.assertSame((Object)RESOURCE_MANAGER, (Object)p.resourceManager());
        }
    }

    @Test
    public void testReplace() {
        Project createdProject = RESOURCE_MANAGER.create(COMPLETE_PROJECT);
        ImmutableMap newLabels = ImmutableMap.of((Object)"new k1", (Object)"new v1");
        ProjectInfo anotherCompleteProject = ProjectInfo.builder((String)COMPLETE_PROJECT.projectId()).labels((Map)newLabels).projectNumber(Long.valueOf(987654321L)).createTimeMillis(Long.valueOf(230682061315L)).state(ProjectInfo.State.DELETE_REQUESTED).parent(createdProject.parent()).build();
        Project returnedProject = RESOURCE_MANAGER.replace(anotherCompleteProject);
        this.compareReadWriteFields(anotherCompleteProject, (ProjectInfo)returnedProject);
        Assert.assertEquals((Object)createdProject.projectNumber(), (Object)returnedProject.projectNumber());
        Assert.assertEquals((Object)createdProject.createTimeMillis(), (Object)returnedProject.createTimeMillis());
        Assert.assertEquals((Object)createdProject.state(), (Object)returnedProject.state());
        Assert.assertEquals((Object)RESOURCE_MANAGER, (Object)returnedProject.resourceManager());
        ProjectInfo nonexistantProject = ProjectInfo.builder((String)"some-project-id-that-does-not-exist").build();
        try {
            RESOURCE_MANAGER.replace(nonexistantProject);
            Assert.fail((String)"Should fail because the project doesn't exist.");
        }
        catch (ResourceManagerException e) {
            Assert.assertEquals((long)403L, (long)e.code());
            Assert.assertTrue((boolean)e.getMessage().contains("the project was not found"));
        }
    }

    @Test
    public void testUndelete() {
        RESOURCE_MANAGER.create(COMPLETE_PROJECT);
        RESOURCE_MANAGER.delete(COMPLETE_PROJECT.projectId());
        Assert.assertEquals((Object)ProjectInfo.State.DELETE_REQUESTED, (Object)RESOURCE_MANAGER.get(COMPLETE_PROJECT.projectId(), new ResourceManager.ProjectGetOption[0]).state());
        RESOURCE_MANAGER.undelete(COMPLETE_PROJECT.projectId());
        Project revivedProject = RESOURCE_MANAGER.get(COMPLETE_PROJECT.projectId(), new ResourceManager.ProjectGetOption[0]);
        this.compareReadWriteFields(COMPLETE_PROJECT, (ProjectInfo)revivedProject);
        Assert.assertEquals((Object)ProjectInfo.State.ACTIVE, (Object)revivedProject.state());
        try {
            RESOURCE_MANAGER.undelete("invalid-project-id");
            Assert.fail((String)"Should fail because the project doesn't exist.");
        }
        catch (ResourceManagerException e) {
            Assert.assertEquals((long)403L, (long)e.code());
            Assert.assertTrue((boolean)e.getMessage().contains("the project was not found"));
        }
    }

    @Test
    public void testGetPolicy() {
        Assert.assertNull((Object)RESOURCE_MANAGER.getPolicy(COMPLETE_PROJECT.projectId()));
        RESOURCE_MANAGER.create(COMPLETE_PROJECT);
        RESOURCE_MANAGER.replacePolicy(COMPLETE_PROJECT.projectId(), POLICY);
        Policy retrieved = RESOURCE_MANAGER.getPolicy(COMPLETE_PROJECT.projectId());
        Assert.assertEquals((Object)POLICY.bindings(), (Object)retrieved.bindings());
        Assert.assertNotNull((Object)retrieved.etag());
        Assert.assertEquals((long)0L, (long)retrieved.version().intValue());
    }

    @Test
    public void testReplacePolicy() {
        try {
            RESOURCE_MANAGER.replacePolicy("nonexistent-project", POLICY);
            Assert.fail((String)"Project doesn't exist.");
        }
        catch (ResourceManagerException e) {
            Assert.assertEquals((long)403L, (long)e.code());
            Assert.assertTrue((boolean)e.getMessage().endsWith("project was not found."));
        }
        RESOURCE_MANAGER.create(PARTIAL_PROJECT);
        Policy oldPolicy = RESOURCE_MANAGER.getPolicy(PARTIAL_PROJECT.projectId());
        RESOURCE_MANAGER.replacePolicy(PARTIAL_PROJECT.projectId(), POLICY);
        try {
            RESOURCE_MANAGER.replacePolicy(PARTIAL_PROJECT.projectId(), oldPolicy);
            Assert.fail((String)"Policy with an invalid etag didn't cause error.");
        }
        catch (ResourceManagerException e) {
            Assert.assertEquals((long)409L, (long)e.code());
            Assert.assertTrue((boolean)e.getMessage().contains("Policy etag mismatch"));
        }
        String originalEtag = RESOURCE_MANAGER.getPolicy(PARTIAL_PROJECT.projectId()).etag();
        Policy newPolicy = RESOURCE_MANAGER.replacePolicy(PARTIAL_PROJECT.projectId(), POLICY);
        Assert.assertEquals((Object)POLICY.bindings(), (Object)newPolicy.bindings());
        Assert.assertNotNull((Object)newPolicy.etag());
        Assert.assertNotEquals((Object)originalEtag, (Object)newPolicy.etag());
    }

    @Test
    public void testTestPermissions() {
        ImmutableList permissions = ImmutableList.of((Object)"resourcemanager.projects.get");
        try {
            RESOURCE_MANAGER.testPermissions("nonexistent-project", (List)permissions);
            Assert.fail((String)"Nonexistent project");
        }
        catch (ResourceManagerException e) {
            Assert.assertEquals((long)403L, (long)e.code());
            Assert.assertEquals((Object)"Project nonexistent-project not found.", (Object)e.getMessage());
        }
        RESOURCE_MANAGER.create(PARTIAL_PROJECT);
        Assert.assertEquals((Object)ImmutableList.of((Object)true), (Object)RESOURCE_MANAGER.testPermissions(PARTIAL_PROJECT.projectId(), (List)permissions));
    }

    @Test
    public void testRetryableException() {
        ResourceManagerRpcFactory rpcFactoryMock = (ResourceManagerRpcFactory)EasyMock.createMock(ResourceManagerRpcFactory.class);
        ResourceManagerRpc resourceManagerRpcMock = (ResourceManagerRpc)EasyMock.createMock(ResourceManagerRpc.class);
        EasyMock.expect((Object)rpcFactoryMock.create((ServiceOptions)EasyMock.anyObject(ResourceManagerOptions.class))).andReturn((Object)resourceManagerRpcMock);
        EasyMock.replay((Object[])new Object[]{rpcFactoryMock});
        ResourceManager resourceManagerMock = (ResourceManager)((ResourceManagerOptions.Builder)ResourceManagerOptions.builder().serviceRpcFactory((ServiceRpcFactory)rpcFactoryMock)).build().service();
        EasyMock.expect((Object)resourceManagerRpcMock.get(PARTIAL_PROJECT.projectId(), EMPTY_RPC_OPTIONS)).andThrow((Throwable)new ResourceManagerException(500, "Internal Error")).andReturn((Object)PARTIAL_PROJECT.toPb());
        EasyMock.replay((Object[])new Object[]{resourceManagerRpcMock});
        Project returnedProject = resourceManagerMock.get(PARTIAL_PROJECT.projectId(), new ResourceManager.ProjectGetOption[0]);
        Assert.assertEquals((Object)new Project(resourceManagerMock, new ProjectInfo.BuilderImpl(PARTIAL_PROJECT)), (Object)returnedProject);
    }

    @Test
    public void testNonRetryableException() {
        ResourceManagerRpcFactory rpcFactoryMock = (ResourceManagerRpcFactory)EasyMock.createMock(ResourceManagerRpcFactory.class);
        ResourceManagerRpc resourceManagerRpcMock = (ResourceManagerRpc)EasyMock.createMock(ResourceManagerRpc.class);
        EasyMock.expect((Object)rpcFactoryMock.create((ServiceOptions)EasyMock.anyObject(ResourceManagerOptions.class))).andReturn((Object)resourceManagerRpcMock);
        EasyMock.replay((Object[])new Object[]{rpcFactoryMock});
        ResourceManager resourceManagerMock = (ResourceManager)((ResourceManagerOptions.Builder)ResourceManagerOptions.builder().serviceRpcFactory((ServiceRpcFactory)rpcFactoryMock)).build().service();
        EasyMock.expect((Object)resourceManagerRpcMock.get(PARTIAL_PROJECT.projectId(), EMPTY_RPC_OPTIONS)).andThrow((Throwable)new ResourceManagerException(403, "Project " + PARTIAL_PROJECT.projectId() + " not found.")).once();
        EasyMock.replay((Object[])new Object[]{resourceManagerRpcMock});
        this.thrown.expect(ResourceManagerException.class);
        this.thrown.expectMessage("Project " + PARTIAL_PROJECT.projectId() + " not found.");
        resourceManagerMock.get(PARTIAL_PROJECT.projectId(), new ResourceManager.ProjectGetOption[0]);
    }

    @Test
    public void testRuntimeException() {
        ResourceManagerRpcFactory rpcFactoryMock = (ResourceManagerRpcFactory)EasyMock.createMock(ResourceManagerRpcFactory.class);
        ResourceManagerRpc resourceManagerRpcMock = (ResourceManagerRpc)EasyMock.createMock(ResourceManagerRpc.class);
        EasyMock.expect((Object)rpcFactoryMock.create((ServiceOptions)EasyMock.anyObject(ResourceManagerOptions.class))).andReturn((Object)resourceManagerRpcMock);
        EasyMock.replay((Object[])new Object[]{rpcFactoryMock});
        ResourceManager resourceManagerMock = (ResourceManager)((ResourceManagerOptions.Builder)ResourceManagerOptions.builder().serviceRpcFactory((ServiceRpcFactory)rpcFactoryMock)).build().service();
        String exceptionMessage = "Artificial runtime exception";
        EasyMock.expect((Object)resourceManagerRpcMock.get(PARTIAL_PROJECT.projectId(), EMPTY_RPC_OPTIONS)).andThrow((Throwable)new RuntimeException(exceptionMessage));
        EasyMock.replay((Object[])new Object[]{resourceManagerRpcMock});
        this.thrown.expect(ResourceManagerException.class);
        this.thrown.expectMessage(exceptionMessage);
        resourceManagerMock.get(PARTIAL_PROJECT.projectId(), new ResourceManager.ProjectGetOption[0]);
    }
}

