/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager;

import com.google.cloud.BaseSerializationTest;
import com.google.cloud.Identity;
import com.google.cloud.PageImpl;
import com.google.cloud.Restorable;
import com.google.cloud.resourcemanager.Policy;
import com.google.cloud.resourcemanager.Project;
import com.google.cloud.resourcemanager.ProjectInfo;
import com.google.cloud.resourcemanager.ResourceManager;
import com.google.cloud.resourcemanager.ResourceManagerException;
import com.google.cloud.resourcemanager.ResourceManagerOptions;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;

public class SerializationTest
extends BaseSerializationTest {
    private static final ResourceManager RESOURCE_MANAGER = (ResourceManager)ResourceManagerOptions.defaultInstance().service();
    private static final ProjectInfo PARTIAL_PROJECT_INFO = ProjectInfo.builder((String)"id1").build();
    private static final ProjectInfo FULL_PROJECT_INFO = ProjectInfo.builder((String)"id").name("name").labels((Map)ImmutableMap.of((Object)"key", (Object)"value")).projectNumber(Long.valueOf(123L)).state(ProjectInfo.State.ACTIVE).createTimeMillis(Long.valueOf(1234L)).build();
    private static final Project PROJECT = new Project(RESOURCE_MANAGER, new ProjectInfo.BuilderImpl(FULL_PROJECT_INFO));
    private static final PageImpl<Project> PAGE_RESULT = new PageImpl(null, "c", Collections.singletonList(PROJECT));
    private static final ResourceManager.ProjectGetOption PROJECT_GET_OPTION = ResourceManager.ProjectGetOption.fields((ResourceManager.ProjectField[])new ResourceManager.ProjectField[]{ResourceManager.ProjectField.NAME});
    private static final ResourceManager.ProjectListOption PROJECT_LIST_OPTION = ResourceManager.ProjectListOption.filter((String)"name:*");
    private static final Policy POLICY = ((Policy.Builder)Policy.builder().addIdentity((Object)Policy.ProjectRole.VIEWER.value(), Identity.user((String)"abc@gmail.com"), new Identity[0])).build();
    private static final ResourceManagerException RESOURCE_MANAGER_EXCEPTION = new ResourceManagerException(42, "message");

    protected Serializable[] serializableObjects() {
        ResourceManagerOptions options = ResourceManagerOptions.builder().build();
        ResourceManagerOptions otherOptions = ((ResourceManagerOptions.Builder)options.toBuilder().projectId("some-unnecessary-project-ID")).build();
        return new Serializable[]{PARTIAL_PROJECT_INFO, FULL_PROJECT_INFO, PROJECT, PAGE_RESULT, PROJECT_GET_OPTION, PROJECT_LIST_OPTION, POLICY, RESOURCE_MANAGER_EXCEPTION, options, otherOptions};
    }

    protected Restorable<?>[] restorableObjects() {
        return null;
    }
}

