/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.testing;

import com.google.api.services.cloudresourcemanager.model.Binding;
import com.google.api.services.cloudresourcemanager.model.Policy;
import com.google.api.services.cloudresourcemanager.model.Project;
import com.google.api.services.cloudresourcemanager.model.ResourceId;
import com.google.cloud.resourcemanager.ResourceManagerException;
import com.google.cloud.resourcemanager.spi.DefaultResourceManagerRpc;
import com.google.cloud.resourcemanager.spi.ResourceManagerRpc;
import com.google.cloud.resourcemanager.testing.LocalResourceManagerHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class LocalResourceManagerHelperTest {
    private static final String DEFAULT_PARENT_ID = "12345";
    private static final String DEFAULT_PARENT_TYPE = "organization";
    private static final ResourceId PARENT = new ResourceId().setId("12345").setType("organization");
    private static final Map<ResourceManagerRpc.Option, ?> EMPTY_RPC_OPTIONS = ImmutableMap.of();
    private static final LocalResourceManagerHelper RESOURCE_MANAGER_HELPER = LocalResourceManagerHelper.create();
    private static final ResourceManagerRpc rpc = new DefaultResourceManagerRpc(RESOURCE_MANAGER_HELPER.options());
    private static final Project PARTIAL_PROJECT = new Project().setProjectId("partial-project");
    private static final Project COMPLETE_PROJECT = new Project().setProjectId("complete-project").setName("full project").setLabels((Map)ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2"));
    private static final Project PROJECT_WITH_PARENT = LocalResourceManagerHelperTest.copyFrom(COMPLETE_PROJECT).setProjectId("project-with-parent-id").setParent(PARENT);
    private static final List<Binding> BINDINGS = ImmutableList.of((Object)new Binding().setRole("roles/owner").setMembers((List)ImmutableList.of((Object)"user:me@gmail.com")), (Object)new Binding().setRole("roles/viewer").setMembers((List)ImmutableList.of((Object)"group:group@gmail.com")));
    private static final Policy POLICY = new Policy().setBindings(BINDINGS);

    @BeforeClass
    public static void beforeClass() {
        RESOURCE_MANAGER_HELPER.start();
    }

    private static Project copyFrom(Project from) {
        return new Project().setProjectId(from.getProjectId()).setName(from.getName()).setLabels(from.getLabels() != null ? ImmutableMap.copyOf((Map)from.getLabels()) : null).setProjectNumber(from.getProjectNumber()).setCreateTime(from.getCreateTime()).setLifecycleState(from.getLifecycleState()).setParent(from.getParent() != null ? from.getParent().clone() : null);
    }

    private void clearProjects() {
        for (Project project : (Iterable)rpc.list(EMPTY_RPC_OPTIONS).y()) {
            RESOURCE_MANAGER_HELPER.removeProject(project.getProjectId());
        }
    }

    @Before
    public void setUp() {
        this.clearProjects();
    }

    @AfterClass
    public static void afterClass() {
        RESOURCE_MANAGER_HELPER.stop();
    }

    @Test
    public void testCreate() {
        Project returnedProject = rpc.create(PARTIAL_PROJECT);
        this.compareReadWriteFields(PARTIAL_PROJECT, returnedProject);
        Assert.assertEquals((Object)"ACTIVE", (Object)returnedProject.getLifecycleState());
        Assert.assertNull((Object)returnedProject.getLabels());
        Assert.assertNull((Object)returnedProject.getName());
        Assert.assertNull((Object)returnedProject.getParent());
        Assert.assertNotNull((Object)returnedProject.getProjectNumber());
        Assert.assertNotNull((Object)returnedProject.getCreateTime());
        Policy policy = rpc.getPolicy(PARTIAL_PROJECT.getProjectId());
        Assert.assertEquals(Collections.emptyList(), (Object)policy.getBindings());
        Assert.assertNotNull((Object)policy.getEtag());
        Assert.assertEquals((long)0L, (long)policy.getVersion().intValue());
        rpc.replacePolicy(PARTIAL_PROJECT.getProjectId(), POLICY);
        Assert.assertEquals((Object)POLICY.getBindings(), (Object)rpc.getPolicy(PARTIAL_PROJECT.getProjectId()).getBindings());
        try {
            rpc.create(PARTIAL_PROJECT);
            Assert.fail((String)"Should fail, project already exists.");
        }
        catch (ResourceManagerException e) {
            Assert.assertEquals((long)409L, (long)e.code());
            Assert.assertTrue((e.getMessage().startsWith("A project with the same project ID") && e.getMessage().endsWith("already exists.") ? 1 : 0) != 0);
            Assert.assertEquals((Object)POLICY.getBindings(), (Object)rpc.getPolicy(PARTIAL_PROJECT.getProjectId()).getBindings());
        }
        returnedProject = rpc.create(PROJECT_WITH_PARENT);
        this.compareReadWriteFields(PROJECT_WITH_PARENT, returnedProject);
        Assert.assertEquals((Object)"ACTIVE", (Object)returnedProject.getLifecycleState());
        Assert.assertNotNull((Object)returnedProject.getProjectNumber());
        Assert.assertNotNull((Object)returnedProject.getCreateTime());
    }

    @Test
    public void testIsInvalidProjectId() {
        Project project = new Project();
        String invalidIDMessageSubstring = "invalid ID";
        this.expectInvalidArgumentException(project, "Project ID cannot be empty.");
        project.setProjectId("abcde");
        this.expectInvalidArgumentException(project, invalidIDMessageSubstring);
        project.setProjectId("this-project-id-is-more-than-thirty-characters-long");
        this.expectInvalidArgumentException(project, invalidIDMessageSubstring);
        project.setProjectId("project-id-with-invalid-character-?");
        this.expectInvalidArgumentException(project, invalidIDMessageSubstring);
        project.setProjectId("-invalid-start-character");
        this.expectInvalidArgumentException(project, invalidIDMessageSubstring);
        project.setProjectId("invalid-ending-character-");
        this.expectInvalidArgumentException(project, invalidIDMessageSubstring);
        project.setProjectId("some-valid-project-id-12345");
        rpc.create(project);
        Assert.assertNotNull((Object)rpc.get(project.getProjectId(), EMPTY_RPC_OPTIONS));
    }

    private void expectInvalidArgumentException(Project project, String errorMessageSubstring) {
        try {
            rpc.create(project);
            Assert.fail((String)"Should fail because of an invalid argument.");
        }
        catch (ResourceManagerException e) {
            Assert.assertEquals((long)400L, (long)e.code());
            Assert.assertTrue((boolean)e.getMessage().contains(errorMessageSubstring));
        }
    }

    @Test
    public void testIsInvalidProjectName() {
        Project project = new Project().setProjectId("some-project-id");
        rpc.create(project);
        Assert.assertNull((Object)rpc.get(project.getProjectId(), EMPTY_RPC_OPTIONS).getName());
        RESOURCE_MANAGER_HELPER.removeProject(project.getProjectId());
        project.setName("This is a valid name-'\"!");
        rpc.create(project);
        Assert.assertEquals((Object)project.getName(), (Object)rpc.get(project.getProjectId(), EMPTY_RPC_OPTIONS).getName());
        RESOURCE_MANAGER_HELPER.removeProject(project.getProjectId());
        project.setName("invalid-character-,");
        try {
            rpc.create(project);
            Assert.fail((String)"Should fail because of invalid project name.");
        }
        catch (ResourceManagerException e) {
            Assert.assertEquals((long)400L, (long)e.code());
            Assert.assertTrue((boolean)e.getMessage().contains("invalid name"));
        }
    }

    @Test
    public void testIsInvalidProjectLabels() {
        Project project = new Project().setProjectId("some-valid-project-id");
        String invalidLabelMessageSubstring = "invalid label entry";
        project.setLabels((Map)ImmutableMap.of((Object)"", (Object)"v1"));
        this.expectInvalidArgumentException(project, invalidLabelMessageSubstring);
        project.setLabels((Map)ImmutableMap.of((Object)"this-project-label-is-more-than-sixty-three-characters-long-so-it-should-fail", (Object)"v1"));
        this.expectInvalidArgumentException(project, invalidLabelMessageSubstring);
        project.setLabels((Map)ImmutableMap.of((Object)"k1", (Object)"this-project-label-is-more-than-sixty-three-characters-long-so-it-should-fail"));
        this.expectInvalidArgumentException(project, invalidLabelMessageSubstring);
        project.setLabels((Map)ImmutableMap.of((Object)"k1?", (Object)"v1"));
        this.expectInvalidArgumentException(project, invalidLabelMessageSubstring);
        project.setLabels((Map)ImmutableMap.of((Object)"k1", (Object)"v1*"));
        this.expectInvalidArgumentException(project, invalidLabelMessageSubstring);
        project.setLabels((Map)ImmutableMap.of((Object)"-k1", (Object)"v1"));
        this.expectInvalidArgumentException(project, invalidLabelMessageSubstring);
        project.setLabels((Map)ImmutableMap.of((Object)"k1", (Object)"-v1"));
        this.expectInvalidArgumentException(project, invalidLabelMessageSubstring);
        project.setLabels((Map)ImmutableMap.of((Object)"k1-", (Object)"v1"));
        this.expectInvalidArgumentException(project, invalidLabelMessageSubstring);
        project.setLabels((Map)ImmutableMap.of((Object)"k1", (Object)"v1-"));
        this.expectInvalidArgumentException(project, invalidLabelMessageSubstring);
        HashMap<String, String> tooManyLabels = new HashMap<String, String>();
        for (int i = 0; i < 257; ++i) {
            tooManyLabels.put("k" + Integer.toString(i), "v" + Integer.toString(i));
        }
        project.setLabels(tooManyLabels);
        this.expectInvalidArgumentException(project, "exceeds the limit of 256 labels");
        project.setLabels((Map)ImmutableMap.of((Object)"k-1", (Object)""));
        rpc.create(project);
        Assert.assertNotNull((Object)rpc.get(project.getProjectId(), EMPTY_RPC_OPTIONS));
        Assert.assertTrue((boolean)((String)rpc.get(project.getProjectId(), EMPTY_RPC_OPTIONS).getLabels().get("k-1")).isEmpty());
    }

    @Test
    public void testDelete() {
        rpc.create(COMPLETE_PROJECT);
        rpc.delete(COMPLETE_PROJECT.getProjectId());
        Assert.assertEquals((Object)"DELETE_REQUESTED", (Object)rpc.get(COMPLETE_PROJECT.getProjectId(), EMPTY_RPC_OPTIONS).getLifecycleState());
        try {
            rpc.delete("some-nonexistant-project-id");
            Assert.fail((String)"Should fail because the project doesn't exist.");
        }
        catch (ResourceManagerException e) {
            Assert.assertEquals((long)403L, (long)e.code());
            Assert.assertTrue((boolean)e.getMessage().contains("not found."));
        }
    }

    @Test
    public void testDeleteWhenDeleteInProgress() {
        rpc.create(COMPLETE_PROJECT);
        RESOURCE_MANAGER_HELPER.changeLifecycleState(COMPLETE_PROJECT.getProjectId(), "DELETE_IN_PROGRESS");
        try {
            rpc.delete(COMPLETE_PROJECT.getProjectId());
            Assert.fail((String)"Should fail because the project is not ACTIVE.");
        }
        catch (ResourceManagerException e) {
            Assert.assertEquals((long)400L, (long)e.code());
            Assert.assertTrue((boolean)e.getMessage().contains("the lifecycle state was not ACTIVE"));
        }
    }

    @Test
    public void testDeleteWhenDeleteRequested() {
        rpc.create(COMPLETE_PROJECT);
        RESOURCE_MANAGER_HELPER.changeLifecycleState(COMPLETE_PROJECT.getProjectId(), "DELETE_REQUESTED");
        try {
            rpc.delete(COMPLETE_PROJECT.getProjectId());
            Assert.fail((String)"Should fail because the project is not ACTIVE.");
        }
        catch (ResourceManagerException e) {
            Assert.assertEquals((long)400L, (long)e.code());
            Assert.assertTrue((boolean)e.getMessage().contains("the lifecycle state was not ACTIVE"));
        }
    }

    @Test
    public void testGet() {
        rpc.create(COMPLETE_PROJECT);
        Project returnedProject = rpc.get(COMPLETE_PROJECT.getProjectId(), EMPTY_RPC_OPTIONS);
        this.compareReadWriteFields(COMPLETE_PROJECT, returnedProject);
        RESOURCE_MANAGER_HELPER.removeProject(COMPLETE_PROJECT.getProjectId());
        Assert.assertNull((Object)rpc.get(COMPLETE_PROJECT.getProjectId(), EMPTY_RPC_OPTIONS));
    }

    @Test
    public void testGetWithOptions() {
        Project originalProject = rpc.create(COMPLETE_PROJECT);
        HashMap<ResourceManagerRpc.Option, String> rpcOptions = new HashMap<ResourceManagerRpc.Option, String>();
        rpcOptions.put(ResourceManagerRpc.Option.FIELDS, "projectId,name,createTime");
        Project returnedProject = rpc.get(COMPLETE_PROJECT.getProjectId(), rpcOptions);
        Assert.assertFalse((boolean)COMPLETE_PROJECT.equals((Object)returnedProject));
        Assert.assertEquals((Object)COMPLETE_PROJECT.getProjectId(), (Object)returnedProject.getProjectId());
        Assert.assertEquals((Object)COMPLETE_PROJECT.getName(), (Object)returnedProject.getName());
        Assert.assertEquals((Object)originalProject.getCreateTime(), (Object)returnedProject.getCreateTime());
        Assert.assertNull((Object)returnedProject.getParent());
        Assert.assertNull((Object)returnedProject.getProjectNumber());
        Assert.assertNull((Object)returnedProject.getLifecycleState());
        Assert.assertNull((Object)returnedProject.getLabels());
    }

    @Test
    public void testList() {
        ResourceManagerRpc.Tuple projects = rpc.list(EMPTY_RPC_OPTIONS);
        Assert.assertNull((Object)projects.x());
        Assert.assertFalse((boolean)((Iterable)projects.y()).iterator().hasNext());
        rpc.create(COMPLETE_PROJECT);
        RESOURCE_MANAGER_HELPER.changeLifecycleState(COMPLETE_PROJECT.getProjectId(), "DELETE_REQUESTED");
        rpc.create(PROJECT_WITH_PARENT);
        projects = rpc.list(EMPTY_RPC_OPTIONS);
        for (Project p : (Iterable)projects.y()) {
            if (p.getProjectId().equals(COMPLETE_PROJECT.getProjectId())) {
                this.compareReadWriteFields(COMPLETE_PROJECT, p);
                continue;
            }
            if (p.getProjectId().equals(PROJECT_WITH_PARENT.getProjectId())) {
                this.compareReadWriteFields(PROJECT_WITH_PARENT, p);
                continue;
            }
            Assert.fail((String)"Unexpected project in list.");
        }
    }

    @Test
    public void testInvalidListPaging() {
        HashMap<ResourceManagerRpc.Option, Integer> rpcOptions = new HashMap<ResourceManagerRpc.Option, Integer>();
        rpcOptions.put(ResourceManagerRpc.Option.PAGE_SIZE, -1);
        try {
            rpc.list(rpcOptions);
        }
        catch (ResourceManagerException e) {
            Assert.assertEquals((Object)"Page size must be greater than 0.", (Object)e.getMessage());
        }
    }

    @Test
    public void testListPaging() {
        HashMap<ResourceManagerRpc.Option, Object> rpcOptions = new HashMap<ResourceManagerRpc.Option, Object>();
        rpcOptions.put(ResourceManagerRpc.Option.PAGE_SIZE, 1);
        rpc.create(PARTIAL_PROJECT);
        rpc.create(COMPLETE_PROJECT);
        ResourceManagerRpc.Tuple projects = rpc.list(rpcOptions);
        Assert.assertNotNull((Object)projects.x());
        Iterator iterator = ((Iterable)projects.y()).iterator();
        this.compareReadWriteFields(COMPLETE_PROJECT, (Project)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        rpcOptions = new HashMap();
        rpcOptions.put(ResourceManagerRpc.Option.PAGE_TOKEN, projects.x());
        projects = rpc.list(rpcOptions);
        iterator = ((Iterable)projects.y()).iterator();
        this.compareReadWriteFields(PARTIAL_PROJECT, (Project)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertNull((Object)projects.x());
    }

    @Test
    public void testListFieldOptions() {
        HashMap<ResourceManagerRpc.Option, String> rpcOptions = new HashMap<ResourceManagerRpc.Option, String>();
        rpcOptions.put(ResourceManagerRpc.Option.FIELDS, "projects(projectId,name,labels),nextPageToken");
        rpc.create(PROJECT_WITH_PARENT);
        ResourceManagerRpc.Tuple projects = rpc.list(rpcOptions);
        Project returnedProject = (Project)((Iterable)projects.y()).iterator().next();
        Assert.assertFalse((boolean)PROJECT_WITH_PARENT.equals((Object)returnedProject));
        Assert.assertEquals((Object)PROJECT_WITH_PARENT.getProjectId(), (Object)returnedProject.getProjectId());
        Assert.assertEquals((Object)PROJECT_WITH_PARENT.getName(), (Object)returnedProject.getName());
        Assert.assertEquals((Object)PROJECT_WITH_PARENT.getLabels(), (Object)returnedProject.getLabels());
        Assert.assertNull((Object)returnedProject.getParent());
        Assert.assertNull((Object)returnedProject.getProjectNumber());
        Assert.assertNull((Object)returnedProject.getLifecycleState());
        Assert.assertNull((Object)returnedProject.getCreateTime());
    }

    @Test
    public void testListPageTokenFieldOptions() {
        HashMap<ResourceManagerRpc.Option, Object> rpcOptions = new HashMap<ResourceManagerRpc.Option, Object>();
        rpcOptions.put(ResourceManagerRpc.Option.PAGE_SIZE, 1);
        rpcOptions.put(ResourceManagerRpc.Option.FIELDS, "nextPageToken,projects(projectId,name)");
        rpc.create(PARTIAL_PROJECT);
        rpc.create(COMPLETE_PROJECT);
        ResourceManagerRpc.Tuple projects = rpc.list(rpcOptions);
        Assert.assertNotNull((Object)projects.x());
        Iterator iterator = ((Iterable)projects.y()).iterator();
        Project returnedProject = (Project)iterator.next();
        Assert.assertEquals((Object)COMPLETE_PROJECT.getProjectId(), (Object)returnedProject.getProjectId());
        Assert.assertEquals((Object)COMPLETE_PROJECT.getName(), (Object)returnedProject.getName());
        Assert.assertNull((Object)returnedProject.getLabels());
        Assert.assertNull((Object)returnedProject.getParent());
        Assert.assertNull((Object)returnedProject.getProjectNumber());
        Assert.assertNull((Object)returnedProject.getLifecycleState());
        Assert.assertNull((Object)returnedProject.getCreateTime());
        Assert.assertFalse((boolean)iterator.hasNext());
        rpcOptions.put(ResourceManagerRpc.Option.PAGE_TOKEN, projects.x());
        projects = rpc.list(rpcOptions);
        iterator = ((Iterable)projects.y()).iterator();
        returnedProject = (Project)iterator.next();
        Assert.assertEquals((Object)PARTIAL_PROJECT.getProjectId(), (Object)returnedProject.getProjectId());
        Assert.assertEquals((Object)PARTIAL_PROJECT.getName(), (Object)returnedProject.getName());
        Assert.assertNull((Object)returnedProject.getLabels());
        Assert.assertNull((Object)returnedProject.getParent());
        Assert.assertNull((Object)returnedProject.getProjectNumber());
        Assert.assertNull((Object)returnedProject.getLifecycleState());
        Assert.assertNull((Object)returnedProject.getCreateTime());
        Assert.assertNull((Object)projects.x());
    }

    @Test
    public void testListNoPageTokenFieldOptions() {
        HashMap<ResourceManagerRpc.Option, Object> rpcOptions = new HashMap<ResourceManagerRpc.Option, Object>();
        rpcOptions.put(ResourceManagerRpc.Option.PAGE_SIZE, 1);
        rpcOptions.put(ResourceManagerRpc.Option.FIELDS, "projects(projectId,name)");
        rpc.create(PARTIAL_PROJECT);
        rpc.create(COMPLETE_PROJECT);
        ResourceManagerRpc.Tuple projects = rpc.list(rpcOptions);
        Assert.assertNull((Object)projects.x());
        Iterator iterator = ((Iterable)projects.y()).iterator();
        Project returnedProject = (Project)iterator.next();
        Assert.assertEquals((Object)COMPLETE_PROJECT.getProjectId(), (Object)returnedProject.getProjectId());
        Assert.assertEquals((Object)COMPLETE_PROJECT.getName(), (Object)returnedProject.getName());
        Assert.assertNull((Object)returnedProject.getLabels());
        Assert.assertNull((Object)returnedProject.getParent());
        Assert.assertNull((Object)returnedProject.getProjectNumber());
        Assert.assertNull((Object)returnedProject.getLifecycleState());
        Assert.assertNull((Object)returnedProject.getCreateTime());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testListPageTokenNoFieldsOptions() {
        HashMap<ResourceManagerRpc.Option, Object> rpcOptions = new HashMap<ResourceManagerRpc.Option, Object>();
        rpcOptions.put(ResourceManagerRpc.Option.PAGE_SIZE, 1);
        rpcOptions.put(ResourceManagerRpc.Option.FIELDS, "nextPageToken");
        rpc.create(PARTIAL_PROJECT);
        rpc.create(COMPLETE_PROJECT);
        ResourceManagerRpc.Tuple projects = rpc.list(rpcOptions);
        Assert.assertNotNull((Object)projects.x());
        Assert.assertNull((Object)projects.y());
        rpcOptions.put(ResourceManagerRpc.Option.PAGE_TOKEN, projects.x());
        projects = rpc.list(rpcOptions);
        Assert.assertNull((Object)projects.x());
        Assert.assertNull((Object)projects.y());
    }

    @Test
    public void testListFilterOptions() {
        HashMap<ResourceManagerRpc.Option, String> rpcFilterOptions = new HashMap<ResourceManagerRpc.Option, String>();
        rpcFilterOptions.put(ResourceManagerRpc.Option.FILTER, "id:* name:myProject labels.color:blue LABELS.SIZE:*");
        Project matchingProject = new Project().setProjectId("matching-project").setName("MyProject").setLabels((Map)ImmutableMap.of((Object)"color", (Object)"blue", (Object)"size", (Object)"big"));
        Project nonMatchingProject1 = new Project().setProjectId("non-matching-project1").setName("myProject");
        nonMatchingProject1.setLabels((Map)ImmutableMap.of((Object)"color", (Object)"blue"));
        Project nonMatchingProject2 = new Project().setProjectId("non-matching-project2").setName("myProj").setLabels((Map)ImmutableMap.of((Object)"color", (Object)"blue", (Object)"size", (Object)"big"));
        Project nonMatchingProject3 = new Project().setProjectId("non-matching-project3");
        rpc.create(matchingProject);
        rpc.create(nonMatchingProject1);
        rpc.create(nonMatchingProject2);
        rpc.create(nonMatchingProject3);
        for (Project p : (Iterable)rpc.list(rpcFilterOptions).y()) {
            Assert.assertFalse((boolean)p.equals((Object)nonMatchingProject1));
            Assert.assertFalse((boolean)p.equals((Object)nonMatchingProject2));
            this.compareReadWriteFields(matchingProject, p);
        }
    }

    @Test
    public void testReplace() {
        Project createdProject = rpc.create(COMPLETE_PROJECT);
        String newName = "new name";
        ImmutableMap newLabels = ImmutableMap.of((Object)"new k1", (Object)"new v1");
        Project anotherCompleteProject = new Project().setProjectId(COMPLETE_PROJECT.getProjectId()).setName(newName).setLabels((Map)newLabels).setProjectNumber(Long.valueOf(987654321L)).setCreateTime("2000-01-01T00:00:00.001Z").setLifecycleState("DELETE_REQUESTED");
        Project returnedProject = rpc.replace(anotherCompleteProject);
        this.compareReadWriteFields(anotherCompleteProject, returnedProject);
        Assert.assertEquals((Object)createdProject.getProjectNumber(), (Object)returnedProject.getProjectNumber());
        Assert.assertEquals((Object)createdProject.getCreateTime(), (Object)returnedProject.getCreateTime());
        Assert.assertEquals((Object)createdProject.getLifecycleState(), (Object)returnedProject.getLifecycleState());
        Project nonexistantProject = new Project();
        nonexistantProject.setProjectId("some-project-id-that-does-not-exist");
        try {
            rpc.replace(nonexistantProject);
            Assert.fail((String)"Should fail because the project doesn't exist.");
        }
        catch (ResourceManagerException e) {
            Assert.assertEquals((long)403L, (long)e.code());
            Assert.assertTrue((boolean)e.getMessage().contains("the project was not found"));
        }
    }

    @Test
    public void testReplaceWhenDeleteRequested() {
        rpc.create(COMPLETE_PROJECT);
        rpc.delete(COMPLETE_PROJECT.getProjectId());
        Project anotherProject = new Project().setProjectId(COMPLETE_PROJECT.getProjectId());
        try {
            rpc.replace(anotherProject);
            Assert.fail((String)"Should fail because the project is not ACTIVE.");
        }
        catch (ResourceManagerException e) {
            Assert.assertEquals((long)400L, (long)e.code());
            Assert.assertTrue((boolean)e.getMessage().contains("the lifecycle state was not ACTIVE"));
        }
    }

    @Test
    public void testReplaceWhenDeleteInProgress() {
        rpc.create(COMPLETE_PROJECT);
        RESOURCE_MANAGER_HELPER.changeLifecycleState(COMPLETE_PROJECT.getProjectId(), "DELETE_IN_PROGRESS");
        Project anotherProject = new Project().setProjectId(COMPLETE_PROJECT.getProjectId());
        try {
            rpc.replace(anotherProject);
            Assert.fail((String)"Should fail because the project is not ACTIVE.");
        }
        catch (ResourceManagerException e) {
            Assert.assertEquals((long)400L, (long)e.code());
            Assert.assertTrue((boolean)e.getMessage().contains("the lifecycle state was not ACTIVE"));
        }
    }

    @Test
    public void testReplaceAddingParent() {
        rpc.create(COMPLETE_PROJECT);
        Project anotherProject = new Project().setProjectId(COMPLETE_PROJECT.getProjectId()).setParent(PARENT);
        try {
            rpc.replace(anotherProject);
            Assert.fail((String)"Should fail because the project's parent was modified after creation.");
        }
        catch (ResourceManagerException e) {
            Assert.assertEquals((long)400L, (long)e.code());
            Assert.assertEquals((Object)"The server currently only supports setting the parent once and does not allow unsetting it.", (Object)e.getMessage());
        }
    }

    @Test
    public void testReplaceRemovingParent() {
        rpc.create(PROJECT_WITH_PARENT);
        Project anotherProject = new Project().setProjectId(PROJECT_WITH_PARENT.getProjectId());
        try {
            rpc.replace(anotherProject);
            Assert.fail((String)"Should fail because the project's parent was unset.");
        }
        catch (ResourceManagerException e) {
            Assert.assertEquals((long)400L, (long)e.code());
            Assert.assertEquals((Object)"The server currently only supports setting the parent once and does not allow unsetting it.", (Object)e.getMessage());
        }
    }

    @Test
    public void testUndelete() {
        rpc.create(COMPLETE_PROJECT);
        rpc.delete(COMPLETE_PROJECT.getProjectId());
        Assert.assertEquals((Object)"DELETE_REQUESTED", (Object)rpc.get(COMPLETE_PROJECT.getProjectId(), EMPTY_RPC_OPTIONS).getLifecycleState());
        rpc.undelete(COMPLETE_PROJECT.getProjectId());
        Project revivedProject = rpc.get(COMPLETE_PROJECT.getProjectId(), EMPTY_RPC_OPTIONS);
        this.compareReadWriteFields(COMPLETE_PROJECT, revivedProject);
        Assert.assertEquals((Object)"ACTIVE", (Object)revivedProject.getLifecycleState());
        try {
            rpc.undelete("invalid-project-id");
            Assert.fail((String)"Should fail because the project doesn't exist.");
        }
        catch (ResourceManagerException e) {
            Assert.assertEquals((long)403L, (long)e.code());
            Assert.assertTrue((boolean)e.getMessage().contains("the project was not found"));
        }
    }

    @Test
    public void testUndeleteWhenActive() {
        rpc.create(COMPLETE_PROJECT);
        try {
            rpc.undelete(COMPLETE_PROJECT.getProjectId());
            Assert.fail((String)"Should fail because the project is not deleted.");
        }
        catch (ResourceManagerException e) {
            Assert.assertEquals((long)400L, (long)e.code());
            Assert.assertTrue((boolean)e.getMessage().contains("lifecycle state was not DELETE_REQUESTED"));
        }
    }

    @Test
    public void testUndeleteWhenDeleteInProgress() {
        rpc.create(COMPLETE_PROJECT);
        RESOURCE_MANAGER_HELPER.changeLifecycleState(COMPLETE_PROJECT.getProjectId(), "DELETE_IN_PROGRESS");
        try {
            rpc.undelete(COMPLETE_PROJECT.getProjectId());
            Assert.fail((String)"Should fail because the project is in the process of being deleted.");
        }
        catch (ResourceManagerException e) {
            Assert.assertEquals((long)400L, (long)e.code());
            Assert.assertTrue((boolean)e.getMessage().contains("lifecycle state was not DELETE_REQUESTED"));
        }
    }

    @Test
    public void testGetPolicy() {
        Assert.assertNull((Object)rpc.getPolicy("nonexistent-project"));
        rpc.create(PARTIAL_PROJECT);
        Policy policy = rpc.getPolicy(PARTIAL_PROJECT.getProjectId());
        Assert.assertEquals(Collections.emptyList(), (Object)policy.getBindings());
        Assert.assertNotNull((Object)policy.getEtag());
    }

    @Test
    public void testReplacePolicy() {
        try {
            rpc.replacePolicy("nonexistent-project", POLICY);
            Assert.fail((String)"Project doesn't exist.");
        }
        catch (ResourceManagerException e) {
            Assert.assertEquals((long)403L, (long)e.code());
            Assert.assertTrue((boolean)e.getMessage().contains("project was not found"));
        }
        rpc.create(PARTIAL_PROJECT);
        Policy invalidPolicy = new Policy().setEtag("wrong-etag");
        try {
            rpc.replacePolicy(PARTIAL_PROJECT.getProjectId(), invalidPolicy);
            Assert.fail((String)"Invalid etag.");
        }
        catch (ResourceManagerException e) {
            Assert.assertEquals((long)409L, (long)e.code());
            Assert.assertTrue((boolean)e.getMessage().startsWith("Policy etag mismatch"));
        }
        String originalEtag = rpc.getPolicy(PARTIAL_PROJECT.getProjectId()).getEtag();
        Policy newPolicy = rpc.replacePolicy(PARTIAL_PROJECT.getProjectId(), POLICY);
        Assert.assertEquals((Object)POLICY.getBindings(), (Object)newPolicy.getBindings());
        Assert.assertNotNull((Object)newPolicy.getEtag());
        Assert.assertNotEquals((Object)originalEtag, (Object)newPolicy.getEtag());
    }

    @Test
    public void testTestPermissions() {
        ImmutableList permissions = ImmutableList.of((Object)"resourcemanager.projects.get");
        try {
            rpc.testPermissions("nonexistent-project", (List)permissions);
            Assert.fail((String)"Nonexistent project.");
        }
        catch (ResourceManagerException e) {
            Assert.assertEquals((long)403L, (long)e.code());
            Assert.assertEquals((Object)"Project nonexistent-project not found.", (Object)e.getMessage());
        }
        rpc.create(PARTIAL_PROJECT);
        Assert.assertEquals((Object)ImmutableList.of((Object)true), (Object)rpc.testPermissions(PARTIAL_PROJECT.getProjectId(), (List)permissions));
    }

    @Test
    public void testChangeLifecycleStatus() {
        Assert.assertFalse((boolean)RESOURCE_MANAGER_HELPER.changeLifecycleState(COMPLETE_PROJECT.getProjectId(), "DELETE_IN_PROGRESS"));
        rpc.create(COMPLETE_PROJECT);
        Assert.assertTrue((boolean)RESOURCE_MANAGER_HELPER.changeLifecycleState(COMPLETE_PROJECT.getProjectId(), "DELETE_IN_PROGRESS"));
        Assert.assertEquals((Object)"DELETE_IN_PROGRESS", (Object)rpc.get(COMPLETE_PROJECT.getProjectId(), EMPTY_RPC_OPTIONS).getLifecycleState());
        try {
            RESOURCE_MANAGER_HELPER.changeLifecycleState(COMPLETE_PROJECT.getProjectId(), "INVALID_STATE");
            Assert.fail((String)"Should fail because of an invalid lifecycle state");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveProject() {
        Assert.assertFalse((boolean)RESOURCE_MANAGER_HELPER.removeProject(COMPLETE_PROJECT.getProjectId()));
        rpc.create(COMPLETE_PROJECT);
        Assert.assertNotNull((Object)rpc.getPolicy(COMPLETE_PROJECT.getProjectId()));
        Assert.assertTrue((boolean)RESOURCE_MANAGER_HELPER.removeProject(COMPLETE_PROJECT.getProjectId()));
        Assert.assertNull((Object)rpc.get(COMPLETE_PROJECT.getProjectId(), EMPTY_RPC_OPTIONS));
        Assert.assertNull((Object)rpc.getPolicy(COMPLETE_PROJECT.getProjectId()));
    }

    private void compareReadWriteFields(Project expected, Project actual) {
        Assert.assertEquals((Object)expected.getProjectId(), (Object)actual.getProjectId());
        Assert.assertEquals((Object)expected.getName(), (Object)actual.getName());
        Assert.assertEquals((Object)expected.getLabels(), (Object)actual.getLabels());
        Assert.assertEquals((Object)expected.getParent(), (Object)actual.getParent());
    }
}

