/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.facebookapi;

import com.google.code.facebookapi.FacebookParam;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FacebookSignatureUtil {
    protected static Log log = LogFactory.getLog(FacebookSignatureUtil.class);

    public static Map<String, String> pulloutFbSigParams(Map<String, String[]> reqParams) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Map.Entry<String, String[]> entry : reqParams.entrySet()) {
            String key = entry.getKey();
            String[] values = entry.getValue();
            if (values.length <= 0 || !FacebookParam.isInNamespace(key)) continue;
            result.put(key, values[0]);
        }
        return result;
    }

    public static Map<String, String> extractFacebookParamsFromArray(Map<CharSequence, CharSequence[]> reqParams) {
        if (null == reqParams) {
            return null;
        }
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Map.Entry<CharSequence, CharSequence[]> entry : reqParams.entrySet()) {
            String key = ((Object)entry.getKey()).toString();
            CharSequence[] values = entry.getValue();
            if (values.length <= 0 || !FacebookParam.isInNamespace(key)) continue;
            result.put(key, FacebookSignatureUtil.toString(values[0]));
        }
        return result;
    }

    public static String toString(CharSequence cs) {
        if (cs != null) {
            return ((Object)cs).toString();
        }
        return null;
    }

    public static Map<String, String> extractFacebookParamsFromStandardsCompliantArray(Map<String, String[]> reqParams) {
        if (null == reqParams) {
            return null;
        }
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Map.Entry<String, String[]> entry : reqParams.entrySet()) {
            String[] value;
            String key = entry.getKey();
            if (!FacebookParam.isInNamespace(key) || (value = entry.getValue()).length <= 0) continue;
            result.put(key, value[0]);
        }
        return result;
    }

    public static Map<String, CharSequence> extractFacebookNamespaceParams(Map<CharSequence, CharSequence> reqParams) {
        if (null == reqParams) {
            return null;
        }
        TreeMap<String, CharSequence> result = new TreeMap<String, CharSequence>();
        for (Map.Entry<CharSequence, CharSequence> entry : reqParams.entrySet()) {
            String key = ((Object)entry.getKey()).toString();
            if (!FacebookParam.isInNamespace(key)) continue;
            result.put(key, entry.getValue());
        }
        return result;
    }

    public static EnumMap<FacebookParam, CharSequence> extractFacebookParams(Map<CharSequence, CharSequence> reqParams) {
        if (null == reqParams) {
            return null;
        }
        EnumMap<FacebookParam, CharSequence> result = new EnumMap<FacebookParam, CharSequence>(FacebookParam.class);
        for (Map.Entry<CharSequence, CharSequence> entry : reqParams.entrySet()) {
            FacebookParam matchingFacebookParam = FacebookParam.get(((Object)entry.getKey()).toString());
            if (null == matchingFacebookParam) continue;
            result.put(matchingFacebookParam, entry.getValue());
        }
        return result;
    }

    public static boolean verifySignature(EnumMap<FacebookParam, String> params, String secret) {
        if (null == params || params.isEmpty()) {
            return false;
        }
        CharSequence sigParam = params.remove(FacebookParam.SIGNATURE);
        return null == sigParam ? false : FacebookSignatureUtil.verifySignature(params, secret, ((Object)sigParam).toString());
    }

    public static boolean verifySignature(EnumMap<FacebookParam, String> params, String secret, String expected) {
        assert (null != secret && !"".equals(secret));
        if (null == params || params.isEmpty()) {
            return false;
        }
        if (null == expected || "".equals(expected)) {
            return false;
        }
        params.remove(FacebookParam.SIGNATURE);
        List<String> sigParams = FacebookSignatureUtil.convertFacebookParams(params.entrySet());
        return FacebookSignatureUtil.verifySignature(sigParams, secret, expected);
    }

    public static boolean verifySignature(Map<String, String> params, String secret) {
        if (null == params || params.isEmpty()) {
            return false;
        }
        CharSequence sigParam = params.remove(FacebookParam.SIGNATURE.toString());
        return null == sigParam ? false : FacebookSignatureUtil.verifySignature(params, secret, ((Object)sigParam).toString());
    }

    public static boolean autoVerifySignature(Map<String, String[]> requestParams, String secret, String expected) {
        Map<String, String> convertedMap = FacebookSignatureUtil.extractFacebookParamsFromStandardsCompliantArray(requestParams);
        return FacebookSignatureUtil.verifySignature(convertedMap, secret, expected);
    }

    public static boolean autoVerifySignature(Map<String, String[]> requestParams, String secret) {
        String expected = requestParams.get("fb_sig")[0];
        return FacebookSignatureUtil.autoVerifySignature(requestParams, secret, expected);
    }

    public static boolean verifySignature(Map<String, String> params, String secret, String expected) {
        assert (null != secret && !"".equals(secret));
        if (null == params || params.isEmpty()) {
            return false;
        }
        if (null == expected || "".equals(expected)) {
            return false;
        }
        params.remove(FacebookParam.SIGNATURE.toString());
        List<String> sigParams = FacebookSignatureUtil.convert(params.entrySet());
        return FacebookSignatureUtil.verifySignature(sigParams, secret, expected);
    }

    private static boolean verifySignature(List<String> sigParams, String secret, String expected) {
        if (null == expected || "".equals(expected)) {
            return false;
        }
        String signature = FacebookSignatureUtil.generateSignature(sigParams, secret);
        return expected.equals(signature);
    }

    public static List<String> convert(Collection<Map.Entry<String, String>> entries) {
        ArrayList<String> result = new ArrayList<String>(entries.size());
        for (Map.Entry<String, String> entry : entries) {
            result.add(FacebookParam.stripSignaturePrefix(entry.getKey()) + "=" + entry.getValue());
        }
        return result;
    }

    public static List<String> convertFacebookParams(Collection<Map.Entry<FacebookParam, String>> entries) {
        ArrayList<String> result = new ArrayList<String>(entries.size());
        for (Map.Entry<FacebookParam, String> entry : entries) {
            result.add(entry.getKey().getSignatureName() + "=" + entry.getValue());
        }
        return result;
    }

    public static String generateSignature(List<String> params, String secret) {
        StringBuffer buffer = new StringBuffer();
        Collections.sort(params);
        for (String param : params) {
            buffer.append(param);
        }
        buffer.append(secret);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            StringBuffer result = new StringBuffer();
            try {
                for (byte b : md.digest(buffer.toString().getBytes("UTF-8"))) {
                    result.append(Integer.toHexString((b & 0xF0) >>> 4));
                    result.append(Integer.toHexString(b & 0xF));
                }
            }
            catch (UnsupportedEncodingException e) {
                for (byte b : md.digest(buffer.toString().getBytes())) {
                    result.append(Integer.toHexString((b & 0xF0) >>> 4));
                    result.append(Integer.toHexString(b & 0xF));
                }
            }
            return result.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            log.error((Object)("MD5 does not appear to be supported" + ex), (Throwable)ex);
            return "";
        }
    }
}

