/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.facebookapi;

import com.google.code.facebookapi.AssociationInfo;
import com.google.code.facebookapi.AssociationType;
import com.google.code.facebookapi.ExtensibleClient;
import com.google.code.facebookapi.FacebookException;
import com.google.code.facebookapi.ProfileInfoField;
import com.google.code.facebookapi.PropertyType;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseAdapter {
    protected final String responseFormat;
    protected final ExtensibleClient client;

    protected BaseAdapter(String responseFormat, ExtensibleClient client) {
        this.responseFormat = responseFormat;
        this.client = client;
        if (!StringUtils.equals((String)client.getResponseFormat(), (String)responseFormat)) {
            throw new IllegalStateException(String.format("Given ExtensibleClient (%s) does not support desired responseFormat (%s)", client.getResponseFormat(), responseFormat));
        }
    }

    protected ExtensibleClient getClient() {
        return this.client;
    }

    public String getApiKey() {
        return this.getClient().getApiKey();
    }

    public String getSecret() {
        return this.getClient().getSecret();
    }

    public String getRawResponse() {
        return this.client.getRawResponse();
    }

    public void beginBatch() {
        this.getClient().beginBatch();
    }

    public void beginPermissionsMode(String apiKey) {
        this.getClient().beginPermissionsMode(apiKey);
    }

    public void data_createObjectType(String name) throws FacebookException {
        this.getClient().data_createObjectType(name);
    }

    public void data_defineAssociation(String associationName, AssociationType associationType, AssociationInfo associationInfo1, AssociationInfo associationInfo2, String inverseName) throws FacebookException {
        this.getClient().data_defineAssociation(associationName, associationType, associationInfo1, associationInfo2, inverseName);
    }

    public void data_defineObjectProperty(String objectType, String propertyName, PropertyType propertyType) throws FacebookException {
        this.getClient().data_defineObjectProperty(objectType, propertyName, propertyType);
    }

    public void data_deleteObject(long objectId) throws FacebookException {
        this.getClient().data_deleteObject(objectId);
    }

    public void data_deleteObjects(Collection<Long> objectIds) throws FacebookException {
        this.getClient().data_deleteObjects(objectIds);
    }

    public void data_dropObjectType(String objectType) throws FacebookException {
        this.getClient().data_dropObjectType(objectType);
    }

    public void data_removeAssociatedObjects(String associationName, long objectId) throws FacebookException {
        this.getClient().data_removeAssociatedObjects(associationName, objectId);
    }

    public void data_removeAssociation(String associationName, long object1Id, long object2Id) throws FacebookException {
        this.getClient().data_removeAssociation(associationName, object1Id, object2Id);
    }

    public void data_renameAssociation(String name, String newName, String newAlias1, String newAlias2) throws FacebookException {
        this.getClient().data_renameAssociation(name, newName, newAlias1, newAlias2);
    }

    public void data_renameObjectProperty(String objectType, String propertyName, String newPropertyName) throws FacebookException {
        this.getClient().data_renameObjectProperty(objectType, propertyName, newPropertyName);
    }

    public void data_renameObjectType(String name, String newName) throws FacebookException {
        this.getClient().data_renameObjectType(name, newName);
    }

    public void data_setAssociation(String associationName, long object1Id, long object2Id, String data, Date associationTime) throws FacebookException {
        this.getClient().data_setAssociation(associationName, object1Id, object2Id, data, associationTime);
    }

    public void data_setObjectProperty(long objectId, String propertyName, String value) throws FacebookException {
        this.getClient().data_setObjectProperty(objectId, propertyName, value);
    }

    public void data_setUserPreference(int prefId, String value) throws FacebookException {
        this.getClient().data_setUserPreference(prefId, value);
    }

    public void data_setUserPreferences(Map<Integer, String> values, boolean replace) throws FacebookException {
        this.getClient().data_setUserPreferences(values, replace);
    }

    public void data_undefineAssociation(String name) throws FacebookException {
        this.getClient().data_undefineAssociation(name);
    }

    public void data_undefineObjectProperty(String objectType, String propertyName) throws FacebookException {
        this.getClient().data_undefineObjectProperty(objectType, propertyName);
    }

    public void data_updateObject(long objectId, Map<String, String> properties, boolean replace) throws FacebookException {
        this.getClient().data_updateObject(objectId, properties, replace);
    }

    public void endPermissionsMode() {
        this.getClient().endPermissionsMode();
    }

    public void fbml_deleteCustomTags(Collection<String> names) throws FacebookException {
        this.getClient().fbml_deleteCustomTags(names);
    }

    public void fbml_registerCustomTags(Collection<JSONObject> tags) throws FacebookException {
        this.getClient().fbml_registerCustomTags(tags);
    }

    @Deprecated
    public void profile_setInfo(Long userId, String title, boolean textOnly, List<ProfileInfoField> fields) throws FacebookException {
        this.getClient().profile_setInfo(userId, title, textOnly, fields);
    }

    @Deprecated
    public void profile_setInfoOptions(ProfileInfoField field) throws FacebookException {
        this.getClient().profile_setInfoOptions(field);
    }

    @Deprecated
    public void setCacheAppAdded(Boolean appAdded) {
        this.getClient().setCacheAppAdded(appAdded);
    }

    public void setCacheAppUser(Boolean appUser) {
        this.getClient().setCacheAppUser(appUser);
    }

    public void setCacheSession(String cacheSessionKey, Long cacheUserId, Long cacheSessionExpires) {
        this.getClient().setCacheSession(cacheSessionKey, cacheUserId, cacheSessionExpires);
    }

    public URL getServerUrl() {
        return this.getClient().getServerUrl();
    }

    public void setServerUrl(URL url) {
        this.getClient().setServerUrl(url);
    }

    public void setServerUrl(String url) {
        this.getClient().setServerUrl(url);
    }

    public int getConnectTimeout() {
        return this.getClient().getConnectTimeout();
    }

    public void setConnectTimeout(int connectTimeout) {
        this.getClient().setConnectTimeout(connectTimeout);
    }

    public int getReadTimeout() {
        return this.getClient().getReadTimeout();
    }

    public void setReadTimeout(int readTimeout) {
        this.getClient().setReadTimeout(readTimeout);
    }

    public String getResponseFormat() {
        return this.getClient().getResponseFormat();
    }

    public void sms_sendMessage(Long userId, CharSequence message) throws FacebookException {
        this.getClient().sms_sendMessage(userId, message);
    }
}

