/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.facebookapi;

import com.google.code.facebookapi.BasicClientHelper;
import com.google.code.facebookapi.BatchQuery;
import com.google.code.facebookapi.FacebookApiUrls;
import com.google.code.facebookapi.FacebookException;
import com.google.code.facebookapi.FacebookMethod;
import com.google.code.facebookapi.FacebookSignatureUtil;
import com.google.code.facebookapi.IFacebookMethod;
import com.google.code.facebookapi.Pair;
import com.google.code.facebookapi.Pairs;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicClient {
    protected static Log log = LogFactory.getLog(BasicClient.class);
    protected static final String CRLF = "\r\n";
    protected static final String PREF = "--";
    protected static final int UPLOAD_BUFFER_SIZE = 1024;
    protected URL _serverUrl;
    protected int _timeout;
    protected int _readTimeout;
    protected final String _apiKey;
    protected final String _secret;
    protected boolean _isDesktop;
    protected String cacheSessionKey;
    protected Long cacheSessionExpires;
    protected String cacheSessionSecret;
    protected String rawResponse;
    protected boolean batchMode;
    protected List<BatchQuery> queries;
    protected String permissionsApiKey = null;

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public List<BatchQuery> getQueries() {
        return this.queries;
    }

    public boolean isDesktop() {
        return this._isDesktop;
    }

    public String getRawResponse() {
        return this.rawResponse;
    }

    protected BasicClient(String apiKey, String secret) {
        this(null, apiKey, secret, null);
    }

    protected BasicClient(String apiKey, String secret, int timeout) {
        this(null, apiKey, secret, null, timeout);
    }

    protected BasicClient(String apiKey, String secret, String sessionKey) {
        this(null, apiKey, secret, sessionKey);
    }

    protected BasicClient(String apiKey, String secret, String sessionKey, int timeout) {
        this(null, apiKey, secret, sessionKey, timeout);
    }

    protected BasicClient(URL serverUrl, String apiKey, String secret, String sessionKey, int timeout) {
        this(serverUrl, apiKey, secret, sessionKey);
        this._timeout = timeout;
    }

    protected BasicClient(URL serverUrl, String apiKey, String secret, String sessionKey, int timeout, int readTimeout) {
        this(serverUrl, apiKey, secret, sessionKey);
        this._timeout = timeout;
        this._readTimeout = readTimeout;
    }

    protected BasicClient(URL serverUrl, String apiKey, String secret, String sessionKey) {
        this.cacheSessionKey = sessionKey;
        this._apiKey = apiKey;
        this._secret = secret;
        if (secret.endsWith("__")) {
            this._isDesktop = true;
        }
        this._serverUrl = null != serverUrl ? serverUrl : FacebookApiUrls.getDefaultServerUrl();
        this._timeout = -1;
        this._readTimeout = -1;
        this.batchMode = false;
        this.queries = new ArrayList<BatchQuery>();
    }

    public String getApiKey() {
        return this._apiKey;
    }

    public String getSecret() {
        return this._secret;
    }

    public void beginPermissionsMode(String apiKey) {
        this.permissionsApiKey = apiKey;
    }

    public void endPermissionsMode() {
        this.permissionsApiKey = null;
    }

    public String getSessionSecret() {
        return this.cacheSessionSecret;
    }

    public void setSessionSecret(String key) {
        this.cacheSessionSecret = key;
    }

    public String getCacheSessionSecret() {
        return this.cacheSessionSecret;
    }

    public void setCacheSessionSecret(String cacheSessionSecret) {
        this.cacheSessionSecret = cacheSessionSecret;
    }

    public Long getCacheSessionExpires() {
        return this.cacheSessionExpires;
    }

    public void setCacheSessionExpires(Long cacheSessionExpires) {
        this.cacheSessionExpires = cacheSessionExpires;
    }

    public String getCacheSessionKey() {
        return this.cacheSessionKey;
    }

    public void setCacheSessionKey(String cacheSessionKey) {
        this.cacheSessionKey = cacheSessionKey;
    }

    protected String callMethod(String responseFormat, IFacebookMethod method, Pair<String, CharSequence> ... paramPairs) throws FacebookException {
        return this.callMethod(responseFormat, method, Arrays.asList(paramPairs), null, null);
    }

    public String callMethod(String responseFormat, IFacebookMethod method, Collection<Pair<String, CharSequence>> paramPairs) throws FacebookException {
        return this.callMethod(responseFormat, method, paramPairs, null, null);
    }

    public String callMethod(String responseFormat, IFacebookMethod method, Collection<Pair<String, CharSequence>> paramPairs, String fileName, InputStream fileStream) throws FacebookException {
        boolean includeSession;
        this.rawResponse = null;
        TreeMap<String, String> params = new TreeMap<String, String>();
        if (this.permissionsApiKey != null) {
            params.put("call_as_apikey", this.permissionsApiKey);
        }
        params.put("method", method.methodName());
        params.put("api_key", this._apiKey);
        params.put("v", "1.0");
        if (null != responseFormat) {
            params.put("format", responseFormat);
        }
        params.put("call_id", Long.toString(System.currentTimeMillis()));
        boolean bl = includeSession = !method.requiresNoSession() && this.cacheSessionKey != null;
        if (includeSession) {
            params.put("session_key", this.cacheSessionKey);
        }
        for (Pair<String, CharSequence> p : paramPairs) {
            CharSequence oldVal = params.put((String)p.first, FacebookSignatureUtil.toString((CharSequence)p.second));
            if (oldVal == null) continue;
            log.warn((Object)String.format("For parameter %s, overwrote old value %s with new value %s.", p.first, oldVal, p.second));
        }
        assert (!params.containsKey("sig"));
        String signature = FacebookSignatureUtil.generateSignature(FacebookSignatureUtil.convert(params.entrySet()), this._secret);
        params.put("sig", signature);
        if (this.batchMode) {
            boolean addToBatch = true;
            if (method.methodName().equals(FacebookMethod.USERS_GET_LOGGED_IN_USER.methodName())) {
                Exception trace = new Exception();
                StackTraceElement[] traceElems = trace.getStackTrace();
                int index = 0;
                for (StackTraceElement elem : traceElems) {
                    if (elem.getMethodName().indexOf("_") != -1) {
                        StackTraceElement caller = traceElems[index + 1];
                        if (!caller.getClassName().equals(BasicClient.class.getName()) || caller.getMethodName().startsWith("auth_")) break;
                        addToBatch = false;
                        break;
                    }
                    ++index;
                }
            }
            if (addToBatch) {
                this.queries.add(new BatchQuery(method, params));
            }
            return null;
        }
        boolean doHttps = FacebookMethod.AUTH_GET_SESSION.equals(method) && "true".equals(params.get("generate_session_secret"));
        try {
            this.rawResponse = method.takesFile() ? this.postFileRequest(params, fileName, fileStream) : this.postRequest(method, params, doHttps);
            return this.rawResponse;
        }
        catch (IOException ex) {
            throw BasicClientHelper.runtimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String postRequest(IFacebookMethod method, Map<String, String> params, boolean doHttps) throws IOException {
        String string;
        String paramString;
        URL serverUrl = doHttps ? FacebookApiUrls.getDefaultHttpsServerUrl() : this._serverUrl;
        CharSequence charSequence = paramString = null == params ? "" : BasicClientHelper.delimit(params.entrySet(), "&", "=", true);
        if (log.isDebugEnabled()) {
            log.debug((Object)(method.methodName() + " POST: " + serverUrl.toString() + "?" + paramString));
        }
        HttpURLConnection conn = null;
        OutputStream out = null;
        InputStream in = null;
        try {
            conn = (HttpURLConnection)serverUrl.openConnection();
            if (this._timeout != -1) {
                conn.setConnectTimeout(this._timeout);
            }
            if (this._readTimeout != -1) {
                conn.setReadTimeout(this._readTimeout);
            }
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.connect();
            out = conn.getOutputStream();
            out.write(paramString.toString().getBytes("UTF-8"));
            in = conn.getInputStream();
            string = BasicClientHelper.getResponse(in);
        }
        catch (Throwable throwable) {
            BasicClientHelper.close(in);
            BasicClientHelper.close(out);
            BasicClientHelper.disconnect(conn);
            throw throwable;
        }
        BasicClientHelper.close(in);
        BasicClientHelper.close(out);
        BasicClientHelper.disconnect(conn);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String postFileRequest(Map<String, String> params, String fileName, InputStream fileStream) throws IOException {
        String string;
        HttpURLConnection con = null;
        OutputStream urlOut = null;
        InputStream in = null;
        try {
            String boundary = Long.toString(System.currentTimeMillis(), 16);
            con = (HttpURLConnection)this._serverUrl.openConnection();
            if (this._timeout != -1) {
                con.setConnectTimeout(this._timeout);
            }
            if (this._readTimeout != -1) {
                con.setReadTimeout(this._readTimeout);
            }
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            con.setRequestProperty("MIME-version", "1.0");
            urlOut = con.getOutputStream();
            DataOutputStream out = new DataOutputStream(urlOut);
            for (Map.Entry<String, String> entry : params.entrySet()) {
                out.writeBytes(PREF + boundary + CRLF);
                out.writeBytes("Content-Type: text/plain;charset=utf-8\r\n");
                out.writeBytes("Content-disposition: form-data; name=\"" + entry.getKey() + "\"" + CRLF);
                out.writeBytes(CRLF);
                byte[] valueBytes = entry.getValue().toString().getBytes("UTF-8");
                out.write(valueBytes);
                out.writeBytes(CRLF);
            }
            out.writeBytes(PREF + boundary + CRLF);
            out.writeBytes("Content-Type: image\r\n");
            out.writeBytes("Content-disposition: form-data; filename=\"" + fileName + "\"" + CRLF);
            out.writeBytes(CRLF);
            byte[] buf = new byte[1024];
            int len = 0;
            while (len >= 0) {
                out.write(buf, 0, len);
                len = fileStream.read(buf);
            }
            out.writeBytes("\r\n--" + boundary + PREF + CRLF);
            out.flush();
            in = con.getInputStream();
            string = BasicClientHelper.getResponse(in);
        }
        catch (Throwable throwable) {
            BasicClientHelper.close(urlOut);
            BasicClientHelper.close(in);
            BasicClientHelper.disconnect(con);
            throw throwable;
        }
        BasicClientHelper.close(urlOut);
        BasicClientHelper.close(in);
        BasicClientHelper.disconnect(con);
        return string;
    }

    public void beginBatch() {
        this.batchMode = true;
        this.queries = new ArrayList<BatchQuery>();
    }

    public String batch_run(String responseFormat, String methods, boolean serial) throws FacebookException {
        if (!serial) {
            return this.callMethod(responseFormat, (IFacebookMethod)FacebookMethod.BATCH_RUN, Pairs.newPair("method_feed", methods));
        }
        return this.callMethod(responseFormat, (IFacebookMethod)FacebookMethod.BATCH_RUN, Pairs.newPair("method_feed", methods), Pairs.newPair("serial_only", "1"));
    }

    public void setServerUrl(String newUrl) {
        String base = newUrl;
        if (base.startsWith("http")) {
            base = base.substring(base.indexOf("://") + 3);
        }
        try {
            String url = "http://" + base;
            this._serverUrl = new URL(url);
        }
        catch (MalformedURLException ex) {
            throw BasicClientHelper.runtimeException(ex);
        }
    }

    public List<String> executeBatch(String responseFormat, boolean serial) throws FacebookException {
        int BATCH_LIMIT = 20;
        this.batchMode = false;
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<BatchQuery> buffer = new ArrayList<BatchQuery>();
        while (!this.queries.isEmpty()) {
            buffer.add(this.queries.remove(0));
            if (buffer.size() != BATCH_LIMIT && !this.queries.isEmpty()) continue;
            String batchRawResponse = this.batch_run(responseFormat, BasicClient.encodeMethods(buffer), serial);
            result.add(batchRawResponse);
            if (buffer.size() == BATCH_LIMIT) {
                log.debug((Object)"Clearing buffer for the next run.");
                buffer.clear();
                continue;
            }
            log.trace((Object)"No need to clear buffer, this is the final iteration of the batch");
        }
        return result;
    }

    public static String encodeMethods(List<BatchQuery> queryList) throws FacebookException {
        JSONArray result = new JSONArray();
        for (BatchQuery query : queryList) {
            if (query.getMethod().takesFile()) {
                throw new FacebookException(100, "File upload API calls cannot be batched:  " + query.getMethod().methodName());
            }
            result.put((Object)BasicClientHelper.delimit(query.getParams().entrySet(), "&", "=", true));
        }
        return result.toString();
    }
}

