/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud;

import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.common.base.Preconditions;
import com.google.gcloud.Restorable;
import com.google.gcloud.RestorableState;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.PrivateKey;
import java.util.Collection;
import java.util.Objects;

public abstract class AuthCredentials
implements Restorable<AuthCredentials> {
    public abstract GoogleCredentials credentials();

    public static AuthCredentials createForAppEngine() {
        return AppEngineAuthCredentials.INSTANCE;
    }

    public static AuthCredentials createApplicationDefaults() throws IOException {
        return new ApplicationDefaultAuthCredentials();
    }

    public static ServiceAccountAuthCredentials createFor(String account, PrivateKey privateKey) {
        return new ServiceAccountAuthCredentials(account, privateKey);
    }

    public static ServiceAccountAuthCredentials createForJson(InputStream jsonCredentialStream) throws IOException {
        GoogleCredentials tempCredentials = GoogleCredentials.fromStream((InputStream)jsonCredentialStream);
        if (tempCredentials instanceof ServiceAccountCredentials) {
            ServiceAccountCredentials tempServiceAccountCredentials = (ServiceAccountCredentials)tempCredentials;
            return new ServiceAccountAuthCredentials(tempServiceAccountCredentials.getClientEmail(), tempServiceAccountCredentials.getPrivateKey());
        }
        throw new IOException("The given JSON Credentials Stream is not for a service account credential.");
    }

    public static class ApplicationDefaultAuthCredentials
    extends AuthCredentials {
        private GoogleCredentials googleCredentials = GoogleCredentials.getApplicationDefault();
        private static final ApplicationDefaultAuthCredentialsState STATE = new ApplicationDefaultAuthCredentialsState();

        ApplicationDefaultAuthCredentials() throws IOException {
        }

        @Override
        public GoogleCredentials credentials() {
            return this.googleCredentials;
        }

        @Override
        public RestorableState<AuthCredentials> capture() {
            return STATE;
        }

        private static class ApplicationDefaultAuthCredentialsState
        implements RestorableState<AuthCredentials>,
        Serializable {
            private static final long serialVersionUID = -8839085552021212257L;

            private ApplicationDefaultAuthCredentialsState() {
            }

            @Override
            public AuthCredentials restore() {
                try {
                    return new ApplicationDefaultAuthCredentials();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Could not restore " + ApplicationDefaultAuthCredentials.class.getSimpleName(), e);
                }
            }

            public int hashCode() {
                return this.getClass().getName().hashCode();
            }

            public boolean equals(Object obj) {
                return obj instanceof ApplicationDefaultAuthCredentialsState;
            }
        }
    }

    public static class ServiceAccountAuthCredentials
    extends AuthCredentials {
        private final String account;
        private final PrivateKey privateKey;

        ServiceAccountAuthCredentials(String account, PrivateKey privateKey) {
            this.account = (String)Preconditions.checkNotNull((Object)account);
            this.privateKey = (PrivateKey)Preconditions.checkNotNull((Object)privateKey);
        }

        public ServiceAccountCredentials credentials() {
            return new ServiceAccountCredentials(null, this.account, this.privateKey, null, null);
        }

        public String account() {
            return this.account;
        }

        public PrivateKey privateKey() {
            return this.privateKey;
        }

        @Override
        public RestorableState<AuthCredentials> capture() {
            return new ServiceAccountAuthCredentialsState(this.account, this.privateKey);
        }

        private static class ServiceAccountAuthCredentialsState
        implements RestorableState<AuthCredentials>,
        Serializable {
            private static final long serialVersionUID = -7302180782414633639L;
            private final String account;
            private final PrivateKey privateKey;

            private ServiceAccountAuthCredentialsState(String account, PrivateKey privateKey) {
                this.account = account;
                this.privateKey = privateKey;
            }

            @Override
            public AuthCredentials restore() {
                return new ServiceAccountAuthCredentials(this.account, this.privateKey);
            }

            public int hashCode() {
                return Objects.hash(this.account, this.privateKey);
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof ServiceAccountAuthCredentialsState)) {
                    return false;
                }
                ServiceAccountAuthCredentialsState other = (ServiceAccountAuthCredentialsState)obj;
                return Objects.equals(this.account, other.account) && Objects.equals(this.privateKey, other.privateKey);
            }
        }
    }

    private static class AppEngineAuthCredentials
    extends AuthCredentials {
        private static final AuthCredentials INSTANCE = new AppEngineAuthCredentials();
        private static final AppEngineAuthCredentialsState STATE = new AppEngineAuthCredentialsState();

        private AppEngineAuthCredentials() {
        }

        @Override
        public GoogleCredentials credentials() {
            return new AppEngineCredentials();
        }

        @Override
        public RestorableState<AuthCredentials> capture() {
            return STATE;
        }

        private static class AppEngineAuthCredentialsState
        implements RestorableState<AuthCredentials>,
        Serializable {
            private static final long serialVersionUID = 3558563960848658928L;

            private AppEngineAuthCredentialsState() {
            }

            @Override
            public AuthCredentials restore() {
                return INSTANCE;
            }

            public int hashCode() {
                return this.getClass().getName().hashCode();
            }

            public boolean equals(Object obj) {
                return obj instanceof AppEngineAuthCredentialsState;
            }
        }

        private static class AppEngineCredentials
        extends GoogleCredentials {
            private final Object appIdentityService;
            private final Method getAccessToken;
            private final Method getAccessTokenResult;
            private final Collection<String> scopes;

            AppEngineCredentials() {
                try {
                    Class<?> factoryClass = Class.forName("com.google.appengine.api.appidentity.AppIdentityServiceFactory");
                    Method method = factoryClass.getMethod("getAppIdentityService", new Class[0]);
                    this.appIdentityService = method.invoke(null, new Object[0]);
                    Class<?> serviceClass = Class.forName("com.google.appengine.api.appidentity.AppIdentityService");
                    Class<?> tokenResultClass = Class.forName("com.google.appengine.api.appidentity.AppIdentityService$GetAccessTokenResult");
                    this.getAccessTokenResult = serviceClass.getMethod("getAccessToken", Iterable.class);
                    this.getAccessToken = tokenResultClass.getMethod("getAccessToken", new Class[0]);
                    this.scopes = null;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not create AppEngineCredentials.", e);
                }
            }

            AppEngineCredentials(Collection<String> scopes, AppEngineCredentials unscoped) {
                this.appIdentityService = unscoped.appIdentityService;
                this.getAccessToken = unscoped.getAccessToken;
                this.getAccessTokenResult = unscoped.getAccessTokenResult;
                this.scopes = scopes;
            }

            public AccessToken refreshAccessToken() throws IOException {
                if (this.createScopedRequired()) {
                    throw new IOException("AppEngineCredentials requires createScoped call before use.");
                }
                try {
                    Object accessTokenResult = this.getAccessTokenResult.invoke(this.appIdentityService, this.scopes);
                    String accessToken = (String)this.getAccessToken.invoke(accessTokenResult, new Object[0]);
                    return new AccessToken(accessToken, null);
                }
                catch (Exception e) {
                    throw new IOException("Could not get the access token.", e);
                }
            }

            public boolean createScopedRequired() {
                return this.scopes == null || this.scopes.isEmpty();
            }

            public GoogleCredentials createScoped(Collection<String> scopes) {
                return new AppEngineCredentials(scopes, this);
            }
        }
    }
}

