/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud;

import com.google.api.client.extensions.appengine.http.UrlFetchTransport;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.gcloud.AuthCredentials;
import com.google.gcloud.RestorableState;
import com.google.gcloud.RetryParams;
import com.google.gcloud.Service;
import com.google.gcloud.ServiceFactory;
import com.google.gcloud.spi.ServiceRpcFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ServiceOptions<ServiceT extends Service<OptionsT>, ServiceRpcT, OptionsT extends ServiceOptions<ServiceT, ServiceRpcT, OptionsT>>
implements Serializable {
    private static final String DEFAULT_HOST = "https://www.googleapis.com";
    private static final long serialVersionUID = 1203687993961393350L;
    private static final String PROJECT_ENV_NAME = "GCLOUD_PROJECT";
    private static final String MANIFEST_ARTIFACT_ID_KEY = "artifactId";
    private static final String MANIFEST_VERSION_KEY = "Implementation-Version";
    private static final String ARTIFACT_ID = "gcloud-java-core";
    private static final String APPLICATION_BASE_NAME = "gcloud-java";
    private static final String APPLICATION_NAME = ServiceOptions.getApplicationName();
    private final String projectId;
    private final String host;
    private final String httpTransportFactoryClassName;
    private final RestorableState<AuthCredentials> authCredentialsState;
    private final RetryParams retryParams;
    private final String serviceRpcFactoryClassName;
    private final String serviceFactoryClassName;
    private final int connectTimeout;
    private final int readTimeout;
    private final Clock clock;
    private transient HttpTransportFactory httpTransportFactory;
    private transient AuthCredentials authCredentials;
    private transient ServiceRpcFactory<ServiceRpcT, OptionsT> serviceRpcFactory;
    private transient ServiceFactory<ServiceT, OptionsT> serviceFactory;
    private transient ServiceT service;
    private transient ServiceRpcT rpc;

    protected ServiceOptions(Class<? extends ServiceFactory<ServiceT, OptionsT>> serviceFactoryClass, Class<? extends ServiceRpcFactory<ServiceRpcT, OptionsT>> rpcFactoryClass, Builder<ServiceT, ServiceRpcT, OptionsT, ?> builder) {
        String string = this.projectId = ((Builder)builder).projectId != null ? ((Builder)builder).projectId : this.defaultProject();
        if (this.projectIdRequired()) {
            Preconditions.checkArgument((this.projectId != null ? 1 : 0) != 0, (Object)"A project ID is required for this service but could not be determined from the builder or the environment.  Please set a project ID using the builder.");
        }
        this.host = (String)MoreObjects.firstNonNull((Object)((Builder)builder).host, (Object)this.defaultHost());
        this.httpTransportFactory = (HttpTransportFactory)MoreObjects.firstNonNull((Object)((Builder)builder).httpTransportFactory, (Object)ServiceOptions.getFromServiceLoader(HttpTransportFactory.class, DefaultHttpTransportFactory.INSTANCE));
        this.httpTransportFactoryClassName = this.httpTransportFactory.getClass().getName();
        this.authCredentials = ((Builder)builder).authCredentials != null ? ((Builder)builder).authCredentials : ServiceOptions.defaultAuthCredentials();
        this.authCredentialsState = this.authCredentials != null ? this.authCredentials.capture() : null;
        this.retryParams = (RetryParams)MoreObjects.firstNonNull((Object)((Builder)builder).retryParams, (Object)RetryParams.defaultInstance());
        this.serviceFactory = (ServiceFactory)MoreObjects.firstNonNull((Object)((Builder)builder).serviceFactory, ServiceOptions.getFromServiceLoader(serviceFactoryClass, this.defaultServiceFactory()));
        this.serviceFactoryClassName = this.serviceFactory.getClass().getName();
        this.serviceRpcFactory = (ServiceRpcFactory)MoreObjects.firstNonNull((Object)((Builder)builder).serviceRpcFactory, ServiceOptions.getFromServiceLoader(rpcFactoryClass, this.defaultRpcFactory()));
        this.serviceRpcFactoryClassName = this.serviceRpcFactory.getClass().getName();
        this.connectTimeout = ((Builder)builder).connectTimeout;
        this.readTimeout = ((Builder)builder).readTimeout;
        this.clock = (Clock)MoreObjects.firstNonNull((Object)((Builder)builder).clock, (Object)Clock.defaultClock());
    }

    protected boolean projectIdRequired() {
        return true;
    }

    private static AuthCredentials defaultAuthCredentials() {
        if (ServiceOptions.appEngineAppId() != null) {
            try {
                return AuthCredentials.createForAppEngine();
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        try {
            return AuthCredentials.createApplicationDefaults();
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected static String appEngineAppId() {
        return System.getProperty("com.google.appengine.application.id");
    }

    protected String defaultHost() {
        return DEFAULT_HOST;
    }

    protected String defaultProject() {
        String projectId = System.getProperty(PROJECT_ENV_NAME, System.getenv(PROJECT_ENV_NAME));
        if (projectId == null) {
            projectId = ServiceOptions.getAppEngineProjectId();
        }
        return projectId != null ? projectId : ServiceOptions.googleCloudProjectId();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String googleCloudProjectId() {
        File configDir = System.getenv().containsKey("CLOUDSDK_CONFIG") ? new File(System.getenv("CLOUDSDK_CONFIG")) : (ServiceOptions.isWindows() && System.getenv().containsKey("APPDATA") ? new File(System.getenv("APPDATA"), "gcloud") : new File(System.getProperty("user.home"), ".config/gcloud"));
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(new File(configDir, "configurations/config_default"));
        }
        catch (FileNotFoundException newConfigFileNotFoundEx) {
            try {
                fileReader = new FileReader(new File(configDir, "properties"));
            }
            catch (FileNotFoundException oldConfigFileNotFoundEx) {
                // empty catch block
            }
        }
        if (fileReader != null) {
            try (BufferedReader reader = new BufferedReader(fileReader);){
                String line;
                String section = null;
                Pattern projectPattern = Pattern.compile("^project\\s*=\\s*(.*)$");
                Pattern sectionPattern = Pattern.compile("^\\[(.*)\\]$");
                while ((line = reader.readLine()) != null) {
                    if (line.isEmpty() || line.startsWith(";")) continue;
                    Matcher matcher = sectionPattern.matcher(line = line.trim());
                    if (matcher.matches()) {
                        section = matcher.group(1);
                        continue;
                    }
                    if (section != null && !section.equals("core") || !(matcher = projectPattern.matcher(line)).matches()) continue;
                    String string = matcher.group(1);
                    return string;
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        try {
            URL url = new URL("http://metadata/computeMetadata/v1/project/project-id");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("X-Google-Metadata-Request", "True");
            InputStream input = connection.getInputStream();
            if (connection.getResponseCode() != 200) return null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
                String string = reader.readLine();
                return string;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
    }

    protected static String getAppEngineProjectId() {
        try {
            Class<?> factoryClass = Class.forName("com.google.appengine.api.appidentity.AppIdentityServiceFactory");
            Class<?> serviceClass = Class.forName("com.google.appengine.api.appidentity.AppIdentityService");
            Method method = factoryClass.getMethod("getAppIdentityService", new Class[0]);
            Object appIdentityService = method.invoke(null, new Object[0]);
            method = serviceClass.getMethod("getServiceAccountName", new Class[0]);
            String serviceAccountName = (String)method.invoke(appIdentityService, new Object[0]);
            int indexOfAtSign = serviceAccountName.indexOf(64);
            return serviceAccountName.substring(0, indexOfAtSign);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public ServiceT service() {
        if (this.service == null) {
            this.service = this.serviceFactory.create(this);
        }
        return this.service;
    }

    public ServiceRpcT rpc() {
        if (this.rpc == null) {
            this.rpc = this.serviceRpcFactory.create(this);
        }
        return this.rpc;
    }

    public String projectId() {
        return this.projectId;
    }

    public String host() {
        return this.host;
    }

    public HttpTransportFactory httpTransportFactory() {
        return this.httpTransportFactory;
    }

    public AuthCredentials authCredentials() {
        return this.authCredentials;
    }

    public RetryParams retryParams() {
        return this.retryParams;
    }

    public HttpRequestInitializer httpRequestInitializer() {
        HttpCredentialsAdapter delegate = this.authCredentials() != null ? new HttpCredentialsAdapter((Credentials)this.authCredentials().credentials().createScoped(this.scopes())) : null;
        return new HttpRequestInitializer((HttpRequestInitializer)delegate){
            final /* synthetic */ HttpRequestInitializer val$delegate;
            {
                this.val$delegate = httpRequestInitializer;
            }

            public void initialize(HttpRequest httpRequest) throws IOException {
                if (this.val$delegate != null) {
                    this.val$delegate.initialize(httpRequest);
                }
                if (ServiceOptions.this.connectTimeout >= 0) {
                    httpRequest.setConnectTimeout(ServiceOptions.this.connectTimeout);
                }
                if (ServiceOptions.this.readTimeout >= 0) {
                    httpRequest.setReadTimeout(ServiceOptions.this.readTimeout);
                }
            }
        };
    }

    public int connectTimeout() {
        return this.connectTimeout;
    }

    public int readTimeout() {
        return this.readTimeout;
    }

    public Clock clock() {
        return this.clock;
    }

    public String applicationName() {
        return APPLICATION_NAME;
    }

    protected int baseHashCode() {
        return Objects.hash(this.projectId, this.host, this.httpTransportFactoryClassName, this.authCredentialsState, this.retryParams, this.serviceFactoryClassName, this.serviceRpcFactoryClassName, this.connectTimeout, this.readTimeout, this.clock);
    }

    protected boolean baseEquals(ServiceOptions<?, ?, ?> other) {
        return Objects.equals(this.projectId, other.projectId) && Objects.equals(this.host, other.host) && Objects.equals(this.httpTransportFactoryClassName, other.httpTransportFactoryClassName) && Objects.equals(this.authCredentialsState, other.authCredentialsState) && Objects.equals(this.retryParams, other.retryParams) && Objects.equals(this.serviceFactoryClassName, other.serviceFactoryClassName) && Objects.equals(this.serviceRpcFactoryClassName, other.serviceRpcFactoryClassName) && Objects.equals(this.connectTimeout, other.connectTimeout) && Objects.equals(this.readTimeout, other.readTimeout) && Objects.equals(this.clock, this.clock);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.httpTransportFactory = (HttpTransportFactory)ServiceOptions.newInstance(this.httpTransportFactoryClassName);
        this.serviceFactory = (ServiceFactory)ServiceOptions.newInstance(this.serviceFactoryClassName);
        this.serviceRpcFactory = (ServiceRpcFactory)ServiceOptions.newInstance(this.serviceRpcFactoryClassName);
        this.authCredentials = this.authCredentialsState != null ? this.authCredentialsState.restore() : null;
    }

    private static <T> T newInstance(String className) throws IOException, ClassNotFoundException {
        try {
            return (T)Class.forName(className).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IOException(e);
        }
    }

    protected abstract <T extends ServiceFactory<ServiceT, OptionsT>> T defaultServiceFactory();

    protected abstract <T extends ServiceRpcFactory<ServiceRpcT, OptionsT>> T defaultRpcFactory();

    protected abstract Set<String> scopes();

    public abstract <B extends Builder<ServiceT, ServiceRpcT, OptionsT, B>> B toBuilder();

    private static <T> T getFromServiceLoader(Class<? extends T> clazz, T defaultInstance) {
        return (T)Iterables.getFirst(ServiceLoader.load(clazz), defaultInstance);
    }

    private static String getApplicationName() {
        String version = null;
        try {
            Enumeration<URL> resources = ServiceOptions.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements() && version == null) {
                Manifest manifest = new Manifest(resources.nextElement().openStream());
                Attributes manifestAttributes = manifest.getMainAttributes();
                String artifactId = manifestAttributes.getValue(MANIFEST_ARTIFACT_ID_KEY);
                if (artifactId == null || !artifactId.equals(ARTIFACT_ID)) continue;
                version = manifestAttributes.getValue(MANIFEST_VERSION_KEY);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return version != null ? "gcloud-java/" + version : APPLICATION_BASE_NAME;
    }

    protected static abstract class Builder<ServiceT extends Service<OptionsT>, ServiceRpcT, OptionsT extends ServiceOptions<ServiceT, ServiceRpcT, OptionsT>, B extends Builder<ServiceT, ServiceRpcT, OptionsT, B>> {
        private String projectId;
        private String host;
        private HttpTransportFactory httpTransportFactory;
        private AuthCredentials authCredentials;
        private RetryParams retryParams;
        private ServiceFactory<ServiceT, OptionsT> serviceFactory;
        private ServiceRpcFactory<ServiceRpcT, OptionsT> serviceRpcFactory;
        private int connectTimeout = -1;
        private int readTimeout = -1;
        private Clock clock;

        protected Builder() {
        }

        protected Builder(ServiceOptions<ServiceT, ServiceRpcT, OptionsT> options) {
            this.projectId = ((ServiceOptions)options).projectId;
            this.host = ((ServiceOptions)options).host;
            this.httpTransportFactory = ((ServiceOptions)options).httpTransportFactory;
            this.authCredentials = ((ServiceOptions)options).authCredentials;
            this.retryParams = ((ServiceOptions)options).retryParams;
            this.serviceFactory = ((ServiceOptions)options).serviceFactory;
            this.serviceRpcFactory = ((ServiceOptions)options).serviceRpcFactory;
            this.connectTimeout = ((ServiceOptions)options).connectTimeout;
            this.readTimeout = ((ServiceOptions)options).readTimeout;
            this.clock = ((ServiceOptions)options).clock;
        }

        protected abstract ServiceOptions<ServiceT, ServiceRpcT, OptionsT> build();

        protected B self() {
            return (B)this;
        }

        public B serviceFactory(ServiceFactory<ServiceT, OptionsT> serviceFactory) {
            this.serviceFactory = serviceFactory;
            return this.self();
        }

        public B clock(Clock clock) {
            this.clock = clock;
            return this.self();
        }

        public B projectId(String projectId) {
            this.projectId = projectId;
            return this.self();
        }

        public B host(String host) {
            this.host = host;
            return this.self();
        }

        public B httpTransportFactory(HttpTransportFactory httpTransportFactory) {
            this.httpTransportFactory = httpTransportFactory;
            return this.self();
        }

        public B authCredentials(AuthCredentials authCredentials) {
            this.authCredentials = authCredentials;
            return this.self();
        }

        public B retryParams(RetryParams retryParams) {
            this.retryParams = retryParams;
            return this.self();
        }

        public B serviceRpcFactory(ServiceRpcFactory<ServiceRpcT, OptionsT> serviceRpcFactory) {
            this.serviceRpcFactory = serviceRpcFactory;
            return this.self();
        }

        public B connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this.self();
        }

        public B readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this.self();
        }
    }

    public static abstract class Clock {
        private static final Clock DEFAULT_TIME_SOURCE = new DefaultClock();

        public abstract long millis();

        public static Clock defaultClock() {
            return DEFAULT_TIME_SOURCE;
        }

        private static class DefaultClock
        extends Clock
        implements Serializable {
            private static final long serialVersionUID = -5077300394286703864L;

            private DefaultClock() {
            }

            @Override
            public long millis() {
                return System.currentTimeMillis();
            }

            private Object readResolve() throws ObjectStreamException {
                return DEFAULT_TIME_SOURCE;
            }
        }
    }

    public static class DefaultHttpTransportFactory
    implements HttpTransportFactory {
        private static final HttpTransportFactory INSTANCE = new DefaultHttpTransportFactory();

        @Override
        public HttpTransport create() {
            if (ServiceOptions.appEngineAppId() != null) {
                try {
                    return new UrlFetchTransport();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new NetHttpTransport();
        }
    }

    public static interface HttpTransportFactory {
        public HttpTransport create();
    }
}

