/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore;

import com.google.api.services.datastore.DatastoreV1;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gcloud.datastore.Datastore;
import com.google.gcloud.datastore.DatastoreBatchWriter;
import com.google.gcloud.datastore.DatastoreException;
import com.google.gcloud.datastore.DatastoreHelper;
import com.google.gcloud.datastore.Entity;
import com.google.gcloud.datastore.FullEntity;
import com.google.gcloud.datastore.IncompleteKey;
import com.google.gcloud.datastore.Key;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BaseDatastoreBatchWriter
implements DatastoreBatchWriter {
    private final String name;
    private final Map<Key, FullEntity<Key>> toAdd = new LinkedHashMap<Key, FullEntity<Key>>();
    private final List<FullEntity<IncompleteKey>> toAddAutoId = new LinkedList<FullEntity<IncompleteKey>>();
    private final Map<Key, FullEntity<Key>> toUpdate = new LinkedHashMap<Key, FullEntity<Key>>();
    private final Map<Key, FullEntity<Key>> toPut = new LinkedHashMap<Key, FullEntity<Key>>();
    private final Set<Key> toDelete = new LinkedHashSet<Key>();
    private boolean active = true;

    protected BaseDatastoreBatchWriter(String name) {
        this.name = name;
    }

    @Override
    public final void addWithDeferredIdAllocation(FullEntity<?> ... entities) {
        this.validateActive();
        for (FullEntity<Key> fullEntity : entities) {
            Object key = fullEntity.key();
            Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Entity must have a key");
            if (key instanceof Key) {
                this.addInternal(fullEntity);
                continue;
            }
            this.toAddAutoId.add(fullEntity);
        }
    }

    private void addInternal(FullEntity<Key> entity) {
        Key key = (Key)entity.key();
        if (this.toAdd.containsKey(key) || this.toUpdate.containsKey(key) || this.toPut.containsKey(key)) {
            throw this.newInvalidRequest("Entity with the key %s was already added or updated in this %s", entity.key(), this.name);
        }
        if (this.toDelete.remove(key)) {
            this.toPut.put(key, entity);
        } else {
            this.toAdd.put(key, entity);
        }
    }

    @Override
    public final Entity add(FullEntity<?> entity) {
        return DatastoreHelper.add(this, entity);
    }

    @Override
    public final List<Entity> add(FullEntity<?> ... entities) {
        Iterator<Object> allocated;
        this.validateActive();
        ArrayList incompleteKeys = Lists.newArrayListWithExpectedSize((int)entities.length);
        for (FullEntity<Key> fullEntity : entities) {
            Object key = fullEntity.key();
            Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Entity must have a key");
            if (key instanceof Key) {
                this.addInternal(fullEntity);
                continue;
            }
            incompleteKeys.add(key);
        }
        if (!incompleteKeys.isEmpty()) {
            IncompleteKey[] toAllocate = (IncompleteKey[])Iterables.toArray((Iterable)incompleteKeys, IncompleteKey.class);
            allocated = this.datastore().allocateId(toAllocate).iterator();
        } else {
            allocated = Collections.emptyIterator();
        }
        ArrayList answer = Lists.newArrayListWithExpectedSize((int)entities.length);
        for (FullEntity<Key> fullEntity : entities) {
            if (fullEntity.key() instanceof Key) {
                answer.add(Entity.convert(fullEntity));
                continue;
            }
            Entity entityWithAllocatedId = Entity.builder((Key)allocated.next(), fullEntity).build();
            this.addInternal(entityWithAllocatedId);
            answer.add(entityWithAllocatedId);
        }
        return answer;
    }

    @Override
    @SafeVarargs
    public final void update(Entity ... entities) {
        this.validateActive();
        for (Entity entity : entities) {
            Key key = (Key)entity.key();
            if (this.toDelete.contains(key)) {
                throw this.newInvalidRequest("Entity with the key %s was already deleted in this %s", entity.key(), this.name);
            }
            if (this.toAdd.remove(key) != null || this.toPut.containsKey(key)) {
                this.toPut.put(key, entity);
                continue;
            }
            this.toUpdate.put(key, entity);
        }
    }

    @Override
    @SafeVarargs
    public final void put(Entity ... entities) {
        this.validateActive();
        for (Entity entity : entities) {
            Key key = (Key)entity.key();
            this.toAdd.remove(key);
            this.toUpdate.remove(key);
            this.toDelete.remove(key);
            this.toPut.put(key, entity);
        }
    }

    @Override
    public final void delete(Key ... keys) {
        this.validateActive();
        for (Key key : keys) {
            this.toAdd.remove(key);
            this.toUpdate.remove(key);
            this.toPut.remove(key);
            this.toDelete.add(key);
        }
    }

    @Override
    public boolean active() {
        return this.active;
    }

    protected String name() {
        return this.name;
    }

    protected Map<Key, FullEntity<Key>> toAdd() {
        return this.toAdd;
    }

    protected List<FullEntity<IncompleteKey>> toAddAutoId() {
        return this.toAddAutoId;
    }

    protected Map<Key, FullEntity<Key>> toUpdate() {
        return this.toUpdate;
    }

    protected Map<Key, FullEntity<Key>> toPut() {
        return this.toPut;
    }

    protected Set<Key> toDelete() {
        return this.toDelete;
    }

    protected void deactivate() {
        this.active = false;
    }

    protected void validateActive() {
        if (!this.active) {
            throw this.newInvalidRequest("%s is no longer active", this.name);
        }
    }

    protected DatastoreException newInvalidRequest(String msg, Object ... params) {
        return DatastoreException.throwInvalidRequest(String.format(msg, params), new Object[0]);
    }

    protected DatastoreV1.Mutation.Builder toMutationPb() {
        DatastoreV1.Mutation.Builder mutationPb = DatastoreV1.Mutation.newBuilder();
        for (FullEntity<IncompleteKey> fullEntity : this.toAddAutoId()) {
            mutationPb.addInsertAutoId(fullEntity.toPb());
        }
        for (FullEntity<IncompleteKey> fullEntity : this.toAdd().values()) {
            mutationPb.addInsert(fullEntity.toPb());
        }
        for (FullEntity<IncompleteKey> fullEntity : this.toUpdate().values()) {
            mutationPb.addUpdate(fullEntity.toPb());
        }
        for (FullEntity<IncompleteKey> fullEntity : this.toPut().values()) {
            mutationPb.addUpsert(fullEntity.toPb());
        }
        for (Key key : this.toDelete()) {
            mutationPb.addDelete(key.toPb());
        }
        return mutationPb;
    }

    protected abstract Datastore datastore();
}

