/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore;

import com.google.api.services.datastore.DatastoreV1;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.gcloud.datastore.Serializable;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public final class Cursor
extends Serializable<DatastoreV1.Value> {
    private static final long serialVersionUID = -1423744878777486541L;
    private final transient ByteString byteString;

    Cursor(ByteString byteString) {
        Preconditions.checkArgument((boolean)byteString.isValidUtf8(), (Object)"content is not a valid UTF-8");
        this.byteString = byteString;
    }

    public int hashCode() {
        return this.byteString.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Cursor && this.byteString.equals((Object)((Cursor)obj).byteString);
    }

    @Override
    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this);
        StringBuilder stBuilder = new StringBuilder();
        for (int i = 0; i < this.byteString.size(); ++i) {
            stBuilder.append(String.format("%02x", this.byteString.byteAt(i)));
        }
        return toStringHelper.add("bytes", (Object)stBuilder.toString()).toString();
    }

    ByteString byteString() {
        return this.byteString;
    }

    public String toUrlSafe() {
        try {
            return URLEncoder.encode(TextFormat.printToString((MessageOrBuilder)this.toPb()), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unexpected encoding exception", e);
        }
    }

    public static Cursor fromUrlSafe(String urlSafe) {
        try {
            String utf8Str = URLDecoder.decode(urlSafe, StandardCharsets.UTF_8.name());
            DatastoreV1.Value.Builder builder = DatastoreV1.Value.newBuilder();
            TextFormat.merge((CharSequence)utf8Str, (Message.Builder)builder);
            return Cursor.fromPb(builder.build());
        }
        catch (TextFormat.ParseException | UnsupportedEncodingException e) {
            throw new IllegalStateException("Unexpected decoding exception", e);
        }
    }

    public static Cursor copyFrom(byte[] bytes) {
        return new Cursor(ByteString.copyFrom((byte[])((byte[])Preconditions.checkNotNull((Object)bytes))));
    }

    @Override
    protected DatastoreV1.Value toPb() {
        return DatastoreV1.Value.newBuilder().setBlobValue(this.byteString).build();
    }

    @Override
    protected Object fromPb(byte[] bytesPb) throws InvalidProtocolBufferException {
        return Cursor.fromPb(DatastoreV1.Value.parseFrom((byte[])bytesPb));
    }

    static Cursor fromPb(DatastoreV1.Value valuePb) {
        return new Cursor(valuePb.getBlobValue());
    }
}

